/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.clientmodel.query;

import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpe.api.ProcessTemplateData;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.clientmodel.bean.ProcessTemplateBeanPropertyExt;
import com.ibm.bpe.clientmodel.exception.BFMQueryException;
import com.ibm.bpe.clientmodel.query.BFMQuery;
import com.ibm.bpe.clientmodel.query.BFMQueryConstants;
import com.ibm.bpe.clientmodel.query.ProcessTemplateQueryAttributes;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import java.util.ArrayList;
import java.util.List;

public class ProcessTemplateQuery
extends BFMQuery {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2006, 2008.\n\n";
    public static final String TYPE = BFMQueryConstants.PROCESSTEMPLATEQUERYTYPE;

    public ProcessTemplateQuery() {
        super(new ProcessTemplateQueryAttributes());
        this.setType(TYPE);
    }

    protected List executeBFMQuery() throws ClientException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)this.getQueryString());
        }
        ProcessTemplateData[] processTemplateDataArray = this.executeProcessTemplateQuery();
        List list = this.transform(processTemplateDataArray);
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)("returning " + list.size() + " templates"));
        }
        return list;
    }

    private ProcessTemplateData[] executeProcessTemplateQuery() throws ClientException {
        ProcessTemplateData[] processTemplateDataArray = null;
        try {
            processTemplateDataArray = this.getService().queryProcessTemplates(this.updateWhereClauseForTemplates(this.getWhereClause()), this.getOrderClause(), this.getThreshold(), null);
        }
        catch (Exception exception) {
            throw new BFMQueryException(new Object[]{this.getQueryString()}, exception);
        }
        return processTemplateDataArray;
    }

    private List transform(ProcessTemplateData[] processTemplateDataArray) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Number of templates " + (processTemplateDataArray != null ? processTemplateDataArray.length : 0)));
        }
        ArrayList<ProcessTemplateBeanPropertyExt> arrayList = null;
        if (processTemplateDataArray != null && processTemplateDataArray.length > 0) {
            arrayList = new ArrayList(processTemplateDataArray.length);
            for (int i = 0; i < processTemplateDataArray.length; ++i) {
                arrayList.add(new ProcessTemplateBeanPropertyExt(processTemplateDataArray[i], this.getConnection()));
            }
        } else {
            arrayList = new ArrayList<ProcessTemplateBeanPropertyExt>(0);
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)("Returned templates " + arrayList.size()));
        }
        return arrayList;
    }
}

