/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.clientmodel.query;

import com.ibm.bpc.clientcore.BPCQueryFilterAttributes;
import com.ibm.bpc.clientcore.util.QueryUtils;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.clientmodel.query.BFMQueryConstants;
import com.ibm.bpe.util.UnicodeUtilities;
import java.util.HashMap;
import java.util.Map;

public class ProcessTemplateFilterAttributes
extends BPCQueryFilterAttributes {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2007, 2009.\n\n";
    public static final String TYPE = BFMQueryConstants.PROCESSTEMPLATE_ENITITYTYPE;
    public static final String ID_COLUMN_NAME = "PTID";
    private static Map validAttributes = new HashMap();

    public ProcessTemplateFilterAttributes() {
        super(TYPE, validAttributes);
    }

    public BPCQueryFilterAttributes getNewInstance() {
        return new ProcessTemplateFilterAttributes();
    }

    public StringBuffer getWhereFilterCondition() {
        String string;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        StringBuffer stringBuffer = new StringBuffer(75);
        if (this.getAttribute("processTemplateName") != null) {
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)QueryUtils.getStringCondition((String)"PROCESS_TEMPLATE.NAME", (Object)this.getAttribute("processTemplateName")));
        }
        if (this.getAttribute("ptid") != null) {
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)("PROCESS_TEMPLATE.PTID IN (" + QueryUtils.convertToIDStringList((String)((String)this.getAttribute("ptid"))) + ") "));
        }
        if (this.getAttribute("processTemplateDisplayName") != null) {
            string = (String)this.getAttribute("processTemplateDisplayName");
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)("(" + QueryUtils.getStringCondition((String)"PROCESS_TEMPLATE.DISPLAY_NAME", (String)string) + " OR (" + "PROCESS_TEMPLATE" + ".DISPLAY_NAME IS NULL AND " + QueryUtils.getStringCondition((String)"PROCESS_TEMPLATE.NAME", (String)string) + "))"));
        }
        if (this.getAttribute("states") != null) {
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)("PROCESS_TEMPLATE.STATE IN (" + QueryUtils.convertToStringList((String[])((String[])this.getAttribute("states"))) + ")"));
        }
        QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)this.getDateTimeCondition("validFrom", "PROCESS_TEMPLATE.VALID_FROM", 0));
        if (this.getAttribute("validFromAfterFirst") != null) {
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)("PROCESS_TEMPLATE.VALID_FROM = (SELECT MIN(VALID_FROM) FROM PROCESS_TEMPLATE WHERE NAME=PROCESS_TEMPLATE.NAME AND VALID_FROM >= " + QueryUtils.convertToTSString((String)((String)this.getAttribute("clear"))) + ")"));
        }
        if (this.getAttribute("validFromBeforeLast") != null) {
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)("PROCESS_TEMPLATE.VALID_FROM = (SELECT MAX(VALID_FROM) FROM PROCESS_TEMPLATE WHERE NAME = PROCESS_TEMPLATE.NAME AND STATE = PROCESS_TEMPLATE.STATE AND VALID_FROM <= " + QueryUtils.convertToTSString((String)((String)this.getAttribute("validFromBeforeLast"))) + ")"));
        }
        if (this.getAttribute("applicationName") != null) {
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)QueryUtils.getStringCondition((String)"PROCESS_TEMPLATE.APPLICATION_NAME", (Object)this.getAttribute("applicationName")));
        }
        if (this.getAttribute("version") != null) {
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)QueryUtils.getStringCondition((String)"PROCESS_TEMPLATE.VERSION", (Object)this.getAttribute("version")));
        }
        if (this.getAttribute("targetNamespace") != null) {
            string = UnicodeUtilities.namespaceEncode((String)this.getAttribute("targetNamespace").toString());
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)QueryUtils.getEqualStringCondition((String)"PROCESS_TEMPLATE.TARGET_NAMESPACE", (String)string));
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)("where " + stringBuffer));
        }
        return stringBuffer;
    }

    public void addStates(int[] nArray) {
        this.setAttribute("states", QueryUtils.convertToStringArray((int[])nArray));
    }

    public void addName(String string) {
        this.setAttribute("processTemplateName", string);
    }

    public void addDisplayName(String string) {
        this.setAttribute("processTemplateDisplayName", string);
    }

    public void addApplicationName(String string) {
        this.setAttribute("applicationName", string);
    }

    public void addVersion(String string) {
        this.setAttribute("version", string);
    }

    public void addTargetNamespace(String string) {
        this.setAttribute("targetNamespace", string);
    }

    public void addValidFromReference(String string) {
        this.addDateTimeAttributeValue("validFromReference", string);
    }

    public void addclear(String string) {
        this.addDateTimeAttributeValue("clear", string);
    }

    public void addValidFromEnd(String string) {
        this.addDateTimeAttributeValue("validFromEnd", string);
    }

    public void addValidFromBeforeLast(String string) {
        this.addDateTimeAttributeValue("validFromBeforeLast", string);
    }

    public void addValidFromReferenceOffset(String string) {
        this.setAttribute("validFromReferenceOffset", string);
    }

    public void addValidFromEndOffset(String string) {
        this.setAttribute("validFromEndOffset", string);
    }

    static {
        ProcessTemplateFilterAttributes.addValidAttribute((String)TYPE, (Map)validAttributes, (String)"ptid", (Object)"");
        ProcessTemplateFilterAttributes.addValidAttribute((String)TYPE, (Map)validAttributes, (String)"states", (Object)new String[0]);
        ProcessTemplateFilterAttributes.addValidAttribute((String)TYPE, (Map)validAttributes, (String)"processTemplateName", (Object)"");
        ProcessTemplateFilterAttributes.addValidAttribute((String)TYPE, (Map)validAttributes, (String)"processTemplateDisplayName", (Object)"");
        ProcessTemplateFilterAttributes.addValidAttribute((String)TYPE, (Map)validAttributes, (String)"validFromReference", (Object)"");
        ProcessTemplateFilterAttributes.addValidAttribute((String)TYPE, (Map)validAttributes, (String)"validFromReferenceOffset", (Object)"");
        ProcessTemplateFilterAttributes.addValidAttribute((String)TYPE, (Map)validAttributes, (String)"validFromAfterFirst", (Object)"");
        ProcessTemplateFilterAttributes.addValidAttribute((String)TYPE, (Map)validAttributes, (String)"validFromEnd", (Object)"");
        ProcessTemplateFilterAttributes.addValidAttribute((String)TYPE, (Map)validAttributes, (String)"validFromEndOffset", (Object)"");
        ProcessTemplateFilterAttributes.addValidAttribute((String)TYPE, (Map)validAttributes, (String)"validFromBeforeLast", (Object)"");
        ProcessTemplateFilterAttributes.addValidAttribute((String)TYPE, (Map)validAttributes, (String)"applicationName", (Object)"");
        ProcessTemplateFilterAttributes.addValidAttribute((String)TYPE, (Map)validAttributes, (String)"version", (Object)"");
        ProcessTemplateFilterAttributes.addValidAttribute((String)TYPE, (Map)validAttributes, (String)"targetNamespace", (Object)"");
    }
}

