/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.clientmodel.query;

import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpe.api.PIID;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.clientmodel.bean.ProcessInstanceBean;
import com.ibm.bpe.clientmodel.bean.ProcessInstanceBeanExt;
import com.ibm.bpe.clientmodel.query.BFMQueryConstants;
import com.ibm.bpe.clientmodel.query.ProcessInstanceQuery;
import com.ibm.bpe.clientmodel.query.ProcessWorkItemQuery;
import com.ibm.task.clientmodel.bean.WorkItemBeanExt;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessInstanceStaffQuery
extends ProcessWorkItemQuery {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2009.\n\n";
    public static final String TYPE = BFMQueryConstants.PROCESSINSTANCEQUERYTYPE;

    public ProcessInstanceStaffQuery() {
        this.setType(TYPE);
    }

    @Override
    public List executeBPCQuery() throws ClientException {
        Object object2;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        ArrayList arrayList = new ArrayList();
        List list = this.getProcessInstanceIds();
        ProcessInstanceQuery processInstanceQuery = this.getProcessInstanceQuery();
        processInstanceQuery.getProcessInstanceFilterAttributes().addProcessInstanceIds(list);
        List list2 = processInstanceQuery.execute();
        List list3 = super.executeBPCQuery();
        ProcessInstanceStaffQuery.addStaffInfo(list2, list3);
        list3 = null;
        HashMap<PIID, Object> hashMap = new HashMap<PIID, Object>(list2.size());
        for (Object object2 : list2) {
            hashMap.put(((ProcessInstanceBean)object2).getID(), object2);
        }
        object2 = list.iterator();
        while (object2.hasNext()) {
            arrayList.add(hashMap.get(object2.next()));
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)("returning " + arrayList.size() + " instances"));
        }
        return arrayList;
    }

    public ProcessInstanceQuery getProcessInstanceQuery() {
        ProcessInstanceQuery processInstanceQuery = new ProcessInstanceQuery();
        processInstanceQuery.setConnection(this.getBfmConnection());
        processInstanceQuery.setCurrentUser(this.getCurrentUser());
        processInstanceQuery.setLocale(this.getLocale());
        processInstanceQuery.setThreshold(this.getThreshold());
        return processInstanceQuery;
    }

    public static void addStaffInfo(List<ProcessInstanceBeanExt> list, List<WorkItemBeanExt> list2) {
        HashMap hashMap = new HashMap(list.size());
        Map<Integer, ArrayList<String>> map = null;
        ArrayList<String> arrayList = null;
        for (WorkItemBeanExt workItemBeanExt : list2) {
            boolean bl;
            ProcessInstanceBeanExt processInstanceBeanExt = workItemBeanExt.getProcessInstance();
            if (processInstanceBeanExt == null) continue;
            PIID pIID = processInstanceBeanExt.getID();
            int n = workItemBeanExt.getReason();
            map = null;
            arrayList = null;
            map = (Map)hashMap.get(pIID);
            if (map == null) {
                map = new HashMap<Integer, ArrayList<String>>();
                hashMap.put(pIID, map);
            } else {
                arrayList = (ArrayList<String>)map.get(new Integer(n));
            }
            String string = workItemBeanExt.getOwner();
            if (string == null) {
                string = workItemBeanExt.getGroupName();
            }
            if (string == null && (bl = workItemBeanExt.isAssignedToEverybody())) {
                string = "";
            }
            if (string == null) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
                map.put(n, arrayList);
            }
            arrayList.add(string);
        }
        for (ProcessInstanceBeanExt processInstanceBeanExt : list) {
            map = (HashMap<Integer, ArrayList<String>>)hashMap.get(processInstanceBeanExt.getID());
            if (map == null) continue;
            processInstanceBeanExt.setStaffInfo((Map<Integer, List<String>>)map);
        }
    }
}

