/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.clientmodel.query;

import com.ibm.bpc.clientcore.BPCQueryFilterAttributes;
import com.ibm.bpc.clientcore.util.QueryUtils;
import com.ibm.bpe.api.PIID;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.clientmodel.query.BFMQueryConstants;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessInstanceFilterAttributes
extends BPCQueryFilterAttributes {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2007, 2009.\n\n";
    public static final String TYPE = BFMQueryConstants.PROCESSINSTANCE_ENITITYTYPE;
    public static final String ID_COLUMN_NAME = "PIID";
    private static Map<String, Object> validAttributes = new HashMap<String, Object>();

    public ProcessInstanceFilterAttributes() {
        super(TYPE, validAttributes);
    }

    public BPCQueryFilterAttributes getNewInstance() {
        return new ProcessInstanceFilterAttributes();
    }

    public StringBuffer getWhereFilterCondition() {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        StringBuffer stringBuffer = new StringBuffer(75);
        if (this.getAttribute("processInstanceName") != null) {
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)QueryUtils.getStringCondition((String)"PROCESS_INSTANCE.NAME", (Object)this.getAttribute("processInstanceName")));
        }
        if (this.getAttribute("piid") != null) {
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)("PROCESS_INSTANCE.PIID IN (" + QueryUtils.convertToIDStringList((String)((String)this.getAttribute("piid"))) + ") "));
        }
        if (this.getAttribute("piids") != null) {
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)("PROCESS_INSTANCE.PIID IN (" + this.getAttribute("piids") + ") "));
        }
        if (this.getAttribute("ptids") != null) {
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)("PROCESS_INSTANCE.PTID IN (" + this.getAttribute("ptids") + ") "));
        }
        if (this.getAttribute("states") != null) {
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)("PROCESS_INSTANCE.STATE IN (" + QueryUtils.convertToStringList((String[])((String[])this.getAttribute("states"))) + ")"));
        }
        QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)this.getDateTimeCondition("started", "PROCESS_INSTANCE.STARTED", 2));
        QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)this.getDateTimeCondition("completed", "PROCESS_INSTANCE.COMPLETED", 0));
        String string = QueryUtils.getWorkItemFilterCondition((BPCQueryFilterAttributes)this);
        if (string != null) {
            StringBuffer stringBuffer2 = new StringBuffer(75);
            stringBuffer2.append("PROCESS_INSTANCE.PIID = WORK_ITEM.OBJECT_ID");
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)stringBuffer2.toString());
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)string);
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)("where " + stringBuffer));
        }
        return stringBuffer;
    }

    protected boolean getWhereFilterConditionEndExecution() {
        return false;
    }

    public void addName(String string) {
        this.setAttribute("processInstanceName", string);
    }

    public void addProcessTemplateIds(String string) {
        this.setAttribute("ptids", QueryUtils.convertToIDStringList((String)string));
    }

    public void addProcessTemplateIds(List<String> list) {
        this.setAttribute("ptids", QueryUtils.convertToIDStringList(list));
    }

    public void addProcessInstanceIds(String string) {
        this.setAttribute("piids", QueryUtils.convertToIDStringList((String)string));
    }

    public void addProcessInstanceIds(List<PIID> list) {
        String[] stringArray = null;
        if (list != null) {
            stringArray = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                stringArray[i] = list.get(i).toString();
            }
        }
        this.setAttribute("piids", QueryUtils.convertToIDStringList((String[])stringArray));
    }

    public void addStates(int[] nArray) {
        this.setAttribute("states", QueryUtils.convertToStringArray((int[])nArray));
    }

    public void addStartedEnd(String string) {
        this.addDateTimeAttributeValue("startedEnd", string);
    }

    public void addStartedReference(String string) {
        this.addDateTimeAttributeValue("startedReference", string);
    }

    public void addStartedEndOffset(String string) {
        this.setAttribute("startedEndOffset", string);
    }

    public void addStartedReferenceOffset(String string) {
        this.setAttribute("startedReferenceOffset", string);
    }

    public void addCompletedEnd(String string) {
        this.addDateTimeAttributeValue("completedEnd", string);
    }

    public void addCompletedReference(String string) {
        this.addDateTimeAttributeValue("completedReference", string);
    }

    public void addCompletedEndOffset(String string) {
        this.setAttribute("completedEndOffset", string);
    }

    public void addCompletedReferenceOffset(String string) {
        this.setAttribute("completedReferenceOffset", string);
    }

    public void addWorkItemReasons(int[] nArray) {
        this.setAttribute("wiReasons", QueryUtils.convertToStringArray((int[])nArray));
    }

    public void addWorkItemOwner(String string) {
        this.setAttribute("wiOwners", new String[]{string});
    }

    public void addWorkItemOwners(String[] stringArray) {
        this.setAttribute("wiOwners", stringArray);
    }

    public void addWorkItemGroups(String[] stringArray) {
        this.setAttribute("wiGroups", stringArray);
    }

    static {
        ProcessInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"processInstanceName", (Object)"");
        ProcessInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"ptids", (Object)"");
        ProcessInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"piid", (Object)"");
        ProcessInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"piids", (Object)"");
        ProcessInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"states", (Object)new String[0]);
        ProcessInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"startedReference", (Object)"");
        ProcessInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"startedReferenceOffset", (Object)"");
        ProcessInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"startedEnd", (Object)"");
        ProcessInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"startedEndOffset", (Object)"");
        ProcessInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"completedReference", (Object)"");
        ProcessInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"completedReferenceOffset", (Object)"");
        ProcessInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"completedEnd", (Object)"");
        ProcessInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"completedEndOffset", (Object)"");
        ProcessInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"wiReasons", (Object)new String[0]);
        ProcessInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"wiOwners", (Object)new String[0]);
        ProcessInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"wiGroups", (Object)new String[0]);
        ProcessInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"privateWIs", (Object)"false");
        ProcessInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"groupWIs", (Object)"false");
        ProcessInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"everybodyWIs", (Object)"false");
    }
}

