/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.clientmodel.query;

import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpc.clientcore.GenericBPCQueryExt;
import com.ibm.bpc.clientcore.exception.CommunicationException;
import com.ibm.bpc.clientcore.exception.InvalidTypeForQueryException;
import com.ibm.bpe.api.BusinessFlowManagerService;
import com.ibm.bpe.api.ProcessException;
import com.ibm.bpe.api.QueryResultSet;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.clientmodel.BFMConnection;
import com.ibm.bpe.clientmodel.bean.ActivityInstanceBean;
import com.ibm.bpe.clientmodel.bean.ProcessInstanceBean;
import com.ibm.bpe.clientmodel.bean.ProcessTemplateBean;
import com.ibm.bpe.clientmodel.exception.BFMQueryException;
import com.ibm.bpe.clientmodel.util.BFMUtils;
import com.ibm.bpe.util.Assert;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericBFMQuery
extends GenericBPCQueryExt {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2009.\n\n";
    private BFMConnection connection = null;

    public List execute() throws ClientException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)this.getQueryString());
        }
        Assert.assertion((this.getConnection() != null ? 1 : 0) != 0, (String)("No connection set for query" + ((Object)((Object)this)).getClass()));
        QueryResultSet queryResultSet = this.executeBFMQuery();
        List<Object> list = null;
        String string = this.getType();
        if (ProcessTemplateBean.class.getName().equals(string)) {
            throw new InvalidTypeForQueryException(new Object[]{ProcessTemplateBean.class.getName(), ((Object)((Object)this)).getClass()});
        }
        if (ProcessInstanceBean.class.getName().equals(string)) {
            list = this.transformToProcessInstances(queryResultSet);
        } else if (ActivityInstanceBean.class.getName().equals(string)) {
            list = this.transformToActivityInstances(queryResultSet);
        } else {
            throw new InvalidTypeForQueryException(new Object[]{string, ((Object)((Object)this)).getClass()});
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)("Returned Instances " + list.size()));
        }
        return list;
    }

    public BFMConnection getConnection() {
        return this.connection;
    }

    public void setConnection(BFMConnection bFMConnection) {
        this.connection = bFMConnection;
    }

    private QueryResultSet executeBFMQuery() throws ClientException {
        try {
            BusinessFlowManagerService businessFlowManagerService = BFMUtils.getBusinessFlowManagerService(this.getConnection());
            if (this.getUseQueryAll()) {
                return businessFlowManagerService.queryAll(this.getSelectClause(), this.getWhereClause(), this.getOrderClause(), null, this.getThreshold(), null);
            }
            return businessFlowManagerService.query(this.getSelectClause(), this.getWhereClause(), this.getOrderClause(), this.getThreshold(), null);
        }
        catch (ProcessException processException) {
            throw new BFMQueryException(new Object[]{this.getQueryString()}, processException);
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(new Object[]{((Object)((Object)this)).getClass()}, (Throwable)remoteException);
        }
    }

    private List<ProcessInstanceBean> transformToProcessInstances(QueryResultSet queryResultSet) {
        ArrayList<ProcessInstanceBean> arrayList = null;
        int n = queryResultSet.size();
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Returned Instances " + n));
        }
        if (n > 0) {
            arrayList = new ArrayList<ProcessInstanceBean>(n);
            for (int i = 0; i < n; ++i) {
                queryResultSet.next();
                arrayList.add(new ProcessInstanceBean(queryResultSet, this.connection));
            }
        }
        return arrayList;
    }

    private List<ActivityInstanceBean> transformToActivityInstances(QueryResultSet queryResultSet) {
        ArrayList<ActivityInstanceBean> arrayList = null;
        int n = queryResultSet.size();
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Returned Instances " + n));
        }
        if (n > 0) {
            arrayList = new ArrayList<ActivityInstanceBean>(n);
            for (int i = 0; i < n; ++i) {
                queryResultSet.next();
                arrayList.add(new ActivityInstanceBean(queryResultSet, this.connection));
            }
        }
        return arrayList;
    }
}

