/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.clientmodel.query;

import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpe.api.ActivityServiceTemplateData;
import com.ibm.bpe.api.BusinessFlowManagerService;
import com.ibm.bpe.api.EventHandlerTemplateData;
import com.ibm.bpe.api.PIID;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.clientmodel.bean.EventActivityBean;
import com.ibm.bpe.clientmodel.exception.BFMQueryException;
import com.ibm.bpe.clientmodel.query.BFMQuery;
import com.ibm.bpe.clientmodel.query.BFMQueryConstants;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import java.util.ArrayList;
import java.util.List;

public class EventActivityQuery
extends BFMQuery {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2007.\n\n";
    private static final String TYPE = BFMQueryConstants.EVENTACTIVITYQUERYTYPE;
    private PIID piid;

    public void setPIID(PIID pIID) {
        this.piid = pIID;
    }

    public PIID getPIID() {
        return this.piid;
    }

    public String getType() {
        return TYPE;
    }

    public List executeBFMQuery() throws ClientException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        try {
            EventHandlerTemplateData[] eventHandlerTemplateDataArray;
            ActivityServiceTemplateData[] activityServiceTemplateDataArray;
            block12: {
                BusinessFlowManagerService businessFlowManagerService;
                block11: {
                    businessFlowManagerService = this.getConnection().getBusinessFlowManagerService();
                    activityServiceTemplateDataArray = null;
                    try {
                        activityServiceTemplateDataArray = businessFlowManagerService.getWaitingActivities(this.getPIID());
                    }
                    catch (Exception exception) {
                        if (!BPCClientTrace.isTracing) break block11;
                        BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Exception during BusinessFlowManagerService.getWaitingActivities( getPIID() )");
                    }
                }
                eventHandlerTemplateDataArray = null;
                try {
                    eventHandlerTemplateDataArray = businessFlowManagerService.getActiveEventHandlers(this.getPIID());
                }
                catch (Exception exception) {
                    if (!BPCClientTrace.isTracing) break block12;
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Exception during BusinessFlowManagerService.getActiveEventHandlers( getPIID() )");
                }
            }
            List list = this.transform(activityServiceTemplateDataArray, eventHandlerTemplateDataArray);
            return list;
        }
        catch (Exception exception) {
            throw new BFMQueryException(new Object[]{"BusinessProcessService.getWaitingActivities()"}, exception);
        }
        finally {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.exit();
            }
        }
    }

    private List transform(ActivityServiceTemplateData[] activityServiceTemplateDataArray, EventHandlerTemplateData[] eventHandlerTemplateDataArray) {
        int n;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        List list = this.transform(activityServiceTemplateDataArray);
        List list2 = this.transform(eventHandlerTemplateDataArray);
        int n2 = list != null ? list.size() : 0;
        int n3 = n = list2 != null ? list2.size() : 0;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)("transformed " + n2 + " ActivityServiceTemplateData objects."));
            BPCClientTrace.exit((Object)("and         " + n + " EventHandlerTemplateData objects."));
        }
        list.addAll(list2);
        return list;
    }

    private List transform(Object[] objectArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = this.transform(objectArray[i]);
                if (object == null) continue;
                arrayList.add(object);
            }
        }
        return arrayList;
    }

    private Object transform(Object object) {
        if (object instanceof ActivityServiceTemplateData) {
            return new EventActivityBean((ActivityServiceTemplateData)object, this.getConnection(), this.getPIID());
        }
        if (object instanceof EventHandlerTemplateData) {
            return new EventActivityBean((EventHandlerTemplateData)object, this.getConnection());
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Unkown type: " + object));
        }
        return null;
    }

    protected String getQueryString() {
        return "BusinessFlowManagerService.getActiveEventHandlers() & BusinessFlowManagerService.getWaitingActivities";
    }
}

