/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.clientmodel.query;

import com.ibm.bpc.clientcore.BPCQueryAttributes;
import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpc.clientcore.exception.CommunicationException;
import com.ibm.bpc.clientcore.query.BPCQueryPropertyExt;
import com.ibm.bpc.clientcore.util.QueryResultSetWrapper;
import com.ibm.bpe.api.BusinessFlowManagerService;
import com.ibm.bpe.api.ProcessException;
import com.ibm.bpe.api.QueryResultSet;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.clientmodel.BFMConnection;
import com.ibm.bpe.clientmodel.exception.BFMQueryException;
import com.ibm.bpe.clientmodel.query.ActivityInstanceFilterAttributes;
import com.ibm.bpe.clientmodel.query.ProcessInstanceFilterAttributes;
import com.ibm.bpe.clientmodel.query.ProcessTemplateFilterAttributes;
import com.ibm.bpe.clientmodel.util.BFMUtils;
import com.ibm.bpe.util.Assert;
import java.rmi.RemoteException;
import java.util.List;

public abstract class BFMQuery
extends BPCQueryPropertyExt {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2009.\n\n";
    private BFMConnection connection;

    public BFMQuery() {
    }

    public BFMQuery(BPCQueryAttributes bPCQueryAttributes) {
        super(bPCQueryAttributes);
    }

    public String getWhereClause() {
        return super.getWhereClause();
    }

    public List executeBPCQuery() throws ClientException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        List list = null;
        Assert.assertion((this.getConnection() != null ? 1 : 0) != 0, (String)("No connection set for query" + ((Object)((Object)this)).getClass()));
        list = this.executeBFMQuery();
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)("Returning " + list.size() + " items"));
        }
        return list;
    }

    protected List executeBFMQuery() throws ClientException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        QueryResultSet queryResultSet = null;
        queryResultSet = this.executeGenericBFMQuery();
        List list = this.transformToBeans(new QueryResultSetWrapper((Object)queryResultSet));
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
        return list;
    }

    protected QueryResultSet executeGenericBFMQuery() throws ClientException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        return this.executeGenericBFMQuery(this.getSelectClause(), this.getWhereClause(), this.getOrderClause(), this.getThreshold());
    }

    private QueryResultSet executeGenericBFMQuery(String string, String string2, String string3, Integer n) throws ClientException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)this.getQueryString(string, string2, string3, n));
        }
        String string4 = this.updateWhereClause(string2);
        QueryResultSet queryResultSet = null;
        try {
            BusinessFlowManagerService businessFlowManagerService = BFMUtils.getBusinessFlowManagerService(this.getConnection());
            queryResultSet = this.getUseQueryAll() ? businessFlowManagerService.queryAll(string, string4, string3, null, n, null) : businessFlowManagerService.query(string, string4, string3, n, null);
        }
        catch (ProcessException processException) {
            throw new BFMQueryException(new Object[]{this.getQueryString(string, string4, string3, n)}, processException);
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(new Object[]{((Object)((Object)this)).getClass()}, (Throwable)remoteException);
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)("result size: " + (queryResultSet == null ? 0 : queryResultSet.size())));
        }
        return queryResultSet;
    }

    public BFMConnection getConnection() {
        return this.connection;
    }

    public void setConnection(BFMConnection bFMConnection) {
        this.connection = bFMConnection;
        this.setSystemAdmin(BFMUtils.isBFMSystemAdministrator(this.connection));
        this.setSystemMonitor(BFMUtils.isBFMSystemMonitor(this.connection));
    }

    public BusinessFlowManagerService getService() throws ClientException {
        Assert.assertion((this.getConnection() != null ? 1 : 0) != 0, (String)("No connection set for query" + ((Object)((Object)this)).getClass()));
        return BFMUtils.getBusinessFlowManagerService(this.getConnection());
    }

    public ProcessTemplateFilterAttributes getProcessTemplateFilterAttributes() {
        return (ProcessTemplateFilterAttributes)this.getQueryAttributes().getFilterAttributes(ProcessTemplateFilterAttributes.TYPE);
    }

    public ProcessInstanceFilterAttributes getProcessInstanceFilterAttributes() {
        return (ProcessInstanceFilterAttributes)this.getQueryAttributes().getFilterAttributes(ProcessInstanceFilterAttributes.TYPE);
    }

    public ActivityInstanceFilterAttributes getActivityInstanceFilterAttributes() {
        return (ActivityInstanceFilterAttributes)this.getQueryAttributes().getFilterAttributes(ActivityInstanceFilterAttributes.TYPE);
    }
}

