/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.clientmodel.query;

import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpe.api.BusinessFlowManagerService;
import com.ibm.bpe.api.PIID;
import com.ibm.bpe.api.QueryResultSet;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.clientmodel.bean.ActivityInstanceBeanPropertyExt;
import com.ibm.bpe.clientmodel.exception.BFMQueryException;
import com.ibm.bpe.clientmodel.query.BFMQuery;
import com.ibm.bpe.clientmodel.query.BFMQueryConstants;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;

public class AllActivityInstancesQuery
extends BFMQuery {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2008.\n\n";
    private static final String TYPE = BFMQueryConstants.ACTIVITYINSTANCEQUERYTYPE;
    private List piids = new ArrayList();
    private TimeZone timeZone = null;

    public void addProcessInstanceId(PIID pIID) {
        this.piids.add(pIID.toString());
    }

    public void addProcessInstanceId(String string) {
        this.piids.add(string);
    }

    public void setProcessInstanceIds(List list) {
        this.piids = list;
    }

    public void setProcessInstanceId(PIID pIID) {
        this.piids = new ArrayList();
        this.addProcessInstanceId(pIID);
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public String getType() {
        return TYPE;
    }

    public List executeBFMQuery() throws ClientException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)("getAllActivities for PIIDs " + this.piids.toString()));
        }
        try {
            Object object;
            BusinessFlowManagerService businessFlowManagerService = this.getConnection().getBusinessFlowManagerService();
            QueryResultSet queryResultSet = null;
            List list = new ArrayList();
            Iterator iterator = this.piids.iterator();
            while (iterator.hasNext()) {
                object = iterator.next().toString();
                queryResultSet = businessFlowManagerService.getAllActivities((String)object, this.getTimeZone());
                list = this.transform(list, queryResultSet);
            }
            object = list;
            return object;
        }
        catch (Exception exception) {
            throw new BFMQueryException(new Object[]{this.getQueryString()}, exception);
        }
        finally {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.exit();
            }
        }
    }

    private List transform(List list, QueryResultSet queryResultSet) {
        List list2 = this.transform(queryResultSet);
        if (list == null) {
            return list2;
        }
        ArrayList arrayList = new ArrayList(list2.size() + list.size());
        arrayList.addAll(list);
        arrayList.addAll(list2);
        return arrayList;
    }

    private List transform(QueryResultSet queryResultSet) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        ArrayList<ActivityInstanceBeanPropertyExt> arrayList = new ArrayList<ActivityInstanceBeanPropertyExt>();
        int n = queryResultSet.size();
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Returned Instances " + n));
        }
        for (int i = 0; i < n; ++i) {
            queryResultSet.next();
            arrayList.add(new ActivityInstanceBeanPropertyExt(queryResultSet, this.getConnection()));
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
        return arrayList;
    }

    protected String getQueryString() {
        return "BusinessFlowManagerService.getAllActivities(" + this.piids.toString() + "," + this.getTimeZone() + ")";
    }
}

