/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.clientmodel.query;

import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpe.api.ActivityServiceTemplateData;
import com.ibm.bpe.api.BusinessFlowManagerService;
import com.ibm.bpe.api.PTID;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.clientmodel.bean.ActivityServiceTemplateBean;
import com.ibm.bpe.clientmodel.exception.BFMQueryException;
import com.ibm.bpe.clientmodel.query.BFMQuery;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import java.util.ArrayList;
import java.util.List;

public class ActivityServiceTemplateQuery
extends BFMQuery {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2007.\n\n";
    private static final String TYPE = ActivityServiceTemplateBean.class.getName();
    private PTID ptid;

    public void setPTID(PTID pTID) {
        this.ptid = pTID;
    }

    public PTID getPTID() {
        return this.ptid;
    }

    public List executeBFMQuery() throws ClientException {
        try {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Querying starting activities for process template: " + this.getPTID().toString()));
            }
            BusinessFlowManagerService businessFlowManagerService = this.getConnection().getBusinessFlowManagerService();
            ActivityServiceTemplateData[] activityServiceTemplateDataArray = businessFlowManagerService.getStartActivities(this.getPTID());
            List list = this.transform(activityServiceTemplateDataArray);
            return list;
        }
        catch (Exception exception) {
            throw new BFMQueryException(new Object[]{"BusinessProcessService.getStartActivities()"}, exception);
        }
    }

    public String getType() {
        return TYPE;
    }

    private List transform(ActivityServiceTemplateData[] activityServiceTemplateDataArray) {
        ArrayList<ActivityServiceTemplateBean> arrayList = new ArrayList<ActivityServiceTemplateBean>(activityServiceTemplateDataArray.length);
        for (int i = 0; i < activityServiceTemplateDataArray.length; ++i) {
            arrayList.add(new ActivityServiceTemplateBean(activityServiceTemplateDataArray[i], this.getConnection()));
        }
        return arrayList;
    }

    protected String getQueryString() {
        return "BusinessProcessService.getStartActivities()";
    }
}

