/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.clientmodel.query;

import com.ibm.bpc.clientcore.BPCQueryFilterAttributes;
import com.ibm.bpc.clientcore.util.QueryUtils;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.clientmodel.query.BFMQueryConstants;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityInstanceFilterAttributes
extends BPCQueryFilterAttributes {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2007, 2009.\n\n";
    public static final String TYPE = BFMQueryConstants.ACTIVITYINSTANCE_ENITITYTYPE;
    public static final String TABLE_NAME = "ACTIVITY";
    public static final String ID_COLUMN_NAME = "AIID";
    private static Map<String, Object> validAttributes = new HashMap<String, Object>();

    public ActivityInstanceFilterAttributes() {
        super(TYPE, validAttributes);
    }

    public BPCQueryFilterAttributes getNewInstance() {
        return new ActivityInstanceFilterAttributes();
    }

    protected StringBuffer getWhereFilterCondition() {
        Object object;
        Serializable serializable;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        StringBuffer stringBuffer = new StringBuffer(75);
        if (this.getAttribute("piids") != null) {
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)("ACTIVITY.PIID IN (" + this.getAttribute("piids") + ") "));
        }
        String[] stringArray = (String[])this.getAttribute("states");
        String[] stringArray2 = (String[])this.getAttribute("stopReasons");
        if (this.getAttribute("kinds") != null) {
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)("ACTIVITY.KIND IN (" + QueryUtils.convertToStringList((String[])((String[])this.getAttribute("kinds"))) + ")"));
        } else if (this.isEntityFilter() && (stringArray == null || stringArray.length != 1 || !Integer.toString(13).equals(stringArray[0]))) {
            serializable = new StringBuffer("ACTIVITY.KIND IN (3,21,23,24,25,26,27,29,36,42,43,44,45,46)");
            if (stringArray == null || Arrays.asList(stringArray).contains(Integer.toString(13))) {
                QueryUtils.addConditionToWhereClause((StringBuffer)serializable, (String)"OR", (String)("ACTIVITY.STATE = " + Integer.toString(13)));
                QueryUtils.encloseCondition((StringBuffer)serializable);
            }
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)serializable.toString());
        }
        serializable = null;
        boolean bl = false;
        if (stringArray != null) {
            object = Arrays.asList(stringArray);
            if (stringArray2 != null && object.contains(Integer.toString(13))) {
                object = new ArrayList<String>(stringArray.length - 1);
                for (int i = 0; i < stringArray.length; ++i) {
                    if (Integer.toString(13).equals(stringArray[i])) {
                        bl = true;
                        continue;
                    }
                    object.add(stringArray[i]);
                }
            }
            if (object.size() > 0) {
                serializable = new StringBuffer("ACTIVITY.STATE IN (" + QueryUtils.convertToStringList((String[])((String[])this.getAttribute("states"))) + ")");
            }
        }
        if (stringArray2 != null) {
            if (stringArray == null || bl) {
                object = new StringBuffer("ACTIVITY.STATE = " + Integer.toString(13));
                QueryUtils.addConditionToWhereClause(object, (String)"AND", (String)("ACTIVITY.STOP_REASON IN (" + QueryUtils.convertToStringList((String[])((String[])this.getAttribute("stopReasons"))) + ")"));
                QueryUtils.encloseCondition(object);
                if (serializable != null) {
                    QueryUtils.addConditionToWhereClause((StringBuffer)serializable, (String)"OR", (String)((StringBuffer)object).toString());
                    QueryUtils.encloseCondition((StringBuffer)serializable);
                } else {
                    serializable = object;
                }
            } else if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Ignoring stop reason filter because state stooped is not part of filters!");
            }
        }
        if (serializable != null) {
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)serializable.toString());
        }
        if (this.getAttribute("subStates") != null) {
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)("ACTIVITY.SUB_STATE IN (" + QueryUtils.convertToStringList((String[])((String[])this.getAttribute("subStates"))) + ")"));
        }
        if (this.getAttribute("activityInstanceName") != null) {
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)QueryUtils.getStringCondition((String)"ACTIVITY.TEMPLATE_NAME", (Object)this.getAttribute("activityInstanceName")));
        }
        if (this.getAttribute("aiid") != null) {
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)("ACTIVITY.AIID IN (" + QueryUtils.convertToIDStringList((String)((String)this.getAttribute("aiid"))) + ") "));
        }
        QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)this.getDateTimeCondition("activated", "ACTIVITY.ACTIVATED", 2));
        QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)this.getDateTimeCondition("completed", "ACTIVITY.COMPLETED", 2));
        QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)this.getDateTimeCondition("expires", "ACTIVITY.EXPIRES", 0));
        object = QueryUtils.getWorkItemFilterCondition((BPCQueryFilterAttributes)this);
        if (object != null) {
            StringBuffer stringBuffer2 = new StringBuffer(75);
            stringBuffer2.append("ACTIVITY.AIID = WORK_ITEM.OBJECT_ID");
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer2, (String)"OR", (String)"ACTIVITY.PIID = WORK_ITEM.ASSOC_OID");
            QueryUtils.encloseCondition((StringBuffer)stringBuffer2);
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)stringBuffer2.toString());
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)object);
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)("where " + stringBuffer));
        }
        return stringBuffer;
    }

    public void addProcessInstanceIds(String string) {
        this.setAttribute("piids", QueryUtils.convertToIDStringList((String)string));
    }

    public void addProcessInstanceIds(List<String> list) {
        this.setAttribute("piids", QueryUtils.convertToIDStringList(list));
    }

    public void addKinds(int[] nArray) {
        this.setAttribute("kinds", QueryUtils.convertToStringArray((int[])nArray));
    }

    public void addStates(int[] nArray) {
        this.setAttribute("states", QueryUtils.convertToStringArray((int[])nArray));
    }

    public void addSubStates(int[] nArray) {
        this.setAttribute("subStates", QueryUtils.convertToStringArray((int[])nArray));
    }

    public void addStopReasons(int[] nArray) {
        this.setAttribute("stopReasons", QueryUtils.convertToStringArray((int[])nArray));
    }

    public void addActivatedReference(String string) {
        this.addDateTimeAttributeValue("activatedReference", string);
    }

    public void addActivatedReferenceOffset(String string) {
        this.setAttribute("activatedReferenceOffset", string);
    }

    public void addActivatedEnd(String string) {
        this.addDateTimeAttributeValue("activatedEnd", string);
    }

    public void addActivatedEndOffset(String string) {
        this.setAttribute("activatedEndOffset", string);
    }

    public void addCompletedReference(String string) {
        this.addDateTimeAttributeValue("completedReference", string);
    }

    public void addCompletedReferenceOffset(String string) {
        this.setAttribute("completedReferenceOffset", string);
    }

    public void addCompletedEnd(String string) {
        this.addDateTimeAttributeValue("completedEnd", string);
    }

    public void addCompletedEndOffset(String string) {
        this.setAttribute("completedEndOffset", string);
    }

    public void addExpiresReference(String string) {
        this.addDateTimeAttributeValue("expiresReference", string);
    }

    public void addExpiresReferenceOffset(String string) {
        this.setAttribute("expiresReferenceOffset", string);
    }

    public void addExpiresEnd(String string) {
        this.addDateTimeAttributeValue("expiresEnd", string);
    }

    public void addExpiresEndOffset(String string) {
        this.setAttribute("expiresEndOffset", string);
    }

    public void addName(String string) {
        this.setAttribute("activityName", string);
    }

    public void addWorkItemReasons(int[] nArray) {
        this.setAttribute("wiReasons", QueryUtils.convertToStringArray((int[])nArray));
    }

    public void addWorkItemOwner(String string) {
        this.setAttribute("wiOwners", new String[]{string});
    }

    public void addWorkItemOwners(String[] stringArray) {
        this.setAttribute("wiOwners", stringArray);
    }

    public void addWorkItemGroups(String[] stringArray) {
        this.setAttribute("wiGroups", stringArray);
    }

    static {
        ActivityInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"piids", (Object)"");
        ActivityInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"kinds", (Object)new String[0]);
        ActivityInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"states", (Object)new String[0]);
        ActivityInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"subStates", (Object)new String[0]);
        ActivityInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"stopReasons", (Object)new String[0]);
        ActivityInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"activityInstanceName", (Object)"");
        ActivityInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"aiid", (Object)"");
        ActivityInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"activatedReference", (Object)"");
        ActivityInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"activatedReferenceOffset", (Object)"");
        ActivityInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"activatedEnd", (Object)"");
        ActivityInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"activatedEndOffset", (Object)"");
        ActivityInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"completedReference", (Object)"");
        ActivityInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"completedReferenceOffset", (Object)"");
        ActivityInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"completedEnd", (Object)"");
        ActivityInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"completedEndOffset", (Object)"");
        ActivityInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"expiresReference", (Object)"");
        ActivityInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"expiresReferenceOffset", (Object)"");
        ActivityInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"expiresEnd", (Object)"");
        ActivityInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"expiresEndOffset", (Object)"");
        ActivityInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"wiReasons", (Object)new String[0]);
        ActivityInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"wiOwners", (Object)new String[0]);
        ActivityInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"wiGroups", (Object)new String[0]);
        ActivityInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"privateWIs", (Object)"false");
        ActivityInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"groupWIs", (Object)"false");
        ActivityInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"everybodyWIs", (Object)"false");
    }
}

