/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.clientmodel.converter;

import com.ibm.bpc.clientcore.converter.CalendarConverter;
import com.ibm.bpc.clientcore.converter.NumberUtils;
import com.ibm.bpc.clientcore.converter.SimpleConverter;
import com.ibm.bpc.clientcore.util.LocaleUtils;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class QueryPropertyConverter
extends CalendarConverter {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2006, 2008.\n\n";

    public String getAsString(Object object, Locale locale) {
        return this.getAsString(object, locale, null);
    }

    public Object getAsObject(String string, Locale locale) {
        return this.getAsObject(string, locale, null);
    }

    public String getAsString(Object object, Locale locale, TimeZone timeZone) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)object);
        }
        String string = null;
        if (object != null) {
            if (object instanceof HashMap) {
                return LocaleUtils.getSortedPropertiesMap((Map)((Map)object), (SimpleConverter)this, (Locale)locale, (TimeZone)timeZone);
            }
            if (NumberUtils.isNumberType((String)object.getClass().getName())) {
                string = NumberUtils.getAsString((String)object.getClass().getName(), (Object)object, (Locale)locale);
            } else if (object instanceof Calendar) {
                string = super.getAsString(object, locale, TimeZone.getTimeZone("UTC"));
            } else if (object instanceof String) {
                string = (String)object;
            } else if (object instanceof List) {
                List list;
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Converting a list of values.");
                }
                if ((list = (List)object).size() == 1) {
                    string = this.getAsString(list.get(0), locale);
                } else {
                    if (BPCClientTrace.isTracing) {
                        BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_EVENT, (String)"Multiple values.");
                    }
                    string = this.getValues((List)object, locale);
                }
            } else {
                throw new IllegalArgumentException("HashMap, Calendar, Long, Double, String or List expected but " + object.getClass().getName() + " encountered");
            }
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit(string);
        }
        return string;
    }

    private String getValues(List list, Locale locale) {
        StringBuffer stringBuffer = new StringBuffer();
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.getAsString(iterator.next(), locale));
            }
        }
        return stringBuffer.toString();
    }

    public Object getAsObject(String string, Locale locale, TimeZone timeZone) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"This Converter does not support getAsObject()");
        }
        return null;
    }
}

