/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.clientmodel.command;

import com.ibm.bpc.clientcore.exception.LockConflictDuringTerminateException;
import com.ibm.bpe.api.BusinessFlowManagerService;
import com.ibm.bpe.api.ProcessException;
import com.ibm.bpe.api.UnexpectedFailureException;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.clientmodel.bean.ProcessInstanceBean;
import com.ibm.bpe.clientmodel.command.ProcessInstanceCommand;
import com.ibm.bpe.database.TomSQLException;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import java.rmi.RemoteException;
import javax.ejb.EJBException;

public class TerminateProcessInstanceCommand
extends ProcessInstanceCommand {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2009.\n\n";

    public TerminateProcessInstanceCommand() {
        super("forceTerminate", null);
    }

    protected void executeBFMCommand(BusinessFlowManagerService businessFlowManagerService, ProcessInstanceBean processInstanceBean) throws ProcessException, RemoteException, EJBException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)("Process Instance ID=" + (processInstanceBean != null ? processInstanceBean.getID().toString() : null)));
        }
        try {
            businessFlowManagerService.forceTerminate(processInstanceBean.getID(), 0);
            processInstanceBean.setExecutionState(6);
        }
        catch (UnexpectedFailureException unexpectedFailureException) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)unexpectedFailureException.getMessage());
            }
            if (unexpectedFailureException.getCause() instanceof TomSQLException || unexpectedFailureException.getRootCause() instanceof TomSQLException) {
                throw new LockConflictDuringTerminateException(null);
            }
            throw unexpectedFailureException;
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)("Terminated=" + (processInstanceBean != null ? processInstanceBean.getExecutionState() == 6 : false)));
        }
    }
}

