/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.clientmodel.command;

import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpc.clientcore.exception.CommunicationException;
import com.ibm.bpc.clientcore.exception.NotAuthorizedException;
import com.ibm.bpe.api.BusinessFlowManagerService;
import com.ibm.bpe.api.EngineNotAuthorizedException;
import com.ibm.bpe.api.ProcessException;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.clientmodel.BFMConnection;
import com.ibm.bpe.clientmodel.bean.ActivityInstanceBean;
import com.ibm.bpe.clientmodel.bean.ProcessInstanceBean;
import com.ibm.bpe.clientmodel.command.BFMCommand;
import com.ibm.bpe.clientmodel.exception.BFMCommandException;
import com.ibm.bpe.clientmodel.util.BFMUtils;
import java.rmi.RemoteException;
import java.util.List;
import javax.ejb.EJBException;

public class SetBFMCustomPropertyCommand
extends BFMCommand {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2009.\n\n";
    Object[] properties = null;
    protected BFMConnection connection;

    public void setBFMConnection(BFMConnection bFMConnection) {
        this.connection = bFMConnection;
    }

    public void setNewValues(Object[] objectArray) {
        this.properties = objectArray;
    }

    public String execute(List list) throws ClientException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        Object e = list.get(0);
        BusinessFlowManagerService businessFlowManagerService = BFMUtils.getBusinessFlowManagerService(this.connection);
        try {
            if (e instanceof ActivityInstanceBean) {
                for (int i = 0; i < this.properties.length; ++i) {
                    String[] stringArray = (String[])this.properties[i];
                    businessFlowManagerService.setCustomProperty(((ActivityInstanceBean)e).getID(), stringArray[0], stringArray[1]);
                }
            } else if (e instanceof ProcessInstanceBean) {
                for (int i = 0; i < this.properties.length; ++i) {
                    String[] stringArray = (String[])this.properties[i];
                    businessFlowManagerService.setCustomProperty(((ProcessInstanceBean)e).getID(), stringArray[0], stringArray[1]);
                }
            }
        }
        catch (EngineNotAuthorizedException engineNotAuthorizedException) {
            throw new NotAuthorizedException(new Object[0], (Throwable)engineNotAuthorizedException);
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(new Object[]{"BusinessFlowManagerService.setCustomProperty"}, (Throwable)remoteException);
        }
        catch (EJBException eJBException) {
            throw new CommunicationException(new Object[]{"BusinessFlowManagerService.setCustomProperty"}, (Throwable)eJBException);
        }
        catch (ProcessException processException) {
            throw new BFMCommandException(new Object[]{"BusinessFlowManagerService.setCustomProperty"}, processException);
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
        return null;
    }

    public boolean isMultiSelectEnabled() {
        return false;
    }

    public boolean[] isApplicable(List list) {
        int n = list.size();
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < n; ++i) {
            blArray[i] = true;
        }
        return blArray;
    }

    public void setContext(Object object) {
    }
}

