/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.clientmodel.command;

import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpc.clientcore.MessageWrapper;
import com.ibm.bpc.clientcore.exception.CommunicationException;
import com.ibm.bpc.clientcore.exception.ContextNotSetException;
import com.ibm.bpc.clientcore.exception.InvalidContextException;
import com.ibm.bpe.api.BusinessFlowManagerService;
import com.ibm.bpe.api.ClientObjectWrapper;
import com.ibm.bpe.api.MissingPartsException;
import com.ibm.bpe.api.ProcessException;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.clientmodel.BFMConnection;
import com.ibm.bpe.clientmodel.bean.ActivityServiceTemplateBean;
import com.ibm.bpe.clientmodel.command.BFMCommand;
import com.ibm.bpe.clientmodel.command.ProcessMessageContext;
import com.ibm.bpe.clientmodel.exception.BFMCommandException;
import com.ibm.bpe.clientmodel.util.BFMUtils;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import java.rmi.RemoteException;
import java.util.List;
import javax.ejb.EJBException;

public class SendMessageCommand
extends BFMCommand {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2008.\n\n";
    protected BFMConnection connection;
    protected Object context;
    protected int requiredAuthorization = 7000;

    public void setBFMConnection(BFMConnection bFMConnection) {
        this.connection = bFMConnection;
    }

    public String execute(List list) throws ClientException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        ProcessMessageContext processMessageContext = null;
        if (this.context == null) {
            throw new ContextNotSetException(new Object[]{this.getClass()});
        }
        try {
            processMessageContext = (ProcessMessageContext)this.context;
        }
        catch (ClassCastException classCastException) {
            throw new InvalidContextException(new Object[]{this.context.getClass(), ProcessMessageContext.class, this.getClass()}, (Throwable)classCastException);
        }
        ActivityServiceTemplateBean activityServiceTemplateBean = (ActivityServiceTemplateBean)list.get(0);
        MessageWrapper messageWrapper = processMessageContext.getInputMessageWrapper();
        BusinessFlowManagerService businessFlowManagerService = BFMUtils.getBusinessFlowManagerService(this.connection);
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Sending message to operation " + activityServiceTemplateBean.getOperationName()));
        }
        ClientObjectWrapper clientObjectWrapper = messageWrapper != null ? new ClientObjectWrapper(messageWrapper.getMessage()) : new ClientObjectWrapper();
        try {
            businessFlowManagerService.sendMessage(activityServiceTemplateBean.getServiceTemplateID(), activityServiceTemplateBean.getActivityTemplateID(), clientObjectWrapper);
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(new Object[]{"BusinessFlowManagerService.sendMessage"}, (Throwable)remoteException);
        }
        catch (EJBException eJBException) {
            throw new CommunicationException(new Object[]{"BusinessFlowManagerService.sendMessage"}, (Throwable)eJBException);
        }
        catch (MissingPartsException missingPartsException) {
            throw new BFMCommandException(new Object[]{"BusinessFlowManagerService.sendMessage"}, missingPartsException);
        }
        catch (ProcessException processException) {
            throw new BFMCommandException(new Object[]{"BusinessFlowManagerService.sendMessage"}, processException);
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
        return null;
    }

    public boolean isMultiSelectEnabled() {
        return false;
    }

    public boolean[] isApplicable(List list) {
        int n = list.size();
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < n; ++i) {
            blArray[i] = false;
            ActivityServiceTemplateBean activityServiceTemplateBean = (ActivityServiceTemplateBean)list.get(i);
            int[] nArray = activityServiceTemplateBean.getAvailableActions();
            for (int j = 0; j < nArray.length; ++j) {
                if (nArray[j] != this.requiredAuthorization) continue;
                blArray[i] = true;
            }
        }
        return blArray;
    }

    public void setContext(Object object) {
        this.context = object;
    }
}

