/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.clientmodel.command;

import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpc.clientcore.MessageContext;
import com.ibm.bpc.clientcore.MessageWrapper;
import com.ibm.bpc.clientcore.exception.CommunicationException;
import com.ibm.bpc.clientcore.exception.ContextNotSetException;
import com.ibm.bpc.clientcore.exception.InvalidContextException;
import com.ibm.bpc.clientcore.exception.WrongTypeForCommandException;
import com.ibm.bpe.api.BusinessFlowManagerService;
import com.ibm.bpe.api.ClientObjectWrapper;
import com.ibm.bpe.api.ProcessException;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.clientmodel.BFMConnection;
import com.ibm.bpe.clientmodel.bean.EventActivityBean;
import com.ibm.bpe.clientmodel.command.BFMCommand;
import com.ibm.bpe.clientmodel.exception.BFMCommandException;
import com.ibm.bpe.clientmodel.util.BFMUtils;
import java.rmi.RemoteException;
import java.util.List;
import javax.ejb.EJBException;

public class SendEventCommand
extends BFMCommand {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2009.\n\n";
    private BFMConnection connection;
    private Object context;

    public void setBFMConnection(BFMConnection bFMConnection) {
        this.connection = bFMConnection;
    }

    public String execute(List list) throws ClientException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)new Integer(list == null ? 0 : list.size()));
        }
        MessageContext messageContext = null;
        if (this.context == null) {
            throw new ContextNotSetException(new Object[]{this.getClass()});
        }
        try {
            messageContext = (MessageContext)this.context;
        }
        catch (ClassCastException classCastException) {
            throw new InvalidContextException(new Object[]{this.context.getClass(), MessageContext.class, this.getClass()}, (Throwable)classCastException);
        }
        this.checkSelectedItems(list);
        Object e = list.get(0);
        if (!(e instanceof EventActivityBean)) {
            throw new WrongTypeForCommandException(new Object[]{this.getClass(), e.getClass(), EventActivityBean.class});
        }
        EventActivityBean eventActivityBean = (EventActivityBean)e;
        try {
            BusinessFlowManagerService businessFlowManagerService = BFMUtils.getBusinessFlowManagerService(this.connection);
            MessageWrapper messageWrapper = messageContext.getInputMessageWrapper();
            Object object = messageWrapper != null ? messageWrapper.getMessage() : null;
            ClientObjectWrapper clientObjectWrapper = new ClientObjectWrapper(object);
            businessFlowManagerService.sendMessage(eventActivityBean.getProcessTemplateName(), eventActivityBean.getPortTypeNameSpace(), eventActivityBean.getPortTypeName(), eventActivityBean.getOperation(), clientObjectWrapper);
        }
        catch (EJBException eJBException) {
            throw new CommunicationException(new Object[]{this.getClass()}, (Throwable)eJBException);
        }
        catch (ProcessException processException) {
            throw new BFMCommandException(new Object[]{"BusinessFlowManagerService.sendMessage()"}, processException);
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(new Object[]{this.getClass()}, (Throwable)remoteException);
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
        return null;
    }

    public boolean isMultiSelectEnabled() {
        return false;
    }

    public boolean[] isApplicable(List list) {
        return null;
    }

    public void setContext(Object object) {
        this.context = object;
    }
}

