/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.clientmodel.command;

import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpc.clientcore.MessageWrapper;
import com.ibm.bpc.clientcore.exception.CommunicationException;
import com.ibm.bpc.clientcore.exception.NotAuthorizedException;
import com.ibm.bpe.api.BusinessFlowManagerService;
import com.ibm.bpe.api.ClientObjectWrapper;
import com.ibm.bpe.api.EngineNotAuthorizedException;
import com.ibm.bpe.api.ProcessException;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.clientmodel.BFMConnection;
import com.ibm.bpe.clientmodel.command.BFMCommand;
import com.ibm.bpe.clientmodel.command.VariableContext;
import com.ibm.bpe.clientmodel.exception.BFMCommandException;
import com.ibm.bpe.clientmodel.util.BFMUtils;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import java.rmi.RemoteException;
import java.util.List;
import javax.ejb.EJBException;

public class SaveVariableCommand
extends BFMCommand {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2009.\n\n";
    protected BFMConnection connection;
    protected VariableContext context = null;

    public void setBFMConnection(BFMConnection bFMConnection) {
        this.connection = bFMConnection;
    }

    public Object getContext() {
        return this.context;
    }

    public void setContext(VariableContext variableContext) {
        this.context = variableContext;
    }

    public String execute(List list) throws ClientException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        Object e = list.get(0);
        VariableContext variableContext = (VariableContext)this.getContext();
        BusinessFlowManagerService businessFlowManagerService = BFMUtils.getBusinessFlowManagerService(this.connection);
        if (variableContext != null) {
            try {
                if (variableContext.getActivityId() != null) {
                    businessFlowManagerService.setVariable(variableContext.getActivityId(), variableContext.getVariableName(), new ClientObjectWrapper(((MessageWrapper)e).getMessage()));
                }
                businessFlowManagerService.setVariable(variableContext.getProcessId(), variableContext.getActivityName(), variableContext.getVariableName(), new ClientObjectWrapper(((MessageWrapper)e).getMessage()));
            }
            catch (EngineNotAuthorizedException engineNotAuthorizedException) {
                throw new NotAuthorizedException(new Object[0], (Throwable)engineNotAuthorizedException);
            }
            catch (RemoteException remoteException) {
                throw new CommunicationException(new Object[]{"BusinessFlowManagerService.setVariable"}, (Throwable)remoteException);
            }
            catch (EJBException eJBException) {
                throw new CommunicationException(new Object[]{"BusinessFlowManagerService.setVariable"}, (Throwable)eJBException);
            }
            catch (ProcessException processException) {
                throw new BFMCommandException(new Object[]{"BusinessFlowManagerService.setVariable"}, processException);
            }
        } else if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Context = null! Cannot save variable!");
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
        return null;
    }

    public boolean[] isApplicable(List list) {
        int n = list.size();
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < n; ++i) {
            blArray[i] = true;
        }
        return blArray;
    }

    public boolean isMultiSelectEnabled() {
        return false;
    }

    public void setContext(Object object) {
    }
}

