/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.clientmodel.command;

import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpc.clientcore.command.WorkItemContext;
import com.ibm.bpc.clientcore.exception.CommunicationException;
import com.ibm.bpc.clientcore.exception.ContextNotSetException;
import com.ibm.bpc.clientcore.exception.ErrorsInCommandException;
import com.ibm.bpc.clientcore.exception.InvalidContextException;
import com.ibm.bpc.clientcore.exception.MissingParameterException;
import com.ibm.bpc.clientcore.exception.MissingParametersException;
import com.ibm.bpc.clientcore.exception.NoObjectsSelectedException;
import com.ibm.bpc.clientcore.exception.NotAuthorizedException;
import com.ibm.bpc.clientcore.util.ClientMessage;
import com.ibm.bpe.api.BusinessFlowManagerService;
import com.ibm.bpe.api.EngineNotAuthorizedException;
import com.ibm.bpe.api.ProcessException;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.clientmodel.BFMConnection;
import com.ibm.bpe.clientmodel.bean.ProcessInstanceBean;
import com.ibm.bpe.clientmodel.command.BFMCommand;
import com.ibm.bpe.clientmodel.exception.BFMCommandException;
import com.ibm.bpe.clientmodel.util.BFMUtils;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import com.ibm.task.clientmodel.bean.WorkItemBeanExt;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ejb.EJBException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProcessInstanceWorkItemCommand
extends BFMCommand {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2009.\n\n";
    private BFMConnection bfmConnection;
    private Object context;

    @Override
    public void setBFMConnection(BFMConnection bFMConnection) {
        this.bfmConnection = bFMConnection;
    }

    public String execute(List list) throws ClientException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        if (list == null || list.size() == 0) {
            throw new NoObjectsSelectedException(null);
        }
        WorkItemContext workItemContext = (WorkItemContext)this.getContext(WorkItemContext.class);
        this.checkParameters();
        BusinessFlowManagerService businessFlowManagerService = BFMUtils.getBusinessFlowManagerService(this.bfmConnection);
        Throwable throwable = null;
        HashMap<Object, Throwable> hashMap = new HashMap<Object, Throwable>();
        ArrayList<ClientMessage> arrayList = new ArrayList<ClientMessage>();
        for (int i = 0; i < list.size(); ++i) {
            throwable = null;
            Object e = list.get(i);
            try {
                this.executeBFMCommand(businessFlowManagerService, e, arrayList);
            }
            catch (ClientException clientException) {
                throwable = clientException;
            }
            catch (EngineNotAuthorizedException engineNotAuthorizedException) {
                throwable = new NotAuthorizedException(new Object[0], (Throwable)engineNotAuthorizedException);
            }
            catch (RemoteException remoteException) {
                throwable = new CommunicationException(new Object[]{this.getClass().getName()}, (Throwable)remoteException);
            }
            catch (EJBException eJBException) {
                throwable = new CommunicationException(new Object[]{this.getClass().getName()}, (Throwable)eJBException);
            }
            catch (ProcessException processException) {
                throwable = processException;
            }
            if (throwable == null) continue;
            if (e != null) {
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (Throwable)throwable);
                }
                if (e instanceof ProcessInstanceBean) {
                    hashMap.put(((ProcessInstanceBean)e).getID(), throwable);
                    continue;
                }
                if (!(e instanceof WorkItemBeanExt)) continue;
                hashMap.put(((WorkItemBeanExt)e).getErrorID(), throwable);
                continue;
            }
            throw new BFMCommandException(new Object[]{this.getClass().getName()}, throwable);
        }
        if (arrayList.size() > 0) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Messages set. List contains: " + arrayList.size() + " entries"));
            }
            workItemContext.setMessages(arrayList);
        }
        if (hashMap.size() != 0) {
            ErrorsInCommandException errorsInCommandException = new ErrorsInCommandException(hashMap);
            throw errorsInCommandException;
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
        return null;
    }

    protected abstract void executeBFMCommand(BusinessFlowManagerService var1, Object var2, List<ClientMessage> var3) throws ClientException, ProcessException, RemoteException, EJBException;

    public boolean isMultiSelectEnabled() {
        return true;
    }

    public boolean[] isApplicable(List list) {
        return null;
    }

    public void setContext(Object object) {
        this.context = object;
    }

    public Object getContext(Class clazz) throws ClientException {
        if (this.context == null) {
            throw new ContextNotSetException(new Object[]{this.getClass()});
        }
        if (!clazz.isInstance(this.context)) {
            throw new InvalidContextException(new Object[]{this.context.getClass(), clazz, this.context.getClass()}, null);
        }
        return this.context;
    }

    protected abstract void checkParameters() throws MissingParameterException, MissingParametersException, ClientException;
}

