/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.clientmodel.command;

import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpc.clientcore.exception.MissingParameterException;
import com.ibm.bpc.clientcore.exception.MissingParametersException;
import com.ibm.bpc.clientcore.exception.WrongTypeForCommandException;
import com.ibm.bpc.clientcore.util.ClientMessage;
import com.ibm.bpc.clientcore.util.ClientMessageImpl;
import com.ibm.bpe.api.BusinessFlowManagerService;
import com.ibm.bpe.api.ProcessException;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.clientmodel.command.ProcessInstanceWorkItemCommand;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import com.ibm.task.clientmodel.bean.WorkItemBean;
import java.rmi.RemoteException;
import java.util.List;
import javax.ejb.EJBException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessInstanceDeleteWorkItemCommand
extends ProcessInstanceWorkItemCommand {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2009.\n\n";

    @Override
    protected void executeBFMCommand(BusinessFlowManagerService businessFlowManagerService, Object object, List<ClientMessage> list) throws ClientException, ProcessException, RemoteException, EJBException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        if (!(object instanceof WorkItemBean)) {
            throw new WrongTypeForCommandException(new Object[]{this.getClass(), object.getClass(), WorkItemBean.class});
        }
        WorkItemBean workItemBean = (WorkItemBean)object;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("processInstanceId=" + workItemBean.getObjectID() + ", workItemId=" + workItemBean.getID()));
        }
        String string = null;
        if (workItemBean.isAssignedToEverybody()) {
            string = "EVERYBODY";
        } else {
            string = workItemBean.getOwner();
            if (string == null) {
                string = workItemBean.getGroupName();
            }
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Calling BusinessFlowManagerService.deleteWorkItem(" + workItemBean.getObjectID().toString() + ", " + workItemBean.getReason() + ", " + string + ")"));
        }
        businessFlowManagerService.deleteWorkItem(workItemBean.getObjectID().toString(), workItemBean.getReason(), string);
        list.add((ClientMessage)new ClientMessageImpl("PROCESS.WORKITEM.DELETED.MSG", new Object[]{string, new Integer(workItemBean.getReason())}));
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }

    @Override
    protected void checkParameters() throws MissingParameterException, MissingParametersException, ClientException {
    }
}

