/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.clientmodel.command;

import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpc.clientcore.command.WorkItemCreateContext;
import com.ibm.bpc.clientcore.exception.MissingParameterException;
import com.ibm.bpc.clientcore.exception.MissingParametersException;
import com.ibm.bpc.clientcore.exception.WrongTypeForCommandException;
import com.ibm.bpc.clientcore.util.ClientMessage;
import com.ibm.bpc.clientcore.util.ClientMessageImpl;
import com.ibm.bpe.api.BusinessFlowManagerService;
import com.ibm.bpe.api.EngineProcessDoesNotExistException;
import com.ibm.bpe.api.EngineProcessWrongKindException;
import com.ibm.bpe.api.EngineProcessWrongStateException;
import com.ibm.bpe.api.ProcessException;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.clientmodel.bean.ProcessInstanceBean;
import com.ibm.bpe.clientmodel.command.ProcessInstanceCommand;
import com.ibm.bpe.clientmodel.command.ProcessInstanceWorkItemCommand;
import com.ibm.bpe.clientmodel.exception.ProcessDoesNotExistException;
import com.ibm.bpe.clientmodel.exception.ProcessWrongKindException;
import com.ibm.bpe.clientmodel.exception.ProcessWrongStateException;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import java.rmi.RemoteException;
import java.util.List;
import javax.ejb.EJBException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessInstanceCreateWorkItemCommand
extends ProcessInstanceWorkItemCommand {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2009.\n\n";

    @Override
    protected void executeBFMCommand(BusinessFlowManagerService businessFlowManagerService, Object object, List<ClientMessage> list) throws ClientException, ProcessException, RemoteException, EJBException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        WorkItemCreateContext workItemCreateContext = (WorkItemCreateContext)this.getContext(WorkItemCreateContext.class);
        if (!(object instanceof ProcessInstanceBean)) {
            throw new WrongTypeForCommandException(new Object[]{this.getClass(), object.getClass(), ProcessInstanceBean.class});
        }
        ProcessInstanceBean processInstanceBean = (ProcessInstanceBean)object;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("processInstanceId=" + processInstanceBean.getID()));
        }
        String string = workItemCreateContext.getRecipient();
        List list2 = workItemCreateContext.getReasons();
        for (String string2 : list2) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Calling BusinessFlowManagerService.createWorkItem(" + processInstanceBean.getID().toString() + ", " + string2 + ", " + string + ")"));
            }
            try {
                businessFlowManagerService.createWorkItem(processInstanceBean.getID(), Integer.valueOf(string2).intValue(), string);
                list.add((ClientMessage)new ClientMessageImpl("PROCESS.WORKITEM.CREATED.MSG", new Object[]{processInstanceBean.getName(), string2, string}));
            }
            catch (EngineProcessWrongStateException engineProcessWrongStateException) {
                throw new ProcessWrongStateException(new Object[]{ProcessInstanceCommand.getStateAsString(processInstanceBean.getExecutionState(), workItemCreateContext.getLocale()), processInstanceBean.getName()}, engineProcessWrongStateException);
            }
            catch (EngineProcessWrongKindException engineProcessWrongKindException) {
                throw new ProcessWrongKindException(new Object[]{processInstanceBean.getName()}, engineProcessWrongKindException);
            }
            catch (EngineProcessDoesNotExistException engineProcessDoesNotExistException) {
                throw new ProcessDoesNotExistException(new Object[]{processInstanceBean.getName()}, engineProcessDoesNotExistException);
            }
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }

    @Override
    protected void checkParameters() throws MissingParameterException, MissingParametersException, ClientException {
        String string;
        WorkItemCreateContext workItemCreateContext = (WorkItemCreateContext)this.getContext(WorkItemCreateContext.class);
        List list = workItemCreateContext.getReasons();
        boolean bl = false;
        if (list == null || list.size() == 0) {
            bl = true;
        }
        if ((string = workItemCreateContext.getRecipient()) == null || string.trim().length() == 0) {
            if (bl) {
                throw new MissingParametersException(new Object[]{workItemCreateContext.getLabelRecipient() + ", " + workItemCreateContext.getLabelReasons()});
            }
            throw new MissingParameterException(new Object[]{workItemCreateContext.getLabelRecipient()});
        }
        if (bl) {
            throw new MissingParameterException(new Object[]{workItemCreateContext.getLabelReasons()});
        }
    }
}

