/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.clientmodel.command;

import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpc.clientcore.CommandContext;
import com.ibm.bpc.clientcore.converter.SimpleConverter;
import com.ibm.bpc.clientcore.exception.CommunicationException;
import com.ibm.bpc.clientcore.exception.ContextNotSetException;
import com.ibm.bpc.clientcore.exception.ErrorsInCommandException;
import com.ibm.bpc.clientcore.exception.InvalidContextException;
import com.ibm.bpc.clientcore.exception.NotAuthorizedException;
import com.ibm.bpc.clientcore.exception.WrongTypeForCommandException;
import com.ibm.bpe.api.BusinessFlowManagerService;
import com.ibm.bpe.api.EngineNotAuthorizedException;
import com.ibm.bpe.api.EngineProcessDoesNotExistException;
import com.ibm.bpe.api.EngineProcessWrongKindException;
import com.ibm.bpe.api.EngineProcessWrongStateException;
import com.ibm.bpe.api.PIID;
import com.ibm.bpe.api.ProcessException;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.clientmodel.BFMConnection;
import com.ibm.bpe.clientmodel.bean.ProcessInstanceBean;
import com.ibm.bpe.clientmodel.command.BFMCommand;
import com.ibm.bpe.clientmodel.exception.BFMCommandException;
import com.ibm.bpe.clientmodel.exception.ProcessDoesNotExistException;
import com.ibm.bpe.clientmodel.exception.ProcessWrongKindException;
import com.ibm.bpe.clientmodel.exception.ProcessWrongStateException;
import com.ibm.bpe.clientmodel.util.BFMUtils;
import com.ibm.bpe.util.Assert;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.ejb.EJBException;

public abstract class ProcessInstanceCommand
extends BFMCommand {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2009.\n\n";
    private Object context = null;
    private String apiCallName4Trace = null;
    private String successView = null;
    private String commandClazz = null;
    private BFMConnection connection;

    public ProcessInstanceCommand(String string, String string2) {
        this.apiCallName4Trace = string;
        this.successView = string2;
        this.commandClazz = this.getClass().getName();
    }

    public void setBFMConnection(BFMConnection bFMConnection) {
        this.connection = bFMConnection;
    }

    public boolean isMultiSelectEnabled() {
        return true;
    }

    public boolean[] isApplicable(List list) {
        return null;
    }

    public void setContext(Object object) {
        this.context = object;
    }

    public String execute(List list) throws ClientException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)this.commandClazz);
        }
        this.checkSelectedItems(list);
        BusinessFlowManagerService businessFlowManagerService = BFMUtils.getBusinessFlowManagerService(this.connection);
        Assert.assertion((businessFlowManagerService != null ? 1 : 0) != 0, (String)"BusinessProcessService is null, but getting it did not cause an Exception");
        HashMap<PIID, ClientException> hashMap = new HashMap<PIID, ClientException>();
        for (int i = 0; i < list.size(); ++i) {
            ClientException clientException = null;
            ProcessInstanceBean processInstanceBean = null;
            Object e = list.get(i);
            try {
                processInstanceBean = (ProcessInstanceBean)e;
                this.executeBFMCommand(businessFlowManagerService, processInstanceBean);
            }
            catch (ClassCastException classCastException) {
                clientException = new WrongTypeForCommandException(new Object[]{this.getClass(), ProcessInstanceBean.class.getName(), e.getClass().getName()}, (Throwable)classCastException);
            }
            catch (ClientException clientException2) {
                clientException = clientException2;
            }
            catch (EngineNotAuthorizedException engineNotAuthorizedException) {
                clientException = new NotAuthorizedException(new Object[0], (Throwable)engineNotAuthorizedException);
            }
            catch (EngineProcessWrongStateException engineProcessWrongStateException) {
                clientException = new ProcessWrongStateException(new Object[]{ProcessInstanceCommand.getStateAsString(processInstanceBean.getExecutionState(), this.getLocale()), processInstanceBean.getName()}, engineProcessWrongStateException);
            }
            catch (EngineProcessWrongKindException engineProcessWrongKindException) {
                clientException = new ProcessWrongKindException(new Object[]{processInstanceBean.getName()}, engineProcessWrongKindException);
            }
            catch (EngineProcessDoesNotExistException engineProcessDoesNotExistException) {
                clientException = new ProcessDoesNotExistException(new Object[]{processInstanceBean.getName()}, engineProcessDoesNotExistException);
            }
            catch (ProcessException processException) {
                clientException = new BFMCommandException(new Object[]{this.apiCallName4Trace}, processException);
            }
            catch (RemoteException remoteException) {
                clientException = new CommunicationException(new Object[]{this.apiCallName4Trace}, (Throwable)remoteException);
            }
            catch (EJBException eJBException) {
                clientException = new CommunicationException(new Object[]{this.apiCallName4Trace}, (Throwable)eJBException);
            }
            if (clientException == null) continue;
            if (processInstanceBean != null) {
                hashMap.put(processInstanceBean.getID(), clientException);
                continue;
            }
            throw clientException;
        }
        if (hashMap.size() != 0) {
            ErrorsInCommandException errorsInCommandException = new ErrorsInCommandException(hashMap);
            throw errorsInCommandException;
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)(this.commandClazz + " - successView=" + this.successView));
        }
        return this.successView;
    }

    protected abstract void executeBFMCommand(BusinessFlowManagerService var1, ProcessInstanceBean var2) throws ProcessException, RemoteException, EJBException;

    public Object getContext() {
        return this.context;
    }

    public Object getContext(Class clazz) throws ClientException {
        if (this.context == null) {
            throw new ContextNotSetException(new Object[]{this.getClass()});
        }
        if (!clazz.isInstance(this.context)) {
            throw new InvalidContextException(new Object[]{this.context.getClass(), clazz, this.context.getClass()}, null);
        }
        return this.context;
    }

    public void setSuccessView(String string) {
        this.successView = string;
    }

    public static String getStateAsString(int n, Locale locale) {
        SimpleConverter simpleConverter = ProcessInstanceBean.getConverter("executionState");
        String string = "";
        if (simpleConverter != null) {
            string = string + simpleConverter.getAsString((Object)new Integer(n), locale);
        }
        return string;
    }

    protected Locale getLocale() {
        Locale locale = Locale.getDefault();
        CommandContext commandContext = null;
        if (this.context != null) {
            try {
                commandContext = (CommandContext)this.getContext(CommandContext.class);
            }
            catch (ClientException clientException) {
                // empty catch block
            }
        }
        if (commandContext == null) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_EVENT, (String)"Using default locale for localized message parameters because no context available to retrieve client locale!");
            }
        } else {
            locale = commandContext.getLocale();
        }
        return locale;
    }
}

