/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.clientmodel.command;

import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpc.clientcore.exception.CommunicationException;
import com.ibm.bpc.clientcore.exception.InvalidContextException;
import com.ibm.bpc.clientcore.exception.NoObjectsSelectedException;
import com.ibm.bpc.clientcore.exception.NotAuthorizedException;
import com.ibm.bpe.api.BusinessFlowManagerService;
import com.ibm.bpe.api.EngineNotAuthorizedException;
import com.ibm.bpe.api.PIID;
import com.ibm.bpe.api.ProcessException;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.clientmodel.BFMConnection;
import com.ibm.bpe.clientmodel.command.BFMCommand;
import com.ibm.bpe.clientmodel.command.ProcessInstanceContext;
import com.ibm.bpe.clientmodel.exception.BFMCommandException;
import com.ibm.bpe.clientmodel.util.BFMUtils;
import com.ibm.bpe.util.Assert;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import java.rmi.RemoteException;
import java.util.List;
import javax.ejb.EJBException;

public class ProcessActivitiesSkipCommand
extends BFMCommand {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2008, 2009.\n\n";
    protected BFMConnection connection;
    protected Object context = null;

    public void setBFMConnection(BFMConnection bFMConnection) {
        this.connection = bFMConnection;
    }

    public Object getContext() {
        return this.context;
    }

    public String execute(List list) throws ClientException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        String string = null;
        if (list == null || list.size() == 0) {
            throw new NoObjectsSelectedException(null);
        }
        ProcessInstanceContext processInstanceContext = null;
        try {
            processInstanceContext = (ProcessInstanceContext)this.getContext();
        }
        catch (ClassCastException classCastException) {
            throw new InvalidContextException(new Object[]{this.getContext().getClass(), ProcessInstanceContext.class, this.getClass()});
        }
        if (processInstanceContext != null) {
            PIID pIID = processInstanceContext.getProcessInstanceId();
            Assert.assertion((pIID != null ? 1 : 0) != 0, (String)"PIID is required!");
            BusinessFlowManagerService businessFlowManagerService = BFMUtils.getBusinessFlowManagerService(this.connection);
            Assert.assertion((businessFlowManagerService != null ? 1 : 0) != 0, (String)"BusinessFlowManagerService is null, but getting it did not cause an Exception");
            for (Object e : list) {
                Assert.assertion((boolean)(e instanceof String), (String)("Expecting a list of activity names! " + list.toString()));
                String string2 = (String)e;
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)(pIID + ": Skip " + string2));
                }
                try {
                    businessFlowManagerService.skip(pIID, string2);
                }
                catch (EngineNotAuthorizedException engineNotAuthorizedException) {
                    throw new NotAuthorizedException(new Object[0], (Throwable)engineNotAuthorizedException);
                }
                catch (ProcessException processException) {
                    throw new BFMCommandException(new Object[]{"BusinessFlowManagerService.skip"}, processException);
                }
                catch (RemoteException remoteException) {
                    throw new CommunicationException(new Object[]{this.getClass().getName()}, (Throwable)remoteException);
                }
                catch (EJBException eJBException) {
                    throw new CommunicationException(new Object[]{this.getClass().getName()}, (Throwable)eJBException);
                }
            }
            string = processInstanceContext.getSuccessTarget();
        } else if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Context = null! Cannot skip activities!");
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit(string);
        }
        return string;
    }

    public boolean[] isApplicable(List list) {
        int n = list.size();
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < n; ++i) {
            blArray[i] = true;
        }
        return blArray;
    }

    public boolean isMultiSelectEnabled() {
        return true;
    }

    public void setContext(Object object) {
        this.context = object;
    }
}

