/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.clientmodel.command;

import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpc.clientcore.util.LocaleUtils;
import com.ibm.bpe.api.BusinessFlowManagerService;
import com.ibm.bpe.api.EngineInvalidMigrationTargetException;
import com.ibm.bpe.api.ProcessException;
import com.ibm.bpe.api.ProcessInstanceData;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.clientmodel.bean.ProcessInstanceBean;
import com.ibm.bpe.clientmodel.command.MigrateProcessInstanceContext;
import com.ibm.bpe.clientmodel.command.ProcessInstanceCommand;
import com.ibm.bpe.clientmodel.exception.ProcessInstanceMigrationTargetException;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import com.ibm.icu.util.TimeZone;
import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.Locale;
import javax.ejb.EJBException;

public class MigrateProcessInstanceCommand
extends ProcessInstanceCommand {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2009.\n\n";

    public MigrateProcessInstanceCommand() {
        super("migrate", null);
    }

    protected void executeBFMCommand(BusinessFlowManagerService businessFlowManagerService, ProcessInstanceBean processInstanceBean) throws ProcessException, RemoteException, EJBException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_EVENT, (String)("Call Migrate for Process " + processInstanceBean.getName()));
        }
        ProcessInstanceData processInstanceData = null;
        ProcessInstanceMigrationTargetException processInstanceMigrationTargetException = null;
        try {
            processInstanceData = businessFlowManagerService.migrate(processInstanceBean.getID(), null);
        }
        catch (EngineInvalidMigrationTargetException engineInvalidMigrationTargetException) {
            processInstanceMigrationTargetException = new ProcessInstanceMigrationTargetException(new Object[]{processInstanceBean.getName(), processInstanceBean.getProcessTemplateDisplayName(), this.getLocalizedDate(processInstanceBean.getValidFromTime())}, null);
            throw processInstanceMigrationTargetException;
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_EVENT, (String)("Process " + processInstanceBean.getName() + " migrated:" + processInstanceData.isMigrated()));
        }
    }

    private String getLocalizedDate(Calendar calendar) throws ClientException {
        MigrateProcessInstanceContext migrateProcessInstanceContext = (MigrateProcessInstanceContext)this.getContext(MigrateProcessInstanceContext.class);
        return LocaleUtils.getLocalizedDate((int)0, (int)0, (Calendar)calendar, (Locale)migrateProcessInstanceContext.getLocale(), (TimeZone)migrateProcessInstanceContext.getTimeZone());
    }
}

