/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.clientmodel.command;

import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpc.clientcore.MessageWrapper;
import com.ibm.bpc.clientcore.exception.CommunicationException;
import com.ibm.bpc.clientcore.exception.ContextNotSetException;
import com.ibm.bpc.clientcore.exception.InvalidContextException;
import com.ibm.bpe.api.BusinessFlowManagerService;
import com.ibm.bpe.api.ClientObjectWrapper;
import com.ibm.bpe.api.MissingPartsException;
import com.ibm.bpe.api.ProcessException;
import com.ibm.bpe.api.ProcessInstanceNotUniqueException;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.clientmodel.bean.ActivityServiceTemplateBean;
import com.ibm.bpe.clientmodel.command.ProcessMessageContext;
import com.ibm.bpe.clientmodel.command.SendMessageCommand;
import com.ibm.bpe.clientmodel.exception.BFMCommandException;
import com.ibm.bpe.clientmodel.util.BFMUtils;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import java.rmi.RemoteException;
import java.util.List;
import javax.ejb.EJBException;

public class InitiateCommand
extends SendMessageCommand {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2009.\n\n";

    public InitiateCommand() {
        this.requiredAuthorization = 7005;
    }

    public String execute(List list) throws ClientException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        ProcessMessageContext processMessageContext = null;
        if (this.context == null) {
            throw new ContextNotSetException(new Object[]{this.getClass()});
        }
        try {
            processMessageContext = (ProcessMessageContext)this.context;
        }
        catch (ClassCastException classCastException) {
            throw new InvalidContextException(new Object[]{this.context.getClass(), ProcessMessageContext.class, this.getClass()}, (Throwable)classCastException);
        }
        String string = processMessageContext.getProcessInstanceName();
        ActivityServiceTemplateBean activityServiceTemplateBean = (ActivityServiceTemplateBean)list.get(0);
        MessageWrapper messageWrapper = processMessageContext.getInputMessageWrapper();
        try {
            BusinessFlowManagerService businessFlowManagerService = BFMUtils.getBusinessFlowManagerService(this.connection);
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Initiate message to operation " + activityServiceTemplateBean.getOperationName() + " with request process instance name " + string));
            }
            ClientObjectWrapper clientObjectWrapper = messageWrapper != null ? new ClientObjectWrapper(messageWrapper.getMessage()) : new ClientObjectWrapper();
            businessFlowManagerService.initiate(activityServiceTemplateBean.getServiceTemplateID(), activityServiceTemplateBean.getActivityTemplateID(), string, clientObjectWrapper);
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(new Object[]{this.getClass()}, (Throwable)remoteException);
        }
        catch (EJBException eJBException) {
            throw new CommunicationException(new Object[]{this.getClass()}, (Throwable)eJBException);
        }
        catch (MissingPartsException missingPartsException) {
            throw new BFMCommandException(new Object[]{"BusinessFlowManagerService.initiate()"}, missingPartsException);
        }
        catch (ProcessInstanceNotUniqueException processInstanceNotUniqueException) {
            throw new BFMCommandException(new Object[]{"BusinessFlowManagerService.initiate()"}, processInstanceNotUniqueException);
        }
        catch (ProcessException processException) {
            throw new BFMCommandException(new Object[]{"BusinessFlowManagerService.initiate()"}, processException);
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
        return null;
    }
}

