/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.clientmodel.command;

import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpc.clientcore.MessageWrapper;
import com.ibm.bpc.clientcore.exception.CommunicationException;
import com.ibm.bpc.clientcore.exception.ContextNotSetException;
import com.ibm.bpc.clientcore.exception.InvalidContextException;
import com.ibm.bpc.clientcore.util.ClientUIHelper;
import com.ibm.bpc.clientcore.util.MessageWrapperImpl;
import com.ibm.bpe.api.BusinessFlowManagerService;
import com.ibm.bpe.api.ClientObjectWrapper;
import com.ibm.bpe.api.CustomClientSettings;
import com.ibm.bpe.api.DataHandlingException;
import com.ibm.bpe.api.FaultReplyException;
import com.ibm.bpe.api.JspLocation;
import com.ibm.bpe.api.JspUsageEnum;
import com.ibm.bpe.api.ProcessException;
import com.ibm.bpe.api.WebClientSetting;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.clientmodel.bean.ActivityServiceTemplateBean;
import com.ibm.bpe.clientmodel.bean.ProcessTemplateBean;
import com.ibm.bpe.clientmodel.command.ProcessMessageContext;
import com.ibm.bpe.clientmodel.command.SendMessageCommand;
import com.ibm.bpe.clientmodel.exception.BFMCommandException;
import com.ibm.bpe.clientmodel.util.BFMUtils;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import com.ibm.websphere.bo.BOCopy;
import com.ibm.websphere.sca.ServiceManager;
import commonj.sdo.DataObject;
import java.rmi.RemoteException;
import java.util.List;
import javax.ejb.EJBException;

public class CallCommand
extends SendMessageCommand {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2009.\n\n";

    public CallCommand() {
        this.requiredAuthorization = 7004;
    }

    public String execute(List list) throws ClientException {
        DataObject dataObject;
        ClientObjectWrapper clientObjectWrapper;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        ProcessMessageContext processMessageContext = null;
        if (this.context == null) {
            throw new ContextNotSetException(new Object[]{this.getClass()});
        }
        try {
            processMessageContext = (ProcessMessageContext)this.context;
        }
        catch (ClassCastException classCastException) {
            throw new InvalidContextException(new Object[]{this.context.getClass(), ProcessMessageContext.class, this.getClass()}, (Throwable)classCastException);
        }
        ActivityServiceTemplateBean activityServiceTemplateBean = (ActivityServiceTemplateBean)list.get(0);
        MessageWrapper messageWrapper = processMessageContext.getInputMessageWrapper();
        ProcessTemplateBean processTemplateBean = activityServiceTemplateBean.getProcessTemplate();
        BusinessFlowManagerService businessFlowManagerService = BFMUtils.getBusinessFlowManagerService(this.connection);
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Conducting call targeting operation " + activityServiceTemplateBean.getOperationName() + " of template " + processTemplateBean.getName()));
        }
        BOCopy bOCopy = (BOCopy)ServiceManager.INSTANCE.locateService("com/ibm/websphere/bo/BOCopy");
        if (messageWrapper != null && messageWrapper.getMessage() instanceof DataObject) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Cloning " + messageWrapper.getMessage()));
            }
            clientObjectWrapper = (DataObject)messageWrapper.getMessage();
            dataObject = bOCopy.copy((DataObject)clientObjectWrapper);
            messageWrapper = new MessageWrapperImpl(processTemplateBean.getApplicationName());
            messageWrapper.setMessage((Object)dataObject);
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Clone: " + dataObject));
            }
        }
        clientObjectWrapper = messageWrapper != null ? new ClientObjectWrapper(messageWrapper.getMessage()) : new ClientObjectWrapper();
        try {
            dataObject = businessFlowManagerService.callWithUISettings(activityServiceTemplateBean.getServiceTemplateID().toString(), activityServiceTemplateBean.getActivityTemplateID().toString(), clientObjectWrapper);
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(new Object[]{"BusinessFlowManagerService.callWithUISettings"}, (Throwable)remoteException);
        }
        catch (EJBException eJBException) {
            throw new CommunicationException(new Object[]{"BusinessFlowManagerService.callWithUISettings"}, (Throwable)eJBException);
        }
        catch (ProcessException processException) {
            if (processException instanceof FaultReplyException) {
                MessageWrapperImpl messageWrapperImpl = new MessageWrapperImpl(processTemplateBean.getApplicationName());
                try {
                    messageWrapperImpl.setMessage((Object)((FaultReplyException)processException).getFaultMessage());
                    messageWrapperImpl.setFaultName(((FaultReplyException)processException).getFaultName());
                    processMessageContext.setFaultMessageWrapper((MessageWrapper)messageWrapperImpl);
                    if (BPCClientTrace.isTracing) {
                        BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Fault retrieved, fault name: " + messageWrapperImpl.getFaultName() + " fault message: " + messageWrapperImpl.getMessage()));
                    }
                }
                catch (DataHandlingException dataHandlingException) {
                    messageWrapperImpl.setMessage((Object)("DataHandlingException: Message object cannot be deserialized. Fault name: " + ((FaultReplyException)processException).getFaultName()));
                    processMessageContext.setFaultMessageWrapper((MessageWrapper)messageWrapperImpl);
                }
            }
            throw new BFMCommandException(new Object[]{"BusinessFlowManagerService.callWithUISettings"}, processException);
        }
        if (dataObject == null) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Result of call is null");
            }
            processMessageContext.setOutputMessageWrapper(null);
        } else {
            MessageWrapperImpl messageWrapperImpl = new MessageWrapperImpl(processTemplateBean.getApplicationName());
            try {
                messageWrapperImpl.setMessage(dataObject.getMessage());
                messageWrapperImpl.setFaultName(null);
                if (ClientUIHelper.getWebClientType() != null) {
                    CustomClientSettings customClientSettings = dataObject.getClientUISettings();
                    WebClientSetting webClientSetting = customClientSettings != null ? customClientSettings.getWebClientSetting(ClientUIHelper.getWebClientType()) : null;
                    JspLocation jspLocation = webClientSetting != null ? ClientUIHelper.getJspLocationForOriginatingInterface((JspUsageEnum)JspUsageEnum.OUTPUT, (WebClientSetting)webClientSetting) : null;
                    String string = jspLocation != null ? jspLocation.getContextRoot() : null;
                    String string2 = jspLocation != null ? jspLocation.getUriAsString() : null;
                    messageWrapperImpl.setContextRoot(string);
                    messageWrapperImpl.setUrl(string2);
                } else {
                    messageWrapperImpl.setContextRoot(null);
                    messageWrapperImpl.setUrl(null);
                }
                processMessageContext.setOutputMessageWrapper((MessageWrapper)messageWrapperImpl);
            }
            catch (ProcessException processException) {
                throw new BFMCommandException(new Object[]{"ProcessResponseWrapper.getMessage"}, processException);
            }
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
        return null;
    }
}

