/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.clientmodel.command;

import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpe.api.BusinessFlowManagerService;
import com.ibm.bpe.api.ProcessException;
import com.ibm.bpe.api.TimerSpecification;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.clientmodel.bean.ActivityInstanceBean;
import com.ibm.bpe.clientmodel.bean.ActivityInstanceBeanExt;
import com.ibm.bpe.clientmodel.command.ActivityInstanceCommand;
import com.ibm.bpe.clientmodel.command.ActivityRescheduleTimerContext;
import com.ibm.bpe.clientmodel.exception.ActivityInvalidActionException;
import com.ibm.bpe.clientmodel.exception.ActivityWrongKindException;
import com.ibm.bpe.clientmodel.exception.ActivityWrongStateException;
import com.ibm.bpe.util.Assert;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ActivityRescheduleTimerCommand
extends ActivityInstanceCommand {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2009.\n\n";
    protected static Map<Integer, List<Integer>> EXPECTED_KIND_AND_STATE = new HashMap<Integer, List<Integer>>(4);

    public ActivityRescheduleTimerCommand() {
        super("rescheduleTimer", null);
    }

    protected void executeBFMCommand(BusinessFlowManagerService businessFlowManagerService, ActivityInstanceBean activityInstanceBean) throws ClientException, ProcessException, RemoteException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        ActivityRescheduleTimerContext activityRescheduleTimerContext = (ActivityRescheduleTimerContext)this.getContext(ActivityRescheduleTimerContext.class);
        TimerSpecification timerSpecification = activityRescheduleTimerContext.getTimerSpecification();
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Timer specification is " + timerSpecification));
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"About to call rescheduleTimer().");
        }
        businessFlowManagerService.rescheduleTimer(activityInstanceBean.getID(), timerSpecification);
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }

    public boolean isMultiSelectEnabled() {
        return false;
    }

    protected void checkPreconditions(ActivityInstanceBean activityInstanceBean, Locale locale) throws ActivityWrongStateException, ActivityWrongKindException, ActivityInvalidActionException {
        this.traceActivityProperties(activityInstanceBean, locale);
        Assert.assertion((boolean)(activityInstanceBean instanceof ActivityInstanceBeanExt), (String)("activity must be of type " + ActivityInstanceBeanExt.class.getName()));
        if (!((ActivityInstanceBeanExt)activityInstanceBean).isActionAvailable(3044)) {
            this.checkExpectedKindAndState(activityInstanceBean, EXPECTED_KIND_AND_STATE, locale);
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"No reason found for unavailable action!");
            }
            throw new ActivityInvalidActionException(new Object[]{activityInstanceBean.getName()});
        }
    }

    static {
        EXPECTED_KIND_AND_STATE.put(new Integer(21), STATE_RUNNING);
        EXPECTED_KIND_AND_STATE.put(new Integer(43), STATES_READY_CLAIMED);
        EXPECTED_KIND_AND_STATE.put(new Integer(27), STATE_WAITING);
        EXPECTED_KIND_AND_STATE.put(new Integer(36), STATE_WAITING);
    }
}

