/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.clientmodel.command;

import com.ibm.bpc.clientcore.exception.CommunicationException;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.clientmodel.bean.ActivityInstanceBean;
import com.ibm.bpe.clientmodel.bean.ActivityInstanceBeanExt;
import com.ibm.bpe.clientmodel.command.ActivityInstanceCommand;
import com.ibm.bpe.clientmodel.exception.ActivityInvalidActionException;
import com.ibm.bpe.clientmodel.exception.ActivityNoJumpTargetsException;
import com.ibm.bpe.clientmodel.exception.ActivityWrongKindException;
import com.ibm.bpe.clientmodel.exception.ActivityWrongStateException;
import com.ibm.bpe.clientmodel.exception.ActivityWrongSubStateException;
import com.ibm.bpe.clientmodel.exception.BFMCommandException;
import com.ibm.bpe.util.Assert;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public abstract class ActivityJumpCommand
extends ActivityInstanceCommand {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2009.\n\n";
    protected static Map<Integer, List<Integer>> EXPECTED_KIND_AND_STATE = new HashMap<Integer, List<Integer>>(5);

    public ActivityJumpCommand(String string, String string2) {
        super(string, string2);
    }

    public boolean isMultiSelectEnabled() {
        return false;
    }

    protected void checkPreconditions(ActivityInstanceBean activityInstanceBean, Locale locale) throws ActivityWrongStateException, ActivityWrongKindException, ActivityNoJumpTargetsException, ActivityWrongSubStateException, BFMCommandException, CommunicationException, ActivityInvalidActionException {
        this.traceActivityProperties(activityInstanceBean, locale);
        Assert.assertion((boolean)(activityInstanceBean instanceof ActivityInstanceBeanExt), (String)("activity must be of type " + ActivityInstanceBeanExt.class.getName()));
        if (!(((ActivityInstanceBeanExt)activityInstanceBean).isActionAvailable(3036) || ((ActivityInstanceBeanExt)activityInstanceBean).isActionAvailable(3037) || ((ActivityInstanceBeanExt)activityInstanceBean).isActionAvailable(3038))) {
            this.checkExpectedKindAndState(activityInstanceBean, EXPECTED_KIND_AND_STATE, locale);
            int n = activityInstanceBean.getSubState();
            if (n != 0) {
                throw new ActivityWrongSubStateException(new Object[]{ActivityJumpCommand.getSubStateAsString(n, locale), activityInstanceBean.getName()});
            }
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"No reason found for unavailable action!");
            }
            throw new ActivityInvalidActionException(new Object[]{activityInstanceBean.getName()});
        }
        ((ActivityInstanceBeanExt)activityInstanceBean).getJumpTargetNames();
    }

    static {
        EXPECTED_KIND_AND_STATE.put(new Integer(KIND_BASIC), STATE_STOPPED);
        EXPECTED_KIND_AND_STATE.put(new Integer(21), STATE_RUNNING);
        EXPECTED_KIND_AND_STATE.put(new Integer(43), STATES_READY_CLAIMED);
        EXPECTED_KIND_AND_STATE.put(new Integer(27), STATE_WAITING);
        EXPECTED_KIND_AND_STATE.put(new Integer(23), STATE_WAITING);
    }
}

