/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.clientmodel.command;

import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpc.clientcore.CommandContext;
import com.ibm.bpc.clientcore.converter.SimpleConverter;
import com.ibm.bpc.clientcore.exception.CommunicationException;
import com.ibm.bpc.clientcore.exception.ContextNotSetException;
import com.ibm.bpc.clientcore.exception.ErrorsInCommandException;
import com.ibm.bpc.clientcore.exception.InvalidContextException;
import com.ibm.bpc.clientcore.exception.NotAuthorizedException;
import com.ibm.bpc.clientcore.exception.WrongTypeForCommandException;
import com.ibm.bpe.api.AIID;
import com.ibm.bpe.api.BusinessFlowManagerService;
import com.ibm.bpe.api.EngineActivityDoesNotExistException;
import com.ibm.bpe.api.EngineActivityWrongKindException;
import com.ibm.bpe.api.EngineActivityWrongStateException;
import com.ibm.bpe.api.EngineNotAuthorizedException;
import com.ibm.bpe.api.EngineProcessWrongStateException;
import com.ibm.bpe.api.ProcessException;
import com.ibm.bpe.api.ProcessInstanceData;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.clientmodel.BFMConnection;
import com.ibm.bpe.clientmodel.bean.ActivityInstanceBean;
import com.ibm.bpe.clientmodel.bean.ProcessInstanceBean;
import com.ibm.bpe.clientmodel.command.BFMCommand;
import com.ibm.bpe.clientmodel.exception.ActivityDoesNotExistException;
import com.ibm.bpe.clientmodel.exception.ActivityWrongKindException;
import com.ibm.bpe.clientmodel.exception.ActivityWrongStateException;
import com.ibm.bpe.clientmodel.exception.BFMCommandException;
import com.ibm.bpe.clientmodel.exception.ProcessWrongStateException;
import com.ibm.bpe.clientmodel.util.BFMUtils;
import com.ibm.bpe.util.Assert;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.ejb.EJBException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ActivityInstanceCommand
extends BFMCommand {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2009.\n\n";
    private Object context = null;
    private String apiCallName4Trace = null;
    private String successView = null;
    private String commandClazz = null;
    private BFMConnection connection;
    private boolean multipleActivitiesSelected = false;
    protected static List<Integer> BASIC_ACTIVITY_KINDS = new ArrayList<Integer>(14);
    protected static int KIND_EXPLORER_ANY;
    protected static int KIND_BASIC;
    protected static List<Integer> STATE_STOPPED;
    protected static List<Integer> STATE_RUNNING;
    protected static List<Integer> STATE_WAITING;
    protected static List<Integer> STATES_READY_CLAIMED;

    public ActivityInstanceCommand(String string, String string2) {
        this.apiCallName4Trace = string;
        this.successView = string2;
        this.commandClazz = this.getClass().getName();
    }

    @Override
    public void setBFMConnection(BFMConnection bFMConnection) {
        this.connection = bFMConnection;
    }

    public boolean isMultiSelectEnabled() {
        return true;
    }

    public boolean[] isApplicable(List list) {
        return null;
    }

    public void setContext(Object object) {
        this.context = object;
    }

    public String execute(List list) throws ClientException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)this.commandClazz);
        }
        this.checkSelectedItems(list);
        CommandContext commandContext = (CommandContext)this.getContext(CommandContext.class);
        BusinessFlowManagerService businessFlowManagerService = BFMUtils.getBusinessFlowManagerService(this.connection);
        Assert.assertion((businessFlowManagerService != null ? 1 : 0) != 0, (String)"BusinessProcessService is null, but getting it did not cause an Exception");
        HashMap<AIID, ClientException> hashMap = new HashMap<AIID, ClientException>();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            ClientException clientException = null;
            ActivityInstanceBean activityInstanceBean = null;
            Object e = list.get(i);
            try {
                activityInstanceBean = (ActivityInstanceBean)e;
            }
            catch (ClassCastException classCastException) {
                clientException = new WrongTypeForCommandException(new Object[]{"ActivityInstanceCommand", ActivityInstanceBean.class.getName(), e.getClass().getName()}, (Throwable)classCastException);
            }
            this.traceActivityProperties(activityInstanceBean, commandContext.getLocale());
            try {
                this.multipleActivitiesSelected = n > 1;
                this.executeBFMCommand(businessFlowManagerService, activityInstanceBean);
            }
            catch (ClientException clientException2) {
                clientException = clientException2;
            }
            catch (EngineNotAuthorizedException engineNotAuthorizedException) {
                clientException = new NotAuthorizedException(new Object[0], (Throwable)engineNotAuthorizedException);
            }
            catch (EngineProcessWrongStateException engineProcessWrongStateException) {
                clientException = new ProcessWrongStateException(new Object[]{this.getProcessInstanceStateString(businessFlowManagerService, activityInstanceBean, commandContext.getLocale()), activityInstanceBean.getProcessInstanceName()}, engineProcessWrongStateException);
            }
            catch (EngineActivityWrongStateException engineActivityWrongStateException) {
                clientException = new ActivityWrongStateException(new Object[]{ActivityInstanceCommand.getStateAsString(activityInstanceBean.getExecutionState(), commandContext.getLocale()), activityInstanceBean.getName()}, engineActivityWrongStateException);
            }
            catch (EngineActivityWrongKindException engineActivityWrongKindException) {
                clientException = new ActivityWrongKindException(new Object[]{ActivityInstanceCommand.getKindAsString(activityInstanceBean.getKind(), commandContext.getLocale()), activityInstanceBean.getName()}, engineActivityWrongKindException);
            }
            catch (EngineActivityDoesNotExistException engineActivityDoesNotExistException) {
                clientException = new ActivityDoesNotExistException(new Object[]{activityInstanceBean.getName()}, engineActivityDoesNotExistException);
            }
            catch (ProcessException processException) {
                clientException = new BFMCommandException(new Object[]{this.commandClazz}, processException);
            }
            catch (RemoteException remoteException) {
                clientException = new CommunicationException(new Object[]{this.commandClazz}, (Throwable)remoteException);
            }
            catch (EJBException eJBException) {
                clientException = new CommunicationException(new Object[]{this.commandClazz}, (Throwable)eJBException);
            }
            if (clientException == null) continue;
            if (activityInstanceBean != null) {
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (Throwable)clientException);
                }
                hashMap.put(activityInstanceBean.getID(), clientException);
                continue;
            }
            throw clientException;
        }
        if (hashMap.size() != 0) {
            ErrorsInCommandException errorsInCommandException = new ErrorsInCommandException(hashMap);
            throw errorsInCommandException;
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)(this.commandClazz + " - successView=" + this.successView));
        }
        return this.successView;
    }

    protected abstract void executeBFMCommand(BusinessFlowManagerService var1, ActivityInstanceBean var2) throws ClientException, ProcessException, RemoteException, EJBException;

    public Object getContext(Class clazz) throws ClientException {
        if (this.context == null) {
            throw new ContextNotSetException(new Object[]{this.getClass()});
        }
        if (!clazz.isInstance(this.context)) {
            throw new InvalidContextException(new Object[]{this.context.getClass(), clazz, this.context.getClass()}, null);
        }
        return this.context;
    }

    public void setSuccessView(String string) {
        this.successView = string;
    }

    public String getSuccessView() {
        return this.successView;
    }

    protected void checkExpectedKindAndState(ActivityInstanceBean activityInstanceBean, Map<Integer, List<Integer>> map, Locale locale) throws ActivityWrongKindException, ActivityWrongStateException {
        List<Integer> list;
        Integer n = new Integer(activityInstanceBean.getKind());
        Integer n2 = new Integer(activityInstanceBean.getExecutionState());
        Integer n3 = n;
        if (!map.containsKey(n)) {
            if (map.containsKey(new Integer(KIND_EXPLORER_ANY))) {
                n3 = new Integer(KIND_EXPLORER_ANY);
            } else if (map.containsKey(new Integer(KIND_BASIC)) && BASIC_ACTIVITY_KINDS.contains(n)) {
                n3 = new Integer(KIND_BASIC);
            } else {
                String string = ActivityInstanceCommand.getKindAsString(n, locale);
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Wrong kind for " + this.apiCallName4Trace + ": " + string));
                }
                throw new ActivityWrongKindException(new Object[]{string, activityInstanceBean.getName()});
            }
        }
        if (!(list = map.get(n3)).contains(n2)) {
            String string = ActivityInstanceCommand.getStateAsString(n2, locale);
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Wrong state for " + this.apiCallName4Trace + ": " + string));
            }
            throw new ActivityWrongStateException(new Object[]{string, activityInstanceBean.getName()});
        }
    }

    protected static String getStateAsString(int n, Locale locale) {
        SimpleConverter simpleConverter = ActivityInstanceBean.getConverter("executionState");
        String string = "";
        if (simpleConverter != null) {
            string = string + simpleConverter.getAsString((Object)new Integer(n), locale);
        }
        return string;
    }

    protected static String getKindAsString(int n, Locale locale) {
        SimpleConverter simpleConverter = ActivityInstanceBean.getConverter("kind");
        String string = "";
        if (simpleConverter != null) {
            string = string + simpleConverter.getAsString((Object)new Integer(n), locale);
        }
        return string;
    }

    protected static String getSubStateAsString(int n, Locale locale) {
        SimpleConverter simpleConverter = ActivityInstanceBean.getConverter("subState");
        String string = "";
        if (simpleConverter != null) {
            string = simpleConverter.getAsString((Object)new Integer(n), locale);
        }
        return string;
    }

    protected static String getStopReasonAsString(int n, Locale locale) {
        SimpleConverter simpleConverter = ActivityInstanceBean.getConverter("stopReason");
        String string = "";
        if (simpleConverter != null) {
            string = simpleConverter.getAsString((Object)new Integer(n), locale);
        }
        return string;
    }

    private String getProcessInstanceStateString(BusinessFlowManagerService businessFlowManagerService, ActivityInstanceBean activityInstanceBean, Locale locale) {
        SimpleConverter simpleConverter;
        String string = "";
        ProcessInstanceData processInstanceData = null;
        try {
            processInstanceData = businessFlowManagerService.getProcessInstance(activityInstanceBean.getProcessInstanceID());
        }
        catch (ProcessException processException) {
        }
        catch (RemoteException remoteException) {
        }
        catch (EJBException eJBException) {
            // empty catch block
        }
        if (processInstanceData != null && (simpleConverter = ProcessInstanceBean.getConverter("executionState")) != null) {
            string = string + simpleConverter.getAsString((Object)new Integer(processInstanceData.getExecutionState()), locale);
        }
        return string;
    }

    protected void traceActivityProperties(ActivityInstanceBean activityInstanceBean, Locale locale) {
        ActivityInstanceCommand.traceActivityProperties(this.apiCallName4Trace, activityInstanceBean, locale);
    }

    protected static void traceActivityProperties(String string, ActivityInstanceBean activityInstanceBean, Locale locale) {
        if (BPCClientTrace.isTracing) {
            int n = activityInstanceBean.getExecutionState();
            int n2 = activityInstanceBean.getKind();
            int n3 = activityInstanceBean.getStopReason();
            String string2 = "";
            if (n == 13) {
                string2 = ", stop reason is " + ActivityInstanceCommand.getStopReasonAsString(n3, locale);
            }
            int n4 = activityInstanceBean.getSubState();
            String string3 = "";
            if (n4 == 0) {
                string3 = ", sub state is " + ActivityInstanceCommand.getSubStateAsString(n4, locale);
            }
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)(string + ": kind is " + ActivityInstanceCommand.getKindAsString(n2, locale) + ", state is " + ActivityInstanceCommand.getStateAsString(n, locale) + string2 + string3));
        }
    }

    protected boolean isMultipleActivitiesSelected() {
        return this.multipleActivitiesSelected;
    }

    static {
        BASIC_ACTIVITY_KINDS.add(new Integer(3));
        BASIC_ACTIVITY_KINDS.add(new Integer(21));
        BASIC_ACTIVITY_KINDS.add(new Integer(23));
        BASIC_ACTIVITY_KINDS.add(new Integer(24));
        BASIC_ACTIVITY_KINDS.add(new Integer(25));
        BASIC_ACTIVITY_KINDS.add(new Integer(26));
        BASIC_ACTIVITY_KINDS.add(new Integer(27));
        BASIC_ACTIVITY_KINDS.add(new Integer(29));
        BASIC_ACTIVITY_KINDS.add(new Integer(42));
        BASIC_ACTIVITY_KINDS.add(new Integer(43));
        BASIC_ACTIVITY_KINDS.add(new Integer(44));
        BASIC_ACTIVITY_KINDS.add(new Integer(45));
        BASIC_ACTIVITY_KINDS.add(new Integer(46));
        BASIC_ACTIVITY_KINDS.add(new Integer(51));
        KIND_EXPLORER_ANY = 999;
        KIND_BASIC = 998;
        STATE_STOPPED = new ArrayList<Integer>(1);
        STATE_RUNNING = new ArrayList<Integer>(1);
        STATE_WAITING = new ArrayList<Integer>(1);
        STATES_READY_CLAIMED = new ArrayList<Integer>(2);
        STATE_RUNNING.add(new Integer(3));
        STATE_STOPPED.add(new Integer(13));
        STATES_READY_CLAIMED.add(new Integer(2));
        STATES_READY_CLAIMED.add(new Integer(8));
        STATE_WAITING.add(new Integer(11));
    }
}

