/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.clientmodel.command;

import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpc.clientcore.MessageWrapper;
import com.ibm.bpe.api.BusinessFlowManagerService;
import com.ibm.bpe.api.ClientObjectWrapper;
import com.ibm.bpe.api.ProcessException;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.clientmodel.bean.ActivityInstanceBean;
import com.ibm.bpe.clientmodel.bean.ActivityInstanceBeanExt;
import com.ibm.bpe.clientmodel.command.ActivityInstanceCommand;
import com.ibm.bpe.clientmodel.command.ActivityMessageContext;
import com.ibm.bpe.clientmodel.exception.ActivityInvalidActionException;
import com.ibm.bpe.clientmodel.exception.ActivityWrongKindException;
import com.ibm.bpe.clientmodel.exception.ActivityWrongStateException;
import com.ibm.bpe.clientmodel.exception.ActivityWrongStopReasonException;
import com.ibm.bpe.clientmodel.exception.ActivityWrongSubStateException;
import com.ibm.bpe.util.Assert;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ActivityForceRetryCommand
extends ActivityInstanceCommand {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2009.\n\n";
    protected static Map<Integer, List<Integer>> EXPECTED_KIND_AND_STATE = new HashMap<Integer, List<Integer>>(3);

    public ActivityForceRetryCommand() {
        super("forceRetry", null);
    }

    protected void executeBFMCommand(BusinessFlowManagerService businessFlowManagerService, ActivityInstanceBean activityInstanceBean) throws ClientException, ProcessException, RemoteException {
        MessageWrapper messageWrapper;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        ActivityMessageContext activityMessageContext = (ActivityMessageContext)this.getContext(ActivityMessageContext.class);
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Continue on error is " + Boolean.toString(activityMessageContext.isContinueOnError())));
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Expiration behavior is " + activityMessageContext.getExpirationBehaviorAsString()));
        }
        if ((messageWrapper = activityMessageContext.getInputMessageWrapper()) != null && messageWrapper.getMessage() != null) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Input message is " + messageWrapper.getMessage()));
            }
            businessFlowManagerService.forceRetry(activityInstanceBean.getID(), new ClientObjectWrapper(messageWrapper.getMessage()), activityMessageContext.isContinueOnError(), activityMessageContext.getExpirationBehavior());
        } else {
            businessFlowManagerService.forceRetry(activityInstanceBean.getID(), null, activityMessageContext.isContinueOnError(), activityMessageContext.getExpirationBehavior());
        }
        this.setSuccessView(activityMessageContext.getSuccessTarget());
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }

    protected void checkPreconditions(ActivityInstanceBean activityInstanceBean, Locale locale) throws ActivityWrongStateException, ActivityWrongKindException, ActivityWrongSubStateException, ActivityWrongStopReasonException, ActivityInvalidActionException {
        this.traceActivityProperties(activityInstanceBean, locale);
        Assert.assertion((boolean)(activityInstanceBean instanceof ActivityInstanceBeanExt), (String)("activity must be of type " + ActivityInstanceBeanExt.class.getName()));
        if (!((ActivityInstanceBeanExt)activityInstanceBean).isActionAvailable(3018)) {
            this.checkExpectedKindAndState(activityInstanceBean, EXPECTED_KIND_AND_STATE, locale);
            int n = activityInstanceBean.getStopReason();
            if (n == 4) {
                throw new ActivityWrongStopReasonException(new Object[]{ActivityForceRetryCommand.getStopReasonAsString(n, locale), activityInstanceBean.getName()});
            }
            int n2 = activityInstanceBean.getSubState();
            if (n2 != 0) {
                throw new ActivityWrongSubStateException(new Object[]{ActivityForceRetryCommand.getSubStateAsString(n2, locale), activityInstanceBean.getName()});
            }
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"No reason found for unavailable action!");
            }
            throw new ActivityInvalidActionException(new Object[]{activityInstanceBean.getName()});
        }
    }

    static {
        EXPECTED_KIND_AND_STATE.put(new Integer(KIND_EXPLORER_ANY), STATE_STOPPED);
        EXPECTED_KIND_AND_STATE.put(new Integer(21), STATE_RUNNING);
        EXPECTED_KIND_AND_STATE.put(new Integer(43), STATES_READY_CLAIMED);
    }
}

