/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.clientmodel.command;

import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpc.clientcore.MessageWrapper;
import com.ibm.bpe.api.BusinessFlowManagerService;
import com.ibm.bpe.api.ClientObjectWrapper;
import com.ibm.bpe.api.ProcessException;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.clientmodel.bean.ActivityInstanceBean;
import com.ibm.bpe.clientmodel.command.ActivityForceCompleteCommand;
import com.ibm.bpe.clientmodel.command.ActivityMessageContext;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import java.rmi.RemoteException;

public class ActivityForceCompleteWithFaultCommand
extends ActivityForceCompleteCommand {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2009.\n\n";

    protected void executeBFMCommand(BusinessFlowManagerService businessFlowManagerService, ActivityInstanceBean activityInstanceBean) throws ClientException, ProcessException, RemoteException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        ActivityMessageContext activityMessageContext = (ActivityMessageContext)this.getContext(ActivityMessageContext.class);
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Continue on error is " + Boolean.toString(activityMessageContext.isContinueOnError())));
        }
        this.executeForceComplete(businessFlowManagerService, activityInstanceBean);
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }

    protected void executeForceComplete(BusinessFlowManagerService businessFlowManagerService, ActivityInstanceBean activityInstanceBean) throws ClientException, ProcessException, RemoteException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        ActivityMessageContext activityMessageContext = (ActivityMessageContext)this.getContext(ActivityMessageContext.class);
        MessageWrapper messageWrapper = activityMessageContext.getFaultMessageWrapper();
        ClientObjectWrapper clientObjectWrapper = null;
        if (messageWrapper != null && messageWrapper.getMessage() != null) {
            clientObjectWrapper = new ClientObjectWrapper(messageWrapper.getMessage());
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Fault message is " + messageWrapper.getMessage()));
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Fault name is " + messageWrapper.getFaultName()));
            }
        }
        if (clientObjectWrapper != null) {
            businessFlowManagerService.forceComplete(activityInstanceBean.getID(), clientObjectWrapper, messageWrapper.getFaultName(), activityMessageContext.isContinueOnError());
        } else {
            businessFlowManagerService.forceComplete(activityInstanceBean.getID(), activityMessageContext.isContinueOnError());
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }
}

