/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.clientmodel.command;

import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpc.clientcore.MessageWrapper;
import com.ibm.bpc.clientcore.exception.PropertyNotSetException;
import com.ibm.bpe.api.BusinessFlowManagerService;
import com.ibm.bpe.api.ClientObjectWrapper;
import com.ibm.bpe.api.ProcessException;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.clientmodel.bean.ActivityInstanceBean;
import com.ibm.bpe.clientmodel.bean.ActivityInstanceBeanExt;
import com.ibm.bpe.clientmodel.command.ActivityInstanceCommand;
import com.ibm.bpe.clientmodel.command.ActivityMessageContext;
import com.ibm.bpe.clientmodel.exception.ActivityInvalidActionException;
import com.ibm.bpe.clientmodel.exception.ActivityWrongKindException;
import com.ibm.bpe.clientmodel.exception.ActivityWrongStateException;
import com.ibm.bpe.clientmodel.exception.ActivityWrongStopReasonException;
import com.ibm.bpe.clientmodel.exception.ActivityWrongSubStateException;
import com.ibm.bpe.util.Assert;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ActivityForceCompleteCommand
extends ActivityInstanceCommand {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2009.\n\n";
    protected static Map<Integer, List<Integer>> EXPECTED_KIND_AND_STATE = new HashMap<Integer, List<Integer>>(4);

    public ActivityForceCompleteCommand() {
        super("forceComplete", null);
    }

    protected void executeBFMCommand(BusinessFlowManagerService businessFlowManagerService, ActivityInstanceBean activityInstanceBean) throws ClientException, ProcessException, RemoteException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        ActivityMessageContext activityMessageContext = (ActivityMessageContext)this.getContext(ActivityMessageContext.class);
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Continue on error is " + Boolean.toString(activityMessageContext.isContinueOnError())));
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"About to call forceComplete().");
        }
        this.executeForceComplete(businessFlowManagerService, activityInstanceBean);
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }

    protected void executeForceComplete(BusinessFlowManagerService businessFlowManagerService, ActivityInstanceBean activityInstanceBean) throws ClientException, ProcessException, RemoteException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        ActivityMessageContext activityMessageContext = (ActivityMessageContext)this.getContext(ActivityMessageContext.class);
        MessageWrapper messageWrapper = null;
        try {
            messageWrapper = activityMessageContext.getOutputMessageWrapper();
        }
        catch (PropertyNotSetException propertyNotSetException) {
            // empty catch block
        }
        ClientObjectWrapper clientObjectWrapper = null;
        if (messageWrapper != null && messageWrapper.getMessage() != null) {
            clientObjectWrapper = new ClientObjectWrapper(messageWrapper.getMessage());
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Output message is " + messageWrapper.getMessage()));
            }
        }
        if (clientObjectWrapper != null) {
            businessFlowManagerService.forceComplete(activityInstanceBean.getID(), clientObjectWrapper, activityMessageContext.isContinueOnError());
        } else {
            businessFlowManagerService.forceComplete(activityInstanceBean.getID(), activityMessageContext.isContinueOnError());
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }

    public boolean isMultiSelectEnabled() {
        return false;
    }

    protected void checkPreconditions(ActivityInstanceBean activityInstanceBean, Locale locale) throws ActivityWrongStateException, ActivityWrongKindException, ActivityWrongSubStateException, ActivityWrongStopReasonException, ActivityInvalidActionException {
        this.traceActivityProperties(activityInstanceBean, locale);
        Assert.assertion((boolean)(activityInstanceBean instanceof ActivityInstanceBeanExt), (String)("activity must be of type " + ActivityInstanceBeanExt.class.getName()));
        if (!((ActivityInstanceBeanExt)activityInstanceBean).isActionAvailable(3017)) {
            this.checkExpectedKindAndState(activityInstanceBean, EXPECTED_KIND_AND_STATE, locale);
            int n = activityInstanceBean.getStopReason();
            if (n == 2) {
                throw new ActivityWrongStopReasonException(new Object[]{ActivityForceCompleteCommand.getStopReasonAsString(n, locale), activityInstanceBean.getName()});
            }
            int n2 = activityInstanceBean.getSubState();
            if (n2 != 0) {
                throw new ActivityWrongSubStateException(new Object[]{ActivityForceCompleteCommand.getSubStateAsString(n2, locale), activityInstanceBean.getName()});
            }
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"No reason found for unavailable action!");
            }
            throw new ActivityInvalidActionException(new Object[]{activityInstanceBean.getName()});
        }
    }

    static {
        EXPECTED_KIND_AND_STATE.put(new Integer(KIND_EXPLORER_ANY), STATE_STOPPED);
        EXPECTED_KIND_AND_STATE.put(new Integer(21), STATE_RUNNING);
        EXPECTED_KIND_AND_STATE.put(new Integer(43), STATES_READY_CLAIMED);
        EXPECTED_KIND_AND_STATE.put(new Integer(27), STATE_WAITING);
    }
}

