/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.clientmodel.bean;

import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpc.clientcore.converter.BooleanConverter;
import com.ibm.bpc.clientcore.converter.CalendarConverter;
import com.ibm.bpc.clientcore.converter.SimpleConverter;
import com.ibm.bpc.clientcore.exception.CommunicationException;
import com.ibm.bpc.clientcore.util.LocaleUtils;
import com.ibm.bpe.api.ActivityServiceTemplateData;
import com.ibm.bpe.api.BusinessFlowManagerService;
import com.ibm.bpe.api.InvalidLengthException;
import com.ibm.bpe.api.PTID;
import com.ibm.bpe.api.ProcessException;
import com.ibm.bpe.api.ProcessTemplateData;
import com.ibm.bpe.api.StaffResultSet;
import com.ibm.bpe.api.WorkItemManagerException;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.clientmodel.BFMConnection;
import com.ibm.bpe.clientmodel.bean.ActivityServiceTemplateBean;
import com.ibm.bpe.clientmodel.converter.ProcessTemplateAutonomyConverter;
import com.ibm.bpe.clientmodel.converter.ProcessTemplateDeletionModeConverter;
import com.ibm.bpe.clientmodel.converter.ProcessTemplateExecutionModeConverter;
import com.ibm.bpe.clientmodel.converter.ProcessTemplateStateConverter;
import com.ibm.bpe.clientmodel.exception.BFMCommandException;
import com.ibm.bpe.clientmodel.exception.NoStartActivitiesException;
import com.ibm.bpe.clientmodel.util.BFMUtils;
import com.ibm.bpe.util.Assert;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import com.ibm.task.api.TKTID;
import com.ibm.task.clientmodel.converter.StaffResultSetConverter;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.ejb.EJBException;

public class ProcessTemplateBean
implements ProcessTemplateData {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2009.\n\n";
    private static HashMap converters = new HashMap();
    private static HashMap labels = new HashMap();
    private BFMConnection connection = null;
    private static final long serialVersionUID = 1L;
    public static final String APPLICATIONNAME_PROPERTY = "applicationName";
    public static final String AUTODELETE_PROPERTY = "autoDelete";
    public static final String AUTONOMY_PROPERTY = "autonomy";
    public static final String AVAILABLEACTIONS_PROPERTY = "availableActions";
    public static final String COMPENSATIONDEFINED_PROPERTY = "compensationDefined";
    public static final String CONTINUEONERROR_PROPERTY = "continueOnError";
    public static final String CREATIONTIME_PROPERTY = "creationTime";
    public static final String DESCRIPTION_PROPERTY = "description";
    public static final String DISPLAYNAME_PROPERTY = "displayName";
    public static final String DOCUMENTATION_PROPERTY = "documentation";
    public static final String EXECUTIONMODE_PROPERTY = "executionMode";
    public static final String ID_PROPERTY = "ID";
    public static final String INPUTMESSAGETYPENAME_PROPERTY = "inputMessageTypeName";
    public static final String INPUTMESSAGETYPETYPESYSTEM_PROPERTY = "inputMessageTypeTypeSystem";
    public static final String LASTMODIFICATIONTIME_PROPERTY = "lastModificationTime";
    public static final String NAME_PROPERTY = "name";
    public static final String OUTPUTMESSAGETYPENAME_PROPERTY = "outputMessageTypeName";
    public static final String OUTPUTMESSAGETYPETYPESYSTEM_PROPERTY = "outputMessageTypeTypeSystem";
    public static final String PROCESSADMINSTRATORS_PROPERTY = "processAdministrators";
    public static final String SCHEMAVERSION_PROPERTY = "schemaVersion";
    public static final String STATE_PROPERTY = "state";
    public static final String VALIDFROMTIME_PROPERTY = "validFromTime";
    public static final String VERSION_PROPERTY = "version";
    public static final String AUTO_DELETION_MODE = "autoDeletionMode";
    public static final String TARGETNAMESPACE_PROPERTY = "targetNamespace";
    private ProcessTemplateData original;
    private List activities;

    public static SimpleConverter getConverter(String string) {
        SimpleConverter simpleConverter = (SimpleConverter)converters.get(string);
        return simpleConverter;
    }

    public static String getLabel(String string) {
        String string2 = (String)labels.get(string);
        return string2;
    }

    public static String getLabel(String string, Locale locale) {
        String string2 = LocaleUtils.getLocalizedString((String)((String)labels.get(string)), (Locale)locale);
        return string2;
    }

    public static boolean isValid(String string) {
        boolean bl = labels.get(string) != null;
        return bl;
    }

    public ProcessTemplateBean(ProcessTemplateData processTemplateData, BFMConnection bFMConnection) {
        this.original = processTemplateData;
        this.connection = bFMConnection;
        Assert.assertion((this.original != null ? 1 : 0) != 0, (String)"original != null");
    }

    public String getApplicationName() {
        return this.original.getApplicationName();
    }

    public boolean getAutoDelete() {
        return this.original.getAutoDelete();
    }

    public int getAutoDeletionMode() {
        return this.original.getAutoDeletionMode();
    }

    public int getAutonomy() {
        return this.original.getAutonomy();
    }

    public int[] getAvailableActions() {
        return this.original.getAvailableActions();
    }

    public Calendar getCreationTime() {
        return this.original.getCreationTime();
    }

    public String getDescription() {
        return this.original.getDescription();
    }

    public String getDisplayName() {
        String string = this.original.getDisplayName();
        if (string == null || string.equals("")) {
            return this.getName();
        }
        return string;
    }

    public String getDocumentation() {
        return this.original.getDocumentation();
    }

    public int getExecutionMode() {
        return this.original.getExecutionMode();
    }

    public PTID getID() {
        return this.original.getID();
    }

    public String getInputMessageTypeName() {
        return this.original.getInputMessageTypeName();
    }

    public String getInputMessageTypeTypeSystemName() {
        return this.original.getInputMessageTypeTypeSystemName();
    }

    public Calendar getLastModificationTime() {
        return this.original.getLastModificationTime();
    }

    public String getName() {
        return this.original.getName();
    }

    public String getOutputMessageTypeName() {
        return this.original.getOutputMessageTypeName();
    }

    public String getOutputMessageTypeTypeSystemName() {
        return this.original.getOutputMessageTypeTypeSystemName();
    }

    public StaffResultSet getProcessAdministrators() throws WorkItemManagerException, InvalidLengthException {
        return this.original.getProcessAdministrators();
    }

    public int getSchemaVersion() {
        return this.original.getSchemaVersion();
    }

    public int getState() {
        return this.original.getState();
    }

    public String getTargetNamespace() {
        return this.original.getTargetNamespace();
    }

    public Calendar getValidFromTime() {
        return this.original.getValidFromTime();
    }

    public String getVersion() {
        return this.original.getVersion();
    }

    public TKTID getAdminTaskTemplateID() {
        return this.original.getAdminTaskTemplateID();
    }

    public boolean isBusinessRelevant() {
        return this.original.isBusinessRelevant();
    }

    public boolean isCompensationDefined() {
        return this.original.isCompensationDefined();
    }

    public boolean isContinueOnError() {
        return this.original.isContinueOnError();
    }

    public List getActivityServiceTemplates() throws ClientException {
        if (this.activities == null) {
            ActivityServiceTemplateData[] activityServiceTemplateDataArray;
            BusinessFlowManagerService businessFlowManagerService = BFMUtils.getBusinessFlowManagerService(this.connection);
            try {
                activityServiceTemplateDataArray = businessFlowManagerService.getStartActivities(this.getID());
            }
            catch (RemoteException remoteException) {
                throw new CommunicationException(new Object[]{"BusinessFlowManagerService.getStartActivities"}, (Throwable)remoteException);
            }
            catch (EJBException eJBException) {
                throw new CommunicationException(new Object[]{"BusinessFlowManagerService.getStartActivities"}, (Throwable)eJBException);
            }
            catch (ProcessException processException) {
                throw new BFMCommandException(new Object[]{"BusinessFlowManagerService.getStartActivities"}, processException);
            }
            if (activityServiceTemplateDataArray.length == 0) {
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"No starting activities available");
                }
                throw new NoStartActivitiesException(new Object[]{this.getName()});
            }
            this.activities = this.convertToList(activityServiceTemplateDataArray);
        }
        return this.activities;
    }

    private List convertToList(ActivityServiceTemplateData[] activityServiceTemplateDataArray) {
        ArrayList<ActivityServiceTemplateBean> arrayList = new ArrayList<ActivityServiceTemplateBean>(activityServiceTemplateDataArray.length);
        for (int i = 0; i < activityServiceTemplateDataArray.length; ++i) {
            arrayList.add(new ActivityServiceTemplateBean(activityServiceTemplateDataArray[i], this.connection));
        }
        return arrayList;
    }

    static {
        labels.put(ID_PROPERTY, "PROCESS.TEMPLATE.ID");
        labels.put(AUTODELETE_PROPERTY, "PROCESS.TEMPLATE.DELETE.ON.COMPLETION");
        labels.put(AVAILABLEACTIONS_PROPERTY, "PROCESS.TEMPLATE.AVAILABLEACTIONS");
        labels.put(CREATIONTIME_PROPERTY, "PROCESS.TEMPLATE.CREATED");
        labels.put(DESCRIPTION_PROPERTY, "PROCESS.TEMPLATE.DESCRIPTION");
        labels.put(DOCUMENTATION_PROPERTY, "PROCESS.TEMPLATE.DOCUMENTATION");
        labels.put(STATE_PROPERTY, "PROCESS.TEMPLATE.STATE");
        labels.put(SCHEMAVERSION_PROPERTY, "PROCESS.TEMPLATE.SCHEMAVERSION");
        labels.put(LASTMODIFICATIONTIME_PROPERTY, "PROCESS.TEMPLATE.LASTMODIFICATIONTIME");
        labels.put(NAME_PROPERTY, "PROCESS.TEMPLATE.NAME");
        labels.put(APPLICATIONNAME_PROPERTY, "PROCESS.TEMPLATE.APPLICATIONNAME");
        labels.put(DISPLAYNAME_PROPERTY, "PROCESS.TEMPLATE.NAME");
        labels.put(VALIDFROMTIME_PROPERTY, "PROCESS.TEMPLATE.VALID.FROM");
        labels.put(VERSION_PROPERTY, "PROCESS.TEMPLATE.VERSION");
        labels.put(EXECUTIONMODE_PROPERTY, "PROCESS.TEMPLATE.EXECUTION.MODE");
        labels.put(AUTONOMY_PROPERTY, "PROCESS.TEMPLATE.AUTONOMY");
        labels.put(COMPENSATIONDEFINED_PROPERTY, "PROCESS.TEMPLATE.COMPENSATION.DEFINED");
        labels.put(CONTINUEONERROR_PROPERTY, "PROCESS.TEMPLATE.CONTINUEONERROR");
        labels.put(INPUTMESSAGETYPENAME_PROPERTY, "PROCESS.TEMPLATE.INPUT.MESSAGE.TYPE");
        labels.put(INPUTMESSAGETYPETYPESYSTEM_PROPERTY, "PROCESS.TEMPLATE.INPUT.MESSAGE.TYPE.SYSTEM");
        labels.put(OUTPUTMESSAGETYPENAME_PROPERTY, "PROCESS.TEMPLATE.OUTPUT.MESSAGE.TYPE");
        labels.put(OUTPUTMESSAGETYPETYPESYSTEM_PROPERTY, "PROCESS.TEMPLATE.OUTPUT.MESSAGE.TYPE.SYSTEM");
        labels.put(PROCESSADMINSTRATORS_PROPERTY, "PROCESS.TEMPLATE.PROCESSADMINISTRATORS");
        labels.put(AUTO_DELETION_MODE, "PROCESS.TEMPLATE.AUTODELETIONMODE");
        labels.put(TARGETNAMESPACE_PROPERTY, "PROCESS.TEMPLATE.TARGET.NAMESPACE");
        converters.put(CREATIONTIME_PROPERTY, new CalendarConverter());
        converters.put(STATE_PROPERTY, new ProcessTemplateStateConverter());
        converters.put(CREATIONTIME_PROPERTY, new CalendarConverter());
        converters.put(LASTMODIFICATIONTIME_PROPERTY, new CalendarConverter());
        converters.put(VALIDFROMTIME_PROPERTY, new CalendarConverter());
        converters.put(EXECUTIONMODE_PROPERTY, new ProcessTemplateExecutionModeConverter());
        converters.put(PROCESSADMINSTRATORS_PROPERTY, new StaffResultSetConverter());
        converters.put(AUTODELETE_PROPERTY, new BooleanConverter());
        converters.put(COMPENSATIONDEFINED_PROPERTY, new BooleanConverter());
        converters.put(CONTINUEONERROR_PROPERTY, new BooleanConverter());
        converters.put(AUTONOMY_PROPERTY, new ProcessTemplateAutonomyConverter());
        converters.put(AUTO_DELETION_MODE, new ProcessTemplateDeletionModeConverter());
    }
}

