/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.clientmodel.bean;

import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpc.clientcore.ColumnInfo;
import com.ibm.bpc.clientcore.converter.SimpleConverter;
import com.ibm.bpc.clientcore.util.ErrorBeanImplExt;
import com.ibm.bpc.clientcore.util.FieldMapCreator;
import com.ibm.bpc.clientcore.util.LocaleUtils;
import com.ibm.bpe.api.ProcessException;
import com.ibm.bpe.api.ProcessInstanceActions;
import com.ibm.bpe.api.ProcessInstanceData;
import com.ibm.bpe.api.QueryResultSet;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.clientmodel.BFMConnection;
import com.ibm.bpe.clientmodel.bean.ProcessInstanceBean;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import com.ibm.task.clientmodel.converter.StaffListConverter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessInstanceBeanExt
extends ProcessInstanceBean {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2004, 2009.\n\n";
    private static final long serialVersionUID = 1L;
    public static Map<String, String> propertyNameToDBMap = new HashMap<String, String>();
    public static final String STAFFINFOADMINSTRATORS_PROPERTY = "staffInfoAdministrators";
    public static final String STAFFINFOREADERS_PROPERTY = "staffInfoReaders";
    private static Map<String, String> labels;
    private static Map<String, SimpleConverter> converters;
    private BFMConnection connection;
    public static final String TABLE_NAME = "PROCESS_INSTANCE";
    private static Map<Integer, String> actionNames;
    private List<Integer> availableActions = null;
    private Map<Integer, List<String>> staffInfo = null;

    public static SimpleConverter getConverter(String string) {
        SimpleConverter simpleConverter = converters.get(string);
        if (simpleConverter == null) {
            simpleConverter = ProcessInstanceBean.getConverter(string);
        }
        return simpleConverter;
    }

    public static String getLabel(String string) {
        String string2 = labels.get(string);
        if (string2 == null) {
            string2 = ProcessInstanceBean.getLabel(string);
        }
        return string2;
    }

    public static String getLabel(String string, Locale locale) {
        String string2 = LocaleUtils.getLocalizedString((String)ProcessInstanceBeanExt.getLabel(string), (Locale)locale);
        return string2;
    }

    public static boolean isValid(String string) {
        boolean bl = ProcessInstanceBeanExt.getLabel(string) != null;
        return bl;
    }

    public static ColumnInfo getColumnInfo(String string, String string2) {
        if (ProcessInstanceBeanExt.isValid(string)) {
            return new ColumnInfo(string, ProcessInstanceBeanExt.getLabel(string), (Object)ProcessInstanceBeanExt.getConverter(string), string2);
        }
        return null;
    }

    public ProcessInstanceBeanExt(ProcessInstanceData processInstanceData, BFMConnection bFMConnection) {
        super(processInstanceData, bFMConnection);
        this.connection = bFMConnection;
    }

    public ProcessInstanceBeanExt(QueryResultSet queryResultSet, BFMConnection bFMConnection) {
        super(queryResultSet, bFMConnection);
        this.connection = bFMConnection;
    }

    public BFMConnection getConnection() {
        return this.connection;
    }

    public void setConnection(BFMConnection bFMConnection) {
        this.connection = bFMConnection;
    }

    public String getExceptionMessage() {
        ProcessException processException = null;
        String string = null;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        try {
            processException = this.getUnhandledException();
            if (processException == null) {
                return "none";
            }
            ErrorBeanImplExt errorBeanImplExt = new ErrorBeanImplExt();
            if (processException instanceof Exception) {
                if (processException instanceof ProcessException) {
                    errorBeanImplExt.setException((Exception)((Object)processException));
                    string = processException instanceof ClientException ? errorBeanImplExt.getAllExceptionMessages() : errorBeanImplExt.getAllExceptionMessages();
                } else {
                    errorBeanImplExt.setException((Exception)((Object)processException));
                    string = errorBeanImplExt.getAllExceptionStacks();
                }
            }
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.exit(string);
            }
            return string;
        }
        catch (Throwable throwable) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (Throwable)throwable);
            }
            return "Internal error while getting Unhandled Exception: \n" + throwable.toString();
        }
    }

    public boolean isActionAvailable(int n) {
        boolean bl = false;
        if (this.availableActions == null) {
            int[] nArray = this.getAvailableActions();
            this.availableActions = new ArrayList<Integer>(nArray.length);
            for (int i = 0; i < nArray.length; ++i) {
                this.availableActions.add(nArray[i]);
            }
            actionNames = FieldMapCreator.createKeyMap(ProcessInstanceActions.class, (String)"", (String)"");
        }
        if (this.availableActions != null) {
            boolean bl2 = bl = this.availableActions.indexOf(new Integer(n)) > -1;
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Action " + actionNames.get(n) + " available: " + Boolean.toString(bl)));
            }
        }
        return bl;
    }

    public void resetAvailableActions() {
        actionNames = null;
        this.availableActions = null;
    }

    public Map<Integer, List<String>> getStaffInfo() {
        return this.staffInfo;
    }

    public void setStaffInfo(Map<Integer, List<String>> map) {
        if (BPCClientTrace.isTracing && map != null) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)map.toString());
        }
        this.staffInfo = map;
    }

    private List<String> getStaffInfo(Integer n) {
        if (this.staffInfo != null) {
            return this.staffInfo.get(n);
        }
        return null;
    }

    public List<String> getStaffInfoAdministrators() {
        return this.getStaffInfo(7);
    }

    public List<String> getStaffInfoReaders() {
        return this.getStaffInfo(3);
    }

    static {
        propertyNameToDBMap.put("ID", "PROCESS_INSTANCE.PIID");
        propertyNameToDBMap.put("completionTime", "PROCESS_INSTANCE.COMPLETED");
        propertyNameToDBMap.put("creationTime", "PROCESS_INSTANCE.CREATED");
        propertyNameToDBMap.put("startTime", "PROCESS_INSTANCE.STARTED");
        propertyNameToDBMap.put("description", "PROCESS_INSTANCE.DESCRIPTION");
        propertyNameToDBMap.put("name", "PROCESS_INSTANCE.NAME");
        propertyNameToDBMap.put("parentProcessInstanceName", "PROCESS_INSTANCE.PARENT_NAME");
        propertyNameToDBMap.put("starter", "PROCESS_INSTANCE.STARTER");
        propertyNameToDBMap.put("processTemplateName", "PROCESS_INSTANCE.TEMPLATE_NAME");
        propertyNameToDBMap.put("processTemplateDisplayName", "PROCESS_TEMPLATE.DISPLAY_NAME");
        propertyNameToDBMap.put("validFromTime", "PROCESS_TEMPLATE.VALID_FROM");
        propertyNameToDBMap.put("topLevelProcessInstanceName", "PROCESS_INSTANCE.TOP_LEVEL_NAME");
        propertyNameToDBMap.put("processTemplateID", "PROCESS_INSTANCE.PTID");
        propertyNameToDBMap.put("executionState", "PROCESS_INSTANCE.STATE");
        labels = new HashMap<String, String>();
        labels.put(STAFFINFOADMINSTRATORS_PROPERTY, "PROCESS.INSTANCE.ADMINISTRATORS");
        labels.put(STAFFINFOREADERS_PROPERTY, "PROCESS.INSTANCE.READERS");
        converters = new HashMap<String, SimpleConverter>();
        converters.put(STAFFINFOADMINSTRATORS_PROPERTY, (SimpleConverter)new StaffListConverter());
        converters.put(STAFFINFOREADERS_PROPERTY, (SimpleConverter)new StaffListConverter());
        actionNames = null;
    }
}

