/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.clientmodel.bean;

import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpc.clientcore.MessageWrapper;
import com.ibm.bpc.clientcore.converter.BooleanConverter;
import com.ibm.bpc.clientcore.converter.CalendarConverter;
import com.ibm.bpc.clientcore.converter.ExceptionConverter;
import com.ibm.bpc.clientcore.converter.SimpleConverter;
import com.ibm.bpc.clientcore.exception.CommunicationException;
import com.ibm.bpc.clientcore.util.ClientUIHelper;
import com.ibm.bpc.clientcore.util.LocaleUtils;
import com.ibm.bpc.clientcore.util.MessageWrapperImpl;
import com.ibm.bpe.api.AIID;
import com.ibm.bpe.api.BusinessFlowManagerService;
import com.ibm.bpe.api.ClientObjectWrapper;
import com.ibm.bpe.api.CustomClientSettings;
import com.ibm.bpe.api.EngineWrongKindException;
import com.ibm.bpe.api.InvalidLengthException;
import com.ibm.bpe.api.JspLocation;
import com.ibm.bpe.api.JspUsageEnum;
import com.ibm.bpe.api.OID;
import com.ibm.bpe.api.PIID;
import com.ibm.bpe.api.PTID;
import com.ibm.bpe.api.ProcessException;
import com.ibm.bpe.api.ProcessInstanceData;
import com.ibm.bpe.api.QueryResultSet;
import com.ibm.bpe.api.StaffResultSet;
import com.ibm.bpe.api.WebClientSetting;
import com.ibm.bpe.api.WorkItemManagerException;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.clientmodel.BFMConnection;
import com.ibm.bpe.clientmodel.converter.ProcessInstanceExecutionStateConverter;
import com.ibm.bpe.clientmodel.exception.BFMCommandException;
import com.ibm.bpe.clientmodel.util.BFMUtils;
import com.ibm.bpe.util.Assert;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import com.ibm.task.api.TKIID;
import com.ibm.task.clientmodel.converter.StaffResultSetConverter;
import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.ejb.EJBException;

public class ProcessInstanceBean
implements ProcessInstanceData {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2004, 2008.\n\n";
    private static final long serialVersionUID = 1L;
    public static final String AVAILABLEACTIONS_PROPERTY = "availableActions";
    public static final String COMPENSATIONSPHERENAME_PROPERTY = "compensationSphereName";
    public static final String COMPLETIONTIME_PROPERTY = "completionTime";
    public static final String CONTINUEONERROR_PROPERTY = "continueOnError";
    public static final String RESUMPTIONTIME_PROPERTY = "resumptionTime";
    public static final String CREATIONTIME_PROPERTY = "creationTime";
    public static final String CUSTOMPROPERTY_PROPERTY = "customProperty";
    public static final String DESCRIPTION_PROPERTY = "description";
    public static final String DISPLAYNAME_PROPERTY = "displayName";
    public static final String EXECUTIONSTATE_PROPERTY = "executionState";
    public static final String FAULTNAME_PROPERTY = "faultName";
    public static final String ID_PROPERTY = "ID";
    public static final String ISCOMPENSATIONDEFINED_PROPERTY = "compensationDefined";
    public static final String INPUTMESSAGETPYENAME_PROPERTY = "inputMessageTypeName";
    public static final String INPUTMESSAGETYPETYPESYSTEMNAME_PROPERTY = "inputMessageTypeTypeSystemName";
    public static final String LASTMODIFICATIONTIME_PROPERTY = "lastModificationTime";
    public static final String LASTSTATECHANGETIME_PROPERTY = "lastStateChangeTime";
    public static final String MIGRATED_PROPERTY = "migrated";
    public static final String NAME_PROPERTY = "name";
    public static final String OUTPUTMESSAGETPYENAME_PROPERTY = "outputMessageTypeName";
    public static final String OUTPUTMESSAGETYPETYPESYSTEMNAME_PROPERTY = "outputMessageTypeTypeSystemName";
    public static final String PROCESSADMINISTRATORS_PROPERTY = "processAdministrators";
    public static final String PROCESSTEMPLATEID_PROPERTY = "processTemplateID";
    public static final String PROCESSTEMPLATENAME_PROPERTY = "processTemplateName";
    public static final String PROCESSTEMPLATEDISPLAYNAME_PROPERTY = "processTemplateDisplayName";
    public static final String STARTER_PROPERTY = "starter";
    public static final String STARTTIME_PROPERTY = "startTime";
    public static final String TOPLEVELPROCESSINSTANCEID_PROPERTY = "topLevelProcessInstanceID";
    public static final String TOPLEVELPROCESSINSTANCENAME_PROPERTY = "topLevelProcessInstanceName";
    public static final String PARENTPROCESSINSTANCEID_PROPERTY = "parentProcessInstanceID";
    public static final String PARENTACTIVITYINSTANCEID_PROPERTY = "parentActivityInstanceID";
    public static final String PARENTPROCESSINSTANCENAME_PROPERTY = "parentProcessInstanceName";
    public static final String UNHANDLEDEXCEPTION_PROPERTY = "unhandledException";
    public static final String EXCEPTIONMESSAGE_PROPERTY = "exceptionMessage";
    public static final String VALIDFROMTIME_PROPERTY = "validFromTime";
    private static final TimeZone UTC_TIMEZONE = TimeZone.getTimeZone("UTC");
    private static final String DEFAULT_PROCESS_VIEW_NAME = "PROCESS_INSTANCE";
    private static Map labels = new HashMap();
    private static Map converters = new HashMap();
    private BFMConnection connection;
    private ProcessInstanceData original;
    private PIID piid = null;
    private long completionTime;
    private boolean completionTimeSet = false;
    private boolean completionTimeFound = false;
    private long resumptionTime;
    private boolean resumptionTimeSet = false;
    private boolean resumptionTimeFound = false;
    private long creationTime;
    private boolean creationTimeSet = false;
    private boolean creationTimeFound = false;
    private String description;
    private boolean descriptionSet = false;
    private boolean descriptionFound = false;
    private boolean templateDescriptionFound = false;
    private String name = null;
    private boolean nameSet = false;
    private String parentProcessInstanceName = null;
    private boolean parentProcessInstanceNameSet = false;
    private boolean parentProcessInstanceNameFound = false;
    private long startTime;
    private boolean startTimeSet = false;
    private boolean startTimeFound = false;
    private String starter = null;
    private boolean starterSet = false;
    private boolean starterFound = false;
    private Integer executionState = null;
    private boolean executionStateSet = false;
    private String processTemplateName = null;
    private boolean processTemplateNameSet = false;
    private String processTemplateDisplayName = null;
    private boolean processTemplateDisplayNameSet = false;
    private String topLevelProcessInstanceName = null;
    private boolean topLevelProcessInstanceNameSet = false;
    private Calendar validFromTime = null;
    private boolean validFromTimeSet = false;

    public static SimpleConverter getConverter(String string) {
        SimpleConverter simpleConverter = (SimpleConverter)converters.get(string);
        return simpleConverter;
    }

    public static String getLabel(String string) {
        String string2 = (String)labels.get(string);
        return string2;
    }

    public static String getLabel(String string, Locale locale) {
        String string2 = LocaleUtils.getLocalizedString((String)ProcessInstanceBean.getLabel(string), (Locale)locale);
        return string2;
    }

    public static boolean isValid(String string) {
        boolean bl = ProcessInstanceBean.getLabel(string) != null;
        return bl;
    }

    public ProcessInstanceBean(ProcessInstanceData processInstanceData, BFMConnection bFMConnection) {
        this.original = processInstanceData;
        Assert.assertion((this.original != null ? 1 : 0) != 0, (String)"original != null");
        this.connection = bFMConnection;
    }

    public ProcessInstanceBean(QueryResultSet queryResultSet, BFMConnection bFMConnection) {
        this(queryResultSet, DEFAULT_PROCESS_VIEW_NAME, bFMConnection);
    }

    public ProcessInstanceBean(QueryResultSet queryResultSet, String string, BFMConnection bFMConnection) {
        Long l = null;
        for (int i = 1; i <= queryResultSet.numberColumns(); ++i) {
            String string2 = queryResultSet.getTableDisplayName(i);
            String string3 = queryResultSet.getColumnDisplayName(i);
            String string4 = null;
            String string5 = null;
            if (string.equalsIgnoreCase(string2)) {
                if (string3.equalsIgnoreCase("PIID")) {
                    this.piid = (PIID)queryResultSet.getOID(i);
                } else if (string3.equalsIgnoreCase("COMPLETED")) {
                    this.completionTimeFound = true;
                    l = queryResultSet.getTimestampAsLong(i);
                    if (l != null) {
                        this.completionTime = l;
                        this.completionTimeSet = true;
                    }
                } else if (string3.equalsIgnoreCase("CREATED")) {
                    this.creationTimeFound = true;
                    l = queryResultSet.getTimestampAsLong(i);
                    if (l != null) {
                        this.creationTime = l;
                        this.creationTimeSet = true;
                    }
                } else if (string3.equalsIgnoreCase("RESUMES")) {
                    this.resumptionTimeFound = true;
                    l = queryResultSet.getTimestampAsLong(i);
                    if (l != null) {
                        this.resumptionTime = l;
                        this.resumptionTimeSet = true;
                    }
                } else if (string3.equalsIgnoreCase("TEMPLATE_DESCR")) {
                    this.templateDescriptionFound = true;
                    string5 = queryResultSet.getString(i);
                } else if (string3.equalsIgnoreCase("DESCRIPTION")) {
                    this.descriptionFound = true;
                    string4 = queryResultSet.getString(i);
                } else if (string3.equalsIgnoreCase("NAME")) {
                    this.name = queryResultSet.getString(i);
                    this.nameSet = true;
                } else if (string3.equalsIgnoreCase("PARENT_NAME")) {
                    this.parentProcessInstanceNameFound = true;
                    this.parentProcessInstanceName = queryResultSet.getString(i);
                    this.parentProcessInstanceNameSet = true;
                } else if (string3.equalsIgnoreCase("STARTED")) {
                    this.startTimeFound = true;
                    l = queryResultSet.getTimestampAsLong(i);
                    if (l != null) {
                        this.startTime = l;
                        this.startTimeSet = true;
                    }
                } else if (string3.equalsIgnoreCase("STARTER")) {
                    this.starterFound = true;
                    this.starter = queryResultSet.getString(i);
                    this.starterSet = true;
                } else if (string3.equalsIgnoreCase("STATE")) {
                    this.executionState = queryResultSet.getInteger(i);
                    this.executionStateSet = true;
                } else if (string3.equalsIgnoreCase("TEMPLATE_NAME")) {
                    this.processTemplateName = queryResultSet.getString(i);
                    this.processTemplateNameSet = true;
                } else if (string3.equalsIgnoreCase("TOP_LEVEL_NAME")) {
                    this.topLevelProcessInstanceName = queryResultSet.getString(i);
                    this.topLevelProcessInstanceNameSet = true;
                }
            } else if ("PROCESS_TEMPLATE".equalsIgnoreCase(string2)) {
                if ("DISPLAY_NAME".equalsIgnoreCase(string3)) {
                    this.processTemplateDisplayName = queryResultSet.getString(i);
                    this.processTemplateDisplayNameSet = true;
                } else if ("VALID_FROM".equalsIgnoreCase(string3)) {
                    this.validFromTime = queryResultSet.getTimestamp(i);
                    this.validFromTimeSet = true;
                }
            }
            if (string5 != null) {
                this.descriptionSet = true;
                this.description = string5;
            }
            if (string4 == null) continue;
            this.descriptionSet = true;
            this.description = string4;
        }
        this.connection = bFMConnection;
    }

    public TKIID getAdminTaskID() {
        return this.getOriginal().getAdminTaskID();
    }

    public int[] getAvailableActions() {
        return this.getOriginal().getAvailableActions();
    }

    public String getCompensationSphereName() {
        return this.getOriginal().getCompensationSphereName();
    }

    public Calendar getCompletionTime() {
        if (this.completionTimeSet && this.original == null) {
            Calendar calendar = Calendar.getInstance(UTC_TIMEZONE);
            calendar.setTimeInMillis(this.completionTime);
            return calendar;
        }
        if (this.original == null) {
            if (!this.completionTimeFound && BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"No value and no original!");
            }
            return null;
        }
        return this.getOriginal().getCompletionTime();
    }

    public Calendar getResumptionTime() {
        if (this.resumptionTimeSet && this.original == null) {
            Calendar calendar = Calendar.getInstance(UTC_TIMEZONE);
            calendar.setTimeInMillis(this.resumptionTime);
            return calendar;
        }
        if (this.original == null) {
            if (!this.resumptionTimeFound && BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"No value and no original!");
            }
            return null;
        }
        return this.getOriginal().getResumptionTime();
    }

    public Calendar getCreationTime() {
        if (this.creationTimeSet && this.original == null) {
            Calendar calendar = Calendar.getInstance(UTC_TIMEZONE);
            calendar.setTimeInMillis(this.creationTime);
            return calendar;
        }
        if (this.original == null) {
            if (!this.creationTimeFound && BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"No value and no original!");
            }
            return null;
        }
        return this.getOriginal().getCreationTime();
    }

    public String getCustomProperty(String string) {
        return this.getOriginal().getCustomProperty(string);
    }

    public String getDescription() {
        if (this.descriptionSet && this.original == null) {
            return this.description;
        }
        if (this.original == null) {
            if (!(this.descriptionFound && this.templateDescriptionFound || !BPCClientTrace.isTracing)) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"No value and no original!");
            }
            return null;
        }
        return this.getOriginal().getDescription();
    }

    public String getDisplayName() {
        String string = this.processTemplateDisplayName;
        if (!this.processTemplateDisplayNameSet || this.original != null) {
            string = this.getOriginal().getDisplayName();
        }
        if (string == null || string.equals("")) {
            string = this.getName();
        }
        return string;
    }

    public int getExecutionState() {
        if (this.executionStateSet && this.original == null) {
            return this.executionState;
        }
        return this.getOriginal().getExecutionState();
    }

    public String getFaultName() {
        return this.getOriginal().getFaultName();
    }

    public PIID getID() {
        if (this.original != null) {
            return this.original.getID();
        }
        if (this.piid != null) {
            return this.piid;
        }
        return this.getOriginal().getID();
    }

    public String getInputMessageTypeName() {
        return this.getOriginal().getInputMessageTypeName();
    }

    public String getInputMessageTypeTypeSystemName() {
        return this.getOriginal().getInputMessageTypeTypeSystemName();
    }

    public Calendar getLastModificationTime() {
        return this.getOriginal().getLastModificationTime();
    }

    public Calendar getLastStateChangeTime() {
        return this.getOriginal().getLastStateChangeTime();
    }

    public String getName() {
        if (this.nameSet && this.original == null) {
            return this.name;
        }
        return this.getOriginal().getName();
    }

    public List getNamesOfCustomProperties() {
        return this.getOriginal().getNamesOfCustomProperties();
    }

    private ProcessInstanceData getOriginal() {
        if (this.original == null) {
            try {
                Object object;
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Retrieving original for " + this.piid));
                }
                if ((object = this.connection.retrieve((OID)this.piid)) instanceof ProcessInstanceData) {
                    this.original = (ProcessInstanceData)object;
                }
            }
            catch (Exception exception) {
                throw new RuntimeException("Could not load original data from PIID.", exception);
            }
        }
        return this.original;
    }

    public String getOutputMessageTypeName() {
        return this.getOriginal().getOutputMessageTypeName();
    }

    public String getOutputMessageTypeTypeSystemName() {
        return this.getOriginal().getOutputMessageTypeTypeSystemName();
    }

    public StaffResultSet getProcessAdministrators() throws WorkItemManagerException, InvalidLengthException {
        return this.getOriginal().getProcessAdministrators();
    }

    public PTID getProcessTemplateID() {
        return this.getOriginal().getProcessTemplateID();
    }

    public String getProcessTemplateName() {
        if (this.processTemplateNameSet && this.original == null) {
            return this.processTemplateName;
        }
        return this.getOriginal().getProcessTemplateName();
    }

    public String getProcessTemplateDisplayName() {
        String string = this.processTemplateDisplayName;
        if (!this.processTemplateDisplayNameSet || this.original != null) {
            string = this.getOriginal().getDisplayName();
        }
        if (string == null || string.equals("")) {
            string = this.getProcessTemplateName();
        }
        return string;
    }

    public String getStarter() {
        if (this.starterSet && this.original == null) {
            return this.starter;
        }
        if (this.original == null) {
            if (!this.starterFound && BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"No value and no original!");
            }
            return null;
        }
        return this.getOriginal().getStarter();
    }

    public Calendar getStartTime() {
        if (this.startTimeSet && this.original == null) {
            Calendar calendar = Calendar.getInstance(UTC_TIMEZONE);
            calendar.setTimeInMillis(this.startTime);
            return calendar;
        }
        if (this.original == null) {
            if (!this.startTimeFound && BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"No value and no original!");
            }
            return null;
        }
        return this.getOriginal().getStartTime();
    }

    public PIID getTopLevelProcessInstanceID() {
        return this.getOriginal().getTopLevelProcessInstanceID();
    }

    public String getTopLevelProcessInstanceName() {
        if (this.topLevelProcessInstanceNameSet && this.original == null) {
            return this.topLevelProcessInstanceName;
        }
        return this.getOriginal().getTopLevelProcessInstanceName();
    }

    public String getParentProcessInstanceName() {
        if (this.parentProcessInstanceNameSet && this.original == null) {
            return this.parentProcessInstanceName;
        }
        if (this.original == null) {
            if (!this.parentProcessInstanceNameFound && BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"No value and no original!");
            }
            return null;
        }
        return this.getOriginal().getParentProcessInstanceName();
    }

    public PIID getParentProcessInstanceID() {
        return this.getOriginal().getParentProcessInstanceID();
    }

    public AIID getParentActivityInstanceID() {
        return this.getOriginal().getParentActivityInstanceID();
    }

    public Calendar getValidFromTime() {
        if (this.validFromTimeSet && this.original == null) {
            return this.validFromTime;
        }
        return this.getOriginal().getValidFromTime();
    }

    public boolean isBusinessRelevant() {
        return this.getOriginal().isBusinessRelevant();
    }

    public boolean isCompensationDefined() {
        return this.getOriginal().isCompensationDefined();
    }

    public void setExecutionState(int n) {
        this.executionState = new Integer(n);
        this.executionStateSet = true;
        this.original = null;
    }

    public MessageWrapper getInputMessageWrapper() throws ClientException {
        MessageWrapperImpl messageWrapperImpl = null;
        try {
            BusinessFlowManagerService businessFlowManagerService = BFMUtils.getBusinessFlowManagerService(this.connection);
            messageWrapperImpl = new MessageWrapperImpl(BFMUtils.lookupApplicationName(businessFlowManagerService, this));
            ClientObjectWrapper clientObjectWrapper = businessFlowManagerService.getInputMessage(this.getID());
            if (BPCClientTrace.isTracing) {
                if (clientObjectWrapper != null && clientObjectWrapper.getObject() != null) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Message available for " + this.getID()));
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)clientObjectWrapper.getObject().toString());
                } else {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("No message available for " + this.getID()));
                }
            }
            if (clientObjectWrapper != null) {
                messageWrapperImpl.setMessage(clientObjectWrapper.getObject());
                if (ClientUIHelper.getWebClientType() != null) {
                    CustomClientSettings customClientSettings;
                    if (BPCClientTrace.isTracing) {
                        BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Set client settings.");
                    }
                    WebClientSetting webClientSetting = (customClientSettings = businessFlowManagerService.getInputClientUISettings(this.getID())) != null ? customClientSettings.getWebClientSetting(ClientUIHelper.getWebClientType()) : null;
                    JspLocation jspLocation = webClientSetting != null ? ClientUIHelper.getJspLocationForOriginatingInterface((JspUsageEnum)JspUsageEnum.INPUT, (WebClientSetting)webClientSetting) : null;
                    String string = jspLocation != null ? jspLocation.getContextRoot() : null;
                    String string2 = jspLocation != null ? jspLocation.getUriAsString() : null;
                    messageWrapperImpl.setContextRoot(string);
                    messageWrapperImpl.setUrl(string2);
                }
            }
        }
        catch (EngineWrongKindException engineWrongKindException) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"No message available for this kind");
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (Throwable)engineWrongKindException);
            }
        }
        catch (RemoteException remoteException) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (Throwable)remoteException);
            }
            throw new CommunicationException(new Object[]{"BusinessFlowManager.getInputMessage"}, (Throwable)remoteException);
        }
        catch (ProcessException processException) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (Throwable)processException);
            }
            throw new BFMCommandException(new Object[]{"BusinessFlowManager.getInputMessage"}, processException);
        }
        catch (EJBException eJBException) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (Throwable)eJBException);
            }
            throw new CommunicationException(new Object[]{"BusinessFlowManager.getInputMessage"}, (Throwable)eJBException);
        }
        return messageWrapperImpl;
    }

    public MessageWrapper getOutputMessageWrapper() throws ClientException {
        MessageWrapperImpl messageWrapperImpl = null;
        try {
            BusinessFlowManagerService businessFlowManagerService = BFMUtils.getBusinessFlowManagerService(this.connection);
            messageWrapperImpl = new MessageWrapperImpl(BFMUtils.lookupApplicationName(businessFlowManagerService, this));
            ClientObjectWrapper clientObjectWrapper = businessFlowManagerService.getOutputMessage(this.getID());
            if (BPCClientTrace.isTracing) {
                if (clientObjectWrapper != null && clientObjectWrapper.getObject() != null) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Message available for " + this.getID()));
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)clientObjectWrapper.getObject().toString());
                } else {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("No message available for " + this.getID()));
                }
            }
            if (clientObjectWrapper != null) {
                messageWrapperImpl.setMessage(clientObjectWrapper.getObject());
                if (ClientUIHelper.getWebClientType() != null) {
                    CustomClientSettings customClientSettings;
                    if (BPCClientTrace.isTracing) {
                        BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Set client settings.");
                    }
                    WebClientSetting webClientSetting = (customClientSettings = businessFlowManagerService.getOutputClientUISettings(this.getID())) != null ? customClientSettings.getWebClientSetting(ClientUIHelper.getWebClientType()) : null;
                    JspLocation jspLocation = customClientSettings != null ? ClientUIHelper.getJspLocationForOriginatingInterface((JspUsageEnum)JspUsageEnum.OUTPUT, (WebClientSetting)webClientSetting) : null;
                    String string = jspLocation != null ? jspLocation.getContextRoot() : null;
                    String string2 = jspLocation != null ? jspLocation.getUriAsString() : null;
                    messageWrapperImpl.setContextRoot(string);
                    messageWrapperImpl.setUrl(string2);
                }
            }
        }
        catch (EngineWrongKindException engineWrongKindException) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"No message available for this kind");
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (Throwable)engineWrongKindException);
            }
        }
        catch (RemoteException remoteException) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (Throwable)remoteException);
            }
            throw new CommunicationException(new Object[]{"BusinessFlowManager.getOutputMessage"}, (Throwable)remoteException);
        }
        catch (ProcessException processException) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (Throwable)processException);
            }
            throw new BFMCommandException(new Object[]{"BusinessFlowManager.getOutputMessage"}, processException);
        }
        catch (EJBException eJBException) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (Throwable)eJBException);
            }
            throw new CommunicationException(new Object[]{"BusinessFlowManager.getOutputMessage"}, (Throwable)eJBException);
        }
        return messageWrapperImpl;
    }

    public MessageWrapper getFaultMessageWrapper() throws ClientException {
        MessageWrapperImpl messageWrapperImpl = null;
        try {
            BusinessFlowManagerService businessFlowManagerService = BFMUtils.getBusinessFlowManagerService(this.connection);
            messageWrapperImpl = new MessageWrapperImpl(BFMUtils.lookupApplicationName(businessFlowManagerService, this));
            ClientObjectWrapper clientObjectWrapper = businessFlowManagerService.getFaultMessage(this.getID());
            if (BPCClientTrace.isTracing) {
                if (clientObjectWrapper != null && clientObjectWrapper.getObject() != null) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Message available for " + this.getID()));
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)clientObjectWrapper.getObject().toString());
                } else {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("No message available for " + this.getID()));
                }
            }
            if (clientObjectWrapper != null) {
                messageWrapperImpl.setMessage(clientObjectWrapper.getObject());
            }
        }
        catch (EngineWrongKindException engineWrongKindException) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"No message available for this kind");
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (Throwable)engineWrongKindException);
            }
        }
        catch (RemoteException remoteException) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (Throwable)remoteException);
            }
            throw new CommunicationException(new Object[]{"BusinessFlowManager.getFaultMessage"}, (Throwable)remoteException);
        }
        catch (ProcessException processException) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (Throwable)processException);
            }
            throw new BFMCommandException(new Object[]{"BusinessFlowManager.getFaultMessage"}, processException);
        }
        catch (EJBException eJBException) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (Throwable)eJBException);
            }
            throw new CommunicationException(new Object[]{"BusinessFlowManager.getFaultMessage"}, (Throwable)eJBException);
        }
        return messageWrapperImpl;
    }

    public ProcessException getUnhandledException() {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        ProcessException processException = null;
        try {
            ProcessInstanceData processInstanceData = this.getOriginal();
            if (processInstanceData == null) {
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Could not obtain ProcessInstanceData object!");
                }
                return new CommunicationException(new Object[]{"BusinessFlowManager.getUnhandledException"});
            }
            processException = processInstanceData.getUnhandledException();
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.exit((Object)((Object)processException));
            }
            return processException;
        }
        catch (Throwable throwable) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (Throwable)throwable);
            }
            return new CommunicationException(new Object[]{"BusinessFlowManager.getUnhandledException"}, throwable);
        }
    }

    public boolean isContinueOnError() {
        return this.getOriginal().isContinueOnError();
    }

    public boolean isMigrated() {
        return this.getOriginal().isMigrated();
    }

    static {
        labels.put(AVAILABLEACTIONS_PROPERTY, "PROCESS.INSTANCE.AVAILABLEACTIONS");
        labels.put(COMPENSATIONSPHERENAME_PROPERTY, "PROCESS.INSTANCE.COMPENSATIONSPHERENAME");
        labels.put(COMPLETIONTIME_PROPERTY, "PROCESS.INSTANCE.COMPLETIONTIME");
        labels.put(CONTINUEONERROR_PROPERTY, "PROCESS.INSTANCE.CONTINUEONERROR");
        labels.put(RESUMPTIONTIME_PROPERTY, "PROCESS.INSTANCE.RESUMPTIONTIME");
        labels.put(CREATIONTIME_PROPERTY, "PROCESS.INSTANCE.CREATED");
        labels.put(CUSTOMPROPERTY_PROPERTY, "PROCESS.INSTANCE.CUSTOMPROPERTY");
        labels.put(DESCRIPTION_PROPERTY, "PROCESS.INSTANCE.DESCRIPTION");
        labels.put(DISPLAYNAME_PROPERTY, "PROCESS.INSTANCE.NAME");
        labels.put(EXECUTIONSTATE_PROPERTY, "PROCESS.INSTANCE.STATE");
        labels.put(FAULTNAME_PROPERTY, "PROCESS.INSTANCE.FAULTNAME");
        labels.put(ID_PROPERTY, "PROCESS.INSTANCE.PIID");
        labels.put(INPUTMESSAGETPYENAME_PROPERTY, "PROCESS.INSTANCE.INPUT.MESSAGE.TYPE");
        labels.put(ISCOMPENSATIONDEFINED_PROPERTY, "PROCESS.INSTANCE.ISCOMPENSATIONDEFINED");
        labels.put(MIGRATED_PROPERTY, "PROCESS.INSTANCE.MIGRATED");
        labels.put(INPUTMESSAGETYPETYPESYSTEMNAME_PROPERTY, "PROCESS.INSTANCE.INPUT.MESSAGE.TYPE.SYSTEM");
        labels.put(LASTMODIFICATIONTIME_PROPERTY, "PROCESS.INSTANCE.LASTMODIFICATIONTIME");
        labels.put(LASTSTATECHANGETIME_PROPERTY, "PROCESS.INSTANCE.LASTSTATECHANGETIME");
        labels.put(NAME_PROPERTY, "PROCESS.INSTANCE.NAME");
        labels.put(OUTPUTMESSAGETPYENAME_PROPERTY, "PROCESS.INSTANCE.OUTPUT.MESSAGE.TYPE");
        labels.put(OUTPUTMESSAGETYPETYPESYSTEMNAME_PROPERTY, "PROCESS.INSTANCE.OUTPUT.MESSAGE.TYPE.SYSTEM");
        labels.put(PROCESSADMINISTRATORS_PROPERTY, "PROCESS.INSTANCE.ADMINISTRATORS");
        labels.put(PROCESSTEMPLATEID_PROPERTY, "PROCESS.INSTANCE.PROCESSTEMPLATEID");
        labels.put(PROCESSTEMPLATENAME_PROPERTY, "PROCESS.INSTANCE.TEMPLATE.NAME");
        labels.put(PROCESSTEMPLATEDISPLAYNAME_PROPERTY, "PROCESS.INSTANCE.TEMPLATE.NAME");
        labels.put(STARTER_PROPERTY, "PROCESS.INSTANCE.STARTER");
        labels.put(STARTTIME_PROPERTY, "PROCESS.INSTANCE.STARTED");
        labels.put(TOPLEVELPROCESSINSTANCEID_PROPERTY, "PROCESS.INSTANCE.TOPLEVEL.ID");
        labels.put(TOPLEVELPROCESSINSTANCENAME_PROPERTY, "PROCESS.INSTANCE.TOPLEVEL.NAME");
        labels.put(PARENTPROCESSINSTANCEID_PROPERTY, "PROCESS.INSTANCE.PARENT.PIID");
        labels.put(PARENTACTIVITYINSTANCEID_PROPERTY, "PROCESS.INSTANCE.PARENT.AIID");
        labels.put(PARENTPROCESSINSTANCENAME_PROPERTY, "PROCESS.INSTANCE.PARENT.NAME");
        labels.put(UNHANDLEDEXCEPTION_PROPERTY, "PROCESS.INSTANCE.UNHANDLEDEXCEPTION");
        labels.put(EXCEPTIONMESSAGE_PROPERTY, "ERROR.MESSAGE");
        labels.put(VALIDFROMTIME_PROPERTY, "PROCESS.INSTANCE.VALID.FROM");
        converters.put(CREATIONTIME_PROPERTY, new CalendarConverter());
        converters.put(STARTTIME_PROPERTY, new CalendarConverter());
        converters.put(COMPLETIONTIME_PROPERTY, new CalendarConverter());
        converters.put(CONTINUEONERROR_PROPERTY, new BooleanConverter());
        converters.put(RESUMPTIONTIME_PROPERTY, new CalendarConverter());
        converters.put(LASTMODIFICATIONTIME_PROPERTY, new CalendarConverter());
        converters.put(LASTSTATECHANGETIME_PROPERTY, new CalendarConverter());
        converters.put(EXECUTIONSTATE_PROPERTY, new ProcessInstanceExecutionStateConverter());
        converters.put(PROCESSADMINISTRATORS_PROPERTY, new StaffResultSetConverter());
        converters.put(ISCOMPENSATIONDEFINED_PROPERTY, new BooleanConverter());
        converters.put(UNHANDLEDEXCEPTION_PROPERTY, new ExceptionConverter());
        converters.put(VALIDFROMTIME_PROPERTY, new CalendarConverter());
        converters.put(MIGRATED_PROPERTY, new BooleanConverter());
    }
}

