/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.clientmodel.bean;

import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpc.clientcore.MessageWrapper;
import com.ibm.bpc.clientcore.converter.SimpleConverter;
import com.ibm.bpc.clientcore.exception.CommunicationException;
import com.ibm.bpc.clientcore.util.LocaleUtils;
import com.ibm.bpc.clientcore.util.MessageWrapperImpl;
import com.ibm.bpe.api.ATID;
import com.ibm.bpe.api.ActivityServiceTemplateData;
import com.ibm.bpe.api.BusinessFlowManagerService;
import com.ibm.bpe.api.ClientObjectWrapper;
import com.ibm.bpe.api.EHTID;
import com.ibm.bpe.api.EngineWrongKindException;
import com.ibm.bpe.api.EventHandlerTemplateData;
import com.ibm.bpe.api.PIID;
import com.ibm.bpe.api.PTID;
import com.ibm.bpe.api.ProcessException;
import com.ibm.bpe.api.ProcessInstanceData;
import com.ibm.bpe.api.ProcessTemplateData;
import com.ibm.bpe.api.QueryResultSet;
import com.ibm.bpe.api.VTID;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.clientmodel.BFMConnection;
import com.ibm.bpe.clientmodel.exception.BFMCommandException;
import com.ibm.bpe.clientmodel.util.BFMUtils;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.ejb.EJBException;

public class EventActivityBean {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2009.\n\n";
    private static Map converters = new HashMap();
    private static Map labels = new HashMap();
    public static String ACTIVITY_DESCRIPTION_PROPERTY = "description";
    public static String ACTIVITY_PORTTYPENAME_PROPERTY = "portTypeName";
    public static String ACTIVITY_OPERATIONNAME_PROPERTY = "operation";
    public static String PROCESSINSTANCE_ID_PROPERTY = "PIID";
    public static String PROCESSINSTANCE_INPUTMESSAGE_PROPERTY = "inputMessageTypeName";
    public static String ACTIVITY_PORTTYPENAMESPACE_PROPERTY = "portTypeNameSpace";
    public static String PROCESSTEMPLATE_NAME_PROPERTY = "processTemplateName";
    public static String ACTIVITY_EVENTHANDLER_PROPERTY = "eventHandler";
    private BFMConnection connection = null;
    private ATID atid;
    private String description;
    private EHTID ehtid;
    private String inputMessageTypeName;
    private String operation;
    private PIID piid;
    private PTID ptid;
    private String portTypeName;
    private String portTypeNameSpace;
    private String processTemplateName;
    private VTID vtid;
    private String applicationName;

    public static SimpleConverter getConverter(String string) {
        SimpleConverter simpleConverter = (SimpleConverter)converters.get(string);
        return simpleConverter;
    }

    public static String getLabel(String string) {
        String string2 = (String)labels.get(string);
        return string2;
    }

    public static String getLabel(String string, Locale locale) {
        String string2 = LocaleUtils.getLocalizedString((String)((String)labels.get(string)), (Locale)locale);
        return string2;
    }

    public static boolean isValid(String string) {
        boolean bl = labels.get(string) != null;
        return bl;
    }

    public EventActivityBean(ActivityServiceTemplateData activityServiceTemplateData, BFMConnection bFMConnection, PIID pIID) {
        this.connection = bFMConnection;
        this.atid = activityServiceTemplateData.getActivityTemplateID();
        this.vtid = activityServiceTemplateData.getServiceTemplateID();
        this.ehtid = null;
        this.portTypeName = activityServiceTemplateData.getPortTypeName();
        this.description = activityServiceTemplateData.getActivityDescription();
        this.operation = activityServiceTemplateData.getOperationName();
        this.inputMessageTypeName = activityServiceTemplateData.getInputMessageTypeName();
        this.portTypeNameSpace = activityServiceTemplateData.getPortTypeNamespace();
        this.processTemplateName = activityServiceTemplateData.getProcessTemplateName();
        this.ptid = activityServiceTemplateData.getProcessTemplateID();
        this.piid = pIID;
    }

    public EventActivityBean(ActivityServiceTemplateData activityServiceTemplateData, BFMConnection bFMConnection) {
        this.connection = bFMConnection;
        this.atid = activityServiceTemplateData.getActivityTemplateID();
        this.vtid = activityServiceTemplateData.getServiceTemplateID();
        this.ehtid = null;
        this.portTypeName = activityServiceTemplateData.getPortTypeName();
        this.description = activityServiceTemplateData.getActivityDescription();
        this.operation = activityServiceTemplateData.getOperationName();
        this.inputMessageTypeName = activityServiceTemplateData.getInputMessageTypeName();
        this.portTypeNameSpace = activityServiceTemplateData.getPortTypeNamespace();
        this.processTemplateName = activityServiceTemplateData.getProcessTemplateName();
        this.ptid = activityServiceTemplateData.getProcessTemplateID();
    }

    public EventActivityBean(EventHandlerTemplateData eventHandlerTemplateData, BFMConnection bFMConnection) {
        this.connection = bFMConnection;
        this.ehtid = eventHandlerTemplateData.getID();
        this.atid = null;
        this.vtid = null;
        this.portTypeName = eventHandlerTemplateData.getPortTypeName();
        this.description = null;
        this.operation = eventHandlerTemplateData.getOperationName();
        this.inputMessageTypeName = eventHandlerTemplateData.getInputMessageTypeName();
        this.portTypeNameSpace = eventHandlerTemplateData.getPortTypeNamespace();
        this.processTemplateName = eventHandlerTemplateData.getProcessTemplateName();
        this.ptid = eventHandlerTemplateData.getProcessTemplateID();
    }

    public EventActivityBean(QueryResultSet queryResultSet) {
        for (int i = 1; i <= queryResultSet.numberColumns(); ++i) {
            String string = queryResultSet.getTableDisplayName(i);
            String string2 = queryResultSet.getColumnDisplayName(i);
            if (string.equalsIgnoreCase("ACTIVITY")) {
                if (string2.equalsIgnoreCase("ATID")) {
                    this.atid = (ATID)queryResultSet.getOID(i);
                }
                if (string2.equalsIgnoreCase("DESCRIPTION")) {
                    this.description = queryResultSet.getString(i);
                }
                if (string2.equalsIgnoreCase("PTID")) {
                    this.ptid = (PTID)queryResultSet.getOID(i);
                }
                if (string2.equalsIgnoreCase("PIID")) {
                    this.piid = (PIID)queryResultSet.getOID(i);
                }
            }
            if (!string.equalsIgnoreCase("ACTIVITY_SERVICE")) continue;
            if (string2.equalsIgnoreCase("VTID")) {
                this.vtid = (VTID)queryResultSet.getOID(i);
            }
            if (string2.equalsIgnoreCase("PORT_TYPE")) {
                this.portTypeName = queryResultSet.getString(i);
            }
            if (string2.equalsIgnoreCase("OPERATION")) {
                this.operation = queryResultSet.getString(i);
            }
            if (!string2.equalsIgnoreCase("PIID")) continue;
            this.piid = (PIID)queryResultSet.getOID(i);
        }
    }

    public ATID getATID() {
        return this.atid;
    }

    public String getDescription() {
        return this.description;
    }

    public EHTID getEHTID() {
        return this.ehtid;
    }

    public String getID() {
        if (this.ehtid != null) {
            return this.ehtid.toString();
        }
        StringBuffer stringBuffer = new StringBuffer("_EAID");
        if (this.getVTID() != null) {
            stringBuffer.append(this.getVTID().toString());
        }
        if (this.getATID() != null) {
            stringBuffer.append(this.getATID().toString());
        }
        if (this.getPIID() != null) {
            stringBuffer.append(this.getPIID().toString());
        }
        return stringBuffer.toString();
    }

    public String getInputMessageTypeName() {
        return this.inputMessageTypeName;
    }

    public String getOperation() {
        return this.operation;
    }

    public PIID getPIID() {
        return this.piid;
    }

    public String getPortTypeName() {
        return this.portTypeName;
    }

    public String getPortTypeNameSpace() {
        return this.portTypeNameSpace;
    }

    public String getProcessTemplateName() {
        return this.processTemplateName;
    }

    public VTID getVTID() {
        return this.vtid;
    }

    public boolean isEventHandler() {
        return this.atid == null;
    }

    public MessageWrapper getInputMessageWrapper() throws ClientException {
        MessageWrapperImpl messageWrapperImpl = null;
        try {
            messageWrapperImpl = new MessageWrapperImpl(this.getApplicationName());
            BusinessFlowManagerService businessFlowManagerService = BFMUtils.getBusinessFlowManagerService(this.connection);
            ClientObjectWrapper clientObjectWrapper = null;
            if (this.getEHTID() != null) {
                clientObjectWrapper = businessFlowManagerService.createMessage(this.getEHTID(), this.getInputMessageTypeName());
            } else {
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Create message " + this.getInputMessageTypeName() + " with initialized correlation sets for " + this.getPIID()));
                }
                try {
                    clientObjectWrapper = businessFlowManagerService.createMessageWithCorrelationSets(this.getVTID(), this.getATID(), this.getPIID(), this.getInputMessageTypeName());
                }
                catch (ProcessException processException) {
                    if (BPCClientTrace.isTracing) {
                        BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (Throwable)processException);
                    }
                    clientObjectWrapper = businessFlowManagerService.createMessage(this.getVTID(), this.getATID(), this.getInputMessageTypeName());
                }
            }
            if (clientObjectWrapper != null) {
                messageWrapperImpl.setMessage(clientObjectWrapper.getObject());
            }
        }
        catch (EngineWrongKindException engineWrongKindException) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"No message available for this kind");
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (Throwable)engineWrongKindException);
            }
        }
        catch (RemoteException remoteException) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (Throwable)remoteException);
            }
            throw new CommunicationException(new Object[]{"BusinessFlowManager.getInputMessage"}, (Throwable)remoteException);
        }
        catch (ProcessException processException) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (Throwable)processException);
            }
            throw new BFMCommandException(new Object[]{"BusinessFlowManager.getInputMessage"}, processException);
        }
        catch (EJBException eJBException) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (Throwable)eJBException);
            }
            throw new CommunicationException(new Object[]{"BusinessFlowManager.getInputMessage"}, (Throwable)eJBException);
        }
        return messageWrapperImpl;
    }

    private String getApplicationName() throws CommunicationException, ProcessException {
        if (this.applicationName == null && (this.ptid != null || this.piid != null)) {
            BusinessFlowManagerService businessFlowManagerService = BFMUtils.getBusinessFlowManagerService(this.connection);
            String string = null;
            try {
                if (this.ptid != null) {
                    string = "BusinessFlowManagerService.getProcessTemplate";
                    ProcessTemplateData processTemplateData = businessFlowManagerService.getProcessTemplate(this.ptid);
                    this.applicationName = processTemplateData.getApplicationName();
                } else if (this.piid != null) {
                    string = "BusinessFlowManagerService.getProcessInstance";
                    ProcessInstanceData processInstanceData = businessFlowManagerService.getProcessInstance(this.piid);
                    this.applicationName = BFMUtils.lookupApplicationName(businessFlowManagerService, processInstanceData);
                }
            }
            catch (RemoteException remoteException) {
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (Throwable)remoteException);
                }
                throw new CommunicationException(new Object[]{string}, (Throwable)remoteException);
            }
            catch (ProcessException processException) {
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (Throwable)processException);
                }
                throw new BFMCommandException(new Object[]{string}, processException);
            }
            catch (EJBException eJBException) {
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (Throwable)eJBException);
                }
                throw new CommunicationException(new Object[]{string}, (Throwable)eJBException);
            }
        }
        return this.applicationName;
    }

    static {
        labels.put(ACTIVITY_DESCRIPTION_PROPERTY, "ACTIVITY.DESCRIPTION");
        labels.put(ACTIVITY_PORTTYPENAME_PROPERTY, "ACTIVITY.PORTTYPENAME");
        labels.put(ACTIVITY_OPERATIONNAME_PROPERTY, "ACTIVITY.OPERATIONNAME");
        labels.put(PROCESSINSTANCE_ID_PROPERTY, "PROCESS.INSTANCE.PIID");
        labels.put(PROCESSINSTANCE_INPUTMESSAGE_PROPERTY, "PROCESS.INSTANCE.INPUT.MESSAGE.TYPE");
        labels.put(ACTIVITY_PORTTYPENAMESPACE_PROPERTY, "ACTIVITY.PORTTYPENAMESPACE");
        labels.put(PROCESSTEMPLATE_NAME_PROPERTY, "PROCESS.TEMPLATE.NAME");
        labels.put(ACTIVITY_EVENTHANDLER_PROPERTY, "ACTIVITY.EVENT.HANDLER");
    }
}

