/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.clientmodel.bean;

import com.ibm.bpe.api.CorrelationPropertyInstanceData;
import com.ibm.bpe.api.CorrelationSetInstanceData;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.clientmodel.bean.CorrelationPropertyBean;
import com.ibm.bpe.util.Assert;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorrelationSetInstanceBean {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2009.\n\n";
    private static final long serialVersionUID = 1L;
    CorrelationSetInstanceData original = null;
    Locale locale = null;
    List<String> correlationPropertyNames = null;
    List<CorrelationPropertyBean> correlationPropertyBeans = null;
    boolean showOriginalValues = false;

    public CorrelationSetInstanceBean(CorrelationSetInstanceData correlationSetInstanceData, Locale locale) {
        Assert.assertion((correlationSetInstanceData != null ? 1 : 0) != 0, (String)"'original' must not be null!");
        this.original = correlationSetInstanceData;
        this.locale = locale;
    }

    public CorrelationSetInstanceData getOriginal() {
        return this.original;
    }

    public void updateOriginal(CorrelationSetInstanceData correlationSetInstanceData, Locale locale) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)correlationSetInstanceData.toString());
        }
        this.original = correlationSetInstanceData;
        this.locale = locale;
        this.updateCorrelationPropertyBeans();
    }

    public String getCorrelationSetName() {
        return this.original.getCorrelationSetName();
    }

    public boolean isInitialized() {
        return this.original.isInitialized();
    }

    public boolean isShowOriginalValues() {
        return this.showOriginalValues;
    }

    public void setShowOriginalValues(boolean bl) {
        this.showOriginalValues = bl;
    }

    public List<CorrelationPropertyBean> getCorrelationPropertyBeans() {
        if (this.correlationPropertyBeans == null) {
            List list = this.original.getCorrelationSetProperties();
            this.correlationPropertyNames = new ArrayList<String>();
            this.correlationPropertyBeans = new ArrayList<CorrelationPropertyBean>();
            if (list != null) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    CorrelationPropertyBean correlationPropertyBean = new CorrelationPropertyBean((CorrelationPropertyInstanceData)iterator.next(), this.locale);
                    if (BPCClientTrace.isTracing) {
                        BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Adding CS property to list: " + correlationPropertyBean.toString()));
                    }
                    this.correlationPropertyNames.add(correlationPropertyBean.getPropertyName());
                    this.correlationPropertyBeans.add(correlationPropertyBean);
                }
            }
        }
        return this.correlationPropertyBeans;
    }

    private void updateCorrelationPropertyBeans() {
        if (this.correlationPropertyBeans == null) {
            this.getCorrelationPropertyBeans();
        } else {
            List list = this.original.getCorrelationSetProperties();
            if (list != null) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    CorrelationPropertyBean correlationPropertyBean = new CorrelationPropertyBean((CorrelationPropertyInstanceData)iterator.next(), this.locale);
                    int n = this.correlationPropertyNames.indexOf(correlationPropertyBean.getPropertyName());
                    if (this.showOriginalValues) {
                        CorrelationPropertyBean correlationPropertyBean2 = this.correlationPropertyBeans.get(n);
                        correlationPropertyBean.setOriginalValue(correlationPropertyBean2.getStringValue());
                    }
                    this.correlationPropertyBeans.set(n, correlationPropertyBean);
                }
            }
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)this.toString());
        }
    }

    public String toString() {
        return this.getCorrelationSetName() + ", isInitialized=" + this.isInitialized() + ", locale=" + this.locale + ", showOriginalValues=" + this.showOriginalValues + ", propertyBeans=" + this.getCorrelationPropertyBeans();
    }
}

