/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.clientmodel.bean;

import com.ibm.bpc.clientcore.converter.ConverterUtils;
import com.ibm.bpc.clientcore.converter.XConverter;
import com.ibm.bpe.api.CorrelationPropertyInstanceData;
import com.ibm.bpe.api.ProcessException;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.clientmodel.exception.CorrelationPropertyEmptyException;
import com.ibm.bpe.util.Assert;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import com.ibm.bpe.util.XSDJavaConverter;
import java.io.Serializable;
import java.util.Locale;
import javax.xml.namespace.QName;

public class CorrelationPropertyBean {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2009.\n\n";
    private CorrelationPropertyInstanceData original = null;
    private String stringValue = null;
    private String originalStringValue = null;
    private Locale locale = null;
    private String javaTypeName = null;
    private QName xsdType = null;
    private boolean converted = false;
    private Object convertedObject = null;
    private ProcessException conversionException = null;

    CorrelationPropertyBean(CorrelationPropertyInstanceData correlationPropertyInstanceData, Locale locale) {
        Assert.assertion((correlationPropertyInstanceData != null ? 1 : 0) != 0, (String)"'CorrelationPropertyInstanceData' must not be null!");
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)correlationPropertyInstanceData.toString());
        }
        this.original = correlationPropertyInstanceData;
        this.locale = locale;
        this.javaTypeName = this.original.getJavaTypeName();
        String string = this.original.getXSDTypeName();
        if (string == null) {
            this.xsdType = XSDJavaConverter.getXSDType4JavaType((String)this.javaTypeName, (XSDJavaConverter.MapRule)XSDJavaConverter.SDO11_8B);
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("No xsdTypeName set - determined from " + this.javaTypeName + " as " + this.xsdType));
            }
        } else {
            this.xsdType = new QName(string, this.original.getXSDTypeNamespace());
        }
        if (this.javaTypeName == null) {
            this.javaTypeName = XSDJavaConverter.getSimpleJavaType4XSDType((QName)this.xsdType, (XSDJavaConverter.MapRule)XSDJavaConverter.SDO11_8B);
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("No javaTypeName set - determined from " + this.xsdType + " as " + this.javaTypeName));
            }
        }
        Assert.assertion((this.javaTypeName != null || this.xsdType != null ? 1 : 0) != 0, (String)"A value must be specified for 'javaType' and/or 'xsdType'!");
        this.originalStringValue = this.stringValue = this.getAsString();
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)this.toString());
        }
    }

    public String getPropertyName() {
        return this.original.getPropertyName();
    }

    public String getJavaTypeName() {
        return this.original.getJavaTypeName();
    }

    public String getXSDTypeName() {
        return this.original.getXSDTypeName();
    }

    public String getMessagePartName() {
        return this.original.getPartName();
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public void setStringValue(String string) {
        this.stringValue = string;
        this.converted = false;
    }

    public String getOriginalValue() {
        return this.originalStringValue;
    }

    public void setOriginalValue(String string) {
        this.originalStringValue = string;
    }

    public Object convertStringToObject() throws ProcessException {
        try {
            this.converted = false;
            this.conversionException = null;
            this.convertedObject = this.getAsObject();
            if (this.getStringValue() == null || this.getStringValue().trim().length() == 0) {
                throw new CorrelationPropertyEmptyException(new String[]{this.getPropertyName()});
            }
        }
        catch (ProcessException processException) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Validation error: " + this.toString() + " - " + processException.getMessage(this.locale)));
            }
            this.conversionException = processException;
            throw processException;
        }
        this.converted = true;
        return this.convertedObject;
    }

    public Object getConvertedObject() throws ProcessException {
        if (!this.converted) {
            this.convertStringToObject();
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, this.convertedObject != null ? this.convertedObject.toString() : null);
        }
        return this.convertedObject;
    }

    public String getConversionExceptionMessage() {
        if (this.conversionException != null) {
            return this.conversionException.getMessage(this.locale);
        }
        return null;
    }

    public void updateValue() throws ProcessException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)this.toString());
        }
        try {
            this.original.setValue((Serializable)this.getConvertedObject());
            this.stringValue = this.getAsString();
            this.originalStringValue = null;
            this.convertedObject = null;
            this.converted = false;
            this.conversionException = null;
        }
        catch (ProcessException processException) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Validation error: " + this.toString() + " - " + processException.getMessage(this.locale)));
            }
            this.conversionException = processException;
            throw processException;
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)this.toString());
        }
    }

    private String getAsString() {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)this.toString());
        }
        String string = null;
        Serializable serializable = this.original.getValue();
        if (serializable != null) {
            Assert.assertion((this.xsdType != null ? 1 : 0) != 0, (String)"'xsdType' must be initialized!");
            XConverter xConverter = ConverterUtils.getInstance();
            string = xConverter.isSupported(this.xsdType) ? xConverter.convertTo(this.locale, this.xsdType, (Object)serializable) : XSDJavaConverter.convertJavaType2Literal((QName)this.xsdType, (XSDJavaConverter.MapRule)XSDJavaConverter.SDO11_8B, (Object)serializable, (Locale)this.locale, null);
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit(string);
        }
        return string;
    }

    private Object getAsObject() throws ProcessException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)this.toString());
        }
        Object object = null;
        Assert.assertion((this.xsdType != null ? 1 : 0) != 0, (String)"'xsdType' must be initialized!");
        XConverter xConverter = ConverterUtils.getInstance();
        object = xConverter.isSupported(this.xsdType) ? xConverter.createFrom(this.locale, this.xsdType, this.getStringValue()) : XSDJavaConverter.convertXSD2JavaType((QName)this.xsdType, (XSDJavaConverter.MapRule)XSDJavaConverter.SDO11_8B, (String)this.getStringValue());
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)("class=" + object.getClass().getName() + ", toString=" + object.toString()));
        }
        return object;
    }

    public String toString() {
        return "propertyName=" + this.getPropertyName() + ", javaType=" + this.javaTypeName + ", xsdType=" + this.xsdType + ", locale=" + this.locale + ", stringValue=" + this.stringValue + ", originalStringValue=" + this.originalStringValue + ", conversionException=" + this.getConversionExceptionMessage();
    }
}

