/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.clientmodel.bean;

import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpc.clientcore.MessageWrapper;
import com.ibm.bpc.clientcore.converter.SimpleConverter;
import com.ibm.bpc.clientcore.exception.CommunicationException;
import com.ibm.bpc.clientcore.util.ClientUIHelper;
import com.ibm.bpc.clientcore.util.LocaleUtils;
import com.ibm.bpc.clientcore.util.MessageWrapperImpl;
import com.ibm.bpe.api.ATID;
import com.ibm.bpe.api.ActivityServiceTemplateData;
import com.ibm.bpe.api.BusinessFlowManagerService;
import com.ibm.bpe.api.ClientObjectWrapper;
import com.ibm.bpe.api.CustomClientSettings;
import com.ibm.bpe.api.JspLocation;
import com.ibm.bpe.api.JspUsageEnum;
import com.ibm.bpe.api.OID;
import com.ibm.bpe.api.PTID;
import com.ibm.bpe.api.ProcessException;
import com.ibm.bpe.api.ProcessTemplateData;
import com.ibm.bpe.api.VTID;
import com.ibm.bpe.api.WebClientSetting;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.clientmodel.BFMConnection;
import com.ibm.bpe.clientmodel.bean.ProcessTemplateBean;
import com.ibm.bpe.clientmodel.bean.ProcessTemplateBeanPropertyExt;
import com.ibm.bpe.clientmodel.exception.BFMCommandException;
import com.ibm.bpe.clientmodel.util.BFMUtils;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import com.ibm.task.api.TKTID;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.ejb.EJBException;

public class ActivityServiceTemplateBean
implements ActivityServiceTemplateData {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2004, 2008.\n\n";
    private static Map converters = new HashMap();
    private static final long serialVersionUID = 1L;
    private static Map labels = new HashMap();
    private ProcessTemplateBean processTemplate = null;
    private BFMConnection connection = null;
    public static final String ACTIVITYDESCRIPTION_PROPERTY = "activityDescription";
    public static final String ACTIVITYDISPLAYNAME_PROPERTY = "activityDisplayName";
    public static final String ACTIVITYNAME_PROPERTY = "activityName";
    public static final String AVAILABLEACTIONS_PROPERTY = "availableActions";
    public static final String INPUTMESSAGETYPENAME_PROPERTY = "inputMessageTypeName";
    public static final String INPUTMESSAGETYPETYPESYSTEMNAME_PROPERTY = "inputMessageTypeTypeSystemName";
    public static final String OPERATIONNAME_PROPERTY = "operationName";
    public static final String PARTNERLINKNAME_PROPERTY = "partnerLinkName";
    public static final String PORTTYPENAME_PROPERTY = "portType";
    public static final String PORTTYPENAMESPACE_PROPERTY = "portTypeNameSpace";
    public static final String PROCESSTEMPLATEID_PROPERTY = "processTemplateID";
    public static final String SERVICETEMPLATEID_PROPERTY = "serviceTemplateID";
    private ActivityServiceTemplateData original = null;

    public static SimpleConverter getConverter(String string) {
        SimpleConverter simpleConverter = (SimpleConverter)converters.get(string);
        return simpleConverter;
    }

    public static String getLabel(String string) {
        String string2 = (String)labels.get(string);
        return string2;
    }

    public static String getLabel(String string, Locale locale) {
        String string2 = LocaleUtils.getLocalizedString((String)((String)labels.get(string)), (Locale)locale);
        return string2;
    }

    public static boolean isValid(String string) {
        boolean bl = labels.get(string) != null;
        return bl;
    }

    public ActivityServiceTemplateBean(ActivityServiceTemplateData activityServiceTemplateData, BFMConnection bFMConnection) {
        this.original = activityServiceTemplateData;
        this.connection = bFMConnection;
    }

    public String getActivityDescription() {
        return this.getOriginal().getActivityDescription();
    }

    public String getActivityDisplayName() {
        String string = this.getOriginal().getActivityDisplayName();
        if (string == null || string.equals("")) {
            return this.getActivityName();
        }
        return string;
    }

    public String getActivityName() {
        return this.getOriginal().getActivityName();
    }

    public ATID getActivityTemplateID() {
        return this.getOriginal().getActivityTemplateID();
    }

    public int[] getAvailableActions() {
        return this.getOriginal().getAvailableActions();
    }

    public OID getID() {
        return this.getServiceTemplateID();
    }

    public String getInputMessageTypeName() {
        return this.getOriginal().getInputMessageTypeName();
    }

    public String getInputMessageTypeTypeSystemName() {
        return this.getOriginal().getInputMessageTypeTypeSystemName();
    }

    public String getOperationName() {
        return this.getOriginal().getOperationName();
    }

    private ActivityServiceTemplateData getOriginal() {
        return this.original;
    }

    public String getPartnerLinkName() {
        return this.getOriginal().getPartnerLinkName();
    }

    public String getPortTypeName() {
        return this.getOriginal().getPortTypeName();
    }

    public String getPortTypeNamespace() {
        return this.getOriginal().getPortTypeNamespace();
    }

    public PTID getProcessTemplateID() {
        return this.getOriginal().getProcessTemplateID();
    }

    public TKTID getTaskTemplateID() {
        return this.getOriginal().getTaskTemplateID();
    }

    public String getProcessTemplateName() {
        return this.getOriginal().getProcessTemplateName();
    }

    public VTID getServiceTemplateID() {
        return this.getOriginal().getServiceTemplateID();
    }

    public boolean isTwoWayOperation() {
        return this.getOriginal().isTwoWayOperation();
    }

    public ProcessTemplateBean getProcessTemplate() throws ClientException {
        if (this.processTemplate == null) {
            this.processTemplate = new ProcessTemplateBeanPropertyExt((ProcessTemplateData)this.connection.retrieve((OID)this.getOriginal().getProcessTemplateID()), this.connection);
        }
        return this.processTemplate;
    }

    public MessageWrapper getInputMessageWrapper() throws ClientException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Creating message with ActivityServiceTemplateID " + this.getServiceTemplateID()));
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("                 with ActivityTemplateID " + this.getActivityTemplateID()));
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("                 with InputMessageTypeName " + this.getInputMessageTypeName()));
        }
        MessageWrapperImpl messageWrapperImpl = null;
        BusinessFlowManagerService businessFlowManagerService = BFMUtils.getBusinessFlowManagerService(this.connection);
        ClientObjectWrapper clientObjectWrapper = null;
        try {
            clientObjectWrapper = businessFlowManagerService.createMessage(this.getServiceTemplateID(), this.getActivityTemplateID(), this.getInputMessageTypeName());
        }
        catch (ProcessException processException) {
            throw new BFMCommandException(new Object[]{"BusinessFlowManagerService.createMessage"}, processException);
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(new Object[]{"BusinessFlowManagerService.createMessage"}, (Throwable)remoteException);
        }
        catch (EJBException eJBException) {
            throw new CommunicationException(new Object[]{"BusinessFlowManagerService.createMessage"}, (Throwable)eJBException);
        }
        messageWrapperImpl = new MessageWrapperImpl(this.getProcessTemplate().getApplicationName());
        if (clientObjectWrapper != null) {
            try {
                if (BPCClientTrace.isTracing && clientObjectWrapper.getObject() == null) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"ClientObjectWrapper contained no data!");
                }
                messageWrapperImpl.setMessage(clientObjectWrapper.getObject());
            }
            catch (ProcessException processException) {
                throw new BFMCommandException(new Object[]{"ClientObjectWrapper.getObject"}, processException);
            }
        } else if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"BusinessFlowManagerService.createMessage returned null!");
        }
        if (ClientUIHelper.getWebClientType() != null) {
            CustomClientSettings customClientSettings;
            try {
                customClientSettings = businessFlowManagerService.getClientUISettings(this.getServiceTemplateID(), this.getActivityTemplateID());
            }
            catch (ProcessException processException) {
                throw new BFMCommandException(new Object[]{"BusinessFlowManagerService.getClientUISettings"}, processException);
            }
            catch (RemoteException remoteException) {
                throw new CommunicationException(new Object[]{"BusinessFlowManagerService.getClientUISettings"}, (Throwable)remoteException);
            }
            catch (EJBException eJBException) {
                throw new CommunicationException(new Object[]{"BusinessFlowManagerService.getClientUISettings"}, (Throwable)eJBException);
            }
            WebClientSetting webClientSetting = customClientSettings != null ? customClientSettings.getWebClientSetting(ClientUIHelper.getWebClientType()) : null;
            JspLocation jspLocation = webClientSetting != null ? ClientUIHelper.getJspLocationForOriginatingInterface((JspUsageEnum)JspUsageEnum.INPUT, (WebClientSetting)webClientSetting) : null;
            String string = jspLocation != null ? jspLocation.getContextRoot() : null;
            String string2 = jspLocation != null ? jspLocation.getUriAsString() : null;
            messageWrapperImpl.setContextRoot(string);
            messageWrapperImpl.setUrl(string2);
        }
        return messageWrapperImpl;
    }

    static {
        labels.put(ACTIVITYDESCRIPTION_PROPERTY, "ACTIVITY.DESCRIPTION");
        labels.put(ACTIVITYDISPLAYNAME_PROPERTY, "ACTIVITY.ACTIVITYNAME");
        labels.put(ACTIVITYNAME_PROPERTY, "ACTIVITY.ACTIVITYNAME");
        labels.put(AVAILABLEACTIONS_PROPERTY, "ACTIVITY.AVAILABLEACTIONS");
        labels.put(INPUTMESSAGETYPENAME_PROPERTY, "ACTIVITY.INPUTMESSAGETYPENAME");
        labels.put(INPUTMESSAGETYPETYPESYSTEMNAME_PROPERTY, "ACTIVITY.INPUTMESSAGETYPETYPESYSTEMNAME");
        labels.put(OPERATIONNAME_PROPERTY, "ACTIVITY.OPERATIONNAME");
        labels.put(PARTNERLINKNAME_PROPERTY, "ACTIVITY.PARTNERLINKNAME");
        labels.put(PORTTYPENAME_PROPERTY, "ACTIVITY.PORTTYPENAME");
        labels.put(PORTTYPENAMESPACE_PROPERTY, "ACTIVITY.PORTTYPENAMESPACE");
        labels.put(PROCESSTEMPLATEID_PROPERTY, "ACTIVITY.IPROCESSTEMPLATEID");
        labels.put(SERVICETEMPLATEID_PROPERTY, "ACTIVITY.SERVICETEMPLATEID");
    }
}

