/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.clientmodel.bean;

import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpc.clientcore.ColumnInfo;
import com.ibm.bpc.clientcore.converter.SimpleConverter;
import com.ibm.bpc.clientcore.exception.CommunicationException;
import com.ibm.bpc.clientcore.exception.NotAuthorizedException;
import com.ibm.bpc.clientcore.util.FieldMapCreator;
import com.ibm.bpc.clientcore.util.LocaleUtils;
import com.ibm.bpe.api.ActivityInstanceActions;
import com.ibm.bpe.api.ActivityInstanceData;
import com.ibm.bpe.api.BranchTemplateData;
import com.ibm.bpe.api.BusinessFlowManagerService;
import com.ibm.bpe.api.EngineNotAuthorizedException;
import com.ibm.bpe.api.LinkTemplateData;
import com.ibm.bpe.api.ProcessException;
import com.ibm.bpe.api.QueryResultSet;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.clientmodel.BFMConnection;
import com.ibm.bpe.clientmodel.bean.ActivityInstanceBean;
import com.ibm.bpe.clientmodel.exception.ActivityNoJumpTargetsException;
import com.ibm.bpe.clientmodel.exception.BFMCommandException;
import com.ibm.bpe.clientmodel.util.BFMUtils;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.ejb.EJBException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityInstanceBeanExt
extends ActivityInstanceBean {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2004, 2009.\n\n";
    private static final long serialVersionUID = 1L;
    public static Map<String, String> propertyNameToDBMap = new HashMap<String, String>();
    private BFMConnection connection = null;
    private int[] availableActions = null;
    private List<String> jumpTargetNames = null;
    private boolean jumpTargetNamesSet = false;
    private LinkTemplateData[] outgoingLinks = null;
    private boolean outgoingLinksSet = false;
    private BranchTemplateData[] branches = null;
    private boolean branchesSet = false;
    public static final String TABLE_NAME = "ACTIVITY";
    private static Map<Integer, String> actionNames;

    public static SimpleConverter getConverter(String string) {
        return ActivityInstanceBean.getConverter(string);
    }

    public static String getLabel(String string) {
        return ActivityInstanceBean.getLabel(string);
    }

    public static String getLabel(String string, Locale locale) {
        String string2 = LocaleUtils.getLocalizedString((String)ActivityInstanceBeanExt.getLabel(string), (Locale)locale);
        return string2;
    }

    public static boolean isValid(String string) {
        boolean bl = ActivityInstanceBeanExt.getLabel(string) != null;
        return bl;
    }

    public static ColumnInfo getColumnInfo(String string, String string2) {
        if (ActivityInstanceBeanExt.isValid(string)) {
            return new ColumnInfo(string, ActivityInstanceBeanExt.getLabel(string), (Object)ActivityInstanceBeanExt.getConverter(string), string2);
        }
        return null;
    }

    public ActivityInstanceBeanExt(ActivityInstanceData activityInstanceData, BFMConnection bFMConnection) {
        super(activityInstanceData, bFMConnection);
        this.connection = bFMConnection;
    }

    public ActivityInstanceBeanExt(QueryResultSet queryResultSet, BFMConnection bFMConnection) {
        super(queryResultSet, bFMConnection);
        this.connection = bFMConnection;
    }

    public boolean isActionAvailable(int n) {
        boolean bl = false;
        if (this.availableActions == null) {
            this.availableActions = super.getAvailableActions();
        }
        String string = actionNames.get(new Integer(n));
        if (this.availableActions != null && this.availableActions.length > 0) {
            for (int i = 0; i < this.availableActions.length; ++i) {
                boolean bl2 = bl = this.availableActions[i] == n;
                if (bl) {
                    switch (n) {
                        case 3034: {
                            if (!this.isSkipRequested()) break;
                            if (BPCClientTrace.isTracing) {
                                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)(string + " not available: Skip is already requested!"));
                            }
                            bl = false;
                            break;
                        }
                        case 3050: {
                            if (this.getKind() != 36) break;
                            if (BPCClientTrace.isTracing) {
                                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)(string + " not available: PICK is not supported!"));
                            }
                            bl = false;
                            break;
                        }
                        case 3035: {
                            if (this.isSkipRequested()) break;
                            if (BPCClientTrace.isTracing) {
                                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)(string + " not available: Skip is not requested!"));
                            }
                            bl = false;
                            break;
                        }
                        case 3036: 
                        case 3037: 
                        case 3038: {
                            List<String> list = null;
                            try {
                                list = this.getJumpTargetNames();
                            }
                            catch (ClientException clientException) {
                                // empty catch block
                            }
                            if (list != null) break;
                            if (BPCClientTrace.isTracing) {
                                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)(string + " not available: No jump targets!"));
                            }
                            bl = false;
                            break;
                        }
                    }
                }
                if (bl) break;
            }
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)(string + ": " + Boolean.toString(bl)));
        }
        return bl;
    }

    public void refreshAvailableActions() {
        this.availableActions = super.getAvailableActions();
    }

    public List<String> getJumpTargetNames() throws BFMCommandException, CommunicationException, ActivityNoJumpTargetsException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)this.getName());
        }
        if (!this.jumpTargetNamesSet) {
            List list = null;
            try {
                list = BFMUtils.getBusinessFlowManagerService(this.connection).getJumpTargetNames(this.getID());
            }
            catch (ProcessException processException) {
                throw new BFMCommandException(new Object[]{"BusinessFlowManagerService.getJumpTargetNames"}, processException);
            }
            catch (RemoteException remoteException) {
                throw new CommunicationException(new Object[]{"BusinessFlowManagerService.getJumpTargetNames"}, (Throwable)remoteException);
            }
            catch (EJBException eJBException) {
                throw new CommunicationException(new Object[]{"BusinessFlowManagerService.getJumpTargetNames"}, (Throwable)eJBException);
            }
            if (list != null) {
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)list.toString());
                }
                this.jumpTargetNames = new ArrayList<String>(list);
                String string = this.getName();
                if (BPCClientTrace.isTracing) {
                    if (this.jumpTargetNames.contains(string)) {
                        // empty if block
                    }
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Removing target activity name '" + string + "', no jump to itself supported!"));
                }
                this.jumpTargetNames.remove(string);
                if (this.jumpTargetNames.size() == 0) {
                    this.jumpTargetNames = null;
                } else {
                    this.jumpTargetNamesSet = true;
                }
            }
        }
        if (this.jumpTargetNames == null) {
            throw new ActivityNoJumpTargetsException(new Object[]{this.getName()});
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit(this.jumpTargetNames);
        }
        return this.jumpTargetNames;
    }

    public LinkTemplateData[] getOutgoingLinks() throws ClientException {
        if (!this.outgoingLinksSet) {
            BusinessFlowManagerService businessFlowManagerService = BFMUtils.getBusinessFlowManagerService(this.connection);
            try {
                this.outgoingLinks = businessFlowManagerService.getOutgoingLinks(this.getID());
                this.outgoingLinksSet = true;
            }
            catch (EngineNotAuthorizedException engineNotAuthorizedException) {
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (Throwable)engineNotAuthorizedException);
                }
                new NotAuthorizedException(new Object[0], (Throwable)engineNotAuthorizedException);
            }
            catch (ProcessException processException) {
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (Throwable)processException);
                }
                throw new BFMCommandException(new Object[]{"BusinessFlowManagerService.getOutgoingLinks"}, processException);
            }
            catch (RemoteException remoteException) {
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (Throwable)remoteException);
                }
                throw new CommunicationException(new Object[]{"BusinessFlowManagerService.getOutgoingLinks"}, (Throwable)remoteException);
            }
            catch (EJBException eJBException) {
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (Throwable)eJBException);
                }
                throw new CommunicationException(new Object[]{"BusinessFlowManagerService.getOutgoingLinks"}, (Throwable)eJBException);
            }
        }
        return this.outgoingLinks;
    }

    public BranchTemplateData[] getBranches() throws ClientException {
        if (!this.branchesSet && this.getKind() == 32) {
            BusinessFlowManagerService businessFlowManagerService = BFMUtils.getBusinessFlowManagerService(this.connection);
            try {
                this.branches = businessFlowManagerService.getBranches(this.getID());
                this.branchesSet = true;
            }
            catch (EngineNotAuthorizedException engineNotAuthorizedException) {
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (Throwable)engineNotAuthorizedException);
                }
                new NotAuthorizedException(new Object[0], (Throwable)engineNotAuthorizedException);
            }
            catch (ProcessException processException) {
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (Throwable)processException);
                }
                throw new BFMCommandException(new Object[]{"BusinessFlowManagerService.getBranches"}, processException);
            }
            catch (RemoteException remoteException) {
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (Throwable)remoteException);
                }
                throw new CommunicationException(new Object[]{"BusinessFlowManagerService.getBranches"}, (Throwable)remoteException);
            }
            catch (EJBException eJBException) {
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (Throwable)eJBException);
                }
                throw new CommunicationException(new Object[]{"BusinessFlowManagerService.getBranches"}, (Throwable)eJBException);
            }
        }
        return this.branches;
    }

    static {
        propertyNameToDBMap.put("ID", "ACTIVITY.AIID");
        propertyNameToDBMap.put("completionTime", "ACTIVITY.COMPLETED");
        propertyNameToDBMap.put("activationTime", "ACTIVITY.ACTIVATED");
        propertyNameToDBMap.put("startTime", "ACTIVITY.STARTED");
        propertyNameToDBMap.put("description", "ACTIVITY.DESCRIPTION");
        propertyNameToDBMap.put("name", "ACTIVITY.TEMPLATE_NAME");
        propertyNameToDBMap.put("owner", "ACTIVITY.OWNER");
        propertyNameToDBMap.put("processInstanceID", "ACTIVITY.PIID");
        propertyNameToDBMap.put("kind", "ACTIVITY.KIND");
        propertyNameToDBMap.put("processTemplateID", "ACTIVITY.PTID");
        propertyNameToDBMap.put("executionState", "ACTIVITY.STATE");
        propertyNameToDBMap.put("expirationTime", "ACTIVITY.EXPIRES");
        propertyNameToDBMap.put("previousExpirationTime", "ACTIVITY.PREVIOUS.EXPIRES");
        propertyNameToDBMap.put("processInstanceName", "PROCESS_INSTANCE.NAME");
        propertyNameToDBMap.put("processTemplateName", "PROCESS_INSTANCE.TEMPLATE_NAME");
        propertyNameToDBMap.put("processTemplateDisplayName", "PROCESS_TEMPLATE.DISPLAY_NAME");
        actionNames = FieldMapCreator.createKeyMap(ActivityInstanceActions.class, (String)"", (String)"");
    }
}

