/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.clientmodel.bean;

import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpc.clientcore.MessageWrapper;
import com.ibm.bpc.clientcore.converter.BooleanConverter;
import com.ibm.bpc.clientcore.converter.CalendarConverter;
import com.ibm.bpc.clientcore.converter.SimpleConverter;
import com.ibm.bpc.clientcore.exception.CommunicationException;
import com.ibm.bpc.clientcore.util.LocaleUtils;
import com.ibm.bpc.clientcore.util.MessageWrapperImpl;
import com.ibm.bpe.api.AIID;
import com.ibm.bpe.api.ATID;
import com.ibm.bpe.api.ActivityInstanceData;
import com.ibm.bpe.api.BusinessFlowManagerService;
import com.ibm.bpe.api.ClientObjectWrapper;
import com.ibm.bpe.api.EHIID;
import com.ibm.bpe.api.EngineWrongKindException;
import com.ibm.bpe.api.EngineWrongStateException;
import com.ibm.bpe.api.FEIID;
import com.ibm.bpe.api.InvalidLengthException;
import com.ibm.bpe.api.OID;
import com.ibm.bpe.api.PIID;
import com.ibm.bpe.api.PTID;
import com.ibm.bpe.api.ProcessException;
import com.ibm.bpe.api.ProcessTemplateData;
import com.ibm.bpe.api.QueryResultSet;
import com.ibm.bpe.api.SIID;
import com.ibm.bpe.api.STID;
import com.ibm.bpe.api.StaffResultSet;
import com.ibm.bpe.api.WorkItemManagerException;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.clientmodel.BFMConnection;
import com.ibm.bpe.clientmodel.converter.ActivityInstanceExecutionStateConverter;
import com.ibm.bpe.clientmodel.converter.ActivityInstanceKindConverter;
import com.ibm.bpe.clientmodel.converter.ActivityInstanceStopReasonConverter;
import com.ibm.bpe.clientmodel.converter.ActivityInstanceSubStateConverter;
import com.ibm.bpe.clientmodel.exception.BFMCommandException;
import com.ibm.bpe.clientmodel.util.BFMUtils;
import com.ibm.bpe.util.Assert;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import com.ibm.task.api.TKIID;
import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.ejb.EJBException;

public class ActivityInstanceBean
implements ActivityInstanceData {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2004, 2009.\n\n";
    private static final long serialVersionUID = 1L;
    private static Map converters = new HashMap();
    private static Map labels = new HashMap();
    public static final String ACTIVATIONTIME_PROPERTY = "activationTime";
    public static final String APPLICATIONNAME_PROPERTY = "applicationName";
    public static final String AVAILABLEACTIONS_PROPERTY = "availableActions";
    public static final String COMPLETIONTIME_PROPERTY = "completionTime";
    public static final String CUSTOMPROPERTY_PROPERTY = "customProperty";
    public static final String CONTINUEONERROR_PROPERTY = "continueOnError";
    public static final String DESCRIPTION_PROPERTY = "description";
    public static final String DISPLAYNAME_PROPERTY = "displayName";
    public static final String EXECUTIONSTATE_PROPERTY = "executionState";
    public static final String EXPIRATIONTIME_PROPERTY = "expirationTime";
    public static final String FAULTNAMES_PROPERTY = "faultNames";
    public static final String ID_PROPERTY = "ID";
    public static final String INPUTMESSAGETYPENAME_PROPERTY = "inputMessageTypeName";
    public static final String INPUTMESSAGETYPETYPESYSTEMNAME_PROPERTY = "inputMessageTypeTypeSystemName";
    public static final String KIND_PROPERTY = "kind";
    public static final String LASTMODIFICATIONTIME_PROPERTY = "lastModificationTime";
    public static final String LASTSTATECHANGETIME_PROPERTY = "lastStateChangeTime";
    public static final String NAME_PROPERTY = "name";
    public static final String OUTPUTMESSAGETYPENAME_PROPERTY = "outputMessageTypeName";
    public static final String OUTPUTMESSAGETYPETYPESYSTEMNAME_PROPERTY = "outputMessageTypeTypeSystemName";
    public static final String OWNER_PROPERTY = "owner";
    public static final String PREVIOUSEXPIRATIONTIME_PROPERTY = "previousExpirationTime";
    public static final String PROCESSADMINISTRATORS_PROPERTY = "processAdministrators";
    public static final String PROCESSINSTANCEID_PROPERTY = "processInstanceID";
    public static final String PROCESSINSTANCENAME_PROPERTY = "processInstanceName";
    public static final String PROCESSTEMPLATEID_PROPERTY = "processTemplateID";
    public static final String PROCESSTEMPLATENAME_PROPERTY = "processTemplateName";
    public static final String PROCESSTEMPLATEDISPLAYNAME_PROPERTY = "processTemplateDisplayName";
    public static final String STARTTIME_PROPERTY = "startTime";
    public static final String UNHANDLEDEXCEPTION_PROPERTY = "unhandledException";
    public static final String STOPREASON_PROPERTY = "stopReason";
    public static final String SKIPREQUESTED_PROPERTY = "skipRequested";
    public static final String SUBSTATE_PROPERTY = "subState";
    private static final TimeZone UTC_TIMEZONE;
    private BFMConnection connection;
    private AIID aiid;
    private long activationTime;
    private boolean activationTimeSet = false;
    private boolean activationTimeFound = false;
    private long completionTime;
    private boolean completionTimeSet = false;
    private boolean completionTimeFound = false;
    private String description;
    private boolean descriptionSet = false;
    private boolean templateDescriptionFound = false;
    private boolean descriptionFound = false;
    private long expirationTime;
    private boolean expirationTimeSet = false;
    private boolean expirationTimeFound = false;
    private OID invokedInstanceID = null;
    private boolean invokedInstanceIDSet = false;
    private Integer invokedInstanceType;
    private boolean invokedInstanceTypeSet = false;
    private Integer kind;
    private boolean kindSet = false;
    private String owner;
    private boolean ownerSet = false;
    private long startTime;
    private boolean startTimeSet = false;
    private boolean startTimeFound = false;
    private Integer executionState;
    private boolean executionStateSet = false;
    private String activityName;
    private boolean activityNameSet = false;
    private String processInstanceName;
    private boolean processInstanceNameSet = false;
    private String processTemplateName;
    private boolean processTemplateNameSet = false;
    private String processTemplateDisplayName = null;
    private boolean processTemplateDisplayNameSet = false;
    private boolean skipRequested = false;
    private boolean skipRequestedSet = false;
    private Integer stopReason;
    private boolean stopReasonSet = false;
    private Integer subState;
    private boolean subStateSet = false;
    private ActivityInstanceData original = null;

    public static SimpleConverter getConverter(String string) {
        SimpleConverter simpleConverter = (SimpleConverter)converters.get(string);
        return simpleConverter;
    }

    public static String getLabel(String string) {
        String string2 = (String)labels.get(string);
        return string2;
    }

    public static String getLabel(String string, Locale locale) {
        String string2 = LocaleUtils.getLocalizedString((String)((String)labels.get(string)), (Locale)locale);
        return string2;
    }

    public static boolean isValid(String string) {
        boolean bl = labels.get(string) != null;
        return bl;
    }

    public ActivityInstanceBean(ActivityInstanceData activityInstanceData, BFMConnection bFMConnection) {
        this.original = activityInstanceData;
        Assert.assertion((this.original != null ? 1 : 0) != 0, (String)"original != null");
        this.connection = bFMConnection;
    }

    public ActivityInstanceBean(QueryResultSet queryResultSet, BFMConnection bFMConnection) {
        Long l = null;
        for (int i = 1; i <= queryResultSet.numberColumns(); ++i) {
            String string = queryResultSet.getTableDisplayName(i);
            String string2 = queryResultSet.getColumnDisplayName(i);
            String string3 = null;
            String string4 = null;
            if (string.equalsIgnoreCase("ACTIVITY")) {
                if (string2.equalsIgnoreCase("AIID")) {
                    this.aiid = (AIID)queryResultSet.getOID(i);
                } else if (string2.equalsIgnoreCase("ACTIVATED")) {
                    this.activationTimeFound = true;
                    l = queryResultSet.getTimestampAsLong(i);
                    if (l != null) {
                        this.activationTime = l;
                        this.activationTimeSet = true;
                    }
                } else if (string2.equalsIgnoreCase("COMPLETED")) {
                    this.completionTimeFound = true;
                    l = queryResultSet.getTimestampAsLong(i);
                    if (l != null) {
                        this.completionTime = l;
                        this.completionTimeSet = true;
                    }
                } else if (string2.equalsIgnoreCase("TEMPLATE_DESCR")) {
                    this.templateDescriptionFound = true;
                    string4 = queryResultSet.getString(i);
                } else if (string2.equalsIgnoreCase("DESCRIPTION")) {
                    this.descriptionFound = true;
                    string3 = queryResultSet.getString(i);
                } else if (string2.equalsIgnoreCase("EXPIRES")) {
                    this.expirationTimeFound = true;
                    l = queryResultSet.getTimestampAsLong(i);
                    if (l != null) {
                        this.expirationTime = l;
                        this.expirationTimeSet = true;
                    }
                } else if (string2.equalsIgnoreCase("INVOKED_INST_ID")) {
                    this.invokedInstanceID = queryResultSet.getOID(i);
                    this.invokedInstanceIDSet = true;
                } else if (string2.equalsIgnoreCase("INVOKED_INST_TYPE")) {
                    this.invokedInstanceType = queryResultSet.getInteger(i);
                    this.invokedInstanceTypeSet = true;
                } else if (string2.equalsIgnoreCase("KIND")) {
                    this.kind = queryResultSet.getInteger(i);
                    this.kindSet = true;
                } else if (string2.equalsIgnoreCase("OWNER")) {
                    this.owner = queryResultSet.getString(i);
                    this.ownerSet = true;
                } else if (string2.equalsIgnoreCase("STARTED")) {
                    this.startTimeFound = true;
                    l = queryResultSet.getTimestampAsLong(i);
                    if (l != null) {
                        this.startTime = l;
                        this.startTimeSet = true;
                    }
                } else if (string2.equalsIgnoreCase("STATE")) {
                    this.executionState = queryResultSet.getInteger(i);
                    this.executionStateSet = true;
                } else if (string2.equalsIgnoreCase("TEMPLATE_NAME")) {
                    this.activityName = queryResultSet.getString(i);
                    this.activityNameSet = true;
                } else if (string2.equalsIgnoreCase("SKIP_REQUESTED")) {
                    Boolean bl = queryResultSet.getBoolean(i);
                    this.skipRequested = bl != null ? bl : false;
                    this.skipRequestedSet = bl != null;
                } else if (string2.equalsIgnoreCase("STOP_REASON")) {
                    this.stopReason = queryResultSet.getInteger(i);
                    this.stopReasonSet = true;
                } else if (string2.equalsIgnoreCase("SUB_STATE")) {
                    this.subState = queryResultSet.getInteger(i);
                    this.subStateSet = true;
                }
            }
            if (string4 != null) {
                this.descriptionSet = true;
                this.description = string4;
            }
            if (string3 != null) {
                this.descriptionSet = true;
                this.description = string3;
            }
            if (string.equalsIgnoreCase("PROCESS_INSTANCE") && string2.equalsIgnoreCase("NAME")) {
                this.processInstanceName = queryResultSet.getString(i);
                this.processInstanceNameSet = true;
            }
            if (!string.equalsIgnoreCase("PROCESS_TEMPLATE")) continue;
            if (string2.equalsIgnoreCase("NAME")) {
                this.processTemplateName = queryResultSet.getString(i);
                this.processTemplateNameSet = true;
            }
            if (!string2.equalsIgnoreCase("DISPLAY_NAME")) continue;
            this.processTemplateDisplayName = queryResultSet.getString(i);
            this.processTemplateDisplayNameSet = true;
        }
        this.connection = bFMConnection;
    }

    public Calendar getActivationTime() {
        if (this.activationTimeSet && this.original == null) {
            Calendar calendar = Calendar.getInstance(UTC_TIMEZONE);
            calendar.setTimeInMillis(this.activationTime);
            return calendar;
        }
        if (this.original == null) {
            if (!this.activationTimeFound && BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"No value and no original!");
            }
            return null;
        }
        return this.getOriginal().getActivationTime();
    }

    public TKIID getAdminTaskID() {
        return this.getOriginal().getAdminTaskID();
    }

    public TKIID getProcessAdminTaskID() {
        return this.getOriginal().getProcessAdminTaskID();
    }

    public OID getInvokedInstanceID() {
        if (this.invokedInstanceIDSet && this.original == null) {
            return this.invokedInstanceID;
        }
        return this.getOriginal().getInvokedInstanceID();
    }

    public int getInvokedInstanceType() {
        if (this.invokedInstanceTypeSet && this.original == null) {
            return this.invokedInstanceType;
        }
        return this.getOriginal().getInvokedInstanceType();
    }

    public ATID getActivityTemplateID() {
        return this.getOriginal().getActivityTemplateID();
    }

    public String getApplicationName() {
        return this.getOriginal().getApplicationName();
    }

    public int[] getAvailableActions() {
        return this.getOriginal().getAvailableActions();
    }

    public Calendar getCompletionTime() {
        if (this.completionTimeSet && this.original == null) {
            Calendar calendar = Calendar.getInstance(UTC_TIMEZONE);
            calendar.setTimeInMillis(this.completionTime);
            return calendar;
        }
        if (this.original == null) {
            if (!this.completionTimeFound && BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"No value and no original!");
            }
            return null;
        }
        return this.getOriginal().getCompletionTime();
    }

    public String getCustomProperty(String string) {
        return this.getOriginal().getCustomProperty(string);
    }

    public String getDescription() {
        if (this.descriptionSet && this.original == null) {
            return this.description;
        }
        if (this.original == null) {
            if (!(this.descriptionFound && this.templateDescriptionFound || !BPCClientTrace.isTracing)) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"No value and no original!");
            }
            return null;
        }
        return this.getOriginal().getDescription();
    }

    public String getDisplayName() {
        String string = this.getOriginal().getDisplayName();
        if (string == null || string.equals("")) {
            return this.getName();
        }
        return string;
    }

    public int getExecutionState() {
        if (this.executionStateSet && this.original == null) {
            return this.executionState;
        }
        return this.getOriginal().getExecutionState();
    }

    public void setExecutionState(int n) {
        this.executionState = new Integer(n);
        this.executionStateSet = true;
        this.original = null;
    }

    public Calendar getExpirationTime() {
        if (this.expirationTimeSet && this.original == null) {
            Calendar calendar = Calendar.getInstance(UTC_TIMEZONE);
            calendar.setTimeInMillis(this.expirationTime);
            return calendar;
        }
        if (this.original == null) {
            if (!this.expirationTimeFound && BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"No value and no original!");
            }
            return null;
        }
        return this.getOriginal().getExpirationTime();
    }

    public List getFaultNames() {
        return this.getOriginal().getFaultNames();
    }

    public AIID getID() {
        if (this.original != null) {
            return this.original.getID();
        }
        if (this.aiid != null) {
            return this.aiid;
        }
        return this.getOriginal().getID();
    }

    public String getInputMessageTypeName() {
        return this.getOriginal().getInputMessageTypeName();
    }

    public String getInputMessageTypeTypeSystemName() {
        return this.getOriginal().getInputMessageTypeTypeSystemName();
    }

    public int getKind() {
        if (this.kindSet && this.original == null) {
            return this.kind;
        }
        return this.getOriginal().getKind();
    }

    public Calendar getLastModificationTime() {
        return this.getOriginal().getLastModificationTime();
    }

    public Calendar getLastStateChangeTime() {
        return this.getOriginal().getLastStateChangeTime();
    }

    public String getName() {
        if (this.activityNameSet && this.original == null) {
            return this.activityName;
        }
        return this.getOriginal().getName();
    }

    public List getNamesOfCustomProperties() {
        return this.getOriginal().getNamesOfCustomProperties();
    }

    private ActivityInstanceData getOriginal() {
        if (this.original == null) {
            try {
                Object object;
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Retrieving original for " + this.aiid));
                }
                if ((object = this.connection.retrieve((OID)this.aiid)) instanceof ActivityInstanceData) {
                    this.original = (ActivityInstanceData)object;
                }
            }
            catch (Exception exception) {
                throw new RuntimeException("Could not load original data from AIID.", exception);
            }
        }
        return this.original;
    }

    public String getOutputMessageTypeName() {
        return this.getOriginal().getOutputMessageTypeName();
    }

    public String getOutputMessageTypeTypeSystemName() {
        return this.getOriginal().getOutputMessageTypeTypeSystemName();
    }

    public String getOwner() {
        if (this.ownerSet && this.original == null) {
            return this.owner;
        }
        return this.getOriginal().getOwner();
    }

    public StaffResultSet getProcessAdministrators() throws WorkItemManagerException, InvalidLengthException {
        return this.getOriginal().getProcessAdministrators();
    }

    public PIID getProcessInstanceID() {
        return this.getOriginal().getProcessInstanceID();
    }

    public String getProcessInstanceName() {
        if (this.processInstanceNameSet && this.original == null) {
            return this.processInstanceName;
        }
        return this.getOriginal().getProcessInstanceName();
    }

    public PTID getProcessTemplateID() {
        return this.getOriginal().getProcessTemplateID();
    }

    public String getProcessTemplateName() {
        if (this.processTemplateNameSet && this.original == null) {
            return this.processTemplateName;
        }
        return this.getOriginal().getProcessTemplateName();
    }

    public String getProcessTemplateDisplayName() {
        String string = this.processTemplateDisplayName;
        if (string == null || string.equals("")) {
            ProcessTemplateData processTemplateData;
            block5: {
                processTemplateData = null;
                try {
                    processTemplateData = (ProcessTemplateData)this.connection.retrieve((OID)this.getProcessTemplateID());
                }
                catch (ClientException clientException) {
                    if (!BPCClientTrace.isTracing) break block5;
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_EVENT, (String)("Returning process template name, no retrieval of display name possible: " + clientException.getMessage()));
                }
            }
            if (processTemplateData != null) {
                string = this.processTemplateDisplayName = processTemplateData.getDisplayName();
                this.processTemplateDisplayNameSet = true;
            } else {
                string = this.getProcessTemplateName();
            }
        }
        return string;
    }

    public Calendar getStartTime() {
        if (this.startTimeSet && this.original == null) {
            Calendar calendar = Calendar.getInstance(UTC_TIMEZONE);
            calendar.setTimeInMillis(this.startTime);
            return calendar;
        }
        if (this.original == null) {
            if (!this.startTimeFound && BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"No value and no original!");
            }
            return null;
        }
        return this.getOriginal().getStartTime();
    }

    public TKIID getTaskID() {
        return this.getOriginal().getTaskID();
    }

    public SIID getScopeID() {
        return this.getOriginal().getScopeID();
    }

    public STID getScopeTemplateID() {
        return this.getOriginal().getScopeTemplateID();
    }

    public EHIID getEventHandlerInstanceID() {
        return this.getOriginal().getEventHandlerInstanceID();
    }

    public FEIID getEnclosingForEachID() {
        return this.getOriginal().getEnclosingForEachID();
    }

    public ProcessException getUnhandledException() {
        return this.getOriginal().getUnhandledException();
    }

    public int getStopReason() {
        if (this.stopReasonSet && this.original == null) {
            return this.stopReason;
        }
        return this.getOriginal().getStopReason();
    }

    public int getSubState() {
        if (this.subStateSet && this.original == null) {
            return this.subState;
        }
        return this.getOriginal().getSubState();
    }

    public boolean isBusinessRelevant() {
        return this.getOriginal().isBusinessRelevant();
    }

    public boolean getActivityClaimed() {
        return this.getOriginal().getExecutionState() == 8;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MessageWrapper getInputMessageWrapper() throws ClientException {
        MessageWrapperImpl messageWrapperImpl = new MessageWrapperImpl(this.getApplicationName());
        int n = this.getKind();
        if (n == 43 || n == 21) {
            try {
                BusinessFlowManagerService businessFlowManagerService = BFMUtils.getBusinessFlowManagerService(this.connection);
                ClientObjectWrapper clientObjectWrapper = businessFlowManagerService.getInputMessage(this.getID());
                if (BPCClientTrace.isTracing) {
                    if (clientObjectWrapper != null && clientObjectWrapper.getObject() != null) {
                        BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Message available for " + this.getID()));
                        BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)clientObjectWrapper.getObject().toString());
                    } else {
                        BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("No message available for " + this.getID()));
                    }
                }
                if (clientObjectWrapper == null) return messageWrapperImpl;
                messageWrapperImpl.setMessage(clientObjectWrapper.getObject());
                return messageWrapperImpl;
            }
            catch (EngineWrongKindException engineWrongKindException) {
                if (!BPCClientTrace.isTracing) return messageWrapperImpl;
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"No message available for this kind");
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (Throwable)engineWrongKindException);
                return messageWrapperImpl;
            }
            catch (EngineWrongStateException engineWrongStateException) {
                if (!BPCClientTrace.isTracing) return messageWrapperImpl;
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"No message available for this state");
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (Throwable)engineWrongStateException);
                return messageWrapperImpl;
            }
            catch (RemoteException remoteException) {
                if (!BPCClientTrace.isTracing) throw new CommunicationException(new Object[]{"BusinessFlowManager.getInputMessage"}, (Throwable)remoteException);
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (Throwable)remoteException);
                throw new CommunicationException(new Object[]{"BusinessFlowManager.getInputMessage"}, (Throwable)remoteException);
            }
            catch (ProcessException processException) {
                if (!BPCClientTrace.isTracing) throw new BFMCommandException(new Object[]{"BusinessFlowManager.getInputMessage"}, processException);
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (Throwable)processException);
                throw new BFMCommandException(new Object[]{"BusinessFlowManager.getInputMessage"}, processException);
            }
            catch (EJBException eJBException) {
                if (!BPCClientTrace.isTracing) throw new CommunicationException(new Object[]{"BusinessFlowManager.getInputMessage"}, (Throwable)eJBException);
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (Throwable)eJBException);
                throw new CommunicationException(new Object[]{"BusinessFlowManager.getInputMessage"}, (Throwable)eJBException);
            }
        } else {
            if (!BPCClientTrace.isTracing) return messageWrapperImpl;
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("No message available for activity kind " + new ActivityInstanceKindConverter().getAsString(new Integer(n))));
        }
        return messageWrapperImpl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MessageWrapper getOutputMessageWrapper() throws ClientException {
        MessageWrapperImpl messageWrapperImpl = new MessageWrapperImpl(this.getApplicationName());
        int n = this.getKind();
        if ((n == 43 || n == 21) && this.getExecutionState() != 3) {
            try {
                BusinessFlowManagerService businessFlowManagerService = BFMUtils.getBusinessFlowManagerService(this.connection);
                ClientObjectWrapper clientObjectWrapper = businessFlowManagerService.getOutputMessage(this.getID());
                if (BPCClientTrace.isTracing) {
                    if (clientObjectWrapper != null && clientObjectWrapper.getObject() != null) {
                        BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Message available for " + this.getID()));
                        BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)clientObjectWrapper.getObject().toString());
                    } else {
                        BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("No message available for " + this.getID()));
                    }
                }
                if (clientObjectWrapper == null) return messageWrapperImpl;
                messageWrapperImpl.setMessage(clientObjectWrapper.getObject());
                return messageWrapperImpl;
            }
            catch (EngineWrongKindException engineWrongKindException) {
                if (!BPCClientTrace.isTracing) return messageWrapperImpl;
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"No message available for this kind");
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (Throwable)engineWrongKindException);
                return messageWrapperImpl;
            }
            catch (EngineWrongStateException engineWrongStateException) {
                if (!BPCClientTrace.isTracing) return messageWrapperImpl;
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"No message available for this state");
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (Throwable)engineWrongStateException);
                return messageWrapperImpl;
            }
            catch (RemoteException remoteException) {
                if (!BPCClientTrace.isTracing) throw new CommunicationException(new Object[]{"BusinessFlowManager.getOutputMessage"}, (Throwable)remoteException);
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (Throwable)remoteException);
                throw new CommunicationException(new Object[]{"BusinessFlowManager.getOutputMessage"}, (Throwable)remoteException);
            }
            catch (ProcessException processException) {
                if (!BPCClientTrace.isTracing) throw new BFMCommandException(new Object[]{"BusinessFlowManager.getOutputMessage"}, processException);
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (Throwable)processException);
                throw new BFMCommandException(new Object[]{"BusinessFlowManager.getOutputMessage"}, processException);
            }
            catch (EJBException eJBException) {
                if (!BPCClientTrace.isTracing) throw new CommunicationException(new Object[]{"BusinessFlowManager.getOutputMessage"}, (Throwable)eJBException);
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (Throwable)eJBException);
                throw new CommunicationException(new Object[]{"BusinessFlowManager.getOutputMessage"}, (Throwable)eJBException);
            }
        } else {
            if (!BPCClientTrace.isTracing) return messageWrapperImpl;
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("No message available for activity kind " + new ActivityInstanceKindConverter().getAsString(new Integer(n))));
        }
        return messageWrapperImpl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MessageWrapper getFaultMessageWrapper() throws ClientException {
        MessageWrapperImpl messageWrapperImpl = new MessageWrapperImpl(this.getApplicationName());
        int n = this.getKind();
        int n2 = this.getExecutionState();
        if (!(n != 43 && n != 21 && n != 42 || n2 != 8 && n2 != 12 && n2 != 6 && n2 != 5 && n2 != 7 && n2 != 2 && n2 != 13)) {
            try {
                BusinessFlowManagerService businessFlowManagerService = BFMUtils.getBusinessFlowManagerService(this.connection);
                ClientObjectWrapper clientObjectWrapper = businessFlowManagerService.getFaultMessage(this.getID());
                if (BPCClientTrace.isTracing) {
                    if (clientObjectWrapper != null && clientObjectWrapper.getObject() != null) {
                        BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Message available for " + this.getID()));
                        BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)clientObjectWrapper.getObject().toString());
                    } else {
                        BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("No message available for " + this.getID()));
                    }
                }
                if (clientObjectWrapper == null) return messageWrapperImpl;
                messageWrapperImpl.setMessage(clientObjectWrapper.getObject());
                return messageWrapperImpl;
            }
            catch (EngineWrongKindException engineWrongKindException) {
                if (!BPCClientTrace.isTracing) return messageWrapperImpl;
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"No message available for this kind");
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (Throwable)engineWrongKindException);
                return messageWrapperImpl;
            }
            catch (EngineWrongStateException engineWrongStateException) {
                if (!BPCClientTrace.isTracing) return messageWrapperImpl;
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"No message available for this state");
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (Throwable)engineWrongStateException);
                return messageWrapperImpl;
            }
            catch (RemoteException remoteException) {
                if (!BPCClientTrace.isTracing) throw new CommunicationException(new Object[]{"BusinessFlowManager.getFaultMessage"}, (Throwable)remoteException);
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (Throwable)remoteException);
                throw new CommunicationException(new Object[]{"BusinessFlowManager.getFaultMessage"}, (Throwable)remoteException);
            }
            catch (ProcessException processException) {
                if (!BPCClientTrace.isTracing) throw new BFMCommandException(new Object[]{"BusinessFlowManager.getFaultMessage"}, processException);
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (Throwable)processException);
                throw new BFMCommandException(new Object[]{"BusinessFlowManager.getFaultMessage"}, processException);
            }
            catch (EJBException eJBException) {
                if (!BPCClientTrace.isTracing) throw new CommunicationException(new Object[]{"BusinessFlowManager.getFaultMessage"}, (Throwable)eJBException);
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (Throwable)eJBException);
                throw new CommunicationException(new Object[]{"BusinessFlowManager.getFaultMessage"}, (Throwable)eJBException);
            }
        } else {
            if (!BPCClientTrace.isTracing) return messageWrapperImpl;
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("No message available for activity kind " + new ActivityInstanceKindConverter().getAsString(new Integer(n))));
        }
        return messageWrapperImpl;
    }

    public boolean isSkipRequested() {
        if (this.skipRequestedSet && this.original == null) {
            return this.skipRequested;
        }
        return this.getOriginal().isSkipRequested();
    }

    public boolean isContinueOnError() {
        return this.getOriginal().isContinueOnError();
    }

    public Calendar getPreviousExpirationTime() {
        Calendar calendar = this.getOriginal().getPreviousExpirationTime();
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("PreviousExpirationTimer:" + calendar));
        }
        return calendar;
    }

    static {
        labels.put(ID_PROPERTY, "ACTIVITY.AIID");
        labels.put(ACTIVATIONTIME_PROPERTY, "ACTIVITY.ACTIVATED");
        labels.put(COMPLETIONTIME_PROPERTY, "ACTIVITY.COMPLETED");
        labels.put(CONTINUEONERROR_PROPERTY, "ACTIVITY.CONTINUEONERROR");
        labels.put(LASTMODIFICATIONTIME_PROPERTY, "ACTIVITY.MODIFIED");
        labels.put(LASTSTATECHANGETIME_PROPERTY, "ACTIVITY.CHANGED");
        labels.put(NAME_PROPERTY, "ACTIVITY.NAME");
        labels.put(DISPLAYNAME_PROPERTY, "ACTIVITY.NAME");
        labels.put(DESCRIPTION_PROPERTY, "ACTIVITY.DESCRIPTION");
        labels.put(OWNER_PROPERTY, "ACTIVITY.OWNER");
        labels.put(STARTTIME_PROPERTY, "ACTIVITY.STARTED");
        labels.put(EXECUTIONSTATE_PROPERTY, "ACTIVITY.STATE");
        labels.put(EXPIRATIONTIME_PROPERTY, "ACTIVITY.EXPIRES");
        labels.put(PREVIOUSEXPIRATIONTIME_PROPERTY, "ACTIVITY.PREVIOUS.EXPIRES");
        labels.put(KIND_PROPERTY, "ACTIVITY.KIND");
        labels.put(UNHANDLEDEXCEPTION_PROPERTY, "ACTIVITY.UNHANDLED.EXCEPTION");
        labels.put(STOPREASON_PROPERTY, "ACTIVITY.STOP.REASON");
        labels.put(PROCESSINSTANCEID_PROPERTY, "ACTIVITY.INSTANCE.ID");
        labels.put(PROCESSTEMPLATEID_PROPERTY, "ACTIVITY.TEMPLATE.ID");
        labels.put(FAULTNAMES_PROPERTY, "ACTIVITY.FAULT.NAMES");
        labels.put(INPUTMESSAGETYPENAME_PROPERTY, INPUTMESSAGETYPENAME_PROPERTY);
        labels.put(INPUTMESSAGETYPETYPESYSTEMNAME_PROPERTY, INPUTMESSAGETYPETYPESYSTEMNAME_PROPERTY);
        labels.put(OUTPUTMESSAGETYPENAME_PROPERTY, OUTPUTMESSAGETYPENAME_PROPERTY);
        labels.put(OUTPUTMESSAGETYPETYPESYSTEMNAME_PROPERTY, OUTPUTMESSAGETYPETYPESYSTEMNAME_PROPERTY);
        labels.put(AVAILABLEACTIONS_PROPERTY, AVAILABLEACTIONS_PROPERTY);
        labels.put(CUSTOMPROPERTY_PROPERTY, CUSTOMPROPERTY_PROPERTY);
        labels.put(PROCESSADMINISTRATORS_PROPERTY, "ACTIVITY.PROCESS.ADMINISTRATORS");
        labels.put(APPLICATIONNAME_PROPERTY, "ACTIVITY.APPLICATION.NAME");
        labels.put(PROCESSTEMPLATENAME_PROPERTY, "PROCESS.TEMPLATE.NAME");
        labels.put(PROCESSTEMPLATEDISPLAYNAME_PROPERTY, "PROCESS.TEMPLATE.NAME");
        labels.put(PROCESSINSTANCENAME_PROPERTY, "PROCESS.INSTANCE.NAME");
        labels.put(SKIPREQUESTED_PROPERTY, "ACTIVITY.SKIPREQUESTED");
        labels.put(SUBSTATE_PROPERTY, "ACTIVITY.SUB.STATE");
        converters.put(ACTIVATIONTIME_PROPERTY, new CalendarConverter());
        converters.put(COMPLETIONTIME_PROPERTY, new CalendarConverter());
        converters.put(CONTINUEONERROR_PROPERTY, new BooleanConverter());
        converters.put(LASTMODIFICATIONTIME_PROPERTY, new CalendarConverter());
        converters.put(LASTSTATECHANGETIME_PROPERTY, new CalendarConverter());
        converters.put(STARTTIME_PROPERTY, new CalendarConverter());
        converters.put(EXPIRATIONTIME_PROPERTY, new CalendarConverter());
        converters.put(PREVIOUSEXPIRATIONTIME_PROPERTY, new CalendarConverter());
        converters.put(EXECUTIONSTATE_PROPERTY, new ActivityInstanceExecutionStateConverter());
        converters.put(KIND_PROPERTY, new ActivityInstanceKindConverter());
        converters.put(STOPREASON_PROPERTY, new ActivityInstanceStopReasonConverter());
        converters.put(SKIPREQUESTED_PROPERTY, new BooleanConverter());
        converters.put(SUBSTATE_PROPERTY, new ActivityInstanceSubStateConverter());
        UTC_TIMEZONE = TimeZone.getTimeZone("UTC");
    }
}

