/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.clientmodel;

import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpc.clientcore.exception.CommunicationException;
import com.ibm.bpe.api.AIID;
import com.ibm.bpe.api.ActivityInstanceData;
import com.ibm.bpe.api.BusinessFlowManager;
import com.ibm.bpe.api.BusinessFlowManagerHome;
import com.ibm.bpe.api.BusinessFlowManagerService;
import com.ibm.bpe.api.LocalBusinessFlowManager;
import com.ibm.bpe.api.LocalBusinessFlowManagerHome;
import com.ibm.bpe.api.OID;
import com.ibm.bpe.api.PIID;
import com.ibm.bpe.api.PTID;
import com.ibm.bpe.api.ProcessException;
import com.ibm.bpe.api.ProcessInstanceData;
import com.ibm.bpe.api.ProcessTemplateData;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.clientmodel.exception.BFMCommandException;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import java.rmi.RemoteException;
import java.util.Hashtable;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

public class BFMConnection {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2009.\n\n";
    private Context context;
    private BusinessFlowManagerHome bpeHome;
    private LocalBusinessFlowManagerHome localBpeHome;
    private String providerURL = null;
    private String jndiName = "com/ibm/bpe/api/BusinessProcessHome";
    private Boolean isConfiguredForRemoteEJB = Boolean.FALSE;
    private Boolean isObserverConfigured = Boolean.FALSE;

    public String getProviderURL() {
        return this.providerURL;
    }

    public void setProviderURL(String string) {
        this.providerURL = string;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String string) {
        this.jndiName = string;
    }

    public void setRemote(String string) {
        this.isConfiguredForRemoteEJB = Boolean.valueOf(string);
    }

    public String getRemote() {
        return this.isConfiguredForRemoteEJB.toString();
    }

    public Boolean getObserver() {
        return this.isObserverConfigured;
    }

    public void setObserver(Boolean bl) {
        this.isObserverConfigured = bl;
    }

    private Context getInitialContext() throws NamingException {
        InitialContext initialContext = null;
        if (this.context != null) {
            return this.context;
        }
        if (this.getProviderURL() != null) {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("java.naming.provider.url", this.providerURL);
            hashtable.put("com.ibm.websphere.naming.jndicache.cacheobject", "none");
            initialContext = new InitialContext(hashtable);
        } else {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("com.ibm.websphere.naming.jndicache.cacheobject", "none");
            initialContext = new InitialContext(hashtable);
        }
        this.context = initialContext;
        return initialContext;
    }

    private boolean isLocal() {
        return this.isConfiguredForRemoteEJB == false;
    }

    public Object retrieve(OID oID) throws ClientException {
        BusinessFlowManagerService businessFlowManagerService = null;
        try {
            businessFlowManagerService = this.getBusinessFlowManagerService();
        }
        catch (CreateException createException) {
            throw new CommunicationException(new Object[]{this.getClass()}, (Throwable)createException);
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(new Object[]{this.getClass()}, (Throwable)remoteException);
        }
        catch (NamingException namingException) {
            throw new CommunicationException(new Object[]{this.getClass()}, (Throwable)namingException);
        }
        String string = null;
        try {
            if (oID instanceof PTID) {
                string = "BusinessFlowManagerService.getProcessTemplate";
                ProcessTemplateData processTemplateData = businessFlowManagerService.getProcessTemplate((PTID)oID);
                return processTemplateData;
            }
            if (oID instanceof PIID) {
                string = "BusinessFlowManagerService.getProcessInstance";
                ProcessInstanceData processInstanceData = businessFlowManagerService.getProcessInstance((PIID)oID);
                return processInstanceData;
            }
            if (oID instanceof AIID) {
                string = "BusinessFlowManagerService.getActivityInstance";
                ActivityInstanceData activityInstanceData = businessFlowManagerService.getActivityInstance((AIID)oID);
                return activityInstanceData;
            }
        }
        catch (ProcessException processException) {
            throw new BFMCommandException(new Object[]{string + " for ID: '" + oID + "'"}, processException);
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(new Object[]{string + " for ID: '" + oID + "'"}, (Throwable)remoteException);
        }
        catch (EJBException eJBException) {
            throw new CommunicationException(new Object[]{string + " for ID: '" + oID + "'"}, (Throwable)eJBException);
        }
        return null;
    }

    public void close() {
        try {
            if (this.context != null) {
                this.context.close();
                this.context = null;
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public BusinessFlowManagerService getBusinessFlowManagerService() throws NamingException, CreateException, RemoteException {
        if (this.isLocal()) {
            return this.getLocalBusinessFlowManager();
        }
        return this.getBusinessFlowManager();
    }

    private BusinessFlowManager getBusinessFlowManager() throws CreateException, RemoteException, NamingException {
        Context context;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        if (this.bpeHome == null) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Creating BusinessFlowManagerHome using JNDI name: " + this.jndiName));
            }
            context = this.getInitialContext();
            Object object = context.lookup(this.jndiName);
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Lookup returned: " + object.toString()));
            }
            this.bpeHome = (BusinessFlowManagerHome)PortableRemoteObject.narrow((Object)object, BusinessFlowManagerHome.class);
        }
        context = null;
        if (this.bpeHome != null) {
            try {
                context = this.bpeHome.create();
            }
            catch (Exception exception) {
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Exception during BFMManager.create(): " + exception.getMessage() + ". Starting retry..."));
                }
                Context context2 = this.getInitialContext();
                Object object = context2.lookup(this.jndiName);
                this.bpeHome = (BusinessFlowManagerHome)PortableRemoteObject.narrow((Object)object, BusinessFlowManagerHome.class);
                context = this.bpeHome.create();
            }
        } else {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Couldn't obtain BusinessFlowManagerHome! -> Throwing RuntimeException");
            }
            throw new IllegalStateException("Couldn't obtain BusinessFlowManagerHome");
        }
        if (context != null) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Returning BusinessFlowManager object");
            }
        } else if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Not Returning BusinessFlowManager object");
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
        return context;
    }

    private LocalBusinessFlowManager getLocalBusinessFlowManager() throws CreateException, NamingException {
        Context context;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        if (this.localBpeHome == null) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Creating LocalBusinessProcessHome using JNDI name: " + this.jndiName));
            }
            context = this.getInitialContext();
            this.localBpeHome = (LocalBusinessFlowManagerHome)context.lookup(this.jndiName);
        }
        context = null;
        if (this.localBpeHome != null) {
            try {
                context = this.localBpeHome.create();
            }
            catch (Exception exception) {
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Exception during BFMManager.create(): " + exception.getMessage() + ". Starting retry..."));
                }
                Context context2 = this.getInitialContext();
                this.localBpeHome = (LocalBusinessFlowManagerHome)context2.lookup(this.jndiName);
                context = this.localBpeHome.create();
            }
        } else {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Couldn't obtain BusinessFlowManagerHome! -> Throwing RuntimeException");
            }
            throw new IllegalStateException("Couldn't obtain BusinessFlowManagerHome");
        }
        if (context != null) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Returning LocalBusinessProcess object");
            }
        } else if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Not Returning LocalBusinessProcess object");
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
        return context;
    }
}

