Sequel.migration do
  up do
  
    run <<-SQL
          merge into dbo.pagestates ps
          using
          (
           #{db2? ? "select '___hardware_inventory___________________' as id from sysibm.sysdummy1" : "select '___hardware_inventory___________________' as id"}
          )
          as tmp on tmp.id = ps.id
          when not matched then
          insert (id, value) values ('___hardware_inventory___________________','{"column_order":{"ip_address":2,"name":1,"processor.computer_type":3,"processor.default_pvu_value":12,"processor.partition_cores":5,"processor.processor_brand":10,"processor.processor_brand_string":8,"processor.processor_vendor":9,"processor.public_cloud_type":4,"processor.pvu_per_core":11,"processor.server_cores":7,"processor.server_name":6,"processor.status":0},"column_widths":{},"columns":["name","ip_address","processor.computer_type","processor.public_cloud_type","processor.status","processor.partition_cores","processor.server_name","processor.server_cores","processor.processor_brand_string","processor.processor_vendor","processor.processor_brand","processor.pvu_per_core","processor.default_pvu_value"],"criteria":{"and":[]},"grid_options":["autosize_columns"],"order":[{"asc":true,"col":null}],"time_range":{"type":"all","units":"days","value":"3"}}')#{mssql? ? ";" : ""}
    SQL
    
    run <<-SQL
          merge into dbo.reports r
          using
          (
            #{db2? ? "select '___hardware_inventory___' as name from sysibm.sysdummy1" : "select '___hardware_inventory___' as name"}
          ) as tmp on tmp.name = r.name
          when not matched then
          insert (user_id,pagestate_id,name,path,private) values (-1,'___hardware_inventory___________________','___hardware_inventory___','/sam/computers','0')#{mssql? ? ";" : ""}
    SQL

    run "delete from dbo.reports where  path like '/sam/computers/%/processors'"
    run "delete from dbo.default_reports where path = '/sam/processors' or path like '/sam/computer_groups/%/processors' or path like '/sam/computers/%/processors'"
    
    ps = self["select id, value from dbo.pagestates where id in (select pagestate_id from dbo.reports where (path = '/sam/processors' or path like '/sam/computer_groups/%/processors'))"].all

    ps.each do |v|
      id = v[:id]
      value2 = JSON.parse(v[:value])

      if value2['criteria']
        top_criteria = value2['criteria'].values.first
        top_criteria.each do |crit|
          if crit.is_a?(Array)
            if crit.length > 2 && crit[0].start_with?("computer.")
              crit[0] = crit[0].gsub("computer.","")
            elsif !crit[0].start_with?("processor.")
              crit[0] = "processor." + crit[0]
            end
          elsif crit.is_a?(Hash)
            nested_criteria = crit.values.first
            nested_criteria.each do |crit2|
              if crit2.length > 2 && crit2[0].start_with?("computer.")
                crit2[0] = crit2[0].gsub("computer.","")
              elsif !crit2[0].start_with?("processor.")
                crit2[0] = "processor." + crit2[0]
              end
            end
          end
        end
      end

      if value2['order']
        if value2['order'].is_a?(Hash)
          array = []
          array << value2['order']
          value2['order'] = array
        end
        if value2['order'] && value2['order'].first && !value2['order'].first['col'].nil?
          if value2['order'].first['col'].start_with?("computer.")
             value2['order'].first['col'] = value2['order'].first['col'].gsub("computer.","")
          elsif !value2['order'].first['col'].start_with?("processor.")
             value2['order'].first['col'] = "processor." + value2['order'].first['col']
          end
        end
      end

      if value2['columns']
        columns = value2['columns']
        new_columns = Array.new
        columns.each do |column|
          if column.start_with?("computer.")
            new_columns << column.gsub("computer.","")
          elsif !column.start_with?("processor.")
            new_columns << "processor." + column
          else
            new_columns << column
          end
        end
        value2['columns'] = new_columns
      end

      if value2['column_order']
        value2['column_order'] = value2['column_order'].transform_keys{ |key|
          if (key.to_s.start_with?("computer."))
            key.to_s.gsub("computer.","")
          elsif !key.to_s.start_with?("processor.")
            "processor." + key.to_s
          else
            key.to_s
          end
        }
      end

      if value2['column_widths']
        value2['column_widths'] = value2['column_widths'].transform_keys{ |key| 
          if (key.to_s.start_with?("computer."))
            key.to_s.gsub("computer.","")
          elsif !key.to_s.start_with?("processor.")
            "processor." + key.to_s
          else
            key.to_s
          end
        }
      end

      new_json_value = value2.to_json
      new_hash = Digest::SHA1.hexdigest(new_json_value) 
      run <<-SQL
            merge into dbo.pagestates ps
            using
            (
              select '#{new_hash.to_s}' as id, '#{new_json_value.to_s}' as value #{db2? ? "from sysibm.sysdummy1" : ""}
            ) as tmp on ps.id = tmp.id
            when not matched then
            insert (id,value) values (tmp.id, tmp.value)
            when matched then update set ps.value = tmp.value#{mssql? ? ";" : ""} 
      SQL
      run "update dbo.reports set pagestate_id = '#{new_hash.to_s}', path = replace(path,'/processors','/computers') where pagestate_id = '#{id}'"

    end
    
  end
end
