Sequel.migration do
  up do
  
    run "delete from dbo.report_subscriptions where report_id in (select id from dbo.reports where pagestate_id in ('___cmps_without_scan____________________','___cmps_without_rec_scan________________'))"
    run "delete from dbo.reports where pagestate_id in ('___cmps_without_scan____________________','___cmps_without_rec_scan________________')"
    run "delete from dbo.pagestates where id in ('___cmps_without_scan____________________','___cmps_without_rec_scan________________')"    
    
    run "drop view sam.computer_scan_results"

    run <<-SQL
         create view sam.computer_scan_results
          (
            id,
            cit_scan_missing
          )
          as
          select
            c.id,
            case when sfcit.id is null or sfiso.id is null then 1 else 0 end as cit_scan_missing
          FROM dbo.computers c
          left join sam.scan_files sfiso
            on sfiso.computer_id = c.id and sfiso.scan_type = 'ISOTAG'
          left join sam.scan_files sfcit
            on sfcit.computer_id = c.id and sfcit.scan_type = 'CIT'
    SQL

    begin
      run "alter table sam.computer_health_statuses add #{db2? ? "column" : ""} last_software_scan_failed smallint not null default 0"
      run "call sysproc.admin_cmd('reorg table sam.computer_health_statuses')" if db2?
    rescue => e
      Rails.logger.warn e.message
    end

    run <<-SQL
          merge into sam.computer_health_statuses chs
          using (
          select chs.computer_id as chs_id, case when (is_catalog_scan_successful = 1 and is_idtag_scan_successful = 1) then 0 else 1 end as last_scan_failed
          from sam.computer_health_statuses chs
          join sam.computer_healths ch on ch.id = chs.computer_id
          group by chs.computer_id , ch.is_catalog_scan_successful, ch.is_idtag_scan_successful
          )
          as tmp on chs.computer_id = tmp.chs_id
          when matched then
          update set last_software_scan_failed=tmp.last_scan_failed#{mssql? ? ";" : ""}
    SQL
    
    run <<-SQL
          merge into dbo.pagestates ps
          using
          (
           #{db2? ? "select '___cmps_with_issues_____________________' as id from sysibm.sysdummy1" : "select '___cmps_with_issues_____________________' as id"}
          )
          as tmp on tmp.id = ps.id
          when not matched then
          insert (id, value) values ('___cmps_with_issues_____________________','{"column_order":{"computer_health.last_scan_attempt":7,"computer_health_status.delayed_data_upload":4,"computer_health_status.last_software_scan_failed":9,"computer_health_status.missing_software_scan":8,"computer_health_status.outdated_capacity_scan":6,"ip_address":3,"last_seen":1,"name":0,"os":2,"processor.status":5},"column_widths":{},"columns":["name","last_seen","os","ip_address","computer_health_status.delayed_data_upload","computer_health_status.missing_software_scan","computer_health_status.outdated_capacity_scan","computer_health_status.last_software_scan_failed","computer_health.last_scan_attempt","processor.status"],"criteria":{"or":[["computer_health_status.delayed_data_upload","=","1"],["processor.status_numeric","not_in",["1"]],["computer_health_status.outdated_capacity_scan","=","1"],["computer_health_status.missing_software_scan","=","1"],{"and":[["computer_health.last_scan_attempt","is_not_empty",""],["computer_health_status.last_software_scan_failed","=","1"]]}]},"grid_options":["autosize_columns"],"order":[{"asc":true,"col":null}]}')#{mssql? ? ";" : ""}
    SQL
    
    run <<-SQL
          merge into dbo.reports r
          using
          (
            #{db2? ? "select '___cmps_with_issues__' as name from sysibm.sysdummy1" : "select '___cmps_with_issues__' as name"}
          ) as tmp on tmp.name = r.name
          when not matched then
          insert (user_id,pagestate_id,name,path,private) values (-1,'___cmps_with_issues_____________________','___cmps_with_issues__','/sam/computers','0')#{mssql? ? ";" : ""}
    SQL
    
  end
end