Class.new(Sequel::Migration) do
 
  def dropDatabaseItem(itemName)
    begin
      run "drop #{itemName}"  
      Rails.logger.info("#{itemName} dropped successfully")
    rescue Exception => e
      Rails.logger.info("#{itemName} does not exist")
    end            
  end

  def removeFilterFromReports(query,columnName)
    ps = self[query].all

    ps.each do |v|
      modified = false
      id = v[:id]
      value2 = JSON.parse(v[:value])
      if value2['criteria']
        top_criteria = value2['criteria'].values.first
        top_criteria.each do |crit|
          if crit.is_a?(Array)
            if crit.length > 2 && crit[0] == columnName
              modified = true
              top_criteria.delete crit
            end
          elsif crit.is_a?(Hash)
            nested_criteria = crit.values.first
            nested_criteria.each do |crit2|
              if crit2.length > 2 && crit2[0] == columnName
                modified = true
                nested_criteria.delete crit2
              end
            end
          end
        end
      end

      if modified
        new_json_value = value2.to_json
        new_hash = Digest::SHA1.hexdigest(new_json_value)

        run <<-SQL
                  merge into dbo.pagestates ps
                  using
                  (
                    select '#{new_hash.to_s}' as id, '#{new_json_value.to_s}' as value #{db2? ? "from sysibm.sysdummy1" : ""}
                  ) as tmp on ps.id = tmp.id
                  when not matched then
                  insert (id,value) values (tmp.id, tmp.value)#{mssql? ? ";" : ""}
        SQL
        run "update dbo.reports set pagestate_id = '#{new_hash.to_s}' where pagestate_id = '#{id}'"
      end
    end
  end  
  
  def up

    dropDatabaseItem("table sam.definition_source_rollups")
    dropDatabaseItem("table sam.publisher_rollups")
    dropDatabaseItem("table sam.software_title_rollups")
    dropDatabaseItem("table sam.software_title_version_rollups")
    dropDatabaseItem("table sam.software_title_release_rollups")
    dropDatabaseItem("table sam.discoverable_rollups")
    dropDatabaseItem("trigger SAM.DISCOVERABLE_ROLLUPS_TRIGGER_UUID_GUID") if db2?
    dropDatabaseItem("table sam.software_component_rollups")
    dropDatabaseItem("table sam.computer_group_unmatched_files")

    run <<-SQL
      CREATE
      VIEW sam.software_bundling_options
      (
        id,
        component_name,
        component_guid,
        product_name,
        product_guid,
        product_version,
        product_metric_id,
        is_charged,
        is_custom
      )    
      as
        select 
           b.id,
        c.name as component_name,
        c.guid as component_guid,
        t.name as product_name,
        t.guid as product_guid,
        r.release as product_version,
        m.id as product_metric_id,
        b.is_charged,
        b.is_custom
        from 
        adm.branch b
        join sam.software_components c on c.id = b.component_id
        join sam.software_titles t on t.id = b.product_id
        join sam.software_title_releases r on r.id = b.release_id
        join sam.metrics m on m.id = b.metric_id
        where b.is_deleted = 0  
    SQL
    
    run <<-SQL
      CREATE
      VIEW sam.software_bundles
      (
        id,
        bundle_name,
        bundle_metric_id,
        bundle_guid,
        bundle_type,
        bundled_product_name,
        bundled_product_metric_id,
        bundled_product_guid,
        ratio
      )   
      as
      select
        fbd.id,
        b.name as bundle_name,
        bm.id as bundle_metric_id,
        stb.guid as bundle_guid,
        b.type as bundle_type,
        stbd.name as bundled_product_name,
        m.id as bundled_product_metric_id,
        stbd.guid as bundled_product_guid,
        case when fbd.factor = 0 or fbd.divider = 0 then null else cast(fbd.divider as varchar(10)) #{db2? ? "||" : "+"} ':' #{db2? ? "||" : "+"} cast(fbd.factor as varchar(10)) end as ratio
      from ibm.bundles b
      join sam.metrics bm on bm.id = b.metric_id
      join sam.software_titles stb on stb.id = b.product_id
      join ibm.flexpoint_bundles_details fbd on fbd.bundle_id = b.id
      join sam.metrics m on m.id = fbd.metric_id
      join sam.software_titles stbd on stbd.id = fbd.product_id
    SQL
    
    run <<-SQL
      CREATE
      VIEW sam.software_catalog_releases
      (
        id,
        name,
        guid,
        publisher,
        version,
        created_at,
        edited_at,
        is_catalog_provided
      )   
      as
      select 
        r.id as id,
        t.name as name,
        r.guid as guid,
        p.name as publisher,
        r.release as version,
        r.created_at,
        r.edited_at,
      case when r.definition_source_remote_id = 52315 or r.definition_source_remote_id = 52316 or r.definition_source_remote_id = 52318 or t.definition_source_remote_id = 52315 or t.definition_source_remote_id = 52316 or t.definition_source_remote_id = 52318 then 0 else 1 end as is_catalog_provided
      from sam.software_titles t
      join sam.software_title_versions v on v.software_title_id = t.id
      join sam.software_title_releases r on r.software_title_version_id = v.id
      join sam.publishers p on p.id = t.publisher_id
      where t.is_component = 0 and r.is_component = 0
    SQL
    
    dropDatabaseItem("view sam.software_catalog_products")
    
    run <<-SQL
      CREATE
      VIEW sam.software_catalog_products
      (
        id,
        name,
        guid,
        publisher_id,
        definition_source_id,
        definition_source_remote_id,
        part_numbers,
        part_numbers_matched,
        computer_group_id,
        metric_id,
        is_custom,
        is_catalog_provided,
        is_entitled,
        is_hybrid,        
        updated_at
      )
      AS
      SELECT
        st.id,
        st.name,
        st.guid,
        st.publisher_id,
        st.definition_source_id,
        st.definition_source_remote_id,
        pm.part_numbers,
        pnm.part_numbers,
        cg.id,
        pm.metric_id as license_type_numeric,
        case when pm.is_custom = 1 or st.definition_source_remote_id = 52315 then 1 else 0 end as is_custom,
        case when pm.is_custom = 1 or st.definition_source_remote_id = 52315 or st.definition_source_remote_id = 52316 or st.definition_source_remote_id = 52318  then 0 else 1 end as is_catalog_provided,
        case when pnm.is_entitled is null then 0 else pnm.is_entitled end as is_entitled,
        pm.is_hybrid,
        st.updated_at
      FROM
        sam.software_titles st
      CROSS JOIN dbo.computer_groups cg
      JOIN sam.products_metrics pm ON st.id = pm.product_id
      LEFT JOIN sam.part_numbers_matched pnm ON pm.product_id = pnm.product_id and pm.metric_id = pnm.metric_id AND cg.id = pnm.computer_group_id
      WHERE st.is_component = 0
    SQL
    
    run "delete from dbo.reports where path like '%/sam/catalog/publishers%'"
    run "delete from dbo.reports where path like '%/sam/catalog/software_title_versions%'"
    run "delete from dbo.reports where path like '%/sam/catalog/software_title_releases%'"
    run "delete from dbo.reports where path like '%/sam/catalog/software_titles%'"
    run "delete from dbo.reports where path like '%/sam/catalog/definition_sources%'"
    run "delete from dbo.reports where path like '%/sam/catalog/signatures%'"
    
    run "delete from dbo.pagestates where value not like '{%}'"    
    
    removeFilterFromReports(
       "select id, value from dbo.pagestates where cast(value as varchar(4000)) like '%criteria%definition_source.name%' and id in (select pagestate_id from dbo.reports where path like '%/sam/catalog/software_components%')",
       "definition_source.name"
    )
    
    removeFilterFromReports(
       "select id, value from dbo.pagestates where cast(value as varchar(4000)) like '%criteria%rollup.count_signatures%' and id in (select pagestate_id from dbo.reports where path like '%/sam/catalog/software_components%')",
       "rollup.count_signatures"
    )    
    
    removeFilterFromReports(
       "select id, value from dbo.pagestates where cast(value as varchar(4000)) like '%criteria%catalog_dimension.definition_source%' and id in (select pagestate_id from dbo.reports where path like '%/sam/extended_software_facts%' or path like '%/sam/computer_groups/%/extended_software_facts%')",
       "catalog_dimension.definition_source"
    )   
    
  end
end