#!/bin/ksh

# ---------------------------------------------------------------------------
# @copyright(disclaimer)
#
# Licensed Materials - Property of IBM
# 5724-B19 / 5697-H60
# Copyright IBM Corp. 1994, 2019 All Rights Reserved.
# US Government Users Restricted Rights - Use, duplication or disclosure 
# restricted by GSA ADP Schedule Contract with IBM Corp.
#
# @endCopyright
# ---------------------------------------------------------------------------
# ***************************************************************************
# *                                                                         *
# * Program name  : ICMRemoveRequire.sh                                     *
# *                                                                         *
# * Description   : Wrapper script for ICMRemoveRequire tool                *
# *                                                                         *
# ***************************************************************************

if [ -z "${IBMCMROOT}" ]; then
    echo ERROR: System environment IBMCMROOT is not set. Please ensure CM is installed properly and you have run the '. $IBMCMROOT/bin/cmbevn81.sh'.
    exit -1
fi

MYJAVA=${IBMCMROOT}/java/jre/bin/java

MYCLASSPATH=./ICMRemoveRequire.jar:${CLASSPATH}
if [ -e "./db2jcc_license_cisuz.jar" ]; then
    MYCLASSPATH=./db2jcc_license_cisuz.jar:./db2jcc_license_cu.jar:${MYCLASSPATH}
fi

if [ -e "./db2jcc4.jar" ]; then
    MYCLASSPATH=./db2jcc4.jar:${MYCLASSPATH}
fi

if [ -e "./db2jcc.jar" ]; then
    MYCLASSPATH=./db2jcc.jar:${MYCLASSPATH}
fi

${MYJAVA} -cp ${MYCLASSPATH} -Ddb2.jcc.charsetDecoderEncoder=3 com.ibm.content.cm.lstools.removerequire.ICMRemoveRequire $*
