/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.content.cm.lstools.removerequire;

import com.ibm.content.cm.lstools.common.LogHelper;
import com.ibm.content.cm.lstools.common.Params;
import java.io.IOException;

public class RemoveRequireParams
extends Params {
    public static final String TOOL_VERSION = "1.0.0";
    public static final String TOOL_IDENTIFIER = "ICMRemoveRequire";
    public static final String INIFILE_HEADER = "ICM Remove Attribute Required Flag Tool INI parameter file";
    private static final long serialVersionUID = "1.0.0".hashCode() ^ "ICMRemoveRequire".hashCode();
    private static transient RemoveRequireParams paramsInstance = null;
    public static final transient String PARAM_DBNAME = "d";
    public static final transient String PARAM_DBUSER = "u";
    public static final transient String PARAM_DBPASSWD = "p";
    public static final transient String PARAM_INIFILE = "inifile";
    public static final transient String PARAM_PREVIEW = "preview";
    public static final transient String PARAM_REORG = "reorg";
    public static final transient String PARAM_ISINATTRGROUP = "isinattrgroup";
    public static final transient String PARAM_ATTRGROUP = "attrgroup";
    public static final transient String PARAM_ATTRIBUTE = "attribute";
    public static final transient String PARAM_COMPTYPE = "comptype";
    public static final transient String PARAM_REMOVEUNIQUE = "removeunique";
    public static final transient String PARAM_HELP = "?";
    public boolean isDB2 = false;
    public boolean isORACLE = false;
    public String schema = null;

    public static RemoveRequireParams getInstance() {
        if (paramsInstance == null) {
            paramsInstance = new RemoveRequireParams();
        }
        return paramsInstance;
    }

    public RemoveRequireParams() {
        super(TOOL_IDENTIFIER, TOOL_VERSION);
        LogHelper.enableLogParam(this, false, true);
        String paramDesc = null;
        String[] defaultValues = null;
        try {
            String batch = System.getenv("ICM");
            boolean isbatch = batch != null && batch.trim().equalsIgnoreCase("BATCH");
            paramDesc = "Datastore name.#Enter the data store name";
            defaultValues = new String[]{"Datastore#ICMNLSDB"};
            super.addAcceptableParam(PARAM_DBNAME, paramDesc, true, true, 1, 0, defaultValues);
            paramDesc = "CM administrative database user.#Enter the IBM Content Manager administrative database user";
            defaultValues = new String[]{"DB User#ICMADMIN"};
            if (isbatch) {
                super.addAcceptableParam(PARAM_DBUSER, paramDesc, false, false, 1, 0, defaultValues);
            } else {
                super.addAcceptableParam(PARAM_DBUSER, paramDesc, true, true, 1, 0, defaultValues);
            }
            paramDesc = "Database password.#Enter the password for the user";
            defaultValues = new String[]{"DB password#"};
            if (isbatch) {
                super.addAcceptableParam(PARAM_DBPASSWD, paramDesc, false, false, 1, 0, defaultValues);
            } else {
                super.addAcceptableParam(PARAM_DBPASSWD, paramDesc, true, false, 1, 0, defaultValues);
            }
            paramDesc = "Preview mode. List the commands to remove required flag from the attribute. #Do you want to run preview mode? Y/N";
            defaultValues = null;
            super.addAcceptableParam(PARAM_PREVIEW, paramDesc, false, true, 0, 0, defaultValues);
            paramDesc = "Reorg mode. Request tool to do reorg. #Do you want to run the REORG command? Y/N";
            defaultValues = null;
            super.addAcceptableParam(PARAM_REORG, paramDesc, false, true, 0, 0, defaultValues);
            paramDesc = "The name of the component type the attribute to be removed required flag from.#Enter the component type name";
            defaultValues = new String[]{"Component type name#"};
            super.addAcceptableParam(PARAM_COMPTYPE, paramDesc, true, true, 1, 0, defaultValues);
            paramDesc = "The name of the attribute to be removed required flag.#Enter the attribute name";
            defaultValues = new String[]{"Attribute name#"};
            super.addAcceptableParam(PARAM_ATTRIBUTE, paramDesc, true, true, 1, 0, defaultValues);
            paramDesc = "This attribute is in an attribute group in the component type. Don't specify the argument if no need attribute group.#Is this attribute in an attribute group in the component type? Y/N";
            defaultValues = null;
            super.addAcceptableParam(PARAM_ISINATTRGROUP, paramDesc, false, true, 0, 0, null);
            paramDesc = "The attribute in this attribute group need to be removed required flag. Don't specify the argument if no need attribute group.#Enter the attribute group name";
            defaultValues = new String[]{"Attribute group name#"};
            super.addAcceptableParam(PARAM_ATTRGROUP, paramDesc, false, true, 0, 1, defaultValues);
            paramDesc = "Remove unique flag if this attribute also has unique flag. #Do you also want to remove unique flag if this attribute has unique flag? Y/N";
            defaultValues = null;
            super.addAcceptableParam(PARAM_REMOVEUNIQUE, paramDesc, false, true, 0, 0, defaultValues);
            paramDesc = "Get parameters from ini file.";
            defaultValues = new String[]{"ini file#" + this.getIniFileName()};
            super.addAcceptableParam(PARAM_INIFILE, paramDesc, false, false, 0, 1, defaultValues);
            paramDesc = "Get the help for this tool";
            defaultValues = null;
            super.addAcceptableParam(PARAM_HELP, paramDesc, false, false, 0, 0, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getHelp() {
        StringBuffer strBuff = new StringBuffer();
        strBuff.append("ICMRemoveRequire tool for IBM Content Manager V8. \n");
        strBuff.append("-------------------------------------------------------\n");
        strBuff.append("");
        strBuff.append("The tool is used for removing attribute required flag from a component type . ");
        strBuff.append('\n');
        strBuff.append("Command\n");
        strBuff.append('\n');
        strBuff.append("java ICMRemoveRequire -d <datastore> -u <db user> -p <db password>\n");
        strBuff.append("      -comptype <component type name>\n");
        strBuff.append("      -attribute <attribute name>\n");
        strBuff.append("      [-isinattrgroup <is this attribute in an attribute group?> ] \n");
        strBuff.append("      [-attrgroup <attribute group name> ] \n");
        strBuff.append("      [-removeunique <remove unique flag> ] \n");
        strBuff.append("      [-inifile [ini file]]\n");
        strBuff.append("      [-log <log level> [log file]]\n");
        strBuff.append("      [-preview ]\n");
        strBuff.append("      [-reorg <DB2 only>]\n");
        strBuff.append("      [-?]\n");
        strBuff.append('\n');
        strBuff.append("Parameters \n");
        strBuff.append('\n');
        String[] paramKeyArray = new String[]{PARAM_DBNAME, PARAM_DBUSER, PARAM_DBPASSWD, PARAM_COMPTYPE, PARAM_ATTRIBUTE, PARAM_ISINATTRGROUP, PARAM_ATTRGROUP, PARAM_REMOVEUNIQUE, PARAM_INIFILE, "log", PARAM_PREVIEW, PARAM_REORG, PARAM_HELP};
        strBuff.append(RemoveRequireParams.getInstance().generateParamHelp(paramKeyArray));
        return strBuff.toString();
    }

    public String getIniFileName() {
        String iniFileName = null;
        if (this.isParamKeyPresent(PARAM_INIFILE)) {
            iniFileName = this.getParamValue(PARAM_INIFILE, 1, false);
        }
        if (iniFileName == null || iniFileName.trim().length() == 0) {
            iniFileName = this.getIdentifier() + ".ini";
        }
        return iniFileName.trim();
    }

    @Override
    public void parseCmdLineArgs(String[] cmdArgs, boolean overwriteExistingValues) throws IllegalArgumentException {
        super.parseCmdLineArgs(cmdArgs, overwriteExistingValues);
        if (this.isParamKeyPresent(PARAM_HELP)) {
            return;
        }
        if (this.isParamKeyPresent(PARAM_INIFILE)) {
            Params.ParamEntry entry;
            try {
                this.loadParamsFromIniFile(this.getIniFileName(), true, false);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("The ini file is not accessible or is not compatible with the tool.");
            }
            if (this.getLastIniFileParseErrorCount() > 0) {
                System.out.println("WARNING: " + this.getLastIniFileParseErrorCount() + " entry(s) ignored and removed from the ini file due to parsing failure. Please review the details below.");
                System.out.println(this.getLastIniFileParseErrorMessages() + "\n");
            }
            if ((entry = this.getParamEntry(PARAM_DBPASSWD)) != null && !entry.requiredValueSatisfied()) {
                throw new IllegalArgumentException("Not enough value(s) from parameter '" + entry.paramKey() + "'");
            }
            super.validateRequiredParams(new String[]{PARAM_DBPASSWD});
        } else {
            super.validateRequiredParams();
        }
        if (this.isParamKeyPresent("log")) {
            this.validateParam("log");
        }
    }

    public void validateParam(String paramKey) throws IllegalArgumentException {
        String tmpStr;
        Params.ParamEntry entry = null;
        if (paramKey.equals("log") && (entry = super.getParamEntry(paramKey)) != null && !LogHelper.validateLogLevel(tmpStr = entry.getValue(1))) {
            throw new IllegalArgumentException("Invalid log level: \"" + tmpStr + "\". Log level should be use one of the following options: " + "ERROR" + ", " + "INFO" + ", " + "DEBUG" + ", " + "DDEBUG" + ", " + "DDDEBUG" + ".");
        }
    }
}

