/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.content.cm.lstools.removerequire;

import com.ibm.content.cm.lstools.common.ICMRebuildCompView;
import com.ibm.content.cm.lstools.common.LSConnection;
import com.ibm.content.cm.lstools.common.LogHelper;
import com.ibm.content.cm.lstools.common.Params;
import com.ibm.content.cm.lstools.removerequire.RemoveRequireParams;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ICMRemoveRequire {
    private static boolean noLogFileAtStartup = true;
    private static boolean runtool = true;
    protected static final String LANG_ENU = "ENU";
    public static boolean isInAttrGroup = false;
    public static String attrGroupName = "";
    public static boolean removeUnique = false;
    public static boolean doReorg = false;
    public static boolean isPreview = false;
    public static boolean isLSzOS = false;
    public static String OS = null;
    public static String dbName = null;
    public static String dbUser = null;
    public static String dbPassword = null;
    public static String dbSchema = null;
    public static String msg = null;
    static final int TYPE_ATTRIBUTE = 1;
    static final int TYPE_ATTRGROUP = 2;
    static final int TYPE_COMPTYPE = 3;
    static final int BIT_REQUIRED = 1;
    static final int BIT_UNIQUE = 2;
    static final int DB2_SQLCODE_ROW_NOTFOUND = 100;
    static final int DB2_SQLCODE_REORG_PENDING = -668;
    static final int DB2_SQLCODE_UNIQUE_NOTNULL = -542;
    static final int DB2_SQLCODE_UNDEFINED_NAME = -204;
    static final int ORACLE_SQLCODE_UNDEFINED_NAME = 903;
    private static String logName = "ICMRemoveRequire.log";
    private static RemoveRequireParams params;
    private static Connection conn;
    private static Logger logger;

    private static void cmdLineParamInput(String[] cmdLineArgs) throws SQLException, Exception {
        String batch = System.getenv("ICM");
        boolean isbatch = batch != null && batch.trim().equalsIgnoreCase("BATCH");
        params.parseCmdLineArgs(cmdLineArgs, true);
        String logFilename = params.getParamValue("log", 2, true);
        if (logFilename != null && !logFilename.equalsIgnoreCase(logName)) {
            File logFile = new File(logFilename);
            logName = logFilename;
            noLogFileAtStartup = !logFile.exists();
        }
        LogHelper.initLogger(params);
        logger = LogHelper.getLogger();
        if (params.isParamKeyPresent("?")) {
            return;
        }
        if (params.isParamKeyPresent("inifile")) {
            if (!params.isParamKeyPresent("p")) {
                params.promptInputForParam("p", null, true, false, false);
            }
            params.removeUserParam("inifile");
        }
        dbName = params.getParamValue("d", 1, false);
        if (isbatch) {
            String pwFile = "/tmp/_icmtk_parms";
            try {
                FileInputStream fis = new FileInputStream(pwFile);
                Properties prop = new Properties();
                prop.load(fis);
                dbPassword = prop.getProperty("LSPW").trim();
                dbUser = prop.getProperty("LSID").trim();
            }
            catch (FileNotFoundException ex) {
                ICMRemoveRequire.printMsg("z/OS batch:  Password file not found.  See ICMDRPAG JCL for information on setting up the password file.");
                logger.log(Level.SEVERE, "Password file not found when running on z/OS using batch JCL", ex);
                return;
            }
            catch (Exception ex) {
                ICMRemoveRequire.printMsg("Exception occured when trying to open the password file.");
                logger.log(Level.SEVERE, "Unexpected error occurred.", ex);
                throw ex;
            }
        } else {
            dbUser = params.getParamValue("u", 1, false);
            dbPassword = params.getParamValue("p", 1, false);
        }
        conn = LSConnection.createDBConnection(dbName, dbUser, dbPassword);
        ICMRemoveRequire.params.isDB2 = LSConnection.getDBType(dbName) == 1;
        ICMRemoveRequire.params.isORACLE = LSConnection.getDBType(dbName) == 2;
        ICMRemoveRequire.params.schema = LSConnection.getDBSchema(dbName);
        isLSzOS = LSConnection.getOSType(dbName) == 3;
        dbSchema = ICMRemoveRequire.params.schema;
    }

    private static void interactiveParamInput() throws Exception {
        if (Params.fileExits(params.getIniFileName())) {
            try {
                params.loadParamsFromIniFile(params.getIniFileName(), true, true);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "loadParamsFromIniFile failed.", e);
                throw e;
            }
        }
        ICMRemoveRequire.promptInputDBParams();
        String[] paramKeyArray = null;
        paramKeyArray = ICMRemoveRequire.params.isDB2 ? new String[]{"removeunique", "reorg", "preview"} : new String[]{"removeunique", "preview"};
        params.promptInputForParams(paramKeyArray, true, false, true);
        String logFilename = params.getParamValue("log", 2, true);
        if (logFilename != null && !logFilename.equalsIgnoreCase(logName)) {
            File logFile = new File(logFilename);
            noLogFileAtStartup = !logFile.exists();
        }
        ICMRemoveRequire.promptInputLogParams();
        LogHelper.initLogger(params);
    }

    public static void main(String[] args) {
        try {
            LogHelper.initLogger(params.getParamDefaultValue("log", 2), "ERROR");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        LSConnection.setLogLevel(Level.FINER, Level.SEVERE);
        try {
            if (args == null || args.length == 0) {
                ICMRemoveRequire.interactiveParamInput();
            } else {
                ICMRemoveRequire.cmdLineParamInput(args);
            }
        }
        catch (IllegalArgumentException illegalArg) {
            ICMRemoveRequire.printMsg("Invalid command line parameter(s): " + illegalArg.getMessage());
            ICMRemoveRequire.printMsg("Please check the usage with -? parameter and correct your input.");
            logger.log(Level.SEVERE, "Invalid command line parameter(s) inputed by user.", illegalArg);
            LogHelper.deInitLogger();
            return;
        }
        catch (Throwable e1) {
            ICMRemoveRequire.printMsg("Unexpected exception occurred. Please check the details in log file : " + LogHelper.getLogFile());
            ICMRemoveRequire.printMsg("Error stack : \n-------------");
            e1.printStackTrace();
            if (logger != null) {
                logger.log(Level.SEVERE, "Unexpected exception occurred.", e1);
                LogHelper.deInitLogger();
            }
            System.exit(-1);
        }
        if (params.isParamKeyPresent("?")) {
            ICMRemoveRequire.printMsg(params.getHelp());
            return;
        }
        ICMRemoveRequire.printMsg("Parameters");
        ICMRemoveRequire.printMsg(params.toString(true, 2));
        logger.log(Level.INFO, "Parameters : ", new String[]{"__LOGSTYLE_TEXT_BLOCK__", params.toString(true, 4)});
        logger.log(Level.INFO, "Rebuild cmdLine : ", new String[]{params.rebuildCmdLine(true)});
        try {
            params.saveParamsToIniFile(params.getIniFileName(), "ICM Remove Attribute Required Flag Tool INI parameter file");
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, "Error in saving parameters to ini file.", e);
            ICMRemoveRequire.printMsg("WARNING: Error in saving parameters to ini file.");
        }
        try {
            ICMRemoveRequire.removeCompAttrRequire();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Unexpected exception occurred.", e);
            ICMRemoveRequire.printMsg("Unexpected exception occurred during remove required flag from the attribute. Please check the details in the log file : " + LogHelper.getLogFile());
            ICMRemoveRequire.printMsg("Error stack : \n-------------");
            e.printStackTrace();
            LogHelper.deInitLogger();
            System.exit(-1);
        }
        try {
            params.saveParamsToIniFile(params.getIniFileName(), "ICM Remove Attribute Required Flag Tool INI parameter file");
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, "Error in saving parameters to ini file.", e);
            ICMRemoveRequire.printMsg("WARNING: Error in saving parameters to ini file.");
        }
        if (!params.isParamKeyPresent("preview")) {
            logger.log(Level.INFO, "\n!!Removed attribute required flag successfully. ");
            ICMRemoveRequire.printMsg("\n!!Removed attribute required flag successfully. ");
            if (isLSzOS) {
                logger.log(Level.INFO, "\n!!Please remember to run reorg!!");
                ICMRemoveRequire.printMsg("\n!!Please remember to run reorg!!");
            } else if (!ICMRemoveRequire.params.isORACLE && !params.isParamKeyPresent("reorg")) {
                logger.log(Level.INFO, "\n!!You chose not to have the tool to run reorg. Please remember to run reorg!!");
                ICMRemoveRequire.printMsg("\n!!You chose not to have the tool to run reorg. Please remember to run reorg!!");
            }
        }
        LogHelper.deInitLogger();
    }

    private static void removeCompAttrRequire() throws Exception {
        logger.entering("ICMRemoveRequire", "removeCompAttrRequire");
        dbUser = params.getParamValue("u", 1, false);
        String compTypeName = params.getParamValue("comptype", 1, false);
        String attributeName = params.getParamValue("attribute", 1, false);
        isInAttrGroup = params.isParamKeyPresent("isinattrgroup");
        attrGroupName = isInAttrGroup ? params.getParamValue("attrgroup", 1, false) : "";
        removeUnique = params.isParamKeyPresent("removeunique");
        doReorg = ICMRemoveRequire.params.isDB2 ? params.isParamKeyPresent("reorg") : false;
        isPreview = params.isParamKeyPresent("preview");
        logger.log(Level.FINE, "Params", new Object[]{"__LOGSTYLE_KEY_VALUE_PAIR__", "dbUser ", dbUser, "compTypeName ", compTypeName, "attributeName ", attributeName, "attrGroupName ", attrGroupName, "removeUnique ", removeUnique, "doReorg ", doReorg, "isPreview ", isPreview});
        try {
            if (!ICMRemoveRequire.params.isORACLE) {
                conn.setHoldability(2);
            }
            ICMRemoveRequire.removeAttrRequire(conn, attributeName, attrGroupName, compTypeName);
            ICMRemoveRequire.myCommit();
        }
        catch (Exception e1) {
            ICMRemoveRequire.printMsg("!!! Exception occured !!! Please fix the problem and rerun the tool.\n");
            ICMRemoveRequire.printMsg("--- Exception stack:\n" + LogHelper.exceptionToString(e1));
            logger.log(Level.SEVERE, "Unexpected error occurred.", e1);
            logger.info("Problem occured!");
            ICMRemoveRequire.myRollback();
            throw e1;
        }
        finally {
            if (conn != null && !conn.isClosed()) {
                try {
                    conn.close();
                }
                catch (Throwable e) {
                    ICMRemoveRequire.printMsg("Unexpected error occurred when trying to close the database connection. We will continue.");
                    logger.log(Level.SEVERE, "Unexpected error occurred when trying to close the database connection.", e);
                }
            }
        }
    }

    public static void printSQLErrorMsg(SQLException e) {
        String errMsg = "";
        if (e != null) {
            errMsg = "%%error code is " + e.getErrorCode() + "%%\n";
            errMsg = errMsg + "%%error message is " + e.getMessage() + "%%\n";
            ICMRemoveRequire.printMsg(errMsg);
        }
    }

    public static void printMsg(String msg) {
        StringBuffer strBuff = new StringBuffer();
        strBuff.append(msg);
        System.out.println(strBuff.toString());
    }

    public static void promptInputDBParams() throws Exception {
        dbName = null;
        while (true) {
            params.setUndoPoint();
            params.promptInputForParam("d", null, true, true, true);
            params.promptInputForParam("u", null, true, true, true);
            params.promptInputForParam("p", null, true, false, false);
            dbName = params.getParamValue("d", 1, false);
            dbUser = params.getParamValue("u", 1, false);
            dbPassword = params.getParamValue("p", 1, false);
            try {
                conn = LSConnection.createDBConnection(dbName, dbUser, dbPassword);
            }
            catch (IllegalArgumentException invalidArgExp) {
                ICMRemoveRequire.printMsg("Failed to retrieve datastore '" + dbName + "'. Please correct your input.");
                params.undoAllInput();
                continue;
            }
            catch (SQLException e) {
                ICMRemoveRequire.printMsg("Failed to connect to database. Please correct your input.");
                logger.log(Level.SEVERE, "Failed to connect to database.", e);
                params.undoAllInput();
                continue;
            }
            break;
        }
        params.promptInputForParam("comptype", null, true, false, false);
        params.promptInputForParam("isinattrgroup", null, true, false, true);
        isInAttrGroup = params.isParamKeyPresent("isinattrgroup");
        if (isInAttrGroup) {
            params.promptInputForParam("attrgroup", null, true, false, false);
        }
        params.promptInputForParam("attribute", null, true, false, false);
        params.commitInput();
        ICMRemoveRequire.params.isDB2 = LSConnection.getDBType(dbName) == 1;
        ICMRemoveRequire.params.isORACLE = LSConnection.getDBType(dbName) == 2;
        dbSchema = ICMRemoveRequire.params.schema = LSConnection.getDBSchema(dbName);
        isLSzOS = LSConnection.getOSType(dbName) == 3;
    }

    public static void promptInputLogParams() throws Exception {
        String inputValue = null;
        String defaultValue = null;
        String msg = null;
        String additionalMsg = "";
        String logFile = null;
        String logLevel = null;
        String paramKey = "log";
        defaultValue = params.getParamValue(paramKey, 1, true);
        if (defaultValue == null || defaultValue.trim().length() == 0) {
            defaultValue = "INFO";
        }
        msg = "Please enter your log level (INFO, DEBUG or ERROR) [" + defaultValue + "] : ";
        while (!params.isParamValueAcceptable(paramKey, 1, inputValue = (inputValue = Params.promptInput(additionalMsg + msg)) == null || inputValue.trim().length() == 0 ? defaultValue : inputValue.trim(), false)) {
            additionalMsg = "Your input '" + inputValue + "' for log level is invalid.\n";
        }
        logLevel = inputValue;
        defaultValue = params.getParamValue(paramKey, 2, true);
        if (defaultValue == null || defaultValue.trim().length() == 0) {
            defaultValue = params.getIdentifier() + ".log";
        }
        msg = "Please enter your log file [" + defaultValue + "] : ";
        inputValue = Params.promptInput(additionalMsg + msg);
        if (inputValue == null || inputValue.trim().length() == 0) {
            inputValue = defaultValue;
        }
        logFile = inputValue;
        RemoveRequireParams removeRequireParams = params;
        removeRequireParams.getClass();
        Params.ParamEntry entry = new Params.ParamEntry((Params)removeRequireParams, paramKey);
        entry.addValue(logLevel);
        entry.addValue(logFile);
        params.inputUserParam(entry);
    }

    public static int getID(String name, int type) throws SQLException, Exception {
        int attributeID = 0;
        String querySql = null;
        PreparedStatement queryStmt = null;
        ResultSet rs = null;
        String msg = null;
        int keywordcode = 0;
        String subMsg = null;
        if (name == null || "".equals(name.trim())) {
            throw new Exception("The name cannot be null.");
        }
        String upperName = name.toUpperCase();
        if (type == 1) {
            if (upperName.equals("ICM$NAME")) {
                throw new Exception("The tool does not remove required flag from the system attribute " + name + ".");
            }
        } else if (type == 3 && (upperName.equals("NOINDEX") || upperName.equals("ICMDRFOLDERS") || upperName.equals("ICMFORMS") || upperName.equals("ICMSAVEDSEARCH"))) {
            throw new Exception("The tool does not remove required flag from " + name + " which is a component of a pre-defined item type.");
        }
        querySql = "SELECT KEYWORDCODE FROM ICMSTNLSKEYWORDS WHERE KEYWORDCLASS = ? AND UPPER(KEYWORDNAME) = UPPER(?) AND LANGUAGECODE='ENU' ";
        if (ICMRemoveRequire.params.isDB2) {
            querySql = querySql + " FOR READ ONLY";
        }
        subMsg = type == 2 ? "attrGroupID" : (type == 3 ? "compTypeID" : "attributeID");
        msg = "***SQL to get " + subMsg + ": <" + querySql + ">\n";
        ICMRemoveRequire.printMsg(msg);
        logger.log(Level.FINE, msg);
        subMsg = type == 2 ? "attribute group" : (type == 3 ? "component type" : "attribute");
        try {
            queryStmt = conn.prepareStatement(querySql);
            if (type == 2) {
                queryStmt.setInt(1, 6);
            } else if (type == 3) {
                queryStmt.setInt(1, 5);
            } else {
                queryStmt.setInt(1, 1);
            }
            queryStmt.setString(2, name);
            rs = queryStmt.executeQuery();
            if (!rs.next()) {
                throw new Exception(name + " is not an " + subMsg + " defined in the library server.\nRerun the tool with the correct " + subMsg + " name.");
            }
            keywordcode = rs.getInt("KEYWORDCODE");
            msg = "***" + subMsg + " id: <" + keywordcode + ">\n";
            ICMRemoveRequire.printMsg(msg);
            logger.log(Level.INFO, msg);
            if (keywordcode < 1000) {
                throw new Exception("The tool does not remove required flag from the system " + subMsg + " " + name + ".");
            }
            attributeID = keywordcode;
        }
        catch (SQLException e) {
            ICMRemoveRequire.printSQLErrorMsg(e);
            throw e;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (queryStmt != null) {
                    queryStmt.close();
                    queryStmt = null;
                }
            }
            catch (Exception exception) {}
        }
        return attributeID;
    }

    public static int getAttrFlag(String attributeName, String compTypeName, int attributeID, int attrGroupID, int compTypeID) throws SQLException, Exception {
        int attrFlag;
        block17: {
            String querySql = null;
            PreparedStatement queryStmt = null;
            ResultSet rs = null;
            String msg = null;
            int sequenceNum = 0;
            attrFlag = 0;
            querySql = "SELECT SEQUENCENUM, ATTRFLAGS FROM ICMSTCOMPATTRS WHERE COMPONENTTYPEID = ? AND ATTRIBUTEGROUP = ? AND  ATTRIBUTEID = ?";
            msg = "***SQL to check componet type attribute: <" + querySql + ">\n";
            ICMRemoveRequire.printMsg(msg);
            logger.log(Level.FINE, msg);
            try {
                queryStmt = conn.prepareStatement(querySql);
                queryStmt.setInt(1, compTypeID);
                if (attrGroupID > 0) {
                    queryStmt.setInt(2, attrGroupID);
                } else {
                    queryStmt.setInt(2, 0);
                }
                queryStmt.setInt(3, attributeID);
                rs = queryStmt.executeQuery();
                if (rs.next()) {
                    ICMRemoveRequire.printMsg(attributeName + " is defined in the component type " + compTypeName + ".");
                    sequenceNum = rs.getInt(1);
                    attrFlag = rs.getInt(2);
                    if (sequenceNum < 0) {
                        throw new Exception("The tool does not remove required flag from the attribute " + attributeName + " which is pre-defined in the componet type " + compTypeName + ".\n");
                    }
                    if ((attrFlag & 2) == 0 && !removeUnique) {
                        throw new Exception("Cannot remove the required flag from the attribute " + attributeName + "from " + compTypeName + " when the attribute is still unique. Please specify -removeunique argument in command line mode or input Y when prompt to remove unique flag in interactive mode to also remove uniqueness\n");
                    }
                    if ((attrFlag & 1) > 0) {
                        throw new Exception("The tool does not remove required flag from the attribute " + attributeName + " which is not required in the componet type " + compTypeName + ".\n");
                    }
                    break block17;
                }
                throw new Exception(attributeName + " is not an attribute defined in the componet type " + compTypeName + ".\nRerun the tool with the correct imput parameters.");
            }
            catch (SQLException e) {
                ICMRemoveRequire.printSQLErrorMsg(e);
                throw e;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (queryStmt != null) {
                        queryStmt.close();
                        queryStmt = null;
                    }
                }
                catch (Exception exception) {}
            }
        }
        return attrFlag;
    }

    public static void checkAutoLinks(int attributeID, int attrGroupID, int compTypeID) throws SQLException, Exception {
        String querySql = null;
        PreparedStatement queryStmt = null;
        ResultSet rs = null;
        String msg = null;
        int cnt = 0;
        querySql = "SELECT COUNT(*) AS ROWCOUNT FROM ICMSTITEMAUTOLINK WHERE ATTRIBUTEGROUP = ? AND ATTRIBUTEID = ? AND TARGETCOMPTYPEID = ?";
        if (ICMRemoveRequire.params.isDB2) {
            querySql = querySql + " FOR READ ONLY";
        }
        msg = "***SQL to check autolinking rule: <" + querySql + ">\n";
        ICMRemoveRequire.printMsg(msg);
        logger.log(Level.FINE, msg);
        try {
            queryStmt = conn.prepareStatement(querySql);
            if (attrGroupID > 0) {
                queryStmt.setInt(1, attrGroupID);
            } else {
                queryStmt.setInt(1, 0);
            }
            queryStmt.setInt(2, attributeID);
            queryStmt.setInt(3, compTypeID);
            rs = queryStmt.executeQuery();
            rs.next();
            cnt = rs.getInt("ROWCOUNT");
            ICMRemoveRequire.printMsg("ROWCOUNT = " + cnt);
            if (cnt > 0) {
                if (!isPreview) {
                    throw new Exception("!!!Can not remove the required flag from the attribute used in autolinking rule!!!");
                }
                ICMRemoveRequire.printMsg("!!!The attribute is used in autolinking rule!!!\n!!!Please remove this autolinking rule before removing the required flag from the attribute!!!");
            }
        }
        catch (SQLException e) {
            ICMRemoveRequire.printSQLErrorMsg(e);
            throw e;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (queryStmt != null) {
                    queryStmt.close();
                    queryStmt = null;
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void checkForeighKey(int attributeID, int attrGroupID, int compTypeID) throws SQLException, Exception {
        String querySql = null;
        PreparedStatement queryStmt = null;
        ResultSet rs = null;
        String msg = null;
        int cnt = 0;
        querySql = "SELECT COUNT(*) AS ROWCOUNT FROM ICMSTCOMPATTRSFK WHERE TARGETCOMPTYPEID = ? AND TARGETATTRGROUPID = ? AND TARGETATTRIBUTEID = ?";
        if (ICMRemoveRequire.params.isDB2) {
            querySql = querySql + " FOR READ ONLY";
        }
        msg = "***SQL to check foreign key: <" + querySql + ">\n";
        ICMRemoveRequire.printMsg(msg);
        logger.log(Level.FINE, msg);
        try {
            queryStmt = conn.prepareStatement(querySql);
            queryStmt.setInt(1, compTypeID);
            if (attrGroupID > 0) {
                queryStmt.setInt(2, attrGroupID);
            } else {
                queryStmt.setInt(2, 0);
            }
            queryStmt.setInt(3, attributeID);
            rs = queryStmt.executeQuery();
            rs.next();
            cnt = rs.getInt("ROWCOUNT");
            ICMRemoveRequire.printMsg("ROWCOUNT = " + cnt);
            if (cnt > 0) {
                if (!isPreview) {
                    throw new Exception("!!!Can not remove the required flag from the attribute used in foreign key reference!!!");
                }
                ICMRemoveRequire.printMsg("!!!The attribute is used in foreign key reference!!!\n!!!Please remove this foreign key reference before removing the required flag from the attribute!!!");
            }
        }
        catch (SQLException e) {
            ICMRemoveRequire.printSQLErrorMsg(e);
            throw e;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (queryStmt != null) {
                    queryStmt.close();
                    queryStmt = null;
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void removeRequiredFlag(int attrGroupID, int attributeID, int compTypeID, int attrFlag) throws SQLException, Exception {
        logger.entering("ICMRemoveRequire", "removeRequiredFlag");
        String updateSql = null;
        PreparedStatement updateStmt = null;
        String msg = null;
        attrFlag |= 1;
        attrFlag |= 2;
        if (attrGroupID <= 0) {
            attrGroupID = 0;
        }
        updateSql = "UPDATE ICMSTCOMPATTRS SET ATTRFLAGS = " + attrFlag + " WHERE COMPONENTTYPEID = " + compTypeID + " AND ATTRIBUTEGROUP = " + attrGroupID + " AND ATTRIBUTEID = " + attributeID;
        msg = "***SQL to remove attribute required falg from componet type: <" + updateSql + ">\n";
        ICMRemoveRequire.printMsg(msg);
        logger.log(Level.FINE, msg);
        if (!isPreview) {
            try {
                ICMRemoveRequire.printMsg("!!!Removing attribute required flag from component type...\n");
                updateStmt = conn.prepareStatement(updateSql);
                updateStmt.executeUpdate();
            }
            catch (SQLException e) {
                ICMRemoveRequire.printSQLErrorMsg(e);
                throw e;
            }
            finally {
                try {
                    if (updateStmt != null) {
                        updateStmt.close();
                        updateStmt = null;
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void reorgTable(String tableName) throws SQLException, Exception {
        String executeReorg = null;
        Statement executeStmt = null;
        executeReorg = "Call ADMIN_CMD('REORG TABLE " + tableName + "')";
        msg = "***Command to reorg the table: <" + executeReorg + ">\n";
        ICMRemoveRequire.printMsg(msg);
        logger.log(Level.FINE, msg);
        if (!isPreview && doReorg) {
            ICMRemoveRequire.myCommit();
            try {
                ICMRemoveRequire.printMsg("!!!Performing REORG on the table...\n");
                executeStmt = conn.createStatement();
                executeStmt.execute(executeReorg);
            }
            catch (SQLException e) {
                ICMRemoveRequire.printSQLErrorMsg(e);
                throw e;
            }
            finally {
                try {
                    if (executeStmt != null) {
                        executeStmt.close();
                        executeStmt = null;
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void removeAttrRequire(Connection conn, String attributeName, String attrGroupName, String compTypeName) throws SQLException, Exception {
        logger.entering("ICMRemoveRequire", "removeAttrRequire");
        int compTypeID = 0;
        int attributeID = 0;
        int attrGroupID = 0;
        int attrFlag = -1;
        String tableName = null;
        OS = ICMRemoveRequire.getOsName();
        ICMRemoveRequire.printMsg("Running OS is " + OS);
        if (isLSzOS) {
            ICMRemoveRequire.printMsg("LS OS is z/OS");
        }
        conn.setAutoCommit(false);
        ICMRemoveRequire.printMsg("\n========================================================");
        ICMRemoveRequire.printMsg("Get attributeID                                           ");
        ICMRemoveRequire.printMsg("========================================================\n");
        attributeID = ICMRemoveRequire.getID(attributeName, 1);
        if (attrGroupName != null && !"".equals(attrGroupName.trim())) {
            ICMRemoveRequire.printMsg("\n========================================================");
            ICMRemoveRequire.printMsg("Get attribute group ID                                    ");
            ICMRemoveRequire.printMsg("========================================================\n");
            attrGroupID = ICMRemoveRequire.getID(attrGroupName, 2);
        }
        ICMRemoveRequire.printMsg("\n========================================================");
        ICMRemoveRequire.printMsg("Get compTypeID for the compTypeName.");
        ICMRemoveRequire.printMsg("========================================================\n");
        compTypeID = ICMRemoveRequire.getID(compTypeName, 3);
        ICMRemoveRequire.printMsg("\n========================================================");
        ICMRemoveRequire.printMsg(" Check if the attribute is defined and required in the component type.");
        ICMRemoveRequire.printMsg("========================================================\n");
        attrFlag = ICMRemoveRequire.getAttrFlag(attributeName, compTypeName, attributeID, attrGroupID, compTypeID);
        ICMRemoveRequire.printMsg("\n========================================================");
        ICMRemoveRequire.printMsg("Check autolinking rule.");
        ICMRemoveRequire.printMsg("========================================================\n");
        ICMRemoveRequire.checkAutoLinks(attributeID, attrGroupID, compTypeID);
        ICMRemoveRequire.printMsg("\n========================================================");
        ICMRemoveRequire.printMsg("Check foreign key.");
        ICMRemoveRequire.printMsg("========================================================\n");
        ICMRemoveRequire.checkForeighKey(attributeID, attrGroupID, compTypeID);
        tableName = ICMRemoveRequire.getUTTableName(compTypeID);
        ICMRemoveRequire.setColNullable(tableName, attrGroupID, attributeID);
        ICMRemoveRequire.printMsg("\n========================================================");
        ICMRemoveRequire.printMsg("Attribute flag in ICMSTCOMPATTRS need to be updated to nullable.");
        ICMRemoveRequire.printMsg("========================================================\n");
        ICMRemoveRequire.removeRequiredFlag(attrGroupID, attributeID, compTypeID, attrFlag);
        if (ICMRemoveRequire.params.isDB2 && !isLSzOS) {
            ICMRemoveRequire.printMsg("\n========================================================");
            ICMRemoveRequire.printMsg("Reorg table will be performed if requested. ");
            ICMRemoveRequire.printMsg("========================================================\n");
            ICMRemoveRequire.reorgTable(tableName);
        }
        ICMRemoveRequire.printMsg("\n========================================================");
        ICMRemoveRequire.printMsg("Rebuild component views.                           ");
        ICMRemoveRequire.printMsg("========================================================\n");
        ICMRemoveRequire.rebuildCompView(compTypeID);
    }

    public static void rebuildCompView(int compViewId) throws SQLException, Exception {
        logger.entering("ICMRemoveRequire", "rebuildCompView");
        if (!isPreview) {
            logger.log(Level.INFO, "\n===Rebuild component type view=== ");
            ICMRemoveRequire.myCommit();
            ICMRebuildCompView builder = new ICMRebuildCompView(dbName, dbUser, dbPassword, dbSchema);
            try {
                builder.build(compViewId);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage());
                throw new Exception("!!!Rebuild component type view falied. You can try to run \"<IBMCMROOT>/config/cmcfglsi -t comptypes\" to build them manually!!!");
            }
        }
    }

    public static void setColNullable(String tableName, int attrGroupID, int attributeID) throws SQLException, Exception {
        logger.entering("ICMRemoveRequire", "setColNullable");
        String columnName = null;
        String executeSql = null;
        Statement executeStmt = null;
        String msg = null;
        columnName = ICMRemoveRequire.getAttrColName(attrGroupID, attributeID);
        msg = "***tableName: <" + tableName + "> columnName: <" + columnName + ">\n";
        ICMRemoveRequire.printMsg(msg);
        logger.log(Level.INFO, msg);
        ICMRemoveRequire.printMsg("\n========================================================");
        ICMRemoveRequire.printMsg("The column will be set to nullable in the table.");
        ICMRemoveRequire.printMsg("========================================================\n");
        if (ICMRemoveRequire.params.isDB2) {
            executeSql = "ALTER TABLE " + tableName + " ALTER COLUMN " + columnName + " DROP NOT NULL";
        } else if (ICMRemoveRequire.params.isORACLE) {
            executeSql = "ALTER TABLE " + tableName + " MODIFY " + columnName + " NULL";
        }
        msg = "***SQL to alter the column to nullable: <" + executeSql + ">\n";
        ICMRemoveRequire.printMsg(msg);
        logger.log(Level.FINE, msg);
        if (!isPreview) {
            ICMRemoveRequire.printMsg("!!!Altering the column to nullable from the table...\n");
            executeStmt = conn.createStatement();
            try {
                executeStmt.execute(executeSql);
            }
            catch (SQLWarning sqlW) {
                msg = "SQLWarning Caught: " + sqlW.getMessage();
                ICMRemoveRequire.printMsg(msg);
                logger.log(Level.WARNING, msg);
            }
            catch (SQLException e) {
                int errCode = e.getErrorCode();
                msg = "%%error code is " + errCode + "%%";
                ICMRemoveRequire.printSQLErrorMsg(e);
                logger.log(Level.SEVERE, msg);
                if (ICMRemoveRequire.params.isDB2 && errCode == -542) {
                    throw new Exception("!!!Can not alter the column with unique constraint to nullable!!!");
                }
                throw e;
            }
            finally {
                try {
                    if (executeStmt != null) {
                        executeStmt.close();
                        executeStmt = null;
                    }
                }
                catch (Exception sqlW) {}
            }
        }
    }

    public static String getUTTableName(int compTypeID) {
        String compTypeTable = null;
        compTypeTable = "00000" + compTypeID;
        compTypeTable = "ICMUT" + compTypeTable.substring(compTypeTable.length() - 5, compTypeTable.length()) + "001";
        return compTypeTable;
    }

    public static String getAttrColName(int attrGroupID, int attributeID) {
        String attrCol = null;
        String attrCol2 = null;
        attrCol = "00000" + attrGroupID;
        attrCol = attrCol.substring(attrCol.length() - 5, attrCol.length());
        attrCol2 = "00000" + attributeID;
        attrCol2 = attrCol2.substring(attrCol2.length() - 5, attrCol2.length());
        attrCol = "ATTR" + attrCol + attrCol2;
        return attrCol;
    }

    public static String getOsName() {
        if (OS == null) {
            OS = System.getProperty("os.name");
        }
        return OS;
    }

    public static boolean iszOS(String OS) {
        return OS.startsWith("z/OS");
    }

    private static void myCommit() throws SQLException {
        if (!conn.getAutoCommit()) {
            try {
                System.out.println("performing commit");
                conn.commit();
            }
            catch (SQLException e) {
                System.out.println("Commit failed.");
                logger.log(Level.SEVERE, "Commit failed..", e);
            }
        }
    }

    private static void myRollback() throws SQLException {
        if (!conn.getAutoCommit()) {
            try {
                System.out.println("performing rollback");
                conn.rollback();
            }
            catch (SQLException e) {
                System.out.println("rollback failed.");
                logger.log(Level.SEVERE, "rollback failed.", e);
            }
        }
    }

    static {
        File logFile = new File(logName);
        if (logFile.exists()) {
            noLogFileAtStartup = false;
        }
        params = RemoveRequireParams.getInstance();
        logger = LogHelper.getLogger();
    }
}

