/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.content.cm.lstools.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class Params
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    protected static String INI_FILE_KEY_VALUE_SEP = "=";
    protected static String INI_FILE_COMMENT_TAG = "#";
    protected static final String SYS_PARAM_KEY_TAG = "@";
    protected static final String SYS_PARAM_KEY_VALUE_SEP = " ";
    public static final String SYS_PARAM_VERSION = "VERSION";
    public static final String SYS_PARAM_IDENTIFIER = "IDENTIFIER";
    protected static final String CMD_PARAM_KEY_TAG = "-";
    protected static final String SEP_CATALOG = "#";
    protected static final String SEP_ELEMENT = "|";
    protected static final String NEWLINE = System.getProperty("line.separator");
    private final HashMap userParams = new HashMap();
    private final HashMap sysParams = new HashMap();
    private final HashMap acceptableParams = new HashMap();
    private transient LinkedList undoEntryList = null;
    private transient boolean isInUndoMode = false;
    private transient ArrayList lastIniFileErrorMsg = new ArrayList();
    private transient int maxUserParamKeyStrLen = -1;

    private Params() {
        this.userParams.clear();
        this.sysParams.clear();
        this.acceptableParams.clear();
        this.undoEntryList = null;
    }

    public Params(String identitier, String version) {
        this.userParams.clear();
        this.sysParams.clear();
        this.acceptableParams.clear();
        this.undoEntryList = null;
        this.setSysParam(SYS_PARAM_IDENTIFIER, identitier);
        this.setSysParam(SYS_PARAM_VERSION, version);
    }

    public Params(Params theOther) {
        this();
        ParamEntry entry2 = null;
        String valueStr = null;
        String keyStr = null;
        Set paramSet = null;
        Map.Entry mapEntry = null;
        paramSet = theOther.sysParams.entrySet();
        Iterator itr = paramSet.iterator();
        while (itr.hasNext()) {
            entry2 = null;
            mapEntry = itr.next();
            keyStr = (String)mapEntry.getKey();
            valueStr = (String)mapEntry.getValue();
            this.sysParams.put(new String(keyStr), new String(valueStr));
        }
        paramSet = theOther.acceptableParams.entrySet();
        itr = paramSet.iterator();
        while (itr.hasNext()) {
            entry2 = null;
            mapEntry = itr.next();
            entry2 = (ParamEntry)mapEntry.getValue();
            this.acceptableParams.put(new String(entry2.paramKey()), entry2.clone());
        }
        paramSet = theOther.userParams.entrySet();
        itr = paramSet.iterator();
        while (itr.hasNext()) {
            entry2 = null;
            mapEntry = itr.next();
            entry2 = (ParamEntry)mapEntry.getValue();
            this.userParams.put(new String(entry2.paramKey()), entry2.clone());
        }
        this.isInUndoMode = theOther.isInUndoMode;
        this.undoEntryList = null;
        if (theOther.isInUndoMode && theOther.undoEntryList != null && !theOther.undoEntryList.isEmpty()) {
            for (ParamEntry entry2 : theOther.undoEntryList) {
                this.undoEntryList.add(entry2.clone());
            }
        }
    }

    public Params clone() {
        Params params = null;
        try {
            params = (Params)Params.deepClone(this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (SecurityException securityException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (params != null) {
            ParamEntry entry2 = null;
            String valueStr = null;
            String keyStr = null;
            Set paramSet = null;
            Map.Entry mapEntry = null;
            paramSet = this.sysParams.entrySet();
            Iterator itr = paramSet.iterator();
            while (itr.hasNext()) {
                entry2 = null;
                mapEntry = itr.next();
                keyStr = (String)mapEntry.getKey();
                valueStr = (String)mapEntry.getValue();
                params.sysParams.put(new String(keyStr), new String(valueStr));
            }
            paramSet = this.acceptableParams.entrySet();
            itr = paramSet.iterator();
            while (itr.hasNext()) {
                entry2 = null;
                mapEntry = itr.next();
                entry2 = (ParamEntry)mapEntry.getValue();
                params.acceptableParams.put(new String(entry2.paramKey()), entry2.clone());
            }
            paramSet = this.userParams.entrySet();
            itr = paramSet.iterator();
            while (itr.hasNext()) {
                entry2 = null;
                mapEntry = itr.next();
                entry2 = (ParamEntry)mapEntry.getValue();
                params.userParams.put(new String(entry2.paramKey()), entry2.clone());
            }
            params.isInUndoMode = this.isInUndoMode;
            params.undoEntryList = null;
            if (this.isInUndoMode && this.undoEntryList != null && !this.undoEntryList.isEmpty()) {
                for (ParamEntry entry2 : this.undoEntryList) {
                    params.undoEntryList.add(entry2.clone());
                }
            }
        }
        return params;
    }

    public String[] listUserParamKeys() {
        String keyStr = null;
        Set paramSet = null;
        String[] keyList = new String[this.userParams.size()];
        paramSet = this.userParams.keySet();
        int i = 0;
        Iterator itr = paramSet.iterator();
        while (itr.hasNext()) {
            keyList[i] = keyStr = (String)itr.next();
            ++i;
        }
        return keyList;
    }

    public String getIdentifier() {
        return this.getSysParam(SYS_PARAM_IDENTIFIER);
    }

    public String getVersion() {
        return this.getSysParam(SYS_PARAM_VERSION);
    }

    public void clearAcceptableParamList() {
        this.acceptableParams.clear();
    }

    public boolean isParamKeyAcceptable(String paramKey) {
        if (paramKey == null || paramKey.trim().length() == 0) {
            return false;
        }
        return this.acceptableParams.containsKey(paramKey);
    }

    public void addAcceptableParam(String paramKey, String paramDesc, boolean isRequired, boolean isSavable, int requiredValueNum, int maxOptionalValueNum, String[] defaultValues) {
        if (paramKey == null || paramKey.trim().length() == 0) {
            throw new IllegalArgumentException("Empty parameter key is not acceptable.");
        }
        ParamEntry entry = new ParamEntry("__KEY_FOR_BUILDING_ACCEPTABLE_PARAM__");
        entry._paramKey = paramKey.trim();
        if (entry._paramKey.startsWith(CMD_PARAM_KEY_TAG)) {
            entry._paramKey = entry._paramKey.substring(CMD_PARAM_KEY_TAG.length());
        }
        if (entry._paramKey.length() == 0) {
            throw new IllegalArgumentException("Invalid parameter key '" + paramKey + "'.");
        }
        entry._isRequired = isRequired;
        entry._isSavable = isSavable;
        entry._requiredValueNum = requiredValueNum;
        entry._maxOptionalValueNum = maxOptionalValueNum;
        entry._paramDesc = paramDesc;
        entry._actualValueNum = 0;
        ParamEntry.access$702(entry, new String[entry._requiredValueNum + entry._maxOptionalValueNum + 1]);
        ((ParamEntry)entry).valueArray[0] = entry._paramKey;
        if (defaultValues != null && defaultValues.length > 0) {
            if (defaultValues.length > entry.maxValueNum()) {
                throw new IllegalArgumentException("The number of default value(s) exceeds the maximum number of value(s) for paramter " + entry.paramKey() + ". The number of default vlaue(s): " + defaultValues.length + ", the maximum number for the parameter: " + entry.maxValueNum());
            }
            for (int i = 0; i < defaultValues.length; ++i) {
                ((ParamEntry)entry).valueArray[i + 1] = defaultValues[i];
            }
            entry._actualValueNum = defaultValues.length;
        }
        this.acceptableParams.put(entry.paramKey(), entry);
        if (entry.paramKey().length() > this.maxUserParamKeyStrLen) {
            this.maxUserParamKeyStrLen = entry.paramKey().length();
        }
    }

    public String getParamDefaultValue(String paramKey, int valueIndex) throws IllegalArgumentException {
        ParamEntry entry = (ParamEntry)this.acceptableParams.get(paramKey);
        if (entry == null) {
            throw new IllegalArgumentException("Unrecognized parameter " + paramKey + ".");
        }
        String value = entry.getValue(valueIndex);
        if (value == null) {
            return null;
        }
        int tagPos = value.indexOf(SEP_CATALOG);
        if (tagPos > 0 && tagPos < value.length() - 1) {
            value = value.substring(tagPos + SEP_CATALOG.length());
        } else if (tagPos == value.length() - 1) {
            value = null;
        }
        if (value != null && value.length() > 0 && (tagPos = value.indexOf(SEP_ELEMENT)) > 0 && tagPos < value.length() - 1) {
            value = value.substring(0, tagPos);
        }
        return value;
    }

    public int getParamDefaultValueInInt(String paramKey, int valueIndex) throws IllegalArgumentException, NumberFormatException {
        String valueStr = this.getParamDefaultValue(paramKey, valueIndex);
        if (valueStr == null) {
            throw new IllegalArgumentException("Parameter " + paramKey + " default value " + valueIndex + " is not provided.");
        }
        if (!Params.validateNumericValue(valueStr, true, Integer.MIN_VALUE, Integer.MAX_VALUE)) {
            throw new NumberFormatException("Parameter " + paramKey + " default value " + valueIndex + " (" + valueStr + ") is not a valid integer.");
        }
        return Integer.parseInt(valueStr);
    }

    public double getParamDefaultValueInDouble(String paramKey, int valueIndex) throws IllegalArgumentException, NumberFormatException {
        String valueStr = this.getParamDefaultValue(paramKey, valueIndex);
        if (valueStr == null) {
            throw new IllegalArgumentException("Parameter " + paramKey + " default value " + valueIndex + " is not provided.");
        }
        if (!Params.validateNumericValue(paramKey, false, Integer.MIN_VALUE, Integer.MAX_VALUE)) {
            throw new NumberFormatException("Parameter " + paramKey + " default value " + valueIndex + " (" + valueStr + ") is not a valid double.");
        }
        return Double.parseDouble(valueStr);
    }

    public String[] getAcceptableValueList(String paramKey, int valueIndex) throws IllegalArgumentException {
        ParamEntry entry = (ParamEntry)this.acceptableParams.get(paramKey);
        String[] valueList = null;
        if (entry == null) {
            throw new IllegalArgumentException("Unrecognized parameter " + paramKey + ".");
        }
        if (entry.isBoolParam()) {
            valueList = new String[]{"N", "NO", "Y", "YES"};
        } else {
            String value = entry.getValue(valueIndex);
            if (value == null) {
                return null;
            }
            int tagPos = value.indexOf(SEP_CATALOG);
            if (tagPos > 0 && tagPos < value.length() - 1) {
                value = value.substring(tagPos + SEP_CATALOG.length());
            } else if (tagPos == value.length() - 1) {
                value = null;
            }
            tagPos = 0;
            if (value != null && value.trim().length() > 0 && (tagPos = (value = value.trim()).indexOf(SEP_ELEMENT)) >= 0) {
                ArrayList<String> arr = new ArrayList<String>();
                String curElement = null;
                arr.clear();
                StringTokenizer tokenizer = new StringTokenizer(value, SEP_ELEMENT);
                while (tokenizer.hasMoreTokens()) {
                    curElement = tokenizer.nextToken().trim();
                    if (curElement.length() <= 0) continue;
                    arr.add(curElement);
                }
                if (arr.size() > 1) {
                    valueList = new String[arr.size()];
                    arr.toArray(valueList);
                }
            }
        }
        return valueList;
    }

    public boolean isParamValueAcceptable(String paramKey, int valueIndex, String value, boolean caseSensitive) throws IllegalArgumentException {
        String[] acceptableValueList = this.getAcceptableValueList(paramKey, valueIndex);
        if (acceptableValueList == null || acceptableValueList.length == 0) {
            return true;
        }
        for (int i = 0; i < acceptableValueList.length; ++i) {
            if (!(caseSensitive ? acceptableValueList[i].equals(value) : acceptableValueList[i].equalsIgnoreCase(value))) continue;
            return true;
        }
        return false;
    }

    public static boolean validateNumericValue(String value, boolean intOnly, int minValue, int maxValue) {
        if (value == null || value.trim().length() == 0) {
            return false;
        }
        int intValue = 0;
        double doubleValue = 0.0;
        boolean result = true;
        double eps = 1.0E-12;
        if (intOnly && (value.indexOf(46) >= 0 || value.indexOf(44) >= 0)) {
            result = false;
            return result;
        }
        try {
            if (intOnly) {
                intValue = Integer.parseInt(value);
                doubleValue = intValue;
            } else {
                doubleValue = Double.parseDouble(value);
            }
        }
        catch (NumberFormatException nfe1) {
            result = false;
        }
        if (result) {
            result = doubleValue > (double)minValue - eps && doubleValue < (double)maxValue + eps;
        }
        return result;
    }

    public String getParamValueName(String paramKey, int valueIndex) throws IllegalArgumentException {
        ParamEntry entry = (ParamEntry)this.acceptableParams.get(paramKey);
        if (entry == null) {
            throw new IllegalArgumentException("Unrecognized parameter " + paramKey + ".");
        }
        String valueName = "value" + valueIndex;
        String value = entry.getValue(valueIndex);
        if (value == null) {
            return valueName;
        }
        int tagPos = value.indexOf(SEP_CATALOG);
        if (tagPos > 0) {
            valueName = value.substring(0, tagPos);
        }
        return valueName;
    }

    public String getParamDesc(String paramKey, boolean getPromptMessage) throws IllegalArgumentException {
        ParamEntry entry = (ParamEntry)this.acceptableParams.get(paramKey);
        if (entry == null) {
            throw new IllegalArgumentException("Unrecognized parameter " + paramKey + ".");
        }
        String promptMsg = "";
        String desc = entry._paramDesc;
        if (desc == null || desc.length() == 0) {
            return "";
        }
        int tagPos = desc.indexOf(SEP_CATALOG);
        if (tagPos >= 0) {
            promptMsg = desc.substring(tagPos + SEP_CATALOG.length());
            desc = desc.substring(0, tagPos);
        }
        return getPromptMessage ? promptMsg : desc;
    }

    public int getParamRequiredValueNum(String paramKey) throws IllegalArgumentException {
        ParamEntry entry = (ParamEntry)this.acceptableParams.get(paramKey);
        if (entry == null) {
            throw new IllegalArgumentException("Unrecognized parameter " + paramKey + ".");
        }
        return entry.requiredValueNum();
    }

    public int getParamMaxOptionValueNum(String paramKey) throws IllegalArgumentException {
        ParamEntry entry = (ParamEntry)this.acceptableParams.get(paramKey);
        if (entry == null) {
            throw new IllegalArgumentException("Unrecognized parameter " + paramKey + ".");
        }
        return entry.maxOptionalValueNum();
    }

    public int getParamMaxValueNum(String paramKey) {
        ParamEntry entry = (ParamEntry)this.acceptableParams.get(paramKey);
        if (entry == null) {
            throw new IllegalArgumentException("Unrecognized parameter " + paramKey + ".");
        }
        return entry.maxValueNum();
    }

    public boolean isParamValueRequired(String paramKey, int valueIndex) throws IllegalArgumentException {
        ParamEntry entry = (ParamEntry)this.acceptableParams.get(paramKey);
        if (entry == null) {
            throw new IllegalArgumentException("Unrecognized parameter " + paramKey + ".");
        }
        return entry.isValueRequired(valueIndex);
    }

    public boolean isBoolParam(String paramKey) throws IllegalArgumentException {
        ParamEntry entry = (ParamEntry)this.acceptableParams.get(paramKey);
        if (entry == null) {
            throw new IllegalArgumentException("Unrecognized parameter " + paramKey + ".");
        }
        return entry.isBoolParam();
    }

    public String getParamDefaultValuesString(String paramKey, String markForNonProvidedValue) throws IllegalArgumentException {
        ParamEntry entry;
        if (markForNonProvidedValue == null || markForNonProvidedValue.length() == 0) {
            markForNonProvidedValue = "?";
        }
        if ((entry = (ParamEntry)this.acceptableParams.get(paramKey)) == null) {
            throw new IllegalArgumentException("Unrecognized parameter " + paramKey + ".");
        }
        boolean hasDefaultValue = false;
        StringBuffer strBuff = new StringBuffer();
        String dftValue = null;
        if (entry.isBoolParam() && !entry.isRequired()) {
            strBuff.append("N");
        } else {
            for (int i = 1; i <= entry.maxValueNum(); ++i) {
                dftValue = entry.getDefaultValue(i);
                if (dftValue != null && dftValue.length() > 0) {
                    hasDefaultValue = true;
                    strBuff.append(dftValue).append(SYS_PARAM_KEY_VALUE_SEP);
                    continue;
                }
                if (entry.isValueRequired(i)) {
                    strBuff.append("<").append(markForNonProvidedValue).append(">");
                } else {
                    strBuff.append("[").append(markForNonProvidedValue).append("]");
                }
                strBuff.append(SYS_PARAM_KEY_VALUE_SEP);
            }
            if (strBuff.length() > 0 && strBuff.charAt(strBuff.length() - 1) == ' ') {
                strBuff.deleteCharAt(strBuff.length() - 1);
            }
        }
        if (hasDefaultValue && strBuff.length() > 0) {
            return strBuff.toString().trim();
        }
        return null;
    }

    public String getParamDesc(String paramKey) throws IllegalArgumentException {
        return this.getParamDesc(paramKey, false);
    }

    public String getHelpForParam(String paramKey) throws IllegalArgumentException {
        int i;
        StringBuffer strBuff = new StringBuffer();
        ParamEntry entry = (ParamEntry)this.acceptableParams.get(paramKey);
        if (entry == null) {
            throw new IllegalArgumentException("Unrecognized parameter " + paramKey + ".");
        }
        strBuff.append(SYS_PARAM_KEY_VALUE_SEP).append(CMD_PARAM_KEY_TAG).append(entry.paramKey()).append(SYS_PARAM_KEY_VALUE_SEP);
        for (i = 1; i <= entry.requiredValueNum(); ++i) {
            strBuff.append("<").append(entry.getValueName(i)).append("> ");
        }
        if (entry.maxOptionalValueNum() > 0) {
            for (i = 1 + entry.requiredValueNum(); i <= entry.requiredValueNum() + entry.maxOptionalValueNum(); ++i) {
                strBuff.append("[").append(entry.getValueName(i)).append("] ");
            }
        }
        strBuff.deleteCharAt(strBuff.length() - 1);
        strBuff.append(NEWLINE);
        strBuff.append("  ").append(entry.isRequired() ? "Required" : "Optional").append(" paramter.").append(NEWLINE);
        strBuff.append("  ").append(entry.paramDesc()).append(NEWLINE);
        if (entry.maxValueNum() > 0) {
            StringBuffer defaultValueBuff = new StringBuffer();
            for (int i2 = 1; i2 <= entry.maxValueNum(); ++i2) {
                String dftValue = this.getParamDefaultValue(paramKey, i2);
                if (dftValue == null) continue;
                defaultValueBuff.append("    ");
                if (entry.isValueRequired(i2)) {
                    defaultValueBuff.append("<").append(entry.getValueName(i2)).append(">");
                } else {
                    defaultValueBuff.append("[").append(entry.getValueName(i2)).append("]");
                }
                defaultValueBuff.append(" : ").append(dftValue).append(NEWLINE);
            }
            if (defaultValueBuff.length() > 0) {
                strBuff.append("  Default value(s)").append(NEWLINE);
                strBuff.append(defaultValueBuff);
            }
        }
        return strBuff.toString();
    }

    public boolean isParamAcceptable(String paramKey) {
        if (paramKey == null || paramKey.length() == 0) {
            return false;
        }
        return this.acceptableParams.containsKey(paramKey);
    }

    public ParamEntry getParamEntry(String paramKey) throws IllegalArgumentException {
        if ((paramKey = paramKey.trim()).startsWith(CMD_PARAM_KEY_TAG)) {
            paramKey = paramKey.substring(CMD_PARAM_KEY_TAG.length());
        }
        if (!this.isParamKeyAcceptable(paramKey)) {
            throw new IllegalArgumentException("Unrecognized parameter " + paramKey + ".");
        }
        return (ParamEntry)this.userParams.get(paramKey);
    }

    public boolean isParamKeyPresent(String paramKey) {
        if ((paramKey = paramKey.trim()).startsWith(CMD_PARAM_KEY_TAG)) {
            paramKey = paramKey.substring(CMD_PARAM_KEY_TAG.length());
        }
        return this.userParams.containsKey(paramKey);
    }

    public String getParamValue(String paramKey, int valueIndex, boolean defaultAsAlternative) throws IllegalArgumentException {
        ParamEntry entry = this.getParamEntry(paramKey);
        if (entry == null) {
            if (defaultAsAlternative) {
                return this.getParamDefaultValue(paramKey, valueIndex);
            }
            return null;
        }
        return entry.getValue(valueIndex);
    }

    public int getParamIntValue(String paramKey, int valueIndex, boolean defaultAsAlternative) throws IllegalArgumentException, NumberFormatException {
        ParamEntry entry = this.getParamEntry(paramKey);
        if (entry == null) {
            if (defaultAsAlternative) {
                return this.getParamDefaultValueInInt(paramKey, valueIndex);
            }
            throw new IllegalArgumentException("Parameter '" + paramKey + "' is not present.");
        }
        return entry.getIntValue(valueIndex);
    }

    public double getParamDoubleValue(String paramKey, int valueIndex, boolean defaultAsAlternative) {
        ParamEntry entry = this.getParamEntry(paramKey);
        if (entry == null) {
            if (defaultAsAlternative) {
                return this.getParamDefaultValueInDouble(paramKey, valueIndex);
            }
            throw new IllegalArgumentException("Parameter '" + paramKey + "' is not provided.");
        }
        return entry.getDoubleValue(valueIndex);
    }

    public void clearUserParamData() {
        this.userParams.clear();
    }

    protected void clearSystemParamData() {
        this.userParams.clear();
    }

    public void setSysParam(String sysParamKey, String value) {
        this.sysParams.put(sysParamKey, value);
    }

    public String getSysParam(String sysParamKey) {
        Object value = this.sysParams.get(sysParamKey);
        if (value != null) {
            return (String)value;
        }
        return null;
    }

    public void parseCmdLineArgs(String[] cmdArgs, boolean overwriteExistingValues) throws IllegalArgumentException {
        ParamEntry entry = null;
        String curArg = null;
        this.setUndoPoint();
        try {
            for (int i = 0; i < cmdArgs.length; ++i) {
                curArg = cmdArgs[i];
                if (curArg.length() >= 2 && curArg.startsWith(CMD_PARAM_KEY_TAG) && (curArg.charAt(1) < '0' || curArg.charAt(1) > '9')) {
                    if (entry != null && (overwriteExistingValues || !this.isParamKeyPresent(entry.paramKey()))) {
                        this.inputUserParam(entry);
                    }
                    entry = new ParamEntry(curArg);
                    continue;
                }
                if (entry == null) {
                    throw new IllegalArgumentException("Invalid parameter value '" + curArg + "'. It doesn't belong to any key.");
                }
                entry.addValue(curArg);
            }
            if (entry != null && (overwriteExistingValues || !this.isParamKeyPresent(entry.paramKey()))) {
                this.inputUserParam(entry);
            }
        }
        catch (IllegalArgumentException e) {
            this.undoAllInput();
            throw e;
        }
        catch (RuntimeException e) {
            this.undoAllInput();
            throw e;
        }
        this.commitInput();
    }

    /*
     * Exception decompiling
     */
    public void loadParamsFromIniFile(String iniFileName, boolean ignoreParsingError, boolean overwriteExistingValues) throws IllegalArgumentException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int getLastIniFileParseErrorCount() {
        return this.lastIniFileErrorMsg.size();
    }

    public String getLastIniFileParseErrorMessages() {
        int errCount = this.getLastIniFileParseErrorCount();
        if (errCount == 0) {
            return "";
        }
        StringBuffer strBuff = new StringBuffer();
        for (int i = 0; i < errCount; ++i) {
            if (errCount > 1) {
                strBuff.append(i + 1).append(". ");
            }
            strBuff.append(this.lastIniFileErrorMsg.get(i)).append(NEWLINE);
        }
        strBuff.deleteCharAt(strBuff.length() - 1);
        return strBuff.toString();
    }

    public String toString(boolean hideNonSavableValues, int indent) {
        StringBuffer strBuff = new StringBuffer();
        ParamEntry entry = null;
        Set paramSet = this.userParams.entrySet();
        for (Map.Entry mapEntry : paramSet) {
            entry = (ParamEntry)mapEntry.getValue();
            strBuff.append(entry.toString(hideNonSavableValues, indent, true)).append(NEWLINE);
        }
        return strBuff.toString();
    }

    public String getIniFormatString(boolean includeNonSavableParams, boolean hideNonSavableValues, boolean includeParamDesc) {
        StringBuffer strBuff = new StringBuffer();
        ParamEntry entry = null;
        Set paramSet = this.userParams.entrySet();
        String paramDesc = "";
        for (Map.Entry mapEntry : paramSet) {
            entry = (ParamEntry)mapEntry.getValue();
            if (!includeNonSavableParams && !entry.isSavable()) {
                entry = null;
                continue;
            }
            if (includeParamDesc) {
                paramDesc = entry.paramDesc();
            }
            if (paramDesc.length() > 0) {
                strBuff.append(INI_FILE_COMMENT_TAG).append(SYS_PARAM_KEY_VALUE_SEP).append(paramDesc).append(NEWLINE);
            }
            strBuff.append(entry.toString(hideNonSavableValues, 0, false)).append(NEWLINE);
            if (paramDesc.length() <= 0) continue;
            strBuff.append(NEWLINE);
        }
        return strBuff.toString();
    }

    public String toString() {
        return this.toString(false, 0);
    }

    public String rebuildCmdLine(boolean hideUnsavableParamValues) {
        StringBuffer strBuff = new StringBuffer();
        ParamEntry entry = null;
        String paramKey = null;
        String paramValues = null;
        Set paramSet = this.userParams.entrySet();
        for (Map.Entry mapEntry : paramSet) {
            entry = (ParamEntry)mapEntry.getValue();
            paramKey = entry.paramKey();
            paramValues = entry.valuesToString(hideUnsavableParamValues);
            strBuff.append(CMD_PARAM_KEY_TAG).append(paramKey).append(SYS_PARAM_KEY_VALUE_SEP);
            if (paramValues.length() <= 0) continue;
            strBuff.append(paramValues).append(SYS_PARAM_KEY_VALUE_SEP);
        }
        return strBuff.toString().trim();
    }

    public void saveParamsToIniFile(String iniFileName, String headerComment) throws IllegalArgumentException, IllegalStateException, IOException {
        if (iniFileName == null || iniFileName.trim().length() == 0) {
            throw new IllegalArgumentException("iniFileName is empty.");
        }
        if (this.isInUndoMode) {
            throw new IllegalStateException("Cannot save the object during undo mode.");
        }
        FileWriter file = new FileWriter(iniFileName);
        StringBuffer fileStr = new StringBuffer();
        if (headerComment != null && headerComment.length() > 0) {
            fileStr.append(headerComment);
            if (!headerComment.startsWith(INI_FILE_COMMENT_TAG)) {
                fileStr.insert(0, INI_FILE_COMMENT_TAG + SYS_PARAM_KEY_VALUE_SEP);
            }
            fileStr.append(NEWLINE).append(NEWLINE);
        }
        Set paramSet = this.sysParams.entrySet();
        String sysParamKey = "";
        String sysParamValue = "";
        int sysParamCount = 0;
        for (Map.Entry mapEntry : paramSet) {
            sysParamKey = (String)mapEntry.getKey();
            sysParamValue = (String)mapEntry.getValue();
            fileStr.append(SYS_PARAM_KEY_TAG).append(sysParamKey).append("  ").append(sysParamValue).append(NEWLINE);
            ++sysParamCount;
        }
        if (sysParamCount > 0) {
            fileStr.append(NEWLINE);
        }
        fileStr.append(this.getIniFormatString(false, true, true));
        file.write(fileStr.toString());
        file.close();
    }

    public void inputUserParam(ParamEntry entry) throws IllegalArgumentException {
        if (entry == null) {
            throw new IllegalArgumentException("The entry to input is null.");
        }
        String paramKey = entry.paramKey();
        if (!entry.requiredValueSatisfied()) {
            throw new IllegalArgumentException("Not enough value(s) for parameter '" + paramKey + "'. It requires " + entry.requiredValueNum() + " value(s), but only " + entry.getActualValueNum() + " value(s) are provided.");
        }
        ParamEntry previousEntry = null;
        previousEntry = (ParamEntry)this.userParams.remove(paramKey);
        this.userParams.put(paramKey, entry);
        if (this.isInUndoMode && !this.isParamUndoAvailable(paramKey)) {
            if (this.undoEntryList == null) {
                this.undoEntryList = new LinkedList();
            }
            if (previousEntry == null) {
                this.undoEntryList.add(entry.createUndoShadowEntryForNewInput());
            } else {
                this.undoEntryList.add(previousEntry);
            }
        }
    }

    public void removeUserParam(String paramKey) throws IllegalArgumentException {
        ParamEntry entry = null;
        if (!this.isParamKeyAcceptable(paramKey)) {
            throw new IllegalArgumentException("Unrecognized parameter: " + paramKey + ".");
        }
        entry = (ParamEntry)this.userParams.remove(paramKey);
        if (entry == null) {
            return;
        }
        if (this.isInUndoMode && !this.isParamUndoAvailable(paramKey)) {
            if (this.undoEntryList == null) {
                this.undoEntryList = new LinkedList();
            }
            this.undoEntryList.add(entry);
        }
    }

    public void removeUserParam(String[] paramKeyArray) throws IllegalArgumentException {
        String paramKey = null;
        for (int i = 0; i < paramKeyArray.length; ++i) {
            paramKey = paramKeyArray[i];
            this.removeUserParam(paramKey);
        }
    }

    public void validateRequiredParams() throws IllegalArgumentException {
        this.validateRequiredParams(null);
    }

    public void validateRequiredParams(String[] excludedParamList) throws IllegalArgumentException {
        ParamEntry entry = null;
        Set paramSet = this.acceptableParams.entrySet();
        String paramKey = null;
        for (Map.Entry mapEntry : paramSet) {
            entry = (ParamEntry)mapEntry.getValue();
            if (!entry.isRequired()) continue;
            paramKey = entry.paramKey();
            if (excludedParamList != null && excludedParamList.length > 0) {
                boolean toExclude = false;
                for (int i = 0; i < excludedParamList.length; ++i) {
                    if (!paramKey.equals(excludedParamList[i])) continue;
                    toExclude = true;
                    break;
                }
                if (toExclude) continue;
            }
            if (this.isParamKeyPresent(paramKey)) continue;
            throw new IllegalArgumentException("Required parameter '" + paramKey + "' is missing.");
        }
    }

    public int getUserParamCount() {
        return this.userParams.size();
    }

    public String generateParamHelp() {
        Set paramKeySet = this.acceptableParams.keySet();
        String paramKey2 = null;
        StringBuffer strBuff = new StringBuffer();
        for (String paramKey2 : paramKeySet) {
            strBuff.append(this.getHelpForParam(paramKey2)).append(NEWLINE);
        }
        return strBuff.toString();
    }

    public String generateParamHelp(String[] paramKeyArray) {
        if (paramKeyArray == null || paramKeyArray.length == 0) {
            return "";
        }
        Set paramKeySet = this.acceptableParams.keySet();
        String paramKey = null;
        StringBuffer strBuff = new StringBuffer();
        for (int i = 0; i < paramKeyArray.length; ++i) {
            paramKey = paramKeyArray[i];
            strBuff.append(this.getHelpForParam(paramKey)).append(NEWLINE);
        }
        return strBuff.toString();
    }

    public static final String promptInput(String messageStr) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(System.in);
        BufferedReader commandlineReader = new BufferedReader(inputStreamReader);
        System.out.println(messageStr);
        String responseStr = null;
        try {
            responseStr = commandlineReader.readLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (responseStr != null) {
            responseStr = responseStr.trim();
        }
        return responseStr;
    }

    public static final int promptInputForInt(String messageStr, int defaultValue, boolean repeatForEmptyInput, boolean repeatForInvalidInput) throws IOException, IllegalArgumentException {
        String inputStr = null;
        int returnValue = defaultValue;
        while (true) {
            if ((inputStr = Params.promptInput(messageStr + " [" + defaultValue + "] : ")) == null || inputStr.trim().length() == 0) {
                returnValue = defaultValue;
                break;
            }
            try {
                returnValue = Integer.parseInt(inputStr);
            }
            catch (NumberFormatException e) {
                if (repeatForInvalidInput) continue;
                throw new IllegalArgumentException("The input is not a valid integer value: " + inputStr);
            }
            break;
        }
        return returnValue;
    }

    public static final double promptInputForDouble(String messageStr, double defaultValue, boolean repeatForInvalidInput) throws IOException, IllegalArgumentException {
        String inputStr = null;
        double returnValue = defaultValue;
        while (true) {
            if ((inputStr = Params.promptInput(messageStr + " [" + defaultValue + "] : ")) == null || inputStr.trim().length() == 0) {
                returnValue = defaultValue;
                break;
            }
            try {
                returnValue = Double.parseDouble(inputStr);
            }
            catch (NumberFormatException e) {
                if (repeatForInvalidInput) continue;
                throw new IllegalArgumentException("The input is not a valid double value: " + inputStr);
            }
            break;
        }
        return returnValue;
    }

    public static final boolean promptInputForBoolean(String messageStr, boolean defaultValue, boolean repeatForInvalidInput) throws IOException, IllegalArgumentException {
        boolean returnValue;
        block5: {
            String inputStr = null;
            returnValue = defaultValue;
            do {
                if ((inputStr = Params.promptInput(messageStr + (defaultValue ? " [Y] : " : " [N] : "))) == null || inputStr.trim().length() == 0) {
                    returnValue = defaultValue;
                } else if ((inputStr = inputStr.trim()).equalsIgnoreCase("Y") || inputStr.equalsIgnoreCase("YES")) {
                    returnValue = true;
                } else {
                    if (!inputStr.equalsIgnoreCase("N") && !inputStr.equalsIgnoreCase("NO")) continue;
                    returnValue = false;
                }
                break block5;
            } while (repeatForInvalidInput);
            throw new IllegalArgumentException("The input is not valid: " + inputStr + ". The valid input includes Y, YES, N, NO (case insensitive).");
        }
        return returnValue;
    }

    public void promptInputForParam(String paramKey, String message, boolean repeatForInvalidInput, boolean useExistingValue, boolean useParamDefaultValue) throws IllegalArgumentException, Exception {
        if (paramKey == null || paramKey.length() == 0) {
            throw new Exception("Must provide paramKey for paramter prompt input.");
        }
        if (!this.isParamKeyAcceptable(paramKey)) {
            throw new Exception("The parameter " + paramKey + " is not acceptable.");
        }
        String msgToPrompt = message;
        String valueToShow = null;
        boolean boolParam = this.isBoolParam(paramKey);
        boolean inputSatisified = false;
        String inputValues = null;
        if (!(msgToPrompt != null && msgToPrompt.length() != 0 || (msgToPrompt = this.getParamDesc(paramKey, true)) != null && msgToPrompt.length() != 0)) {
            msgToPrompt = boolParam ? "Do you need " + paramKey + "? (Y/N)" : "Please input " + paramKey;
        }
        valueToShow = null;
        if (boolParam) {
            valueToShow = "N";
            if (useExistingValue && this.isParamKeyPresent(paramKey)) {
                valueToShow = "Y";
            }
        } else {
            ParamEntry existingEntry;
            if (useExistingValue && (existingEntry = this.getParamEntry(paramKey)) != null && existingEntry.getActualValueNum() > 0) {
                valueToShow = existingEntry.valuesToString();
            }
            if ((valueToShow == null || valueToShow.length() == 0) && useParamDefaultValue) {
                valueToShow = this.getParamDefaultValuesString(paramKey, null);
            }
        }
        if (valueToShow != null && valueToShow.length() > 0) {
            msgToPrompt = msgToPrompt + " [" + valueToShow + "]";
        }
        msgToPrompt = msgToPrompt + " : ";
        String additionalInputMessage = "";
        while (!inputSatisified) {
            ParamEntry entry;
            inputValues = Params.promptInput(additionalInputMessage + msgToPrompt);
            if (inputValues == null || inputValues.trim().length() == 0) {
                inputValues = valueToShow;
            }
            if (inputValues == null || inputValues.trim().length() == 0) {
                if (repeatForInvalidInput) {
                    additionalInputMessage = "Empty input is not acceptable for this paramter." + NEWLINE;
                    continue;
                }
                throw new IllegalArgumentException("Empty input is not acceptable for paramter " + paramKey);
            }
            inputValues = inputValues.trim();
            if (boolParam) {
                if (!this.isParamValueAcceptable(paramKey, 1, inputValues, false)) {
                    if (repeatForInvalidInput) {
                        additionalInputMessage = "The input '" + inputValues + "' is not acceptable for this paramter." + NEWLINE;
                        continue;
                    }
                    throw new IllegalArgumentException("The input '" + inputValues + "' is not acceptable for paramter " + paramKey);
                }
                if (inputValues.toUpperCase().startsWith("Y")) {
                    entry = new ParamEntry(paramKey);
                    this.inputUserParam(entry);
                } else {
                    this.removeUserParam(paramKey);
                }
                inputSatisified = true;
                break;
            }
            entry = new ParamEntry(paramKey);
            try {
                entry.addValueArrayInString(inputValues);
                this.inputUserParam(entry);
            }
            catch (IllegalArgumentException e1) {
                if (repeatForInvalidInput) {
                    additionalInputMessage = "The input '" + inputValues + "' is not acceptable for this paramter." + NEWLINE;
                    continue;
                }
                throw e1;
            }
            inputSatisified = true;
            break;
        }
    }

    public void promptInputForParams(String[] paramKeyArray, boolean repeatForInvalidInput, boolean useExistingValue, boolean useDefaultValue) throws IllegalArgumentException, Exception {
        String paramKey = null;
        for (int i = 0; i < paramKeyArray.length; ++i) {
            paramKey = paramKeyArray[i];
            this.promptInputForParam(paramKey, null, repeatForInvalidInput, useExistingValue, useDefaultValue);
        }
    }

    public static boolean fileExits(String filePathName) {
        File file = new File(filePathName);
        return file.isFile();
    }

    public static boolean dirExits(String dirPathName) {
        File file = new File(dirPathName);
        return file.isDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveObjectToFile(Params paramsObj, String fileName) throws IllegalArgumentException, IllegalStateException, IOException {
        if (paramsObj == null) {
            throw new IllegalArgumentException("paramsObj is null.");
        }
        if (fileName == null || fileName.trim().length() == 0) {
            throw new IllegalArgumentException("iniFileName is empty.");
        }
        if (paramsObj.isInUndoMode()) {
            throw new IllegalStateException("Cannot save the object during in mode.");
        }
        FileOutputStream fos = null;
        ObjectOutputStream out = null;
        ArrayList<ParamEntry> nonSavableParams = new ArrayList<ParamEntry>();
        ParamEntry entry = null;
        Set paramSet = paramsObj.userParams.entrySet();
        Iterator itr2 = paramSet.iterator();
        while (itr2.hasNext()) {
            Map.Entry mapEntry = itr2.next();
            entry = (ParamEntry)mapEntry.getValue();
            if (entry.isSavable()) continue;
            nonSavableParams.add(entry);
            itr2.remove();
        }
        try {
            fos = new FileOutputStream(fileName);
            out = new ObjectOutputStream(fos);
            out.writeObject(paramsObj);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception itr2) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception itr2) {}
            }
            for (int i = 0; i < nonSavableParams.size(); ++i) {
                entry = (ParamEntry)nonSavableParams.get(i);
                paramsObj.userParams.put(entry.paramKey(), entry);
            }
        }
    }

    public void saveObjectToFile(String fileName) throws IllegalArgumentException, IllegalStateException, IOException {
        Params.saveObjectToFile(this, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Params loadObjectFromFile(String fileName) throws IOException, ClassNotFoundException {
        FileInputStream fis = null;
        ObjectInputStream oin = null;
        Params returnObject = null;
        try {
            fis = new FileInputStream(fileName);
            oin = new ObjectInputStream(fis);
            returnObject = (Params)oin.readObject();
        }
        finally {
            if (oin != null) {
                try {
                    oin.close();
                }
                catch (Exception exception) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception exception) {}
            }
        }
        if (returnObject != null) {
            returnObject.commitInput();
        }
        return returnObject;
    }

    public void loadObjectFromFile(String fileName, boolean overwriteExistingUserParams) throws IOException, ClassNotFoundException, IllegalAccessException {
        Params params = Params.loadObjectFromFile(fileName);
        this.mergeUserParamsAndFields(params, overwriteExistingUserParams);
        params = null;
    }

    private static Object deepClone(Object obj) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException {
        Object newObj;
        block19: {
            block31: {
                block30: {
                    block29: {
                        block28: {
                            block27: {
                                block26: {
                                    block25: {
                                        block24: {
                                            block23: {
                                                block22: {
                                                    block21: {
                                                        block20: {
                                                            block18: {
                                                                newObj = null;
                                                                if (obj != null) break block18;
                                                                newObj = null;
                                                                break block19;
                                                            }
                                                            if (!obj.getClass().isPrimitive()) break block20;
                                                            newObj = obj;
                                                            break block19;
                                                        }
                                                        if (!obj.getClass().isArray()) break block21;
                                                        int arrayLen = Array.getLength(obj);
                                                        Class<?> elementClass = obj.getClass().getComponentType();
                                                        Object origValue = null;
                                                        Object newValue = null;
                                                        newObj = Array.newInstance(elementClass, arrayLen);
                                                        for (int arrayIdx = 0; arrayIdx < arrayLen; ++arrayIdx) {
                                                            origValue = Array.get(obj, arrayIdx);
                                                            newValue = Params.deepClone(origValue);
                                                            Array.set(newObj, arrayIdx, newValue);
                                                        }
                                                        break block19;
                                                    }
                                                    if (!obj.getClass().equals(Short.class)) break block22;
                                                    newObj = new Short((Short)obj);
                                                    break block19;
                                                }
                                                if (!obj.getClass().equals(Character.class)) break block23;
                                                newObj = new Character(((Character)obj).charValue());
                                                break block19;
                                            }
                                            if (!obj.getClass().equals(Integer.class)) break block24;
                                            newObj = new Integer((Integer)obj);
                                            break block19;
                                        }
                                        if (!obj.getClass().equals(Double.class)) break block25;
                                        newObj = new Double((Double)obj);
                                        break block19;
                                    }
                                    if (!obj.getClass().equals(Float.class)) break block26;
                                    newObj = new Float(((Float)obj).floatValue());
                                    break block19;
                                }
                                if (!obj.getClass().equals(Long.class)) break block27;
                                newObj = new Long((Long)obj);
                                break block19;
                            }
                            if (!obj.getClass().equals(Boolean.class)) break block28;
                            newObj = new Boolean((Boolean)obj);
                            break block19;
                        }
                        if (!obj.getClass().equals(Byte.class)) break block29;
                        newObj = new Byte((Byte)obj);
                        break block19;
                    }
                    if (!(obj instanceof Collection)) break block30;
                    Constructor<?> ct = null;
                    try {
                        ct = obj.getClass().getConstructor(null);
                        newObj = ct.newInstance(null);
                    }
                    catch (Throwable e) {
                        throw new NoSuchMethodException("No-arg constructor is inaccessable for class " + obj.getClass().getName() + ".");
                    }
                    Object element2 = null;
                    Object newElement = null;
                    for (Object element2 : (Collection)obj) {
                        newElement = Params.deepClone(element2);
                        ((Collection)newObj).add(newElement);
                    }
                    break block19;
                }
                if (!(obj instanceof Map)) break block31;
                Constructor<?> ct = null;
                try {
                    ct = obj.getClass().getConstructor(null);
                    newObj = ct.newInstance(null);
                }
                catch (Throwable e) {
                    throw new NoSuchMethodException("No-arg constructor is inaccessable for class " + obj.getClass().getName() + ".");
                }
                Map.Entry mapEntry2 = null;
                Object key = null;
                Object value = null;
                Object newKey = null;
                Object newValue = null;
                Map map = (Map)obj;
                Set entrySet = map.entrySet();
                for (Map.Entry mapEntry2 : entrySet) {
                    key = mapEntry2.getKey();
                    value = mapEntry2.getValue();
                    newKey = Params.deepClone(key);
                    newValue = Params.deepClone(value);
                    ((Map)newObj).put(newKey, newValue);
                }
                break block19;
            }
            Class<?>[] interfaceList = obj.getClass().getInterfaces();
            newObj = null;
            if (interfaceList != null && interfaceList.length > 0) {
                for (int i = 0; i < interfaceList.length; ++i) {
                    if (!interfaceList[i].equals(Cloneable.class)) continue;
                    newObj = interfaceList.clone();
                }
            }
            if (newObj == null) {
                Constructor<?> ct = null;
                try {
                    ct = obj.getClass().getConstructor(obj.getClass());
                }
                catch (SecurityException key) {
                }
                catch (NoSuchMethodException key) {
                    // empty catch block
                }
                if (ct != null) {
                    newObj = ct.newInstance(obj);
                }
            }
            if (newObj != null) break block19;
            Field[] fieldArray = obj.getClass().getFields();
            Field field = null;
            String fieldName = null;
            Object fieldValue = null;
            String fieldClassName = null;
            int fieldModifiers = -1;
            Constructor<?> ct = null;
            try {
                ct = obj.getClass().getConstructor(null);
                newObj = ct.newInstance(null);
            }
            catch (Throwable e) {
                throw new NoSuchMethodException("Both the copy constructor and the No-arg constructor are inaccessable for class " + obj.getClass().getName() + ".");
            }
            Field[] newFieldArray = newObj.getClass().getFields();
            Field newField = null;
            String newFieldName = null;
            Object newFieldValue = null;
            String newFieldClassName = null;
            int newFieldModifiers = -1;
            boolean foundMatchingField = false;
            for (int i = 0; i < fieldArray.length; ++i) {
                field = fieldArray[i];
                fieldName = field.getName();
                fieldClassName = field.getDeclaringClass().getName();
                fieldModifiers = field.getModifiers();
                if (Modifier.isStatic(fieldModifiers) || Modifier.isFinal(fieldModifiers)) continue;
                foundMatchingField = false;
                for (int j = 0; j < newFieldArray.length; ++j) {
                    newField = newFieldArray[j];
                    newFieldName = newField.getName();
                    newFieldClassName = newField.getDeclaringClass().getName();
                    if (!newFieldName.equals(fieldName) || !newFieldClassName.equals(fieldClassName)) continue;
                    newFieldModifiers = newField.getModifiers();
                    if (Modifier.isStatic(newFieldModifiers) || Modifier.isFinal(newFieldModifiers)) break;
                    foundMatchingField = true;
                    break;
                }
                if (!foundMatchingField) continue;
                fieldValue = field.get(obj);
                newFieldValue = Params.deepClone(fieldValue);
                newField.set(newObj, newFieldValue);
            }
        }
        return newObj;
    }

    public void mergeUserParamsAndFields(Params theOther, boolean overwriteExistingUserParams) throws IllegalAccessException, IllegalStateException {
        if (theOther == null) {
            return;
        }
        if (theOther.isInUndoMode()) {
            throw new IllegalStateException("Cannot merge a parameter object in undo mode.");
        }
        this.commitInput();
        ParamEntry entry = null;
        ParamEntry newEntry = null;
        Set paramSet = theOther.userParams.entrySet();
        String paramKey = null;
        Iterator itr = paramSet.iterator();
        while (itr.hasNext()) {
            newEntry = null;
            entry = null;
            Map.Entry mapEntry = itr.next();
            entry = (ParamEntry)mapEntry.getValue();
            paramKey = entry.paramKey();
            if ((overwriteExistingUserParams || !this.isParamKeyPresent(paramKey)) && this.isParamAcceptable(paramKey)) {
                newEntry = new ParamEntry(entry);
            }
            if (mapEntry != null) {
                this.inputUserParam(entry);
            }
            entry = null;
        }
        Field[] fieldArray = theOther.getClass().getFields();
        Field field = null;
        String fieldName = null;
        Object fieldValue = null;
        String fieldClassName = null;
        int fieldModifiers = -1;
        Field[] myFieldArray = this.getClass().getFields();
        Field myField = null;
        String myFieldName = null;
        Object myFieldValue = null;
        String myFieldClassName = null;
        int myFieldModifiers = -1;
        boolean foundMatchingField = false;
        for (int i = 0; i < fieldArray.length; ++i) {
            field = fieldArray[i];
            fieldName = field.getName();
            fieldClassName = field.getDeclaringClass().getName();
            fieldModifiers = field.getModifiers();
            if (Modifier.isStatic(fieldModifiers) || Modifier.isFinal(fieldModifiers)) continue;
            foundMatchingField = false;
            for (int j = 0; j < myFieldArray.length; ++j) {
                myField = myFieldArray[j];
                myFieldName = myField.getName();
                myFieldClassName = myField.getDeclaringClass().getName();
                if (!myFieldName.equals(fieldName) || !myFieldClassName.equals(fieldClassName)) continue;
                myFieldModifiers = myField.getModifiers();
                if (Modifier.isStatic(myFieldModifiers) || Modifier.isFinal(myFieldModifiers)) break;
                foundMatchingField = true;
                break;
            }
            if (!foundMatchingField) continue;
            try {
                fieldValue = field.get(theOther);
            }
            catch (IllegalArgumentException e1) {
                continue;
            }
            catch (IllegalAccessException e1) {
                throw new IllegalAccessException("Failed to retrieve value from " + field.getDeclaringClass().getName() + "." + field.getName() + ". Please ensure both the class and the field are public.");
            }
            try {
                myFieldValue = Params.deepClone(fieldValue);
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            catch (SecurityException e) {
                continue;
            }
            catch (InstantiationException e) {
                continue;
            }
            catch (IllegalAccessException e) {
                continue;
            }
            catch (InvocationTargetException e) {
                continue;
            }
            catch (NoSuchMethodException e) {
                continue;
            }
            try {
                myField.set(this, myFieldValue);
                continue;
            }
            catch (IllegalArgumentException e1) {
                continue;
            }
            catch (IllegalAccessException e1) {
                throw new IllegalAccessException("Failed to set value to " + field.getDeclaringClass().getName() + "." + field.getName() + " of \"this\". Please ensure both the class and the field are public.");
            }
        }
    }

    public boolean isInUndoMode() {
        return this.isInUndoMode;
    }

    public void setUndoPoint() {
        if (this.isInUndoMode) {
            this.commitInput();
        }
        this.isInUndoMode = true;
    }

    public void commitInput() {
        if (!this.isInUndoMode) {
            return;
        }
        this.undoEntryList = null;
        this.isInUndoMode = false;
    }

    public void undoAllInput() {
        if (!this.isInUndoMode) {
            return;
        }
        ParamEntry entry2 = null;
        String curEntryParamKey = null;
        if (this.undoEntryList != null && !this.undoEntryList.isEmpty()) {
            for (ParamEntry entry2 : this.undoEntryList) {
                curEntryParamKey = entry2.getValue(0);
                if (entry2.isUndoShadowEntry()) {
                    if (entry2.paramKey().equals("__KEY_FOR_UNDO_NEW_INPUT_PARAM__")) {
                        this.userParams.remove(curEntryParamKey);
                    }
                } else {
                    this.userParams.put(curEntryParamKey, entry2);
                }
                entry2 = null;
            }
        }
        this.undoEntryList = null;
        this.isInUndoMode = false;
    }

    public void undoInput(String paramKey) {
        if (!this.isInUndoMode || this.undoEntryList == null || this.undoEntryList.isEmpty()) {
            return;
        }
        ParamEntry entry = null;
        String curEntryParamKey = null;
        Iterator itr = this.undoEntryList.iterator();
        while (itr.hasNext()) {
            entry = (ParamEntry)itr.next();
            curEntryParamKey = entry.getValue(0);
            if (!curEntryParamKey.equals(paramKey)) continue;
            if (entry.isUndoShadowEntry()) {
                if (curEntryParamKey.equals("__KEY_FOR_UNDO_NEW_INPUT_PARAM__")) {
                    this.userParams.remove(curEntryParamKey);
                }
            } else {
                this.userParams.put(curEntryParamKey, entry);
            }
            entry = null;
            itr.remove();
            break;
        }
    }

    public String[] listUndoParamKeys() {
        if (!this.isInUndoMode || this.undoEntryList == null || this.undoEntryList.isEmpty()) {
            return null;
        }
        String[] keyList = new String[this.undoEntryList.size()];
        int i = 0;
        ParamEntry entry2 = null;
        for (ParamEntry entry2 : this.undoEntryList) {
            keyList[i] = entry2.getValue(0);
            ++i;
        }
        return keyList;
    }

    public boolean isParamUndoAvailable(String paramKey) {
        if (!this.isInUndoMode || this.undoEntryList == null || this.undoEntryList.isEmpty()) {
            return false;
        }
        ParamEntry entry2 = null;
        for (ParamEntry entry2 : this.undoEntryList) {
            if (!paramKey.equals(entry2.getValue(0))) continue;
            return true;
        }
        return false;
    }

    public final class ParamEntry
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = 1L;
        private String _paramKey = null;
        private boolean _isRequired = true;
        private boolean _isSavable = true;
        private int _requiredValueNum = 0;
        private int _maxOptionalValueNum = 0;
        private int _actualValueNum = 0;
        private String[] valueArray = null;
        private String _paramDesc = null;
        private static final String KEY_FOR_BUILDING_ACCEPTABLE_PARAM = "__KEY_FOR_BUILDING_ACCEPTABLE_PARAM__";
        private static final String KEY_FOR_UNDO_NEW_INPUT_PARAM = "__KEY_FOR_UNDO_NEW_INPUT_PARAM__";
        private static final String HIDDEN_VALUE = "********";

        protected ParamEntry() {
        }

        public ParamEntry(ParamEntry theOtherEntry) {
            this._paramKey = theOtherEntry._paramKey;
            this._isSavable = theOtherEntry._isSavable;
            this._requiredValueNum = theOtherEntry._requiredValueNum;
            this._maxOptionalValueNum = theOtherEntry._maxOptionalValueNum;
            this._actualValueNum = theOtherEntry._actualValueNum;
            this._paramDesc = theOtherEntry._paramDesc;
            this.valueArray = new String[theOtherEntry.valueArray.length];
            for (int i = 0; i < theOtherEntry.valueArray.length; ++i) {
                this.valueArray[i] = theOtherEntry.valueArray[i];
            }
        }

        public ParamEntry clone() {
            return new ParamEntry(this);
        }

        public ParamEntry(String paramKey) throws IllegalArgumentException {
            if (paramKey.equals(KEY_FOR_BUILDING_ACCEPTABLE_PARAM) || paramKey.equals(KEY_FOR_UNDO_NEW_INPUT_PARAM)) {
                return;
            }
            this._paramKey = paramKey.trim();
            if (this._paramKey.startsWith(Params.CMD_PARAM_KEY_TAG)) {
                this._paramKey = this._paramKey.substring(Params.CMD_PARAM_KEY_TAG.length());
            }
            if (!Params.this.acceptableParams.containsKey(this._paramKey)) {
                throw new IllegalArgumentException("Unrecognized parameter " + paramKey);
            }
            ParamEntry expectedEntry = (ParamEntry)Params.this.acceptableParams.get(this._paramKey);
            this._isRequired = expectedEntry.isRequired();
            this._isSavable = expectedEntry.isSavable();
            this._requiredValueNum = expectedEntry.requiredValueNum();
            this._maxOptionalValueNum = expectedEntry.maxOptionalValueNum();
            this._actualValueNum = 0;
            this.valueArray = new String[this._requiredValueNum + this._maxOptionalValueNum + 1];
            this.valueArray[0] = this._paramKey;
        }

        private ParamEntry createUndoShadowEntryForNewInput() {
            ParamEntry entry = new ParamEntry(this);
            entry._paramKey = KEY_FOR_UNDO_NEW_INPUT_PARAM;
            entry._actualValueNum = 0;
            return entry;
        }

        private boolean isUndoShadowEntry() {
            return this._paramKey.equals(KEY_FOR_UNDO_NEW_INPUT_PARAM);
        }

        public String paramKey() {
            return this._paramKey;
        }

        public String paramDesc() {
            return Params.this.getParamDesc(this._paramKey);
        }

        public boolean isRequired() {
            return this._isRequired;
        }

        public boolean isSavable() {
            return this._isSavable;
        }

        public int requiredValueNum() {
            return this._requiredValueNum;
        }

        public int maxOptionalValueNum() {
            return this._maxOptionalValueNum;
        }

        public int maxValueNum() {
            return this._requiredValueNum + this._maxOptionalValueNum;
        }

        public int getActualValueNum() {
            return this._actualValueNum;
        }

        public boolean isBoolParam() {
            return this.maxValueNum() == 0;
        }

        public void addValue(String value) throws IllegalArgumentException {
            int maxValueNum = this.maxValueNum();
            ++this._actualValueNum;
            if (this._actualValueNum > maxValueNum) {
                throw new IllegalArgumentException("Too many value(s) for parameter " + this._paramKey + ". It can have " + maxValueNum + " value(s) at maximum.");
            }
            Params.this.isParamValueAcceptable(this._paramKey, this._actualValueNum, value, false);
            this.valueArray[this._actualValueNum] = value;
        }

        public void addValueArrayInString(String valueArray) throws IllegalArgumentException {
            if (valueArray == null || valueArray.trim().length() == 0) {
                return;
            }
            StringTokenizer tokenizer = new StringTokenizer(valueArray.trim());
            while (tokenizer.hasMoreElements()) {
                this.addValue(tokenizer.nextToken());
            }
        }

        public boolean requiredValueSatisfied() {
            return this._actualValueNum >= this._requiredValueNum;
        }

        public boolean validateNumericValue(int valueIndex, boolean intOnly, int minValue, int maxValue) {
            String value = this.getValue(valueIndex);
            return Params.validateNumericValue(value, intOnly, minValue, maxValue);
        }

        public String getValue(int valueIndex) {
            if (valueIndex >= 0 && valueIndex <= this._actualValueNum) {
                return this.valueArray[valueIndex];
            }
            return null;
        }

        public int getIntValue(int valueIndex) throws IllegalArgumentException, NumberFormatException {
            String valueStr = this.getValue(valueIndex);
            if (valueStr == null) {
                throw new IllegalArgumentException("Parameter '" + this._paramKey + "' value " + valueIndex + " is not provided.");
            }
            if (!this.validateNumericValue(valueIndex, true, Integer.MIN_VALUE, Integer.MAX_VALUE)) {
                throw new NumberFormatException("Parameter '" + this._paramKey + "' value " + valueIndex + " (" + valueStr + ") is not a valid integer.");
            }
            return Integer.parseInt(valueStr);
        }

        public double getDoubleValue(int valueIndex) throws IllegalArgumentException, NumberFormatException {
            String valueStr = this.getValue(valueIndex);
            if (valueStr == null) {
                throw new IllegalArgumentException("Parameter '" + this._paramKey + "' value " + valueIndex + " is not provided.");
            }
            if (!this.validateNumericValue(valueIndex, false, Integer.MIN_VALUE, Integer.MAX_VALUE)) {
                throw new NumberFormatException("Parameter '" + this._paramKey + "' value " + valueIndex + " (" + valueStr + ") is not a valid double.");
            }
            return Double.parseDouble(valueStr);
        }

        public String getValueName(int valueIndex) {
            return Params.this.getParamValueName(this._paramKey, valueIndex);
        }

        public String getDefaultValue(int valueIndex) {
            return Params.this.getParamDefaultValue(this._paramKey, valueIndex);
        }

        public int getDefaultValueInInt(int valueIndex) throws IllegalArgumentException, NumberFormatException {
            return Params.this.getParamDefaultValueInInt(this._paramKey, valueIndex);
        }

        public double getDefaultValueInDouble(int valueIndex) throws IllegalArgumentException, NumberFormatException {
            return Params.this.getParamDefaultValueInDouble(this._paramKey, valueIndex);
        }

        public boolean isValueRequired(int valueIndex) {
            if (valueIndex >= 1 && valueIndex <= this.maxValueNum()) {
                return valueIndex <= this.requiredValueNum();
            }
            return false;
        }

        public String toString(boolean hideNonSavableValues, int indent, boolean alignValues) {
            StringBuffer strBuff = new StringBuffer();
            StringBuffer myParamKey = new StringBuffer();
            for (int i = 0; i < indent; ++i) {
                myParamKey.insert(0, ' ');
            }
            myParamKey.append(this._paramKey);
            if (alignValues) {
                if (Params.this.maxUserParamKeyStrLen < 1) {
                    String keyStr2 = null;
                    Set paramSet = null;
                    paramSet = Params.this.acceptableParams.keySet();
                    for (String keyStr2 : paramSet) {
                        if (keyStr2.length() <= Params.this.maxUserParamKeyStrLen) continue;
                        Params.this.maxUserParamKeyStrLen = keyStr2.length();
                    }
                }
                int fillingBlanks = Params.this.maxUserParamKeyStrLen - this._paramKey.length();
                for (int i = 0; i < fillingBlanks; ++i) {
                    myParamKey.append(' ');
                }
                myParamKey.append(" = ");
            } else {
                myParamKey.append("=");
            }
            strBuff.append(myParamKey);
            if (this.isBoolParam()) {
                strBuff.append("Y");
            } else {
                strBuff.append(this.valuesToString(hideNonSavableValues));
            }
            return strBuff.toString();
        }

        public String toString() {
            return this.toString(false, 0, false);
        }

        public String valuesToString() {
            return this.valuesToString(true);
        }

        public String valuesToString(boolean hideValuesIfUnsavable) {
            StringBuffer strBuff = new StringBuffer();
            for (int i = 1; i <= this.getActualValueNum(); ++i) {
                if (hideValuesIfUnsavable && !this.isSavable()) {
                    strBuff.append(HIDDEN_VALUE);
                } else {
                    strBuff.append(this.valueArray[i]);
                }
                strBuff.append(Params.SYS_PARAM_KEY_VALUE_SEP);
            }
            return strBuff.toString().trim();
        }

        static /* synthetic */ String[] access$702(ParamEntry x0, String[] x1) {
            x0.valueArray = x1;
            return x1;
        }
    }
}

