/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.content.cm.lstools.common;

import com.ibm.content.cm.lstools.common.Params;
import java.io.IOException;
import java.lang.reflect.Array;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public final class LogHelper {
    public static final String PARAM_LOG = "log";
    public static final String LOGLEVEL_ERROR = "ERROR";
    public static final String LOGLEVEL_INFO = "INFO";
    public static final String LOGLEVEL_DEBUG = "DEBUG";
    public static final String LOGLEVEL_DDEBUG = "DDEBUG";
    public static final String LOGLEVEL_DDDEBUG = "DDDEBUG";
    public static final String LOGSTYLE_KEY_VALUE_PAIR = "__LOGSTYLE_KEY_VALUE_PAIR__";
    public static final String LOGSTYLE_TEXT_BLOCK = "__LOGSTYLE_TEXT_BLOCK__";
    private static final String LOGGER_NAME = LogHelper.class.getName();
    private static boolean logInited = false;
    private static String logFile = null;
    private static final String NEWLINE = System.getProperty("line.separator");
    private static Logger logger = LogHelper.deInitLogger();

    public static Logger deInitLogger() {
        Logger myLogger = Logger.getLogger(LOGGER_NAME);
        myLogger.setLevel(Level.SEVERE);
        myLogger.setUseParentHandlers(true);
        Handler[] handlers = myLogger.getHandlers();
        if (handlers != null && handlers.length > 0) {
            for (int i = 0; i < handlers.length; ++i) {
                if (handlers[i] instanceof FileHandler) {
                    handlers[i].close();
                }
                myLogger.removeHandler(handlers[i]);
            }
        }
        logFile = null;
        logInited = false;
        return myLogger;
    }

    private LogHelper() throws Exception {
        throw new Exception("Please do not use this method.");
    }

    public static void initLogger(String logPathFile, String logLevel) throws SecurityException, IOException {
        boolean changeLogFile;
        Level mappedLogLevel = LogHelper.mapLogLevel(logLevel);
        if (mappedLogLevel == null) {
            throw new IllegalArgumentException("Invalid log level: " + logLevel);
        }
        if (!(logInited || logPathFile != null && logPathFile.trim().length() != 0)) {
            throw new IllegalArgumentException("No log file name is provided to init the logger.");
        }
        boolean bl = changeLogFile = !logInited || logFile == null || logFile.trim().length() == 0 || !logFile.equals(logPathFile);
        if (changeLogFile) {
            LogHelper.deInitLogger();
            logger.setUseParentHandlers(false);
            FileHandler fileHandler = new FileHandler(logPathFile, true);
            fileHandler.setFormatter(new MyLogHander());
            logger.addHandler(fileHandler);
            logFile = logPathFile;
        }
        logger.setLevel(mappedLogLevel);
        logInited = true;
    }

    public static void enableLogParam(Params params, boolean isRequired, boolean isSavable) {
        String logFile = params.getIdentifier() + ".log";
        String paramDesc = "Log settings. The log level can be: ERROR, INFO, DEBUG, DDEBUG or DDDEBUG.#Please input the log level and log file";
        try {
            params.addAcceptableParam(PARAM_LOG, paramDesc, isRequired, isSavable, 1, 1, new String[]{"log level#INFO|ERROR|DEBUG|DDEBUG|DDDEBUG|", "log file#" + logFile});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean validateLogLevel(String logLevel) {
        return logLevel != null && logLevel.trim().length() > 0 && LogHelper.mapLogLevel(logLevel) != null;
    }

    private static Level mapLogLevel(String logLevel) {
        Level mappedLogLevel = null;
        if (logLevel == null || logLevel.trim().length() == 0) {
            return Level.INFO;
        }
        mappedLogLevel = logLevel.equalsIgnoreCase(LOGLEVEL_ERROR) ? Level.WARNING : (logLevel.equalsIgnoreCase(LOGLEVEL_INFO) ? Level.INFO : (logLevel.equalsIgnoreCase(LOGLEVEL_DEBUG) ? Level.FINE : (logLevel.equalsIgnoreCase(LOGLEVEL_DDEBUG) ? Level.FINER : (logLevel.equalsIgnoreCase(LOGLEVEL_DDDEBUG) ? Level.FINEST : null))));
        return mappedLogLevel;
    }

    public static void initLogger(Params params) throws SecurityException, IOException {
        String logLevel = params.getParamValue(PARAM_LOG, 1, false);
        String logFile = params.getParamValue(PARAM_LOG, 2, false);
        if (!(logLevel != null && logLevel.trim().length() != 0 || (logLevel = params.getParamDefaultValue(PARAM_LOG, 1)) != null && logLevel.trim().length() != 0)) {
            throw new IllegalArgumentException("No log level is provided.");
        }
        logLevel = logLevel.toUpperCase();
        if (logFile == null || logFile.trim().length() == 0) {
            logFile = params.getParamDefaultValue(PARAM_LOG, 2);
        }
        LogHelper.initLogger(logFile, logLevel);
    }

    public static Logger getLogger() {
        logger = Logger.getLogger(LOGGER_NAME);
        return logger;
    }

    public static String getLogFile() {
        return logFile;
    }

    public static String exceptionToString(Throwable e) {
        StringBuffer strBuff = new StringBuffer();
        if (e == null) {
            strBuff.append("null");
        } else {
            Throwable cause;
            strBuff.append("    ").append(e.getClass().getName());
            String msg = e.getMessage();
            if (msg != null && msg.length() > 0) {
                strBuff.append(" : ").append(msg);
            }
            strBuff.append(NEWLINE);
            StackTraceElement[] stack = e.getStackTrace();
            if (stack != null && stack.length > 0) {
                for (int i = 0; i < stack.length; ++i) {
                    strBuff.append("        at ").append(stack[i].getClassName()).append(".").append(stack[i].getMethodName());
                    strBuff.append("(").append(stack[i].getFileName()).append(":").append(stack[i].getLineNumber()).append(")");
                    strBuff.append(NEWLINE);
                }
            }
            if ((cause = e.getCause()) != null) {
                strBuff.append("    Caused by:").append(LogHelper.exceptionToString(cause));
            }
        }
        return strBuff.toString();
    }

    private static String objectToSring(Object object) {
        StringBuffer strBuff = new StringBuffer();
        if (object == null) {
            strBuff.append("null");
        } else if (object instanceof String || object instanceof Character) {
            strBuff.append('<').append(object.toString()).append('>');
        } else if (object.getClass().isArray()) {
            int arrayLen = Array.getLength(object);
            strBuff.append('{');
            for (int i = 0; i < arrayLen; ++i) {
                strBuff.append(LogHelper.objectToSring(Array.get(object, i)));
                if (i >= arrayLen - 1) continue;
                strBuff.append(", ");
            }
            strBuff.append('}');
        } else {
            strBuff.append(object.toString());
        }
        return strBuff.toString();
    }

    static /* synthetic */ String access$100() {
        return NEWLINE;
    }

    private static class MyLogHander
    extends Formatter {
        private static final SimpleDateFormat _sDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        private static final String NEWLINE = LogHelper.access$100();
        private static final int KEY_VALUE_ALIGN = 32;

        private MyLogHander() {
        }

        @Override
        public String format(LogRecord record) {
            Throwable throwedObject;
            StringBuffer strBuff = new StringBuffer();
            strBuff.append(_sDateFormat.format(new Date(record.getMillis())));
            strBuff.append(" [");
            if (record.getLevel().intValue() >= Level.SEVERE.intValue()) {
                strBuff.append(LogHelper.LOGLEVEL_ERROR);
            } else if (record.getLevel().intValue() >= Level.WARNING.intValue()) {
                strBuff.append("WARNING");
            } else if (record.getLevel().intValue() >= Level.INFO.intValue()) {
                strBuff.append(LogHelper.LOGLEVEL_INFO);
            } else if (record.getLevel().intValue() >= Level.CONFIG.intValue()) {
                strBuff.append("CONFIG");
            } else if (record.getLevel().intValue() >= Level.FINE.intValue()) {
                strBuff.append(LogHelper.LOGLEVEL_DEBUG);
            } else if (record.getLevel().intValue() >= Level.FINER.intValue()) {
                strBuff.append(LogHelper.LOGLEVEL_DDEBUG);
            } else {
                strBuff.append(LogHelper.LOGLEVEL_DDDEBUG);
            }
            strBuff.append("] ");
            strBuff.append(record.getSourceClassName()).append(".").append(record.getSourceMethodName()).append(" - ");
            strBuff.append(record.getMessage());
            strBuff.append(NEWLINE);
            Object[] parms = record.getParameters();
            if (parms != null && parms.length > 0) {
                boolean isTextBlock;
                boolean isKeyValuePair = parms[0] != null && parms[0].equals(LogHelper.LOGSTYLE_KEY_VALUE_PAIR);
                boolean bl = isTextBlock = parms[0] != null && parms[0].equals(LogHelper.LOGSTYLE_TEXT_BLOCK);
                if (isKeyValuePair) {
                    String key = null;
                    for (int i = 1; i < parms.length; ++i) {
                        if (i % 2 != 0) {
                            strBuff.append("    ");
                            key = parms[i] == null ? "null" : parms[i].toString().trim();
                            int alignBlanks = 32 - key.length();
                            strBuff.append(key);
                            for (int alignBlankCounter = 0; alignBlankCounter < alignBlanks; ++alignBlankCounter) {
                                strBuff.append(' ');
                            }
                            strBuff.append(" : ");
                            continue;
                        }
                        strBuff.append(LogHelper.objectToSring(parms[i]));
                        if (i >= parms.length - 1) continue;
                        strBuff.append(NEWLINE);
                    }
                } else if (isTextBlock) {
                    for (int i = 1; i < parms.length; ++i) {
                        if (parms[i] == null) {
                            strBuff.append("null");
                        } else {
                            strBuff.append(parms[i].toString());
                        }
                        while (strBuff.charAt(strBuff.length() - 1) == '\n' || strBuff.charAt(strBuff.length() - 1) == '\r') {
                            strBuff.deleteCharAt(strBuff.length() - 1);
                        }
                        if (i >= parms.length - 1) continue;
                        strBuff.append(NEWLINE);
                    }
                } else {
                    for (int i = 0; i < parms.length; ++i) {
                        strBuff.append("    ");
                        if (parms.length > 1) {
                            strBuff.append(i + 1).append(". ");
                        }
                        strBuff.append(LogHelper.objectToSring(parms[i]));
                        if (i >= parms.length - 1) continue;
                        strBuff.append(NEWLINE);
                    }
                }
                strBuff.append(NEWLINE);
            }
            if ((throwedObject = record.getThrown()) != null) {
                strBuff.append(LogHelper.exceptionToString(throwedObject));
            }
            return strBuff.toString();
        }
    }
}

