/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.content.cm.lstools.common;

import com.ibm.content.cm.lstools.common.LogHelper;
import com.ibm.mm.sdk.common.DKException;
import com.ibm.mm.sdk.server.DKDatastoreICM;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LSConnection {
    private static final String DB2_JDBC_TYPE2_DRIVER = "COM.ibm.db2.jdbc.app.DB2Driver";
    private static final String DB2_JDBC_TYPE4_DRIVER = "com.ibm.db2.jcc.DB2Driver";
    private static final String ORA_JDBC_TYPE2_DRIVER = "oracle.jdbc.driver.OracleDriver";
    private static final String ORA_JDBC_TYPE4_DRIVER = "oracle.jdbc.driver.OracleDriver";
    private static LinkedList datastoreInfo = new LinkedList();
    private static final String DEFAULT_SERVER_DEF_INI = "cmbicmsrvs.ini";
    private static String serverDefIniFile = null;
    public static final int DBTYPE_UNKNOWN = 0;
    public static final int DBTYPE_DB2 = 1;
    public static final int DBTYPE_ORA = 2;
    public static final int JDBC_TYPE2 = 2;
    public static final int JDBC_TYPE4 = 4;
    private static final int INFO_IDX_ICMSERVER = 0;
    private static final int INFO_IDX_ICMSERVERREPTYPE = 1;
    private static final int INFO_IDX_ICMSCHEMA = 2;
    private static final int INFO_IDX_ICMSSO = 3;
    private static final int INFO_IDX_ICMDBAUTH = 4;
    private static final int INFO_IDX_ICMREMOTE = 5;
    private static final int INFO_IDX_ICMHOSTNAME = 6;
    private static final int INFO_IDX_ICMPORT = 7;
    private static final int INFO_IDX_ICMREMOTEDB = 8;
    private static final int INFO_IDX_ICMNODENAME = 9;
    private static final int INFO_IDX_ICMOSTYPE = 10;
    private static final int INFO_IDX_ICMJDBCDRIVER = 11;
    private static final int INFO_IDX_ICMJDBCURL = 12;
    private static final int INFO_IDX_ICMJNDIREF = 13;
    private static final int INFO_IDX_ICMDBVER = 14;
    private static final int INFO_IDX_ICMGMTSYSATTRTS = 15;
    private static final int INFO_IDX_SIZE = 16;
    private static final Logger logger = LogHelper.getLogger();
    private static Level detailedLogLevel = Level.OFF;
    private static Level errorLogLevel = Level.OFF;
    private static final String ENV_IBMCMROOT = "IBMCMROOT";
    private static final boolean iszOS = System.getProperty("os.name").startsWith("z/OS");

    public static void setLogLevel(Level _detailedLogLevel, Level _errorLogLevel) {
        detailedLogLevel = _detailedLogLevel;
        errorLogLevel = _errorLogLevel.intValue() < detailedLogLevel.intValue() ? detailedLogLevel : _errorLogLevel;
    }

    public static boolean datastoreExists(String datastoreName) throws IOException, Exception {
        LSConnection.loadDatastoreInfo();
        return LSConnection.getDatastoreInfo(datastoreName) != null;
    }

    public static Connection createDBConnection(String datastoreName, String dbUser, String dbPassword) throws SQLException, IOException, Exception {
        Connection conn = null;
        LSConnection.loadDatastoreInfo();
        String jdbcClassName = LSConnection.getJdbcDriverClass(datastoreName);
        String jdbcURL = LSConnection.getJdbcURL(datastoreName);
        String dbSchema = LSConnection.getDBSchema(datastoreName);
        int dbType = LSConnection.getDBType(datastoreName);
        Properties properties = new Properties();
        properties.put("user", dbUser.toUpperCase());
        properties.put("password", dbPassword);
        if (detailedLogLevel != Level.OFF && logger.getLevel().intValue() <= detailedLogLevel.intValue()) {
            logger.log(detailedLogLevel, "Params", new Object[]{"__LOGSTYLE_KEY_VALUE_PAIR__", "datastoreName", datastoreName, "dbUser", dbUser, "dbPassword", "********", "jdbcClassName", jdbcClassName, "jdbcURL", jdbcURL, "dbSchema", dbSchema, "dbType", dbType});
        }
        if (dbType == 1 && dbSchema != null && dbSchema.length() > 0) {
            properties.put("currentSchema", dbSchema);
        }
        try {
            Class.forName(jdbcClassName);
        }
        catch (ClassNotFoundException classNotFound) {
            if (errorLogLevel != Level.OFF && logger.getLevel().intValue() <= errorLogLevel.intValue()) {
                logger.log(errorLogLevel, "ClassNotFoundException occurred when loading the JDBC driver. ", new Object[]{"__LOGSTYLE_KEY_VALUE_PAIR__", "datastoreName", datastoreName, "dbType", dbType, "jdbcClassName", jdbcClassName, "jdbcURL", jdbcURL, "CLASSPATH", System.getProperty("java.class.path")});
                logger.log(errorLogLevel, "Loading the JDBC driver failed. ", classNotFound);
            }
            throw classNotFound;
        }
        conn = DriverManager.getConnection(jdbcURL, properties);
        if (dbType == 2 && dbSchema != null && dbSchema.length() > 0) {
            Statement stmt = null;
            try {
                stmt = conn.createStatement();
                stmt.executeUpdate("ALTER SESSION SET CURRENT_SCHEMA=" + dbSchema);
            }
            catch (Exception e1) {
                if (stmt != null) {
                    stmt.close();
                }
                conn.close();
                throw e1;
            }
            stmt.close();
        }
        return conn;
    }

    public static DKDatastoreICM createDSConnection(String datastoreName, String user, String password, String connParams) throws DKException, Exception {
        DKDatastoreICM dsICM = new DKDatastoreICM();
        dsICM.connect(datastoreName, user, password, connParams);
        return dsICM;
    }

    public static void loadDatastoreInfo() throws IOException, Exception {
        if (serverDefIniFile == null) {
            String connectorsIniPath = LSConnection.getConnectorsIniPath();
            String serverDefIniAbsolutePathFile = null;
            if (connectorsIniPath != null && connectorsIniPath.length() > 0) {
                serverDefIniAbsolutePathFile = connectorsIniPath + '/' + DEFAULT_SERVER_DEF_INI;
            }
            LSConnection.loadDatastoreInfo(serverDefIniAbsolutePathFile);
        }
    }

    public static void loadDatastoreInfo(String _serverDefIniFile) throws IOException, Exception {
        String lines = null;
        String strValue = "";
        int intValue = 0;
        datastoreInfo.clear();
        serverDefIniFile = null;
        Object[] infoArray = null;
        if (_serverDefIniFile == null || _serverDefIniFile.trim().length() == 0) {
            _serverDefIniFile = DEFAULT_SERVER_DEF_INI;
        }
        if (detailedLogLevel != Level.OFF && logger.getLevel().intValue() <= detailedLogLevel.intValue()) {
            logger.log(detailedLogLevel, "Parsing server definitions from : " + _serverDefIniFile);
        }
        BufferedReader istream = new BufferedReader(new FileReader(_serverDefIniFile));
        while ((lines = istream.readLine()) != null) {
            if ((lines = lines.trim()).equals("")) continue;
            if (lines.startsWith("ICMSERVER") && !lines.startsWith("ICMSERVERREPTYPE")) {
                infoArray = new Object[16];
                datastoreInfo.addLast(infoArray);
                strValue = lines.substring(lines.indexOf(61) + 1).trim();
                infoArray[0] = strValue;
                continue;
            }
            if (lines.startsWith("ICMSERVERREPTYPE")) {
                if (infoArray == null) {
                    throw new Exception("Error parsing " + _serverDefIniFile);
                }
                strValue = lines.substring(lines.indexOf(61) + 1).trim();
                infoArray[1] = new String(strValue);
                continue;
            }
            if (lines.startsWith("ICMSCHEMA")) {
                if (infoArray == null) {
                    throw new Exception("Error parsing " + _serverDefIniFile);
                }
                strValue = lines.substring(lines.indexOf(61) + 1).trim().toUpperCase();
                infoArray[2] = new String(strValue);
                continue;
            }
            if (lines.startsWith("ICMSSO")) {
                if (infoArray == null) {
                    throw new Exception("Error parsing " + _serverDefIniFile);
                }
                strValue = lines.substring(lines.indexOf(61) + 1).trim();
                infoArray[3] = new String(strValue);
                continue;
            }
            if (lines.startsWith("ICMDBAUTH")) {
                if (infoArray == null) {
                    throw new Exception("Error parsing " + _serverDefIniFile);
                }
                strValue = lines.substring(lines.indexOf(61) + 1).trim();
                infoArray[4] = new String(strValue);
                continue;
            }
            if (lines.startsWith("ICMREMOTEDB")) {
                if (infoArray == null) {
                    throw new Exception("Error parsing " + _serverDefIniFile);
                }
                strValue = lines.substring(lines.indexOf(61) + 1).trim();
                infoArray[8] = new String(strValue);
                continue;
            }
            if (lines.startsWith("ICMREMOTE") && !lines.startsWith("ICMREMOTEDB")) {
                if (infoArray == null) {
                    throw new Exception("Error parsing " + _serverDefIniFile);
                }
                strValue = lines.substring(lines.indexOf(61) + 1).trim();
                infoArray[5] = new String(strValue);
                continue;
            }
            if (lines.startsWith("ICMHOSTNAME")) {
                if (infoArray == null) {
                    throw new Exception("Error parsing " + _serverDefIniFile);
                }
                strValue = lines.substring(lines.indexOf(61) + 1).trim();
                infoArray[6] = new String(strValue);
                continue;
            }
            if (lines.startsWith("ICMPORT")) {
                if (infoArray == null) {
                    throw new Exception("Error parsing " + _serverDefIniFile);
                }
                strValue = lines.substring(lines.indexOf(61) + 1).trim();
                if (strValue.length() > 0) {
                    try {
                        intValue = Integer.parseInt(strValue);
                    }
                    catch (NumberFormatException e) {
                        throw new Exception("Error ICMPORT in " + _serverDefIniFile + " : " + lines);
                    }
                } else {
                    intValue = -1;
                }
                infoArray[7] = new Integer(intValue);
                continue;
            }
            if (lines.startsWith("ICMNODENAME")) {
                if (infoArray == null) {
                    throw new Exception("Error parsing " + _serverDefIniFile);
                }
                strValue = lines.substring(lines.indexOf(61) + 1).trim();
                infoArray[9] = new String(strValue);
                continue;
            }
            if (lines.startsWith("ICMOSTYPE")) {
                if (infoArray == null) {
                    throw new Exception("Error parsing " + _serverDefIniFile);
                }
                strValue = lines.substring(lines.indexOf(61) + 1).trim();
                infoArray[10] = new String(strValue);
                continue;
            }
            if (lines.startsWith("ICMJDBCDRIVER")) {
                if (infoArray == null) {
                    throw new Exception("Error parsing " + _serverDefIniFile);
                }
                strValue = lines.substring(lines.indexOf(61) + 1).trim();
                infoArray[11] = new String(strValue);
                continue;
            }
            if (lines.startsWith("ICMJDBCURL")) {
                if (infoArray == null) {
                    throw new Exception("Error parsing " + _serverDefIniFile);
                }
                strValue = lines.substring(lines.indexOf(61) + 1).trim();
                infoArray[12] = new String(strValue);
                continue;
            }
            if (lines.startsWith("ICMJNDIREF")) {
                if (infoArray == null) {
                    throw new Exception("Error parsing " + _serverDefIniFile);
                }
                strValue = lines.substring(lines.indexOf(61) + 1).trim();
                infoArray[13] = new String(strValue);
                continue;
            }
            if (lines.startsWith("ICMDBVER")) {
                if (infoArray == null) {
                    throw new Exception("Error parsing " + _serverDefIniFile);
                }
                strValue = lines.substring(lines.indexOf(61) + 1).trim();
                infoArray[14] = new String(strValue);
                continue;
            }
            if (!lines.startsWith("ICMGMTSYSATTRTS")) continue;
            if (infoArray == null) {
                throw new Exception("Error parsing " + _serverDefIniFile);
            }
            strValue = lines.substring(lines.indexOf(61) + 1).trim();
            infoArray[15] = new String(strValue);
        }
        serverDefIniFile = _serverDefIniFile;
        LSConnection.logDatastoreInfo();
    }

    private static void logDatastoreInfo() {
        if (detailedLogLevel != Level.OFF && logger.getLevel().intValue() > detailedLogLevel.intValue()) {
            return;
        }
        if (datastoreInfo == null && datastoreInfo.size() == 0) {
            return;
        }
        Object[] paramArray2 = null;
        Object[] logParams = null;
        logger.log(detailedLogLevel, "Datastores retrieved : " + datastoreInfo.size());
        String dsName = null;
        for (Object[] paramArray2 : datastoreInfo) {
            logParams = new Object[paramArray2.length * 2 + 1];
            logParams[0] = "__LOGSTYLE_KEY_VALUE_PAIR__";
            dsName = (String)paramArray2[0];
            for (int i = 0; i < paramArray2.length; ++i) {
                logParams[i * 2 + 1] = dsName + "[" + i + "]";
                logParams[i * 2 + 2] = paramArray2[i];
            }
            logger.log(detailedLogLevel, "Datastore definition for " + dsName, logParams);
        }
    }

    private static Object[] getDatastoreInfo(String datastoreName) {
        if (datastoreInfo == null || datastoreInfo.isEmpty()) {
            return null;
        }
        Object[] paramArray2 = null;
        Object[] ret = null;
        String curDSName = null;
        datastoreName = datastoreName.trim();
        for (Object[] paramArray2 : datastoreInfo) {
            curDSName = (String)paramArray2[0];
            if (!curDSName.equalsIgnoreCase(datastoreName)) continue;
            ret = paramArray2;
            break;
        }
        return ret;
    }

    public static int getDBType(String datastoreName) throws IllegalArgumentException, Exception {
        String strValue = null;
        Object[] infoArray = LSConnection.getDatastoreInfo(datastoreName);
        if (infoArray == null) {
            throw new IllegalArgumentException("Datastore '" + datastoreName + "' is not defined in " + serverDefIniFile);
        }
        strValue = (String)infoArray[1];
        if (strValue == null || strValue.length() == 0) {
            throw new Exception("ICMSERVERREPTYPE is missing for " + datastoreName);
        }
        int ret = 0;
        if ((strValue = strValue.toUpperCase()).equals("DB2") || strValue.equals("DB2CON")) {
            ret = 1;
        } else if (strValue.equals("ORA") || strValue.equals("ORACLE") || strValue.equals("ORACON")) {
            ret = 2;
        }
        return ret;
    }

    public static int getJdbcType(String datastoreName) throws IllegalArgumentException {
        Integer intValue = null;
        String strValue = null;
        Object[] infoArray = LSConnection.getDatastoreInfo(datastoreName);
        if (infoArray == null) {
            IllegalArgumentException e1 = new IllegalArgumentException("Datastore '" + datastoreName + "' is not defined in " + serverDefIniFile);
            if (errorLogLevel != Level.OFF && logger.getLevel().intValue() <= errorLogLevel.intValue()) {
                logger.log(errorLogLevel, "Datastore '" + datastoreName + "' is not defined in " + serverDefIniFile, e1);
            }
            throw e1;
        }
        strValue = (String)infoArray[12];
        if (strValue != null && strValue.length() > 0) {
            if (detailedLogLevel != Level.OFF && logger.getLevel().intValue() <= detailedLogLevel.intValue()) {
                logger.log(detailedLogLevel, "ICMJDBCURL is provided. JDBC Type : 4");
            }
            return 4;
        }
        strValue = (String)infoArray[6];
        if (strValue == null || strValue.length() == 0) {
            if (detailedLogLevel != Level.OFF && logger.getLevel().intValue() <= detailedLogLevel.intValue()) {
                logger.log(detailedLogLevel, "ICMJDBCURL is not provided. JDBC Type : 2");
            }
            return 2;
        }
        intValue = (Integer)infoArray[7];
        if (intValue == null || intValue < 0) {
            if (detailedLogLevel != Level.OFF && logger.getLevel().intValue() <= detailedLogLevel.intValue()) {
                logger.log(detailedLogLevel, "ICMPORT is not provided. JDBC Type : 2");
            }
            return 2;
        }
        strValue = (String)infoArray[8];
        if (strValue == null || strValue.length() == 0) {
            if (detailedLogLevel != Level.OFF && logger.getLevel().intValue() <= detailedLogLevel.intValue()) {
                logger.log(detailedLogLevel, "ICMREMOTEDB is not provided. JDBC Type : 2");
            }
            return 2;
        }
        if (detailedLogLevel != Level.OFF && logger.getLevel().intValue() <= detailedLogLevel.intValue()) {
            logger.log(detailedLogLevel, "ICMJDBCURL, ICMPORT, ICMREMOTEDB are provided. JDBC Type : 4");
        }
        return 4;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String getJdbcURL(String datastoreName) throws IllegalArgumentException, Exception {
        String connStr;
        block14: {
            int dbType;
            Object[] infoArray;
            block15: {
                String strValue = null;
                infoArray = LSConnection.getDatastoreInfo(datastoreName);
                if (infoArray == null) {
                    throw new IllegalArgumentException("Datastore '" + datastoreName + "' is not defined in " + serverDefIniFile);
                }
                strValue = (String)infoArray[12];
                if (strValue != null && strValue.length() > 0) {
                    return strValue;
                }
                int jdbcType = LSConnection.getJdbcType(datastoreName);
                dbType = LSConnection.getDBType(datastoreName);
                connStr = null;
                if (jdbcType != 2) break block15;
                if (dbType == 1) {
                    connStr = "jdbc:db2:" + datastoreName;
                    break block14;
                } else if (dbType == 2) {
                    connStr = "jdbc:oracle:oci:@" + datastoreName;
                    break block14;
                } else {
                    Exception e1 = new Exception("Unknown DB type. Check your ICMSERVERREPTYPE of datastore " + datastoreName);
                    if (errorLogLevel != Level.OFF && logger.getLevel().intValue() <= errorLogLevel.intValue()) {
                        logger.log(errorLogLevel, "Unknown DB type : " + dbType, e1);
                    }
                    throw e1;
                }
            }
            String dbHostname = null;
            int dbPort = 0;
            String dbName = null;
            dbName = (String)infoArray[8];
            dbHostname = (String)infoArray[6];
            dbPort = (Integer)infoArray[7];
            if (dbPort < 1 || dbPort > 65535) {
                throw new Exception("Invalid port number: " + dbPort);
            }
            if (dbType == 1) {
                connStr = "jdbc:db2://" + dbHostname + ":" + dbPort + "/" + dbName;
            } else if (dbType == 2) {
                connStr = "jdbc:oracle:thin:@" + dbHostname + ":" + dbPort + ":" + dbName;
            } else {
                Exception e1 = new Exception("Unknown DB type. Check your ICMSERVERREPTYPE of datastore " + datastoreName);
                if (errorLogLevel != Level.OFF && logger.getLevel().intValue() <= errorLogLevel.intValue()) {
                    logger.log(errorLogLevel, "Unknown DB type : " + dbType, e1);
                }
                throw e1;
            }
        }
        if (detailedLogLevel != Level.OFF && logger.getLevel().intValue() <= detailedLogLevel.intValue()) {
            logger.log(detailedLogLevel, "getJdbcURL() return ", new String[]{connStr});
        }
        return connStr;
    }

    public static String getJdbcDriverClass(String datastoreName) throws IllegalArgumentException, Exception {
        String strValue = null;
        Object[] infoArray = LSConnection.getDatastoreInfo(datastoreName);
        if (infoArray == null) {
            IllegalArgumentException e1 = new IllegalArgumentException("Datastore '" + datastoreName + "' is not defined in " + serverDefIniFile);
            if (errorLogLevel != Level.OFF && logger.getLevel().intValue() <= errorLogLevel.intValue()) {
                logger.log(errorLogLevel, "Datastore '" + datastoreName + "' is not defined in " + serverDefIniFile, e1);
            }
            throw e1;
        }
        strValue = (String)infoArray[11];
        if (strValue != null && strValue.length() > 0) {
            return strValue;
        }
        int jdbcType = LSConnection.getJdbcType(datastoreName);
        int dbType = LSConnection.getDBType(datastoreName);
        if (dbType == 1) {
            if (iszOS) {
                return DB2_JDBC_TYPE4_DRIVER;
            }
            if (jdbcType == 2) {
                return DB2_JDBC_TYPE2_DRIVER;
            }
            return DB2_JDBC_TYPE4_DRIVER;
        }
        if (dbType == 2) {
            if (jdbcType == 2) {
                return "oracle.jdbc.driver.OracleDriver";
            }
            return "oracle.jdbc.driver.OracleDriver";
        }
        Exception e1 = new Exception("Unknown DB type. Check your ICMSERVERREPTYPE of datastore " + datastoreName);
        if (errorLogLevel != Level.OFF && logger.getLevel().intValue() <= errorLogLevel.intValue()) {
            logger.log(errorLogLevel, "Unknown DB type : " + dbType, e1);
        }
        throw e1;
    }

    public static String getDBSchema(String datastoreName) throws IllegalArgumentException, Exception {
        String strValue = null;
        Object[] infoArray = LSConnection.getDatastoreInfo(datastoreName);
        if (infoArray == null) {
            IllegalArgumentException e1 = new IllegalArgumentException("Datastore '" + datastoreName + "' is not defined in " + serverDefIniFile);
            if (errorLogLevel != Level.OFF && logger.getLevel().intValue() <= errorLogLevel.intValue()) {
                logger.log(errorLogLevel, "Datastore '" + datastoreName + "' is not defined in " + serverDefIniFile, e1);
            }
            throw e1;
        }
        strValue = (String)infoArray[2];
        return strValue;
    }

    public static String getConnectorsIniPath() throws Exception {
        String cmRoot = System.getenv(ENV_IBMCMROOT);
        if (cmRoot == null || cmRoot.trim().length() == 0) {
            Exception e1 = new Exception("System environment IBMCMROOT is not set. Please run cmbenv81.sh/bat first.");
            if (errorLogLevel != Level.OFF && logger.getLevel().intValue() <= errorLogLevel.intValue()) {
                logger.log(errorLogLevel, "System environment IBMCMROOT is not set.", e1);
            }
            throw e1;
        }
        String connIniPath = null;
        String cmbcmenvFile = LSConnection.normalizePath(cmRoot + "/cmgmt/cmbcmenv.properties");
        Properties cmbcmenvProp = new Properties();
        File file = new File(cmbcmenvFile);
        if (!file.isFile()) {
            FileNotFoundException e1 = new FileNotFoundException("File is missing : " + cmbcmenvFile + ". Please ensure II4C is installed.");
            if (errorLogLevel != Level.OFF && logger.getLevel().intValue() <= errorLogLevel.intValue()) {
                logger.log(errorLogLevel, "File is missing : " + cmbcmenvFile, e1);
            }
            throw e1;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            cmbcmenvProp.load(fis);
        }
        catch (IOException e) {
            if (errorLogLevel != Level.OFF && logger.getLevel().intValue() <= errorLogLevel.intValue()) {
                logger.log(errorLogLevel, "Failed to load properties from " + cmbcmenvFile + ". The original IOException : ", e);
            }
            IOException e1 = new IOException("Failed to load properties from " + cmbcmenvFile);
            throw e1;
        }
        String relativePath = System.getProperty("com.ibm.mm.sdk.common.cmrelativepath");
        if (relativePath == null) {
            try {
                relativePath = cmbcmenvProp.getProperty("CMRELATIVEPATH");
                if (detailedLogLevel != Level.OFF && logger.getLevel().intValue() <= detailedLogLevel.intValue()) {
                    logger.log(detailedLogLevel, "Retrieved relativePath from CMRELATIVEPATH : " + relativePath);
                }
            }
            catch (MissingResourceException missResExp) {
                relativePath = null;
            }
            if (relativePath != null && relativePath.equalsIgnoreCase("TRUE")) {
                URL relPathURL = LSConnection.class.getClassLoader().getResource("cmbcmenv.properties");
                try {
                    relativePath = URLDecoder.decode(relPathURL.getFile(), "UTF-8");
                    relativePath = relativePath.substring(0, relativePath.indexOf("cmbcmenv.properties"));
                    if (detailedLogLevel != Level.OFF && logger.getLevel().intValue() <= detailedLogLevel.intValue()) {
                        logger.log(detailedLogLevel, "Decoded  relativePath : " + relativePath);
                    }
                }
                catch (UnsupportedEncodingException e) {
                    relativePath = null;
                }
            }
        }
        if (relativePath != null && relativePath.length() > 0) {
            relativePath = LSConnection.normalizePath(relativePath);
            connIniPath = relativePath + "/connectors";
        } else {
            if (detailedLogLevel != Level.OFF && logger.getLevel().intValue() <= detailedLogLevel.intValue()) {
                logger.log(detailedLogLevel, "No relative path retrieved. Try the CMCFGDIR in cmbcmenv.ini");
            }
            connIniPath = cmbcmenvProp.getProperty("CMCFGDIR");
            connIniPath = LSConnection.normalizePath(connIniPath);
        }
        if (detailedLogLevel != Level.OFF && logger.getLevel().intValue() <= detailedLogLevel.intValue()) {
            logger.log(detailedLogLevel, "Connectors configuration file path : " + connIniPath);
        }
        return connIniPath;
    }

    private static String normalizePath(String pathString) {
        if (pathString == null || pathString.trim().length() == 0) {
            return null;
        }
        pathString = pathString.replaceAll("\\\\", "\\/");
        if ((pathString = pathString.replaceAll("\\/\\/+", "\\/")).charAt(pathString.length() - 1) == '/') {
            pathString = pathString.substring(0, pathString.length() - 1);
        }
        return pathString;
    }

    public static int getOSType(String datastoreName) throws IllegalArgumentException, Exception {
        String strValue = null;
        Object[] infoArray = LSConnection.getDatastoreInfo(datastoreName);
        if (infoArray == null) {
            throw new IllegalArgumentException("Datastore '" + datastoreName + "' is not defined in " + serverDefIniFile);
        }
        strValue = (String)infoArray[10];
        if (strValue == null || strValue.length() == 0) {
            throw new Exception("ICMOSTYPE is missing for " + datastoreName);
        }
        int ret = 0;
        if (strValue.indexOf("390") >= 0) {
            ret = 3;
        }
        return ret;
    }
}

