/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.content.cm.lstools.common;

import com.ibm.content.cm.lstools.common.LSConnection;
import com.ibm.content.cm.lstools.common.LogHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ICMRebuildCompView {
    static String _userInfo = "";
    static String _userToken = "";
    private static Connection _con = null;
    static String _database;
    static String _userid;
    static String _pw;
    static String _schema;
    static boolean isORACLE;

    public static void main(String[] argv) {
        Logger logger = LogHelper.getLogger();
        logger.setLevel(Level.OFF);
        _database = "icmnlsdb";
        _userid = "icmadmin";
        _pw = "password";
        _schema = "icmadmin";
        System.out.println("!!!ICMRebuildCompView...");
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            if (argv.length > 0) {
                _database = argv[0];
            } else {
                System.out.println("Enter datastore name:");
                _database = br.readLine();
            }
            if (argv.length > 1) {
                _userid = argv[1];
            } else {
                System.out.println("Enter userid:");
                _userid = br.readLine();
            }
            if (argv.length > 2) {
                _pw = argv[2];
            } else {
                System.out.println("Enter password:");
                _pw = br.readLine();
            }
            if (argv.length > 3) {
                _schema = argv[3];
            } else {
                System.out.println("Enter schema:");
                _schema = br.readLine();
            }
        }
        catch (IOException e) {
            System.out.println("Error on br.readLine()");
            e.printStackTrace();
        }
        ICMRebuildCompView builder = new ICMRebuildCompView(_database, _userid, _pw, _schema);
        try {
            builder.build();
        }
        catch (Exception e) {
            System.out.println("ICMRebuildCompView Failed");
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public ICMRebuildCompView(String database, String userid, String pw, String schema) {
        _database = database;
        _userid = userid;
        _pw = pw;
        _schema = schema;
    }

    public void getConnection() throws Exception {
        try {
            _con = LSConnection.createDBConnection(_database, _userid, _pw);
            isORACLE = LSConnection.getDBType(_database) == 2;
        }
        catch (SQLException e) {
            System.out.println("Datastore connect error " + _database);
        }
    }

    public void build(int compViewId) throws Exception {
        block14: {
            int rc;
            block13: {
                this.getConnection();
                try {
                    rc = ICMRebuildCompView.logon();
                    if (rc == 0) break block13;
                    try {
                        _con.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    throw new Exception("  *** Can not logon, exiting...");
                }
                catch (SQLException e) {
                    System.out.println("sql logon error");
                    e.printStackTrace();
                    System.exit(-1);
                }
            }
            rc = 0;
            int rc1 = 0;
            try {
                System.out.println("Rebuild CompViewId " + compViewId);
                rc1 = ICMRebuildCompView.generateAccessModule(compViewId);
                rc += rc1;
                if (rc1 != 0) {
                    System.out.println("Rebuild CompViewId " + compViewId + " failed.");
                } else {
                    System.out.println("Rebuild CompViewId " + compViewId + " successful.");
                }
                if (rc != 0) {
                    throw new SQLException();
                }
            }
            catch (SQLException e) {
                System.out.println("SQL error calling genAccessModule");
                e.printStackTrace();
                System.exit(-1);
            }
            ICMRebuildCompView.myCommit();
            try {
                int rc2 = ICMRebuildCompView.logoff();
                if (rc2 == 0) break block14;
                try {
                    _con.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw new Exception("  *** Can not logoff, exiting...");
            }
            catch (SQLException e) {
                System.out.println("Sql logoff error");
                System.exit(-1);
            }
        }
    }

    public void build() throws Exception {
        int rc;
        Vector<Integer> v;
        block27: {
            block26: {
                this.getConnection();
                v = new Vector<Integer>();
                try {
                    String querySql = "select COMPONENTVIEWID from " + _schema + ".ICMSTCOMPVIEWDEFS where ACCESSMODULESTATUS = -1 and COMPONENTVIEWID > 0";
                    PreparedStatement Stmt = _con.prepareStatement(querySql);
                    ResultSet rs = Stmt.executeQuery();
                    while (rs.next()) {
                        if (rs.getInt(1) == 0) continue;
                        v.add(new Integer(rs.getInt(1)));
                    }
                    rs.close();
                }
                catch (SQLException e) {
                    System.out.println("Error getting ViewIDs");
                    System.exit(-1);
                }
                try {
                    int rc2 = ICMRebuildCompView.logon();
                    if (rc2 == 0) break block26;
                    try {
                        _con.close();
                    }
                    catch (SQLException Stmt) {
                        // empty catch block
                    }
                    throw new Exception("  *** Can not logon, exiting...");
                }
                catch (SQLException e) {
                    System.out.println("sql logon error");
                    e.printStackTrace();
                    System.exit(-1);
                }
            }
            System.out.println("Number of view found " + v.size());
            rc = 0;
            int rc1 = 0;
            if (v.size() > 0) {
                try {
                    for (int i = 0; i < v.size(); ++i) {
                        System.out.println("Rebuild CompViewId " + v.elementAt(i));
                        rc1 = ICMRebuildCompView.generateAccessModule((Integer)v.elementAt(i));
                        rc += rc1;
                        if (rc1 != 0) {
                            System.out.println("Rebuild CompViewId " + v.elementAt(i) + " failed");
                            continue;
                        }
                        System.out.println("Rebuild CompViewId " + v.elementAt(i) + " successful");
                    }
                    if (rc != 0) {
                        throw new SQLException();
                    }
                }
                catch (SQLException e) {
                    System.out.println("SQL error calling genAccessModule");
                    e.printStackTrace();
                    System.exit(-1);
                }
                ICMRebuildCompView.myCommit();
                try {
                    int rc2 = ICMRebuildCompView.logoff();
                    if (rc2 == 0) break block27;
                    try {
                        _con.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    if (v.size() > 0) {
                        if (rc == 0) {
                            System.out.println("Rebuild successful");
                        } else {
                            System.out.println("Error generating modules");
                        }
                    }
                    throw new Exception("  *** Can not logoff, exiting...");
                }
                catch (SQLException e) {
                    System.out.println("Sql logoff error");
                    System.exit(-1);
                }
            }
        }
        try {
            _con.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (v.size() > 0) {
            if (rc == 0) {
                System.out.println("Rebuild successful");
            } else {
                System.out.println("Error generating modules " + rc);
            }
        } else {
            System.out.println("No view rebuilt");
        }
    }

    private static int generateAccessModule(int compViewId) throws SQLException {
        String sql = "";
        sql = isORACLE ? "begin ICMLSPKG.ICMGENACCESSMODULE(?,?,?,?,?,?,?,?,?,?);end;" : "Call " + _schema + ".ICMGENACCESSMODULE(?,?,?,?,?,?,?,?,?,?) ";
        CallableStatement stmt = _con.prepareCall(sql);
        stmt.registerOutParameter(1, 4);
        stmt.registerOutParameter(2, 4);
        stmt.registerOutParameter(3, 4);
        stmt.registerOutParameter(4, 4);
        stmt.registerOutParameter(9, 4);
        stmt.setShort(5, (short)15);
        stmt.setInt(6, 0);
        stmt.setString(7, _userInfo);
        stmt.setString(8, _userToken);
        stmt.setInt(9, 0);
        stmt.setInt(10, compViewId);
        boolean success = stmt.execute();
        int lRC = stmt.getInt(1);
        int lReason = stmt.getInt(2);
        int lExtRC = stmt.getInt(3);
        int lExtReason = stmt.getInt(4);
        try {
            stmt.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (lRC == 0) {
            ICMRebuildCompView.myCommit();
            return 0;
        }
        ICMRebuildCompView.writeError("Error generating module", lRC, lReason, lExtRC, lExtReason, null);
        return 1;
    }

    private static int logon() throws SQLException {
        String sql = "";
        sql = isORACLE ? "begin ICMLSPKG.ICMLOGON(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?);end;" : "Call " + _schema + ".ICMLOGON(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        CallableStatement stmt = _con.prepareCall(sql);
        stmt.registerOutParameter(1, 4);
        stmt.registerOutParameter(2, 4);
        stmt.registerOutParameter(3, 4);
        stmt.registerOutParameter(4, 4);
        stmt.registerOutParameter(9, 4);
        stmt.setShort(5, (short)15);
        stmt.setInt(6, 0);
        stmt.setString(7, _userInfo);
        stmt.setString(8, _userToken);
        stmt.setInt(9, 0);
        stmt.registerOutParameter(7, 12);
        stmt.registerOutParameter(8, 1);
        stmt.registerOutParameter(10, 1);
        stmt.registerOutParameter(11, 12);
        stmt.registerOutParameter(15, 12);
        stmt.registerOutParameter(16, 4);
        stmt.registerOutParameter(17, 4);
        stmt.registerOutParameter(18, 4);
        stmt.registerOutParameter(19, 5);
        stmt.registerOutParameter(20, 5);
        stmt.registerOutParameter(21, 12);
        stmt.registerOutParameter(22, 12);
        stmt.registerOutParameter(23, 12);
        stmt.registerOutParameter(24, 12);
        stmt.registerOutParameter(25, 12);
        stmt.registerOutParameter(26, 5);
        stmt.registerOutParameter(27, 4);
        stmt.registerOutParameter(28, 5);
        stmt.registerOutParameter(29, 4);
        if (isORACLE) {
            stmt.registerOutParameter(30, -10);
            stmt.registerOutParameter(31, -10);
        }
        stmt.setString(10, "ENU");
        stmt.setString(11, _userid);
        String application = "ICMRebuildCompView";
        String password = "";
        String newPassword = "";
        try {
            stmt.setBytes(12, password.getBytes("ASCII"));
            stmt.setBytes(13, newPassword.getBytes("ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        stmt.setString(14, application);
        boolean success = stmt.execute();
        int lRC = stmt.getInt(1);
        int lReason = stmt.getInt(2);
        int lExtRC = stmt.getInt(3);
        int lExtReason = stmt.getInt(4);
        if (lRC == 0) {
            _userInfo = stmt.getString(7);
            _userToken = stmt.getString(8);
        } else {
            ICMRebuildCompView.writeError("Error logging on to server", lRC, lReason, lExtRC, lExtReason, null);
        }
        try {
            stmt.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        ICMRebuildCompView.myCommit();
        return lRC;
    }

    private static int logoff() throws SQLException {
        String sql = "";
        sql = isORACLE ? "begin ICMLSPKG.ICMLOGOFF(?,?,?,?,?,?,?,?,?);end;" : "Call " + _schema + ".ICMLOGOFF(?,?,?,?,?,?,?,?,?)";
        CallableStatement stmt = _con.prepareCall(sql);
        stmt.registerOutParameter(1, 4);
        stmt.registerOutParameter(2, 4);
        stmt.registerOutParameter(3, 4);
        stmt.registerOutParameter(4, 4);
        stmt.registerOutParameter(9, 4);
        stmt.setShort(5, (short)15);
        stmt.setInt(6, 0);
        stmt.setString(7, _userInfo);
        stmt.setString(8, _userToken);
        stmt.setInt(9, 0);
        boolean success = stmt.execute();
        int lRC = stmt.getInt(1);
        int lReason = stmt.getInt(2);
        int lExtRC = stmt.getInt(3);
        int lExtReason = stmt.getInt(4);
        if (lRC != 0) {
            ICMRebuildCompView.writeError("Error logging off server", lRC, lReason, lExtRC, lExtReason, null);
        }
        try {
            stmt.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        ICMRebuildCompView.myCommit();
        return lRC;
    }

    private static void writeError(String header, int lRC, int lReason, int lExtRC, int lExtReason, Exception ex) {
        System.out.println(header + " lRC          = " + lRC + " lReason      = " + lReason + " lExtRC       = " + lExtRC + " lExtReason   = " + lExtReason);
    }

    private static void myCommit() throws SQLException {
        if (!_con.getAutoCommit()) {
            try {
                _con.commit();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    static {
        isORACLE = false;
    }
}

